%%% $Id: Bennett5.Rd,v 1.3 2001/01/12 05:07:37 bates Exp $
\name{Bennett5}
\alias{Bennett5}
\non_function{}
\title{Magentization modelling}
\description{
  The \code{Bennett5} data frame has 154 rows and 2 columns of data from a
  magnetism study
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of magnetism values.
    }
    \item{x}{
      A numeric vector of log(time).
    }
  }
}
\details{
  These data are the result of a NIST study involving superconductivity
  magnetization modeling.  The response variable is magnetism, and the
  predictor variable is the log of time in minutes.
}
\source{
  Bennett, L., L. Swartzendruber, and H. Brown, 
  NIST (1994).  
  Superconductivity Magnetization Modeling.
}
\examples{
data(Bennett5)
plot(y ~ x, data = Bennett5)
\dontrun{
fm1 <- nls(y ~ b1*(b2+x)**(-1/b3), data = Bennett5,
           start = c(b1 = -2000, b2 = 50, b3 = 0.8), trace = TRUE)
}
fm2 <- nls(y ~ b1*(b2+x)**(-1/b3), data = Bennett5,
           start = c(b1 = -1500, b2 = 45, b3 = 0.85), trace = TRUE)
fm3 <- nls(y ~ (b2+x)**(-1/b3), data = Bennett5, alg = "plinear",
           start = c( b2 = 50, b3 = 0.8), trace = TRUE)
fm4 <- nls(y ~ (b2+x)**(-1/b3), data = Bennett5, alg = "plinear",
           start = c( b2 = 45, b3 = 0.8), trace = TRUE)
}
\keyword{datasets}
\eof
%%% $Id: Chwirut1.Rd,v 1.2 2001/01/10 17:49:12 bates Exp $
\name{Chwirut1}
\alias{Chwirut1}
\non_function{}
\title{Ultrasonic calibration study 1}
\description{
  The \code{Chwirut1} data frame has 214 rows and 2 columns giving
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of ultrasonic response values
    }
    \item{x}{
      A numeric vector or metal distance values
    }
  }
}
\details{
  These data are the result of a NIST study involving
  ultrasonic calibration.  The response variable is
  ultrasonic response, and the predictor variable is
  metal distance.
}
\source{
  Chwirut, D., NIST (197?).   Ultrasonic Reference Block Study. 
}
\examples{
data(Chwirut1)
plot(y ~ x, data = Chwirut1)
fm1 <- nls(y ~ exp(-b1*x)/(b2+b3*x), data = Chwirut1, trace = TRUE,
           start = c(b1 = 0.1, b2 = 0.01, b3 = 0.02))
fm2 <- nls(y ~ exp(-b1*x)/(b2+b3*x), data = Chwirut1, trace = TRUE,
           start = c(b1 = 0.15, b2 = 0.008, b3 = 0.010))
fm3 <- nls(y ~ exp(-b1*x)/(1+p3*x), data = Chwirut1, trace = TRUE,
           start = c(b1 = 0.1, p3 = 0.02/0.01), algorithm = "plinear")
fm4 <- nls(y ~ exp(-b1*x)/(1+p3*x), data = Chwirut1, trace = TRUE,
           start = c(b1 = 0.15, p3 = 0.01/0.008), algorithm = "plinear")
}
\keyword{datasets}
\eof
%%% $Id: Chwirut2.Rd,v 1.2 2001/01/10 17:49:12 bates Exp $
\name{Chwirut2}
\alias{Chwirut2}
\non_function{}
\title{Ultrasonic calibration data 2}
\description{
The \code{Chwirut2} data frame has nr rows and nc columns giving
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of ultrasonic response values.
    }
    \item{x}{
      A numeric vector of metal distance values.
    }
  }
}
\details{
  These data are the result of a NIST study involving
  ultrasonic calibration.  The response variable is
  ultrasonic response, and the predictor variable is
  metal distance.
}
\source{
  Chwirut, D., NIST (197?).  
    Ultrasonic Reference Block Study. 
}
\examples{
data(Chwirut2)
plot(y ~ x, data = Chwirut2)
fm1 <- nls(y ~ exp(-b1*x)/(b2+b3*x), data = Chwirut2, trace = TRUE,
           start = c(b1 = 0.1 , b2 = 0.01, b3 = 0.02) )
fm2 <- nls(y ~ exp(-b1*x)/(b2+b3*x), data = Chwirut2, trace = TRUE,
           start = c(b1 = 0.15 , b2 = 0.008, b3 = 0.01) )
fm3 <- nls(y ~ exp(-b1*x)/(1+p3*x), data = Chwirut2, trace = TRUE,
           start = c(b1 = 0.1, p3 = 2.), alg = "plinear" )
fm4 <- nls(y ~ exp(-b1*x)/(1+p3*x), data = Chwirut2, trace = TRUE,
           start = c(b1 = 0.15, p3 = 0.01/0.008), alg = "plinear" )
}
\keyword{datasets}
\eof
%%% $Id: DanielWood.Rd,v 1.2 2001/01/10 17:49:12 bates Exp $
\name{DanielWood}
\alias{DanielWood}
\non_function{}
\title{Radiated energy}
\description{
The \code{DanielWood} data frame has 6 rows and 2 columns giving the
energy radiated from a carbon filament versus the absolute temperature
of the filament.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of the energy radiated from a carbon filament
      lamp.
    }
    \item{x}{
      A numeric vector of the temperature of the filament (1000 K).
    }
  }
}
\details{
    These data and model are described in Daniel and Wood
    (1980), and originally published in E.S.Keeping, 
    "Introduction to Statistical Inference," Van Nostrand
    Company, Princeton, NJ, 1962, p. 354.  The response
    variable is energy radiated from a carbon filament
    lamp per cm**2 per second, and the predictor variable
    is the absolute temperature of the filament in 1000
    degrees Kelvin.
}
\source{
Daniel, C. and F. S. Wood (1980).
Fitting Equations to Data, Second Edition. 
New York, NY:  John Wiley and Sons, pp. 428-431.
}
\examples{
data(DanielWood)
plot(y ~ x, data = DanielWood)
fm1 <- nls(y ~ b1*x**b2, data = DanielWood, trace = TRUE,
           start = c(b1 = 1, b2 = 5))
fm2 <- nls(y ~ b1*x**b2, data = DanielWood, trace = TRUE,
           start = c(b1 = 0.7, b2 = 4))
fm3 <- nls(y ~ x**b2, data = DanielWood, trace = TRUE,
           start = c(b2 = 5), algorithm = "plinear")
fm4 <- nls(y ~ x**b2, data = DanielWood, trace = TRUE,
           start = c(b2 = 4), algorithm = "plinear")
}
\keyword{datasets}
\eof
%%% $Id: ENSO.Rd,v 1.2 2001/01/10 17:49:12 bates Exp $
\name{ENSO}
\alias{ENSO}
\non_function{}
\title{Atmospheric pressure differences}
\description{
The \code{ENSO} data frame has 168 rows and 2 columns giving atmospheric
pressure differences over time.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of monthly averaged atmospheric pressure
      differences between Easter Island and Darwin, Australia.
    }
    \item{x}{
      A numeric vector of time values.
    }
  }
}
\details{
    The data are monthly averaged atmospheric pressure 
    differences between Easter Island and Darwin, 
    Australia.  This difference drives the trade winds in 
    the southern hemisphere.  Fourier analysis of the data
    reveals 3 significant cycles.  The annual cycle is the
    strongest, but cycles with periods of approximately 44
    and 26 months are also present.  These cycles
    correspond to the El Nino and the Southern Oscillation.
    Arguments to the SIN and COS functions are in radians.
}
\source{
Kahaner, D., C. Moler, and S. Nash, (1989). 
Numerical Methods and Software.  
Englewood Cliffs, NJ: Prentice Hall, pp. 441-445.
}
\examples{
data(ENSO)
plot(y ~ x, data = ENSO)
plot(y ~ x, data = ENSO, type = "l")  # to see the pattern more clearly
fm1 <- nls(y ~ b1 + b2*cos( 2*pi*x/12 ) + b3*sin( 2*pi*x/12 ) 
                      + b5*cos( 2*pi*x/b4 ) + b6*sin( 2*pi*x/b4 )
                      + b8*cos( 2*pi*x/b7 ) + b9*sin( 2*pi*x/b7 ),
           data = ENSO, trace = TRUE,
           start = c(b1 = 11.0, b2 = 3.0, b3 = 0.5, b4 = 40.0, b5 = -0.7,
                     b6 = -1.3, b7 = 25.0, b8 = -0.3, b9 = 1.4))
fm2 <- nls(y ~ b1 + b2*cos( 2*pi*x/12 ) + b3*sin( 2*pi*x/12 ) 
                      + b5*cos( 2*pi*x/b4 ) + b6*sin( 2*pi*x/b4 )
                      + b8*cos( 2*pi*x/b7 ) + b9*sin( 2*pi*x/b7 ),
           data = ENSO, trace = TRUE,
           start = c(b1 = 10.0, b2 =  3.0, b3 =  0.5, b4 = 44.0, b5 = -1.5,
                     b6 =  0.5, b7 = 26.0, b8 = -0.1, b9 =  1.5)) 
fm3 <- nls(y ~ cbind(1, cos( 2*pi*x/12 ), sin( 2*pi*x/12 ), cos( 2*pi*x/b4 ),
                    sin( 2*pi*x/b4 ), cos( 2*pi*x/b7 ), sin( 2*pi*x/b7 )),
           data = ENSO, trace = TRUE,
           start = c(b4 = 40.0, b7 = 25.0), algorithm = "plinear")
fm4 <- nls(y ~ cbind(1, cos( 2*pi*x/12 ), sin( 2*pi*x/12 ), cos( 2*pi*x/b4 ),
                    sin( 2*pi*x/b4 ), cos( 2*pi*x/b7 ), sin( 2*pi*x/b7 )),
           data = ENSO, trace = TRUE,
           start = c(b4 = 44.0, b7 = 26.0), algorithm = "plinear")
}
\keyword{datasets}
\eof
%%% $Id: Eckerle4.Rd,v 1.3 2001/01/10 17:49:12 bates Exp $
\name{Eckerle4}
\alias{Eckerle4}
\non_function{}
\title{Circular interference data}
\description{
The \code{Eckerle4} data frame has 35 rows and 2 columns giving
transmittance as a function of wavelength.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of transmittance values.
    }
    \item{x}{
      A numeric vector of wavelengths.
    }
  }
}
\details{
  These data are the result of a NIST study involving
  circular interference transmittance.  The response
  variable is transmittance, and the predictor variable
  is wavelength.
}
\source{
Eckerle, K., NIST (197?).  
Circular Interference Transmittance Study.
}
\examples{
data(Eckerle4)
plot(y ~ x, data = Eckerle4)
\dontrun{
## should fail - ridiculous starting value for b3
fm1 <- nls(y ~ (b1/b2) * exp(-0.5*((x-b3)/b2)**2), data = Eckerle4, trace = TRUE,
           start = c(b1 = 1, b2 = 10, b3 = 500))
}
fm2 <- nls(y ~ (b1/b2) * exp(-0.5*((x-b3)/b2)**2), data = Eckerle4, trace = TRUE,
           start = c(b1 = 1.5, b2 = 5, b3 = 450))
\dontrun{
## should fail - ridiculous starting value for b3
fm3 <- nls(y ~ (1/b2) * exp(-0.5*((x-b3)/b2)**2), data = Eckerle4, trace = TRUE,
           start = c(b2 = 10, b3 = 500), algorithm = "plinear")
}
fm4 <- nls(y ~ (1/b2) * exp(-0.5*((x-b3)/b2)**2), data = Eckerle4, trace = TRUE,
           start = c(b2 = 5, b3 = 450), algorithm = "plinear")
}
\keyword{datasets}
\eof
%%% $Id: Gauss1.Rd,v 1.2 2001/01/10 17:49:12 bates Exp $
\name{Gauss1}
\alias{Gauss1}
\non_function{}
\title{Generated data}
\description{
The \code{Gauss1} data frame has 250 rows and 2 columns of generated data.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of generated responses.
    }
    \item{x}{
      A numeric vector of generated input values.
    }
  }
}
\details{
    The data are generated data with two well-separated Gaussians on a 
    decaying exponential baseline plus normally 
    distributed zero-mean noise with variance = 6.25.
}
\source{
    Rust, B., NIST (1996).
}
\examples{
data(Gauss1)
plot(y ~ x, data = Gauss1)
fm1 <- nls(y ~ b1*exp( -b2*x ) + b3*exp( -(x-b4)**2 / b5**2 )
               + b6*exp( -(x-b7)**2 / b8**2 ), data = Gauss1, trace = TRUE,
           start = c(b1 = 97.0, b2 = 0.009, b3 = 100.0, b4 = 65.0, b5 = 20.0,
                     b6 = 70.0, b7 = 178., b8 = 16.5))
fm2 <- nls(y ~ b1*exp( -b2*x ) + b3*exp( -(x-b4)**2 / b5**2 )
               + b6*exp( -(x-b7)**2 / b8**2 ), data = Gauss1, trace = TRUE,
           start = c(b1 = 94.0, b2 =  0.0105, b3 = 99.0, b4 = 63.0, b5 = 25.0,
                     b6 = 71.0, b7 = 180.0, b8 = 20.0))
fm3 <- nls(y ~ cbind(exp(-b2*x), exp(-(x-b4)**2/b5**2), exp(-(x-b7)**2/b8**2)),
           data = Gauss1, trace = TRUE,
           start = c( b2 = 0.009, b4 = 65.0, b5 = 20.0, b7 = 178., b8 = 16.5),
           algorithm = "plinear")
fm4 <- nls(y ~ cbind(exp(-b2*x), exp(-(x-b4)**2/b5**2), exp(-(x-b7)**2/b8**2)),
           data = Gauss1, trace = TRUE,
           start = c( b2 = 0.0105, b4 = 63.0, b5 = 25.0, b7 = 180., b8 = 20.0),
           algorithm = "plinear")
}
\keyword{datasets}
\eof
%%% $Id: Gauss2.Rd,v 1.2 2001/01/10 17:49:12 bates Exp $
\name{Gauss2}
\alias{Gauss2}
\non_function{}
\title{Generated data}
\description{
The \code{Gauss2} data frame has 250 rows and 2 columns giving
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of generated response values.
    }
    \item{x}{
      A numeric vector of generated input values.
    }
  }
}
\details{
    The data are two slightly-blended Gaussians on a 
    decaying exponential baseline plus normally 
    distributed zero-mean noise with variance = 6.25. 
}
\source{
    Rust, B., NIST (1996)
}
\examples{
data(Gauss2)
plot(y ~ x, data = Gauss2)
fm1 <- nls(y ~ b1*exp( -b2*x ) + b3*exp( -(x-b4)**2 / b5**2 )
               + b6*exp( -(x-b7)**2 / b8**2 ), data = Gauss2, trace = TRUE,
           start = c(b1 = 96, b2 = 0.009, b3 = 103, b4 = 106, b5 = 18,
                     b6 = 72, b7 = 151, b8 = 18))
fm2 <- nls(y ~ b1*exp( -b2*x ) + b3*exp( -(x-b4)**2 / b5**2 )
               + b6*exp( -(x-b7)**2 / b8**2 ), data = Gauss2, trace = TRUE,
           start = c(b1 = 98, b2 = 0.0105, b3 = 103, b4 = 105, b5 = 20,
                     b6 = 73, b7 = 150, b8 = 20))
fm3 <- nls(y ~ cbind(exp(-b2*x), exp(-(x-b4)**2/b5**2), exp(-(x-b7)**2/b8**2)),
           data = Gauss2, trace = TRUE,
           start = c(b2 = 0.009, b4 = 106, b5 = 18, b7 = 151, b8 = 18),
           algorithm = "plinear")
fm4 <- nls(y ~ cbind(exp(-b2*x), exp(-(x-b4)**2/b5**2), exp(-(x-b7)**2/b8**2)),
           data = Gauss2, trace = TRUE,
           start = c(b2 = 0.0105, b4 = 105, b5 = 20, b7 = 150, b8 = 20),
           algorithm = "plinear")
}
\keyword{datasets}
\eof
%%% $Id: Gauss3.Rd,v 1.2 2001/01/10 17:49:12 bates Exp $
\name{Gauss3}
\alias{Gauss3}
\non_function{}
\title{Generated data}
\description{
The \code{Gauss3} data frame has 250 rows and 2 columns giving generated
data of Gaussian peaks with a decaying exponential background.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of generated responses.
    }
    \item{x}{
      A numeric vector of generated inputs.
    }
  }
}
\details{
  The data are two strongly-blended Gaussians on a 
  decaying exponential baseline plus normally 
  distributed zero-mean noise with variance = 6.25.
}
\source{
Rust, B., NIST (1996).
}
\examples{
data(Gauss3)
plot(y ~ x, data = Gauss3)
fm1 <- nls(y ~ b1*exp( -b2*x ) + b3*exp( -(x-b4)**2 / b5**2 )
               + b6*exp( -(x-b7)**2 / b8**2 ), data = Gauss3, trace = TRUE,
           start = c(b1 = 94.9, b2 = 0.009, b3 = 90.1, b4 = 113, b5 = 20,
                     b6 = 73.8, b7 = 140, b8 = 20))
fm2 <- nls(y ~ b1*exp( -b2*x ) + b3*exp( -(x-b4)**2 / b5**2 )
               + b6*exp( -(x-b7)**2 / b8**2 ), data = Gauss3, trace = TRUE,
           start = c(b1 = 96, b2 = 0.0096, b3 = 80, b4 = 110, b5 = 25,
                     b6 = 74, b7 = 139, b8 = 25)) 
fm3 <- nls(y ~ cbind(exp(-b2*x), exp(-(x-b4)**2/b5**2), exp(-(x-b7)**2/b8**2)),
           data = Gauss3, trace = TRUE,
           start = c(b2 = 0.009, b4 = 113, b5 = 20, b7 = 140, b8 = 20),
           algorithm = "plinear")
fm4 <- nls(y ~ cbind(exp(-b2*x), exp(-(x-b4)**2/b5**2), exp(-(x-b7)**2/b8**2)),
           data = Gauss3, trace = TRUE,
           start = c(b2 = 0.0096, b4 = 110, b5 = 25, b7 = 139, b8 = 25),
           algorithm = "plinear")
}
\keyword{datasets}
\eof
%%% $Id: Hahn1.Rd,v 1.2 2001/01/10 17:49:12 bates Exp $
\name{Hahn1}
\alias{Hahn1}
\non_function{}
\title{Thermal expansion data}
\description{
The \code{Hahn1} data frame has 236 rows and 2 columns of data from a
study on the thermal expansion of copper.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of values of the coefficient of thermal expansion.
    }
    \item{x}{
      A numeric vector of temperatures (K).
    }
  }
}
\details{
  These data are the result of a NIST study involving
  the thermal expansion of copper.  The response 
  variable is the coefficient of thermal expansion, and
  the predictor variable is temperature in degrees 
  Kelvin.
}
\source{
Hahn, T., NIST (197?). 
Copper Thermal Expansion Study.
}
\examples{
data(Hahn1)
plot(y ~ x, data = Hahn1)
fm1 <- nls(y ~ (b1+b2*x+b3*x**2+b4*x**3) / (1+b5*x+b6*x**2+b7*x**3),
           data = Hahn1, trace = TRUE,
           start = c(b1 = 10, b2 = -1, b3 = 0.05,
             b4 = -0.00001, b5 = -0.05, b6 = 0.001, b7 = -0.000001))
fm2 <- nls(y ~ (b1+b2*x+b3*x**2+b4*x**3) / (1+b5*x+b6*x**2+b7*x**3),
           data = Hahn1, trace = TRUE,
           start = c(b1 = 1, b2 = -0.1, b3 = 0.005, b4 = -0.000001,
              b5 = -0.005, b6 = 0.0001, b7 = -0.0000001))
fm3 <- nls(y ~ cbind(1, x, x^2, x^3)/(1+x*(b5+x*(b6+x*b7))),
           data = Hahn1, trace = TRUE, algorithm = "plinear",
           start = c(b5 = -0.05, b6 = 0.001, b7 = -0.000001))
fm4 <- nls(y ~ cbind(1, x, x^2, x^3)/(1+x*(b5+x*(b6+x*b7))),
           data = Hahn1, trace = TRUE, algorithm = "plinear",
           start = c(b5 = -0.005, b6 = 0.0001, b7 = -0.0000001))
}
\keyword{datasets}
\eof
%%% $Id: Kirby2.Rd,v 1.2 2001/01/10 17:49:12 bates Exp $
\name{Kirby2}
\alias{Kirby2}
\non_function{}
\title{Microscope line width standards}
\description{
The \code{Kirby2} data frame has 151 rows and 2 columns of data from an
NIST study on scanning electron microscope line width standards.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of response values.
    }
    \item{x}{
      A numeric vector of input values.
    }
  }
}
\details{
These data are the result of a NIST study involving
scanning electron microscope line with standards.
}
\source{
Kirby, R., NIST (197?).  
Scanning electron microscope line width standards.
}
\examples{
data(Kirby2)
plot(y ~ x, data = Kirby2)
fm1 <- nls(y ~ (b1 + b2*x + b3*x**2) / (1 + b4*x + b5*x**2),
           data = Kirby2, trace = TRUE,
           start = c(b1 = 2, b2 = -0.1, b3 = 0.003, b4 = -0.001, b5 = 0.00001))
fm2 <- nls(y ~ (b1 + b2*x + b3*x**2) / (1 + b4*x + b5*x**2),
           data = Kirby2, trace = TRUE,
           start = c(b1 = 1.5, b2 = -0.15, b3 = 0.0025, b4 = -0.0015,
                     b5 = 0.00002))
fm3 <- nls(y ~ cbind(1, x, x**2)/(1 + x*(b4 + b5*x)),
           data = Kirby2, trace = TRUE, algorithm = "plinear",
           start = c(b4 = -0.001, b5 = 0.00001))
fm4 <- nls(y ~ cbind(1, x, x**2)/(1 + x*(b4 + b5*x)),
           data = Kirby2, trace = TRUE, algorithm = "plinear",
           start = c(b4 = -0.0015, b5 = 0.00002))
}
\keyword{datasets}
\eof
%%% $Id: Lanczos1.Rd,v 1.3 2001/01/10 17:49:12 bates Exp $
\name{Lanczos1}
\alias{Lanczos1}
\non_function{}
\title{Generated data}
\description{
The \code{Lanczos1} data frame has 24 rows and 2 columns of generated
data.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of generated responses.
    }
    \item{x}{
      A numeric vector of generated input values
    }
  }
}
\details{
  These data are taken from an example discussed in
  Lanczos (1956).  The data were generated to 14-digits
  of accuracy using
  \code{f(x) = 0.0951*exp(-x) + 0.8607*exp(-3*x) + 1.5576*exp(-5*x)}.
}
\source{
    Lanczos, C. (1956).
    Applied Analysis.
    Englewood Cliffs, NJ:  Prentice Hall, pp. 272-280.
}
\examples{
data(Lanczos1)
plot(y ~ x, data = Lanczos1)
## plot on log scaleto see the apparent number of exponential terms
plot(y ~ x, data = Lanczos1, log = "y")
\dontrun{
## data are an exact fit so the convergence criterion fails
fm1 <- nls(y ~ b1*exp(-b2*x) + b3*exp(-b4*x) + b5*exp(-b6*x),
           data = Lanczos1, trace = TRUE,
           start = c(b1 = 1.2, b2 = 0.3, b3 = 5.6, b4 = 5.5,
                     b5 = 6.5, b6 = 7.6))
}
\dontrun{
## data are an exact fit so the convergence criterion fails
fm2 <- nls(y ~ b1*exp(-b2*x) + b3*exp(-b4*x) + b5*exp(-b6*x),
           data = Lanczos1, trace = TRUE,
           start = c(b1 = 0.5, b2 = 0.7, b3 = 3.6, b4 = 4.2,
                     b5 = 4, b6 = 6.3))
}
\dontrun{
## data are an exact fit so the convergence criterion fails
fm3 <- nls(y ~ exp(outer(x,-c(b2, b4, b6))),
           data = Lanczos1, trace = TRUE, algorithm = "plinear",
           start = c(b2 = 0.3, b4 = 5.5, b6 = 7.6))
}
\dontrun{
## data are an exact fit so the convergence criterion fails
fm4 <- nls(y ~ exp(outer(x,-c(b2, b4, b6))),
           data = Lanczos1, trace = TRUE, algorithm = "plinear",
           start = c(b2 = 0.7, b4 = 4.2, b6 = 6.3))
}
}
\keyword{datasets}
\eof
%%% $Id: Lanczos2.Rd,v 1.3 2001/01/10 17:49:12 bates Exp $
\name{Lanczos2}
\alias{Lanczos2}
\non_function{}
\title{Generated data}
\description{
The \code{Lanczos2} data frame has 24 rows and 2 columns of generated data.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of generated responses.
    }
    \item{x}{
      A numeric vector of generated input values.
    }
  }
}
\details{
    These data are taken from an example discussed in
    Lanczos (1956).  The data were generated to 6-digits
    of accuracy using
    \code{f(x) = 0.0951*exp(-x) + 0.8607*exp(-3*x) + 1.5576*exp(-5*x)}.
}
\source{
    Lanczos, C. (1956).
    Applied Analysis.
    Englewood Cliffs, NJ:  Prentice Hall, pp. 272-280.
}
\examples{
data(Lanczos2)
plot(y ~ x, data = Lanczos2)
## plot log response to see the number of exponential terms
plot(y ~ x, data = Lanczos2, log = "y")
\dontrun{
## Numerical derivatives do not produce sufficient accuracy to converge
fm1 <- nls(y ~ b1*exp(-b2*x) + b3*exp(-b4*x) + b5*exp(-b6*x),
           data = Lanczos2, trace = TRUE,
           start = c(b1 = 1.2, b2 = 0.3, b3 = 5.6, b4 = 5.5,
                     b5 = 6.5, b6 = 7.6))
}
\dontrun{
## Numerical derivatives do not produce sufficient accuracy to converge
fm2 <- nls(y ~ b1*exp(-b2*x) + b3*exp(-b4*x) + b5*exp(-b6*x),
           data = Lanczos2, trace = TRUE,
           start = c(b1 = 0.5, b2 = 0.7, b3 = 3.6, b4 = 4.2,
                     b5 = 4, b6 = 6.3))
}
\dontrun{
## Numerical derivatives do not produce sufficient accuracy to converge
fm3 <- nls(y ~ exp(outer(x,-c(b2, b4, b6))),
           data = Lanczos2, trace = TRUE, algorithm = "plinear",
           start = c(b2 = 0.3, b4 = 5.5, b6 = 7.6))
}
\dontrun{
## Numerical derivatives do not produce sufficient accuracy to converge
fm4 <- nls(y ~ exp(outer(x,-c(b2, b4, b6))),
           data = Lanczos2, trace = TRUE, algorithm = "plinear",
           start = c(b2 = 0.7, b4 = 4.2, b6 = 6.3))
}
## Use analytic derivatives
Lanczos <- deriv(~ b1*exp(-b2*x) + b3*exp(-b4*x) + b5*exp(-b6*x),
                 paste("b", 1:6, sep = ""),
                 function(x, b1, b2, b3, b4, b5, b6){})
fm5 <- nls(y ~ Lanczos(x, b1, b2, b3, b4, b5, b6),
           data = Lanczos2, trace = TRUE,
           start = c(b1 = 1.2, b2 = 0.3, b3 = 5.6, b4 = 5.5,
                     b5 = 6.5, b6 = 7.6))
fm6 <- nls(y ~ Lanczos(x, b1, b2, b3, b4, b5, b6),
           data = Lanczos2, trace = TRUE,
           start = c(b1 = 0.5, b2 = 0.7, b3 = 3.6, b4 = 4.2,
                     b5 = 4, b6 = 6.3))
}
\keyword{datasets}
\eof
%%% $Id: Lanczos3.Rd,v 1.3 2001/01/10 17:49:12 bates Exp $
\name{Lanczos3}
\alias{Lanczos3}
\non_function{}
\title{Generated data}
\description{
The \code{Lanczos3} data frame has 24 rows and 2 columns of generated data.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of generated responses.
    }
    \item{x}{
      A numeric vector of generated input values.
    }
  }
}
\details{
  These data are taken from an example discussed in
  Lanczos (1956).  The data were generated to 5-digits
  of accuracy using
  \code{f(x) = 0.0951*exp(-x) + 0.8607*exp(-3*x) + 1.5576*exp(-5*x)}.
}
\source{
    Lanczos, C. (1956).
    Applied Analysis.
    Englewood Cliffs, NJ:  Prentice Hall, pp. 272-280.
}
\examples{
data(Lanczos3)
plot(y ~ x, data = Lanczos3)
## plot log response to see the number of exponential terms
plot(y ~ x, data = Lanczos3, log = "y")
\dontrun{
## Numerical derivatives do not produce sufficient accuracy to converge
fm1 <- nls(y ~ b1*exp(-b2*x) + b3*exp(-b4*x) + b5*exp(-b6*x),
           data = Lanczos3, trace = TRUE,
           start = c(b1 = 1.2, b2 = 0.3, b3 = 5.6, b4 = 5.5,
                     b5 = 6.5, b6 = 7.6))
fm2 <- nls(y ~ b1*exp(-b2*x) + b3*exp(-b4*x) + b5*exp(-b6*x),
           data = Lanczos3, trace = TRUE,
           start = c(b1 = 0.5, b2 = 0.7, b3 = 3.6, b4 = 4.2,
                     b5 = 4, b6 = 6.3))
fm3 <- nls(y ~ exp(outer(x,-c(b2, b4, b6))),
           data = Lanczos3, trace = TRUE, algorithm = "plinear",
           start = c(b2 = 0.3, b4 = 5.5, b6 = 7.6))
fm4 <- nls(y ~ exp(outer(x,-c(b2, b4, b6))),
           data = Lanczos3, trace = TRUE, algorithm = "plinear",
           start = c(b2 = 0.7, b4 = 4.2, b6 = 6.3))
}
## Use analytic derivatives
Lanczos <- deriv(~ b1*exp(-b2*x) + b3*exp(-b4*x) + b5*exp(-b6*x),
                 paste("b", 1:6, sep = ""),
                 function(x, b1, b2, b3, b4, b5, b6){})
fm5 <- nls(y ~ Lanczos(x, b1, b2, b3, b4, b5, b6),
           data = Lanczos3, trace = TRUE,
           start = c(b1 = 1.2, b2 = 0.3, b3 = 5.6, b4 = 5.5,
                     b5 = 6.5, b6 = 7.6))
fm6 <- nls(y ~ Lanczos(x, b1, b2, b3, b4, b5, b6),
           data = Lanczos3, trace = TRUE,
           start = c(b1 = 0.5, b2 = 0.7, b3 = 3.6, b4 = 4.2,
                     b5 = 4, b6 = 6.3))
}
\keyword{datasets}
\eof
%%% $Id: MGH09.Rd,v 1.3 2001/01/10 17:49:12 bates Exp $
\name{MGH09}
\alias{MGH09}
\non_function{}
\title{More, Gabrow and Hillstrom example 9}
\description{
The \code{MGH09} data frame has 11 rows and 2 columns giving
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of response values.
    }
    \item{x}{
      A numeric vector of input values.
    }
  }
}
\details{
  This problem was found to be difficult for some very 
  good algorithms.  There is a local minimum at (+inf,
  -14.07..., -inf, -inf) with final sum of squares 
  0.00102734....
  
  See More, J. J., Garbow, B. S., and Hillstrom, K. E. 
  (1981).  \emph{Testing unconstrained optimization software.}
    \bold{ACM Transactions on Mathematical Software}. 7(1): 
    pp. 17--41.
}
\source{
Kowalik, J.S., and M. R. Osborne, (1978).  
Methods for Unconstrained Optimization Problems.  
New York, NY:  Elsevier North-Holland.
}
\examples{
data(MGH09)
plot(y ~ x, data = MGH09)
\dontrun{
## starting values for this attempt are ridiculous
fm1 <- nls(y ~ b1*(x**2+x*b2) / (x**2+x*b3+b4),
           data = MGH09, trace = TRUE,
           start = c(b1 = 25, b2 = 39, b3 = 41.5, b4 = 39))
}
fm2 <- nls(y ~ b1*(x**2+x*b2) / (x**2+x*b3+b4),
           data = MGH09, trace = TRUE,
           start = c(b1 = 0.25, b2 = 0.39, b3 = 0.415, b4 = 0.39))
fm3 <- nls(y ~ cbind(x, x**2) / (x**2+x*b3+b4),
           data = MGH09, trace = TRUE, algorithm = "plinear",
           start = c(b3 = 41.5, b4 = 39))
fm4 <- nls(y ~ cbind(x, x**2) / (x**2+x*b3+b4),
           data = MGH09, trace = TRUE, algorithm = "plinear",
           start = c(b3 = 0.415, b4 = 0.39))
}
\keyword{datasets}
\eof
%%% $Id: MGH10.Rd,v 1.3 2001/01/10 17:49:12 bates Exp $
\name{MGH10}
\alias{MGH10}
\non_function{}
\title{More, Gabrow and Hillstrom example 10}
\description{
The \code{MGH10} data frame has 16 rows and 2 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of response values.
    }
    \item{x}{
      A numeric vector of input values.
    }
  }
}
\details{
  This problem was found to be difficult for some very
  good algorithms.

  See More, J. J., Garbow, B. S., and Hillstrom, K. E. 
  (1981).  \emph{Testing unconstrained optimization software.}
  \bold{ACM Transactions on Mathematical Software.} 7(1): 
  pp. 17-41.
}
\source{
  Meyer, R. R. (1970).  
  Theoretical and computational aspects of nonlinear 
  regression.  In Nonlinear Programming, Rosen, 
  Mangasarian and Ritter (Eds).  
  New York, NY: Academic Press, pp. 465-486.
}
\examples{
data(MGH10)
plot(y ~ x, data = MGH10)
## check plot on log scale for shape
plot(y ~ x, data = MGH10, log = "y")
\dontrun{
## starting values for this run are ridiculous
fm1 <- nls(y ~ b1 * exp(b2/(x+b3)), data = MGH10, trace = TRUE,
           start = c(b1 = 2, b2 = 400000, b3 = 25000))
}
fm2 <- nls(y ~ b1 * exp(b2/(x+b3)), data = MGH10, trace = TRUE,
           start = c(b1 = 0.02, b2 = 4000, b3 = 250))
\dontrun{
fm3 <- nls(y ~ exp(b2/(x+b3)), data = MGH10, trace = TRUE,
           start = c(b2 = 400000, b3 = 25000),
           algorithm = "plinear")
}
fm4 <- nls(y ~ exp(b2/(x+b3)), data = MGH10, trace = TRUE,
           start = c(b2 = 4000, b3 = 250),
           algorithm = "plinear")
}
\author{}
\keyword{datasets}
\eof
%%% $Id: MGH17.Rd,v 1.3 2001/01/10 17:49:12 bates Exp $
\name{MGH17}
\alias{MGH17}
\non_function{}
\title{More, Gabrow and Hillstrom example 17}
\description{
The \code{MGH17} data frame has 33 rows and 2 columns
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of response values.
    }
    \item{x}{
      A numeric vector of input values.
    }
  }
}
\details{
  This problem was found to be difficult for some very
  good algorithms.

  See More, J. J., Garbow, B. S., and Hillstrom, K. E.
  (1981).  \emph{Testing unconstrained optimization software.}
  \bold{ACM Transactions on Mathematical Software.} 7(1):
  pp. 17-41.
}
\source{
  Osborne, M. R. (1972).  
  Some aspects of nonlinear least squares 
  calculations.  In Numerical Methods for Nonlinear 
  Optimization, Lootsma (Ed).  
  New York, NY:  Academic Press, pp. 171-189.
}
\examples{
data(MGH17)
plot(y ~ x, data = MGH17)
\dontrun{
## Starting values here are ridiculous
fm1 <- nls(y ~ b1 + b2*exp(-x*b4) + b3*exp(-x*b5),
           data = MGH17, trace = TRUE,
           start = c(b1 = 50, b2 = 150, b3 = -100, b4 = 1, b5 = 2))
}
fm2 <- nls(y ~ b1 + b2*exp(-x*b4) + b3*exp(-x*b5),
           data = MGH17, trace = TRUE,
           start = c(b1 = 0.5, b2 = 1.5, b3 = -1, b4 = 0.01, b5 = 0.02))
\dontrun{
fm3 <- nls(y ~ cbind(1, exp(-x*b4), exp(-x*b5)),
           data = MGH17, trace = TRUE, algorithm = "plinear",
           start = c(b4 = 1, b5 = 2))
}
fm4 <- nls(y ~ cbind(1, exp(-x*b4), exp(-x*b5)),
           data = MGH17, trace = TRUE, algorithm = "plinear",
           start = c(b4 = 0.01, b5 = 0.02))
}
\keyword{datasets}
\eof
%%% $Id: Misra1a.Rd,v 1.2 2001/01/10 17:49:12 bates Exp $
\name{Misra1a}
\alias{Misra1a}
\non_function{}
\title{Monomolecular Absorption Data}
\description{
  The \code{Misra1a} data frame has 14 rows and 2 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of volume values.
    }
    \item{x}{
      A numeric vector of pressure values.
    }
  }
}
\details{
  These data are the result of a NIST study regarding
  dental research in monomolecular adsorption.  The
  response variable is volume, and the predictor
  variable is pressure.
}
\source{
Misra, D., NIST (1978).  
Dental Research Monomolecular Adsorption Study.
}
\examples{
data(Misra1a)
plot(y ~ x, data = Misra1a)
fm1 <- nls(y ~ b1*(1-exp(-b2*x)), data = Misra1a, trace = TRUE,
           start = c(b1 = 500, b2 = 0.0001) )
fm2 <- nls(y ~ b1*(1-exp(-b2*x)), data = Misra1a, trace = TRUE,
           start = c(b1 = 250, b2 = 0.0005) )
fm3 <- nls(y ~ 1-exp(-b2*x), data = Misra1a, trace = TRUE,
           start = c(b2 = 0.0001), algorithm = "plinear" )
fm4 <- nls(y ~ 1-exp(-b2*x), data = Misra1a, trace = TRUE,
           start = c(b2 = 0.0005), algorithm = "plinear" )
## Using a self-starting model
fm5 <- nls(y ~ SSasympOrig(x, Asym, lrc), data = Misra1a)
}
\keyword{datasets}
\eof
%%% $Id: Misra1b.Rd,v 1.2 2001/01/10 17:49:12 bates Exp $
\name{Misra1b}
\alias{Misra1b}
\non_function{}
\title{Monomolecular Absorption Data}
\description{
The \code{Misra1b} data frame has 14 rows and 2 columns.
It is the same data as \code{Misra1a} but a different model is fit.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of volume values.
    }
    \item{x}{
      A numeric vector of pressure values.
    }
  }
}
\details{
  These data are the result of a NIST study regarding
  dental research in monomolecular adsorption.  The
  response variable is volume, and the predictor
  variable is pressure.
}
\source{
Misra, D., NIST (1978).  
Dental Research Monomolecular Adsorption Study.
}
\examples{
data(Misra1b)
plot(y ~ x, data = Misra1b)
fm1 <- nls(y ~ b1 * (1-(1+b2*x/2)**(-2)), data = Misra1b, trace = TRUE,
           start = c(b1 = 500, b2 = 0.0001) )
fm2 <- nls(y ~ b1 * (1-(1+b2*x/2)**(-2)), data = Misra1b, trace = TRUE,
           start = c(b1 = 300, b2 = 0.0002) )
fm3 <- nls(y ~ 1-(1+b2*x/2)**(-2), data = Misra1b, trace = TRUE,
           start = c(b2 = 0.0001), algorithm = "plinear" )
fm4 <- nls(y ~ 1-(1+b2*x/2)**(-2), data = Misra1b, trace = TRUE,
           start = c(b2 = 0.0005), algorithm = "plinear" )
}
\keyword{datasets}
\eof
%%% $Id: Misra1c.Rd,v 1.2 2001/01/10 17:49:12 bates Exp $
\name{Misra1c}
\alias{Misra1c}
\non_function{}
\title{Monomolecular Absorption data}
\description{
The \code{Misra1c} data frame has 14 rows and 2 columns.
This is the same data as \code{Misra1a} but a different model is fit.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of volume values.
    }
    \item{x}{
      A numeric vector of pressure values.
    }
  }
}
\details{
  These data are the result of a NIST study regarding
  dental research in monomolecular adsorption.  The
  response variable is volume, and the predictor
  variable is pressure.
}
\source{
  Misra, D., NIST (1978).  
  Dental Research Monomolecular Adsorption Study.
}
\examples{
data(Misra1c)
plot(y ~ x, data = Misra1c)
fm1 <- nls(y ~ b1*(1-(1+2*b2*x)**(-.5)), data = Misra1c, trace = TRUE,
           start = c(b1 = 500, b2 = 0.0001) )
fm2 <- nls(y ~ b1*(1-(1+2*b2*x)**(-.5)), data = Misra1c, trace = TRUE,
           start = c(b1 = 600, b2 = 0.0002) )
fm3 <- nls(y ~ 1-(1+2*b2*x)**(-.5), data = Misra1c, trace = TRUE,
           start = c(b2 = 0.0001), algorithm = "plinear" )
fm4 <- nls(y ~ 1-(1+2*b2*x)**(-.5), data = Misra1c, trace = TRUE,
           start = c(b2 = 0.0002), algorithm = "plinear" )
}
\keyword{datasets}
\eof
%%% $Id: Misra1d.Rd,v 1.2 2001/01/10 17:49:12 bates Exp $
\name{Misra1d}
\alias{Misra1d}
\non_function{}
\title{Monomolecular Absorption data}
\description{
  The \code{Misra1d} data frame has 14 rows and 2 columns.
  This is the same data as \code{Misra1a} but a different model is fit.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of volume values.
    }
    \item{x}{
      A numeric vector of pressure values.
    }
  }
}
\details{
  These data are the result of a NIST study regarding
  dental research in monomolecular adsorption.  The
  response variable is volume, and the predictor
  variable is pressure.
}
\source{
Misra, D., NIST (1978).  
Dental Research Monomolecular Adsorption Study.
}
\examples{
data(Misra1d)
plot(y ~ x, data = Misra1d)
fm1 <- nls(y ~ b1*b2*x*((1+b2*x)**(-1)), data = Misra1d, trace = TRUE,
           start = c(b1 = 500, b2 = 0.0001) )
fm2 <- nls(y ~ b1*b2*x*((1+b2*x)**(-1)), data = Misra1d, trace = TRUE,
           start = c(b1 = 450, b2 = 0.0003) )
fm3 <- nls(y ~ b2*x*((1+b2*x)**(-1)), data = Misra1d, trace = TRUE,
           start = c(b2 = 0.0001), algorithm = "plinear" )
fm4 <- nls(y ~ b2*x*((1+b2*x)**(-1)), data = Misra1d, trace = TRUE,
           start = c(b2 = 0.0005), algorithm = "plinear" )
}
\keyword{datasets}
\eof
%%% $Id: Nelson.Rd,v 1.3 2001/01/10 17:49:12 bates Exp $
\name{Nelson}
\alias{Nelson}
\non_function{}
\title{Dialectric breakdown data}
\description{
The \code{Nelson} data frame has 128 rows and 3 columns of data from an
accelerated test of dialectric breakdown.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of dialectric breakdown strength values.
    }
    \item{x1}{
      A numeric vector of time values.
    }
    \item{x2}{
      A numeric vector of temperature values.
    }
  }
}
\details{
  These data are the result of a study involving
  the analysis of performance degradation data from
  accelerated tests, published in IEEE Transactions
  on Reliability.  The response variable is dialectric
  breakdown strength in kilo-volts, and the predictor
  variables are time in weeks and temperature in degrees
  Celsius.
}
\source{
Nelson, W. (1981).  
Analysis of Performance-Degradation Data.  
IEEE Transactions on Reliability.
Vol. 2, R-30, No. 2, pp. 149-155.
}
\examples{
data(Nelson)
plot(y ~ x1, data = Nelson, log = "y")
plot(y ~ x2, data = Nelson, log = "y")
coplot(y ~ x1 | x2, data = Nelson)
coplot(y ~ x2 | x1, data = Nelson)
\dontrun{
fm1 <- nls(log(y) ~ b1 - b2*x1 * exp(-b3*x2), data = Nelson,
           start = c(b1 = 2, b2 = 0.0001, b3 = -0.01), trace = TRUE)
}
fm2 <- nls(log(y) ~ b1 - b2*x1 * exp(-b3*x2), data = Nelson,
           start = c(b1 = 2.5, b2 = 0.000000005, b3 = -0.05), trace = TRUE)
\dontrun{
fm3 <- nls(log(y) ~ cbind(1, -x1 * exp(-b3*x2)), data = Nelson,
           start = c(b3 = -0.01), trace = TRUE, algorithm = "plinear")
}
fm4 <- nls(log(y) ~ cbind(1, -x1 * exp(-b3*x2)), data = Nelson,
           start = c(b3 = -0.05), trace = TRUE, algorithm = "plinear")
}
\keyword{datasets}
\eof
%%% $Id: Ratkowsky2.Rd,v 1.3 2001/01/10 17:49:12 bates Exp $
\name{Ratkowsky2}
\alias{Ratkowsky2}
\non_function{}
\title{Pasture yield data}
\description{
  The \code{Ratkowsky2} data frame has 9 rows and 2 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of pasture yields.
    }
    \item{x}{
      A numeric vector of growing times.
    }
  }
}
\details{
  This model and data are an example of fitting
  sigmoidal growth curves taken from Ratkowsky (1983).
  The response variable is pasture yield, and the
  predictor variable is growing time.
}
\source{
Ratkowsky, D.A. (1983).  
Nonlinear Regression Modeling.
New York, NY:  Marcel Dekker, pp. 61 and 88.
}
\examples{
data(Ratkowsky2)
plot(y ~ x, data = Ratkowsky2)
\dontrun{
fm1 <- nls(y ~ b1 / (1+exp(b2-b3*x)), data = Ratkowsky2, trace = TRUE,
           start = c(b1 = 100, b2 = 1, b3 = 0.1))
}
fm2 <- nls(y ~ b1 / (1+exp(b2-b3*x)), data = Ratkowsky2, trace = TRUE,
           start = c(b1 = 75, b2 = 2.5, b3 = 0.07))
fm3 <- nls(y ~ 1 / (1+exp(b2-b3*x)), data = Ratkowsky2, trace = TRUE,
           start = c(b2 = 1, b3 = 0.1), alg = "plinear")
fm4 <- nls(y ~ 1 / (1+exp(b2-b3*x)), data = Ratkowsky2, trace = TRUE,
           start = c(b2 = 2.5, b3 = 0.07), alg = "plinear")
## Using a self-starting model
fm5 <- nls(y ~ SSlogis(x, Asym, xmid, scal), data = Ratkowsky2)
summary(fm5)
}         
\keyword{datasets}
\eof
%%% $Id: Ratkowsky3.Rd,v 1.3 2001/01/10 17:49:12 bates Exp $
\name{Ratkowsky3}
\alias{Ratkowsky3}
\non_function{}
\title{Onion growth data}
\description{
The \code{Ratkowsky3} data frame has 15 rows and 2 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of dry weights of onion bulbs and tops.
    }
    \item{x}{
      A numeric vector of growing times.
    }
  }
}
\details{
This model and data are an example of fitting  
sigmoidal growth curves taken from Ratkowsky (1983).  
The response variable is the dry weight of onion bulbs 
and tops, and the predictor variable is growing time. 
}
\source{
Ratkowsky, D.A. (1983).  
Nonlinear Regression Modeling.
New York, NY:  Marcel Dekker, pp. 62 and 88.
}
\examples{
data(Ratkowsky3)
plot(y ~ x, data = Ratkowsky3)
\dontrun{
## causes NA/NaN/Inf error
fm1 <- nls(y ~ b1 / ((1+exp(b2-b3*x))**(1/b4)), data = Ratkowsky3,
           start = c(b1 = 100, b2 = 10, b3 = 1, b4 = 1),
           trace = TRUE)
}
fm2 <- nls(y ~ b1 / ((1+exp(b2-b3*x))**(1/b4)), data = Ratkowsky3,
           start = c(b1 = 700, b2 = 5, b3 = 0.75, b4 = 1.3),
           trace = TRUE)
fm3 <- nls(y ~ 1 / ((1+exp(b2-b3*x))**(1/b4)), data = Ratkowsky3,
           start = c(b2 = 10, b3 = 1, b4 = 1), algorithm = "plinear",
           trace = TRUE) 
fm4 <- nls(y ~ 1 / ((1+exp(b2-b3*x))**(1/b4)), data = Ratkowsky3,
           start = c(b2 = 5, b3 = 0.75, b4 = 1.3), algorithm = "plinear",
           trace = TRUE)
}
\keyword{datasets}
\eof
%%% $Id: Roszman1.Rd,v 1.3 2001/01/10 17:49:12 bates Exp $
\name{Roszman1}
\alias{Roszman1}
\non_function{}
\title{Quantum defects in iodine}
\description{
The \code{Roszman1} data frame has 25 rows and 2 columns of data on the
number of quantum defects in iodine atoms at different energy states.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of number of quantum defects.
    }
    \item{x}{
      A numeric vector of the excited energy state.
    }
  }
}
\details{
These data are the result of a NIST study involving
quantum defects in iodine atoms.  The response
variable is the number of quantum defects, and the
predictor variable is the excited energy state.
The argument to the ARCTAN function is in radians.
}
\source{
Roszman, L., NIST (19??).  
Quantum Defects for Sulfur I Atom.
}
\examples{
data(Roszman1)
plot(y ~ x, data = Roszman1)
fm1 <- nls(y ~ b1 - b2*x - atan(b3/(x-b4))/pi, data = Roszman1,
           start = c(b1 = 0.1, b2 = -0.00001, b3 = 1000, b4 = -100),
           trace = TRUE)
fm2 <- nls(y ~ b1 - b2*x - atan(b3/(x-b4))/pi, data = Roszman1,
           start = c(b1 = 0.2, b2 = -0.0000015, b3 = 1200, b4 = -150),
           trace = TRUE)
}
\keyword{datasets}
\eof
%%% $Id: Thurber.Rd,v 1.3 2001/01/10 17:49:12 bates Exp $
\name{Thurber}
\alias{Thurber}
\non_function{}
\title{Electron mobility data}
\description{
The \code{Thurber} data frame has 37 rows and 2 columns.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{y}{
      A numeric vector of electron mobility values.
    }
    \item{x}{
      A numeric vector of logs of electron density values.
    }
  }
}
\details{
  These data are the result of a NIST study involving
  semiconductor electron mobility.  The response 
  variable is a measure of electron mobility, and the 
  predictor variable is the natural log of the density.
}
\source{
  Thurber, R., NIST (197?).  
  Semiconductor electron mobility modeling.
}
\examples{
data(Thurber)
plot(y ~ x, data = Thurber)
fm1 <- nls(y ~ (b1+x*(b2+x*(b3+b4*x))) / (1+x*(b5+x*(b6+x*b7))),
           data = Thurber, trace = TRUE,
           start = c(b1 = 1000, b2 = 1000, b3 = 400, b4 = 40,
                     b5 = 0.7, b6 = 0.3, b7 = 0.03))
fm2 <- nls(y ~ (b1+x*(b2+x*(b3+b4*x))) / (1+x*(b5+x*(b6+x*b7))),
           data = Thurber, trace = TRUE,
           start = c(b1 = 1300, b2 = 1500, b3 = 500, b4 = 75,
                     b5 = 1, b6 = 0.4, b7 = 0.05))
fm3 <- nls(y ~ outer(x, 0:3, "^")/(1+x*(b5+x*(b6+x*b7))),
           data = Thurber, trace = TRUE,
           start = c(b5 = 0.7, b6 = 0.3, b7 = 0.03), alg = "plinear")
fm4 <- nls(y ~ outer(x, 0:3, "^")/(1+x*(b5+x*(b6+x*b7))),
           data = Thurber, trace = TRUE,
           start = c(b5 = 1, b6 = 0.4, b7 = 0.05), alg = "plinear")
fm4
}
\keyword{datasets}
\eof
