% file nnet/class.ind.d copyright (C) 1994-9 W. N. Venables and B. D. Ripley
%
\name{class.ind}
\alias{class.ind}
\title{
Generates Class Indicator Matrix from a Factor
}
\description{
Generates a class indicator function from a given factor.
}
\usage{
class.ind(cl)
}
\arguments{
\item{cl}{
factor or vector of classes for cases.
}}
\value{
a matrix which is zero except for the column corresponding to the class.
}
\references{
  Venables, W. N. and Ripley, B. D. (2002)
  \emph{Modern Applied Statistics with S.} Fourth edition.  Springer.
}
\examples{
# The function is currently defined as
class.ind <- function(cl)
{
  n <- length(cl)
  cl <- as.factor(cl)
  x <- matrix(0, n, length(levels(cl)) )
  x[(1:n) + n*(unclass(cl)-1)] <- 1
  dimnames(x) <- list(names(cl), levels(cl))
  x
}
}
\keyword{neural}
\keyword{utilities}

\eof
% file nnet/multinom.d copyright (C) 1994-9 W. N. Venables and B. D. Ripley
%
\name{multinom}
\alias{multinom}
\alias{add1.multinom}
\alias{anova.multinom}
\alias{coef.multinom}
\alias{drop1.multinom}
\alias{extractAIC.multinom}
\alias{predict.multinom}
\alias{print.multinom}
\alias{summary.multinom}
\alias{print.summary.multinom}
\alias{vcov.multinom}
\alias{model.frame.multinom}
\title{
Fit Multinomial Log-linear Models
}
\description{
Fits multinomial log-linear models via neural networks.
}
\usage{
multinom(formula, data, weights, subset, na.action,
         contrasts = NULL, Hess = FALSE, summ = 0, censored = FALSE,
         model = FALSE, \dots)
}
\arguments{
\item{formula}{
a formula expression as for regression models, of the form
\code{response ~ predictors}. The response should be a factor or a
matrix with K columns, which will be interpreted as counts for each of
K classes.
A log-linear model is fitted, with coefficients zero for the first
class. An offset can be included: it should be a matrix with K columns
if the response is a matrix with K columns or a factor with K > 2
classes, or a vector for a factor with 2 levels.
See the documentation of \code{\link{formula}()} for other details.
}
\item{data}{
an optional data frame in which to interpret the variables occurring
in \code{formula}.
}
\item{weights}{
optional case weights in fitting.
}
\item{subset}{
expression saying which subset of the rows of the data should  be used
in the fit. All observations are included by default.
}
\item{na.action}{
a function to filter missing data.
}
\item{contrasts}{
a list of contrasts to be used for some or all of
the factors appearing as variables in the model formula.
}
\item{Hess}{
logical for whether the Hessian (the observed/expected information matrix)
should be returned.
}
\item{summ}{
integer; if non-zero summarize by deleting duplicate rows and adjust weights.
Methods 1 and 2 differ in speed (2 uses \code{C}); method 3 also combines rows
with the same X and different Y, which changes the baseline for the
deviance.
}
\item{censored}{
If Y is a matrix with \code{K > 2} columns, interpret the entries as one
for possible classes, zero for impossible classes, rather than as
counts.
}
\item{model}{
  logical. If true, the model frame is saved as component \code{model}
  of the returned object.
}
\item{\dots}{
additional arguments for \code{nnet}
}}
\value{
A \code{nnet} object with additional components:

\item{deviance}{
the residual deviance.
}
\item{edf}{
the (effective) number of degrees of freedom used by the model
}
\item{AIC}{
the AIC for this fit.
}
\item{Hessian}{
(if \code{Hess} is true).
}
\item{model}{
(if \code{model} is true).
}}
\references{
  Venables, W. N. and Ripley, B. D. (2002)
  \emph{Modern Applied Statistics with S.} Fourth edition.  Springer.
}
\seealso{
\code{\link{nnet}}
}
\examples{
options(contrasts = c("contr.treatment", "contr.poly"))
library(MASS)
example(birthwt)
(bwt.mu <- multinom(low ~ ., bwt))
\dontrun{Call:
multinom(formula = low ~ ., data = bwt)

Coefficients:
 (Intercept)         age         lwt raceblack raceother
    0.823477 -0.03724311 -0.01565475  1.192371 0.7406606
     smoke      ptd        ht        ui       ftv1     ftv2+
  0.7555234 1.343648 1.913213 0.6802007 -0.4363238 0.1789888


Residual Deviance: 195.4755
AIC: 217.4755
}
}
\keyword{neural}
\keyword{models}

\eof
% file nnet/nnet.Hess.d copyright (C) 1994-2000 W. N. Venables and B. D. Ripley
%
\name{nnetHess}
\alias{nnetHess}
\title{
Evaluates Hessian for a Neural Network
}
\description{
Evaluates the Hessian (matrix of second derivatives) of the specified
neural network. Normally called via argument \code{Hess=TRUE} to \code{nnet} or via
\code{vcov.multinom}.
}
\usage{
nnetHess(net, x, y, weights)
}
\arguments{
\item{net}{
object of class \code{nnet} as returned by \code{nnet}.
}
\item{x}{
training data.
}
\item{y}{
classes for training data.
}
\item{weights}{
the (case) weights used in the \code{nnet} fit.
}}
\value{
square symmetric matrix of the Hessian evaluated at the weights stored
in the net.
}
\references{
  Ripley, B. D. (1996)
  \emph{Pattern Recognition and Neural Networks.} Cambridge.

  Venables, W. N. and Ripley, B. D. (2002)
  \emph{Modern Applied Statistics with S.} Fourth edition.  Springer.
}
\seealso{
\code{\link{nnet}}, \code{\link{predict.nnet}}
}
\examples{
data(iris3)
# use half the iris data
ir <- rbind(iris3[,,1], iris3[,,2], iris3[,,3])
targets <- matrix(c(rep(c(1,0,0),50), rep(c(0,1,0),50), rep(c(0,0,1),50)),
150, 3, byrow=TRUE)
samp <- c(sample(1:50,25), sample(51:100,25), sample(101:150,25))
ir1 <- nnet(ir[samp,], targets[samp,],size=2, rang=0.1, decay=5e-4, maxit=200)
eigen(nnetHess(ir1, ir[samp,], targets[samp,]), TRUE)$values
}
\keyword{neural}

\eof
% file nnet/nnet.d copyright (C) 1994-9 W. N. Venables and B. D. Ripley
%
\name{nnet}
\alias{nnet}
\alias{nnet.default}
\alias{nnet.formula}
\alias{add.net}
\alias{norm.net}
\alias{eval.nn}
\alias{coef.nnet}
\alias{print.nnet}
% \alias{residuals.nnet}
\alias{summary.nnet}
\alias{print.summary.nnet}
\title{
Fit Neural Networks
}
\description{
Fit single-hidden-layer neural network, possibly with skip-layer connections.
}
\usage{
nnet(x, \dots)

\method{nnet}{formula}(formula, data, weights, \dots,
     subset, na.action = na.fail, contrasts = NULL)

\method{nnet}{default}(x, y, weights, size, Wts, mask,
     linout = FALSE, entropy = FALSE, softmax = FALSE,
     censored = FALSE, skip = FALSE, rang = 0.7, decay = 0,
     maxit = 100, Hess = FALSE, trace = TRUE, MaxNWts = 1000,
     abstol = 1.0e-4, reltol = 1.0e-8, \dots)
}
\arguments{
\item{formula}{
A formula of the form \code{class ~ x1 + x2 + \dots}
}
\item{x}{
matrix or data frame of \code{x} values for examples.
}
\item{y}{
matrix or data frame of target values for examples.
}
\item{weights}{
(case) weights for each example -- if missing defaults to 1.
}
\item{size}{
number of units in the hidden layer. Can be zero if there are skip-layer units.
}
\item{data}{
Data frame from which variables specified in  \code{formula} are
preferentially to be taken.
}
\item{subset}{
An index vector specifying the cases to be used in the training
sample.  (NOTE: If given, this argument must be named.)
}
\item{na.action}{
A function to specify the action to be taken if \code{NA}s are found.
The default action is for the procedure to fail.  An alternative is
na.omit, which leads to rejection of cases with missing values on
any required variable.  (NOTE: If given, this argument must be named.)
}
\item{contrasts}{
a list of contrasts to be used for some or all  of
the  factors  appearing as variables in the model formula.
}
\item{Wts}{
initial parameter vector. If missing chosen at random.
}
\item{mask}{
logical vector indicating which parameters should be optimized (default all).
}
\item{linout}{
switch for linear output units. Default logistic output units.
}
\item{entropy}{
switch for entropy (= maximum conditional likelihood) fitting.
Default by least-squares.
}
\item{softmax}{
switch for softmax (log-linear model) and maximum conditional
likelihood fitting. \code{linout}, \code{entropy}, \code{softmax} and \code{censored} are mutually
exclusive.
}
\item{censored}{
A variant on \code{softmax}, in which non-zero targets mean possible
classes. Thus for \code{softmax} a row of \code{(0, 1, 1)} means one example
each of classes 2 and 3, but for \code{censored} it means one example whose
class is only known to be 2 or 3.
}
\item{skip}{
switch to add skip-layer connections from input to output.
}
\item{rang}{
Initial random weights on [-\code{rang}, \code{rang}].  Value about 0.5 unless the
inputs are large, in which case it should be chosen so that
\code{rang} * max(\code{|x|}) is about 1.
}
\item{decay}{
parameter for weight decay.  Default 0.
}
\item{maxit}{
maximum number of iterations. Default 100.
}
\item{Hess}{
If true, the Hessian of the measure of fit at the best set of weights
found is returned as component \code{Hessian}.
}
\item{trace}{
switch for tracing optimization. Default \code{TRUE}.
}
\item{MaxNWts}{
The maximum allowable number of weights.  There is no intrinsic limit
in the code, but increasing \code{MaxNWts} will probably allow fits that
are very slow and time-consuming (and perhaps uninterruptable under
Windows).
}
\item{abstol}{
Stop if the fit criterion falls below \code{abstol}, indicating an
essentially perfect fit.
}
\item{reltol}{
Stop if the optimizer is unable to reduce the fit criterion by a
factor of at least \code{1 - reltol}.
}
\item{\dots}{
arguments passed to or from other methods.
}}
\value{
object of class \code{"nnet"} or \code{"nnet.formula"}.
Mostly internal structure, but has components

\item{wts}{
the best set of weights found
}
\item{value}{
value of fitting criterion plus weight decay term.
}
\item{fitted.values}{
the fitted values for the training data.
}
\item{residuals}{
the residuals for the training data.
}}
\details{
If the response in \code{formula} is a factor, an appropriate classification
network is constructed; this has one output and entropy fit if the
number of levels is two, and a number of outputs equal to the number
of classes and a softmax output stage for more levels.  If the
response is not a factor, it is passed on unchanged to \code{nnet.default}.

Optimization is done via the BFGS method of \code{\link{optim}}.
}
\references{
  Ripley, B. D. (1996)
  \emph{Pattern Recognition and Neural Networks.} Cambridge.

  Venables, W. N. and Ripley, B. D. (2002)
  \emph{Modern Applied Statistics with S.} Fourth edition.  Springer.
}
\seealso{
\code{\link{predict.nnet}}, \code{\link{nnetHess}}
}
\examples{
data(iris3)
# use half the iris data
ir <- rbind(iris3[,,1],iris3[,,2],iris3[,,3])
targets <- class.ind( c(rep("s", 50), rep("c", 50), rep("v", 50)) )
samp <- c(sample(1:50,25), sample(51:100,25), sample(101:150,25))
ir1 <- nnet(ir[samp,], targets[samp,], size = 2, rang = 0.1,
            decay = 5e-4, maxit = 200)
test.cl <- function(true, pred){
        true <- max.col(true)
        cres <- max.col(pred)
        table(true, cres)
}
test.cl(targets[-samp,], predict(ir1, ir[-samp,]))


# or
ird <- data.frame(rbind(iris3[,,1], iris3[,,2], iris3[,,3]),
	species = c(rep("s",50), rep("c", 50), rep("v", 50)))
ir.nn2 <- nnet(species ~ ., data = ird, subset = samp, size = 2, rang = 0.1,
               decay = 5e-4, maxit = 200)
table(ird$species[-samp], predict(ir.nn2, ird[-samp,], type = "class"))
}
\keyword{neural}

\eof
% file nnet/predict.nnet.d copyright (C) 1994-9 W. N. Venables and B. D. Ripley
%
\name{predict.nnet}
\alias{predict.nnet}
\title{
Predict New Examples by a Trained Neural Net
}
\description{
Predict new examples by a trained neural net.
}
\usage{
\method{predict}{nnet}(object, newdata, type = c("raw","class"), \dots)
}
\arguments{
\item{object}{
an object of class \code{nnet} as  returned by \code{nnet}.
}
\item{newdata}{
matrix or data frame of test examples. A vector is considered to be
a row vector comprising a single case.
}
\item{type}{
Type of output
}
\item{\dots}{
arguments passed to or from other methods.
}}
\value{
If \code{type = "raw"}, the matrix of values returned by the trained network;
if \code{type = "class"}, the corresponding class (which is probably only
useful if the net was generated by \code{nnet.formula}).
}
\details{
This function is a method for the generic function
\code{predict()} for class \code{"nnet"}.
It can be invoked by calling \code{predict(x)} for an
object \code{x} of the appropriate class, or directly by
calling \code{predict.nnet(x)} regardless of the
class of the object.
}
\references{
  Ripley, B. D. (1996)
  \emph{Pattern Recognition and Neural Networks.} Cambridge.

  Venables, W. N. and Ripley, B. D. (2002)
  \emph{Modern Applied Statistics with S.} Fourth edition.  Springer.
}
\seealso{
\code{\link{nnet}}, \code{\link{which.is.max}}
}
\examples{
data(iris3)
# use half the iris data
ir <- rbind(iris3[,,1], iris3[,,2], iris3[,,3])
targets <- class.ind( c(rep("s", 50), rep("c", 50), rep("v", 50)) )
samp <- c(sample(1:50,25), sample(51:100,25), sample(101:150,25))
ir1 <- nnet(ir[samp,], targets[samp,],size = 2, rang = 0.1,
            decay = 5e-4, maxit = 200)
test.cl <- function(true, pred){
        true <- max.col(true)
        cres <- max.col(pred)
        table(true, cres)
}
test.cl(targets[-samp,], predict(ir1, ir[-samp,]))

# or
ird <- data.frame(rbind(iris3[,,1], iris3[,,2], iris3[,,3]),
	species=c(rep("s",50), rep("c", 50), rep("v", 50)))
ir.nn2 <- nnet(species ~ ., data = ird, subset = samp, size = 2, rang = 0.1,
            decay = 5e-4, maxit = 200)
table(ird$species[-samp], predict(ir.nn2, ird[-samp,], type = "class"))
}
\keyword{neural}

\eof
% file nnet/which.is.max.d copyright (C) 1994-9 W. N. Venables and B. D. Ripley
%
\name{which.is.max}
\alias{which.is.max}
\title{
Find Maximum Position in Vector
}
\description{
Find the maximum position in a vector, breaking ties at random.
}
\usage{
which.is.max(x)
}
\arguments{
\item{x}{
a vector
}}
\value{
index of a maximal value.
}
\details{
Ties are broken at random.
}
\seealso{
\code{\link{max.col}}, \code{\link{which.max}} which takes the first of ties.
}
\references{
  Venables, W. N. and Ripley, B. D. (2002)
  \emph{Modern Applied Statistics with S.} Fourth edition.  Springer.
}
\examples{
\dontrun{
pred <- predict(nnet, test)
table(true, apply(pred,1,which.is.max))
}}
\keyword{utilities}

\eof
