qq.plot                 package:car                 R Documentation

_Q_u_a_n_t_i_l_e-_C_o_m_p_a_r_i_s_o_n _P_l_o_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     Plots empirical quantiles of a variable, or of studentized
     residuals from a linear model, against theoretical quantiles of a
     comparison distribution.

_U_s_a_g_e:

     qq.plot(x, ...)

     qqp(...)

     ## Default S3 method:
     qq.plot(x, distribution="norm", 
       ylab=deparse(substitute(x)), 
       xlab=paste(distribution, "quantiles"), main="", las=par('las'),
       envelope=0.95, labels=FALSE, col=palette()[2], lwd=2, pch=1,
       line=c("quartiles", "robust", "none"), ...)

     ## S3 method for class 'lm':
     qq.plot(x, main="", xlab=paste(distribution, "Quantiles"), 
       ylab=paste("Studentized Residuals(", deparse(substitute(x)), ")",
         sep = ""), 
       distribution=c("t", "norm"), line=c("quartiles", "robust", "none"), 
       las=par('las'), simulate=FALSE, envelope=0.95, labels=names(rstudent), 
       reps=100, col=palette()[2], lwd=2, pch=1, ...)

_A_r_g_u_m_e_n_t_s:

       x: vector of numeric values or 'lm' object.

distribution: root name of comparison distribution - e.g., 'norm' for
          the normal distribution; 't' for the t-distribution.

    ylab: label for vertical (empirical quantiles) axis.

    xlab: label for horizontal (comparison quantiles) axis.

    main: label for plot.

envelope: confidence level for point-wise confidence envelope, or 
          'FALSE' for no envelope.

  labels: vector of point labels for interactive point identification,
          or 'FALSE' for no labels.

     las: if '0', ticks labels are drawn parallel to the axis; set to
          '1' for horizontal labels (see 'par').

     col: color for points and lines; the default is the _second_ entry
          in the current color palette (see 'palette' and 'par').

     pch: plotting character for points; default is '1'  (a circle, see
          'par').

     lwd: line width; default is '2' (see 'par'). Confidence envelopes
          are drawn at half this line width.

    line: '"quartiles"' to pass a line through the quartile-pairs, or
          '"robust"' for a robust-regression line; the latter uses the
          'rlm' function in the 'MASS' package. Specifying 'line =
          "none"' suppresses the line.

simulate: if 'TRUE' calculate confidence envelope by parametric
          bookstrap; for 'lm' object only. The method is due to
          Atkinson (1985).

    reps: integer; number of bootstrap replications for confidence
          envelope.

     ...: arguments such as 'df' to be passed to the appropriate
          quantile function.

_D_e_t_a_i_l_s:

     Draws theoretical quantile-comparison plots for variables and for
     studentized residuals from a linear model. A comparison line is
     drawn on the plot either through the quartiles of the two
     distributions, or by robust regression. 

     Any distribution for which quantile and density functions exist in
     R (with prefixes 'q' and 'd', respectively) may be used. 
     Studentized residuals are plotted against the appropriate
     t-distribution.

     The function 'qqp' is an abbreviation for 'qq.plot'.

_V_a_l_u_e:

     'NULL'. These functions are used only for their side effect (to
     make a graph).

_A_u_t_h_o_r(_s):

     John Fox jfox@mcmaster.ca

_R_e_f_e_r_e_n_c_e_s:

     Fox, J. (1997) _Applied Regression, Linear Models, and Related
     Methods._ Sage.

     Atkinson, A. C. (1985) _Plots, Transformations, and Regression._
     Oxford.

_S_e_e _A_l_s_o:

     'qqplot', 'qqnorm', 'qqline'

_E_x_a_m_p_l_e_s:

     x<-rchisq(100, df=2)
     qq.plot(x)
     qq.plot(x, dist="chisq", df=2)

     data(Ornstein)
     mod<-lm(interlocks~assets+sector+nation, data=Ornstein)
     qq.plot(mod, sim=TRUE)

