spread.level.plot            package:car            R Documentation

_S_p_r_e_a_d-_L_e_v_e_l _P_l_o_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     Creates plots for examining the possible dependence of spread on
     level, or an extension of these plots to the studentized residuals
     from linear models.

_U_s_a_g_e:

     spread.level.plot(x, ...)

     slp(x, ...)

     ## S3 method for class 'formula':
     spread.level.plot(formula, data=NULL, subset, na.action, 
         main=paste("Spread-Level Plot for", varnames[response], 
         "by", varnames[-response]), ...)

     ## Default S3 method:
     spread.level.plot(x, by, 
       robust.line=any("MASS"==.packages(all=TRUE)), 
       start=0, xlab="Median", ylab="Hinge-Spread", las=par("las"),
       main=paste("Spread-Level Plot for", deparse(substitute(x)), 
       "by", deparse(substitute(by))), col=palette()[2], pch=1, lwd=2, ...)

     ## S3 method for class 'lm':
     spread.level.plot(x, start=0, 
       robust.line=any("MASS"==.packages(all=TRUE)), 
       xlab="Fitted Values",
       ylab="Absolute Studentized Residuals", las=par("las"),
       main=paste("Spread-Level Plot for", deparse(substitute(x))),
       pch=1, col=palette()[2], lwd=2, ...)
       
     ## S3 method for class 'spread.level.plot':
     print(x, ...)

_A_r_g_u_m_e_n_t_s:

       x: a formula or an 'lm' object to be plotted; alternatively a
          numeric vector.

 formula: a formula of the form 'y~x', where 'y' is a numeric vector
          and 'x' is a factor.

    data: an optional data frame containing the variables to be
          plotted.  By default the variables are taken from the
          environment from which  'spread.level.plot' is called.

  subset: an optional vector specifying a subset of observations to be
          used.

na.action: a function that indicates what should happen when the data
          contain 'NA's.  The default is set by the 'na.action' setting
          of 'options'.

      by: a factor, numeric or character vector defining groups.

robust.line: if 'TRUE' a robust line is fit using the 'rlm' function in
          the 'MASS' package; if 'FALSE' a line is fit using 'lm'.

   start: add the constant 'start' to each data value.

    main: title for the plot.

    xlab: label for horizontal axis.

    ylab: label for vertical axis.

     las: if '0', ticks labels are drawn parallel to the axis; set to
          '1' for horizontal labels (see 'par').

     col: color for points and lines; the default is the _second_ entry
          in the current color palette (see 'palette' and 'par').

     pch: plotting character for points; default is '1'  (a circle, see
          'par').

     lwd: line width; default is '2' (see 'par').

     ...: arguments passed to plotting functions.

_D_e_t_a_i_l_s:

     Except for linear models, computes the statistics for, and plots,
     a Tukey spread-level plot of log(hinge-spread) vs. log(median) for
     the groups; fits a line to the plot; and calculates a
     spread-stabilizing transformation from the slope of the line. 

     For linear models, plots log(abs(studentized residuals) vs.
     log(fitted values).

     The function 'slp' is an abbreviation for 'spread.level.plot'.

_V_a_l_u_e:

     A list containing: 

Statistics: a matrix with the lower-hinge, median, upper-hinge, and
          hinge-spread for each group. (Not for an 'lm' object.)

PowerTransformation: spread-stabilizing power transformation,
          calculated as 1 - slope of the line fit to the plot.

_A_u_t_h_o_r(_s):

     John Fox jfox@mcmaster.ca

_R_e_f_e_r_e_n_c_e_s:

     Fox, J. (1997) _Applied Regression, Linear Models, and Related
     Methods._ Sage.

     Hoaglin, D. C., Mosteller, F. and Tukey, J. W. (Eds.) (1983)
     _Understanding Robust and Exploratory Data Analysis._ Wiley.

_S_e_e _A_l_s_o:

     'hccm', 'ncv.test'

_E_x_a_m_p_l_e_s:

     data(Ornstein)
     attach(Ornstein)
     spread.level.plot(interlocks+1~nation)
     ## $Statistics
     ##     LowerHinge Median UpperHinge Hinge-Spread
     ## US           2    6.0         13           11
     ## UK           4    9.0         14           10
     ## CAN          6   13.0         30           24
     ## OTH          4   15.5         24           20
     ## 
     ## $PowerTransformation
     ## [1] 0.1534487
     mod<-lm(interlocks ~ assets + sector + nation)
     slp(mod)
     ## $PowerTransformation
     ## [1] 0.3222165
     ## 
     ## Warning message: 
     ## Start =  3 added to fitted values to avoid 0 or negative values. in: spread.level.plot.lm(x, ...) 

