### Name: Anova
### Title: Anova Tables for Linear and Generalized Linear Models
### Aliases: Anova Anova.lm Anova.aov Anova.II.lm Anova.III.lm Anova.glm
###   Anova.II.F.glm Anova.II.LR.glm Anova.II.Wald.glm Anova.III.F.glm
###   Anova.III.LR.glm Anova.III.Wald.glm
### Keywords: htest models regression

### ** Examples

data(Moore)
mod<-lm(conformity~fcategory*partner.status, data=Moore, 
  contrasts=list(fcategory=contr.sum, partner.status=contr.sum))
Anova(mod)
## Anova Table (Type II tests)
##
## Response: conformity
##                         Sum Sq Df F value   Pr(>F)
## fcategory                 11.61  2  0.2770 0.759564
## partner.status           212.21  1 10.1207 0.002874
## fcategory:partner.status 175.49  2  4.1846 0.022572
## Residuals                817.76 39                 
Anova(mod, type="III")
## Anova Table (Type III tests)
##
## Response: conformity
##                          Sum Sq Df  F value    Pr(>F)
## (Intercept)              5752.8  1 274.3592 < 2.2e-16
## fcategory                  36.0  2   0.8589  0.431492
## partner.status            239.6  1  11.4250  0.001657
## fcategory:partner.status  175.5  2   4.1846  0.022572
## Residuals                 817.8 39                   



