### Name: Transformation Axes
### Title: Axes for Transformed Variables
### Aliases: power.axis box.cox.axis prob.axis
### Keywords: aplot

### ** Examples

data(UN)
UN<-na.omit(UN)
attach(UN)
par(mar=c(5, 4, 4, 4)+.1)

plot(log(gdp, 10), log(infant.mortality, 10))
power.axis(0, base=10, side="above", 
  at=c(50,200,500,2000,5000,20000),grid=TRUE, axis.title="GDP per capita")
power.axis(0, base=10, side="right",
  at=c(5,10,20,50,100), grid=TRUE, axis.title="infant mortality rate per 1000")

plot(box.cox(gdp, 0), box.cox(infant.mortality, 0))
box.cox.axis(0, side="above", 
  grid=TRUE, axis.title="GDP per capita")
box.cox.axis(0, side="right",
  grid=TRUE, axis.title="infant mortality rate per 1000")

qq.plot(logit(infant.mortality/1000))
prob.axis()

qq.plot(logit(infant.mortality/1000))
prob.axis(c(.005, .01, .02, .04, .08, .16))



