### Name: box.cox.var
### Title: Constructed Variable for Box-Cox Transformation
### Aliases: box.cox.var
### Keywords: manip regression

### ** Examples

data(Ornstein)
mod<-lm(interlocks+1~assets, data=Ornstein)
mod.aux<-update(mod, .~.+box.cox.var(interlocks+1))
summary(mod.aux)
## Call:
## lm(formula = interlocks + 1 ~ assets + box.cox.var(interlocks + 
##     1), data = Ornstein)
## 
## Residuals:
##     Min      1Q  Median      3Q     Max 
## -23.189  -6.701   0.541   6.773  12.051 
## 
## Coefficients:
##                               Estimate Std. Error t value Pr(>|t|)
## (Intercept)                  1.461e+01  5.426e-01  26.920   <2e-16
## assets                      -7.142e-05  5.119e-05  -1.395    0.164
## box.cox.var(interlocks + 1)  7.427e-01  4.136e-02  17.956   <2e-16
## 
## Residual standard error: 7.247 on 245 degrees of freedom
## Multiple R-Squared: 0.7986,     Adjusted R-squared: 0.797 
## F-statistic: 485.7 on 2 and 245 degrees of freedom,     p-value:     0 
av.plots(mod.aux, "box.cox.var(interlocks + 1)")



