### Name: flexmix
### Title: Flexible Mixture Modeling
### Aliases: flexmix flexmix,formula,ANY,ANY,ANY,missing-method
###   flexmix,formula,ANY,ANY,ANY,list-method
###   flexmix,formula,ANY,ANY,ANY,FLXmodel-method parameters
###   parameters,flexmix-method predict,flexmix-method show,flexmix-method
### Keywords: regression cluster

### ** Examples


## generate some artificial data with a Gaussian response y and a
## Poisson response yp
x <- runif(200, 0, 10)
mydf <- data.frame(x=x,
                 y=c(5*x[1:100], 40-(x[101:200]-5)^2)+3*rnorm(200),
                 yp=rpois(200, exp(c(2-0.2*x[1:100], 1+0.1*x[101:200]))),
                 class=rep(1:2, c(100,100)))

plot(y~x, data=mydf, col=class)

## mixture of two linear regression models. Note that control parameters
## can be specified as named list and abbreviated if unique.
ex.qpol <- flexmix(y~x+I(x^2), data=mydf, k=2,
                   control=list(verb=5, iter=100))

ex.qpol
ex.qpol@components

## now use both responses simultanously
## first we have a look at the data
opar <- par("mfrow")
par(mfrow=1:2)
plot(y~x, data=mydf, col=class)
plot(yp~x, data=mydf, col=class)
par(mfrow=opar)

## now we fit a model with one Gaussian response and one Poisson
## response. Note that the formulas inside the call to FLXglm are
## relative to the overall model formula.
ex.qpol1 <- flexmix(y~x, data=mydf, k=2,
                    model=list(FLXglm(y~.+I(x^2)), 
                               FLXglm(yp~., family="poisson")))  

ex.qpol1
table(ex.qpol1@cluster, mydf$class)

## for Gaussian responses we get coefficients and standard deviation
parameters(ex.qpol1, component=1, model=1)

## for Poisson response we get only coefficients
parameters(ex.qpol1, component=1, model=2)



