\name{AIC-methods}
\docType{methods}
\title{Methods for Function AIC}
\alias{AIC,flexmix-method}
\description{Evaluate the Akaike Information Criterion.
  This function is defined as an old-style generic in the \code{base}
  package.  In this package is it converted to an S4 generic.}
\section{Methods}{
  \describe{
    \item{object = ANY}{Evaluate the AIC of a general object}
    \item{object = flexmix}{Evaluate the AIC of an
      \code{flexmix} object}
  }
}
\keyword{methods}
\eof
\name{BIC}
\docType{genericFunction}
\alias{BIC}
\alias{BIC,logLik-method}
\alias{BIC,flexmix-method}
\title{Bayesian Information Criterion}
\description{
  This generic function calculates the Bayesian information criterion,
  also known as Schwarz's Bayesian criterion (SBC), for one or several
  fitted model objects for which a log-likelihood value can be obtained,
  according to the formula \eqn{-2 \mbox{log-likelihood} + n_{par}
    \log(n_{obs})}{-2*log-likelihood + npar*log(nobs)}, where
  \eqn{n_{par}}{npar}  represents the
  number of parameters and \eqn{n_{obs}}{nobs} the number of
  observations in the fitted model. 
}
\usage{
BIC(object, \dots)
}
\arguments{
  \item{object}{An object of a suitable class for the BIC to be
    calculated - usually a \code{\link[base:logLik]{logLik}} object
    created by a call to the \code{\link[base:logLik]{logLik}} generic.
  }
  \item{\dots}{Some methods for this generic function may take
    additional, optional arguments.  At present none do.}
}
\value{
  if just one object is provided, returns a numeric value with the
  corresponding BIC; if more than one object are provided, returns a
  \code{data.frame} with rows corresponding to the objects and columns
  representing the number of parameters in the model (\code{df}) and the
  BIC.
}
\references{
  Schwarz, G. (1978) "Estimating the Dimension of a Model", Annals of
  Statistics, 6, 461-464.
}
\author{Function copied from package lme4 by Douglas Bates and Saikat DebRoy}
%\note{}
\seealso{\code{\link[base:logLik]{logLik}}, \code{\link{AIC}}}
%\examples{}
\keyword{models}
\eof
\name{FLXcomponent-class}
\docType{class}
\alias{FLXcomponent-class}
\alias{show,FLXcomponent-method}
\title{Class "FLXcomponent"}
\description{A fitted component of a \code{\link{flexmix}} model.}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("FLXcomponent", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{df}:}{Number of paramters used by the component.}
    \item{\code{logLik}:}{Function computing the log-likelihood of
      observations.}
    \item{\code{parameters}:}{List with model parameters.}
    \item{\code{predict}:}{Function predicting response for new data.}
  }
}
\author{Friedrich Leisch}
\keyword{classes}
\eof
\name{FLXcontrol-class}
\docType{class}
\alias{FLXcontrol-class}
\alias{coerce,list,FLXcontrol-method}
\alias{coerce,NULL,FLXcontrol-method}
\title{Class "FLXcontrol"}
\description{Hyperparameters for the EM algorithm.}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("FLXcontrol",
  ...)}. In addition, named lists can be coerced to \code{FLXcontrol}
objects, names are completed if unique (see examples).
}
\section{Slots}{
  \describe{
    \item{\code{iter.max}:}{Maximum number of iterations.}
    \item{\code{minprior}:}{Minimum prior probability of clusters,
      components falling below this threshold are removed during the
      iteration.}
    \item{\code{tolerance}:}{The EM algorithm is stopped when the
      (relative) change of log-likelood is smaller than \code{tolerance}.}
    \item{\code{verbose}:}{If a positive integer, then the
      log-likelihood is reported every \code{verbose} iterations. If 0,
      no output is generated during model fitting.}
    \item{\code{classify}:}{Character string, one of \code{"auto"},
      \code{"weighted"}, \code{"hard"}, \code{"random"}.}
  }
}

\author{Friedrich Leisch}
\keyword{classes}
\examples{
mycont = list(iter=200, tol=0.001, class="r")
as(mycont, "FLXcontrol")
}
\eof
\name{FLXfit}
\alias{FLXfit}
\title{Fitter Function for FlexMix Models}
\description{
  This is the basic computing engine called by \code{\link{flexmix}}, it
  should usually not be used directly unless
  by experienced users.
}
\usage{
FLXfit(k = NULL, cluster = NULL, model, control)
}
\arguments{
  \item{k}{Number of clusters (not needed if \code{cluster} is specified).}
  \item{cluster}{Initial cluster assignments of observations at the
    start of the EM algorithm (default is random assignment into \code{k}
    clusters).}
  \item{model}{List of \code{FLXmodel} objects.}
  \item{control}{Object of class \code{FLXcontrol}.}
}
\value{
  Returns an object of class \code{flexmix}.
}
\author{Friedrich Leisch}
\seealso{\code{\link{flexmix}}, \code{\link{flexmix-class}}}
\keyword{regression}
\keyword{cluster}
\eof
\name{FLXglm}
\alias{FLXglm}
\title{FlexMix Interface to Generalized Linear Models}
\description{
  This is the main driver for FlexMix interfacing the \code{\link{glm}}
  family of models.
}
\usage{
FLXglm(formula = . ~ ., family = c("gaussian", "binomial", "poisson", "Gamma"))
}
\arguments{
  \item{formula}{A formula which is interpreted relative to the formula
    specified in the call to \code{\link{flexmix}} using
    \code{\link{update.formula}}. Default is to use the original
    \code{\link{flexmix}} model
    formula.}
  \item{family}{A character string naming a \code{\link{glm}}
    family function.}
}
\details{
  See \code{\link{flexmix}} for examples.
}
\value{
  Returns an object of class \code{FLXmodel}.
}
\author{Friedrich Leisch}
\seealso{\code{\link{flexmix}}, \code{\link{glm}}}
\keyword{regression}
\keyword{models}
\eof
\name{FLXmclust}
\alias{FLXmclust}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{FlexMix Clustering Demo Driver}
\description{
  This is a demo driver for \code{\link{flexmix}} implementing
  model-based clustering of Gaussian data. 
}
\usage{
FLXmclust(formula = . ~ ., diagonal = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{formula}{A formula which is interpreted relative to the formula
    specified in the call to \code{\link{flexmix}} using
    \code{\link{update.formula}}. Only the left-hand side (response) of
    the formula is used. Default is to use the original
    \code{\link{flexmix}} model
    formula.}
  \item{diagonal}{If \code{TRUE}, then the covariance matrix of the
    components is restricted to diagonal matrices.}
}
\details{
  This is meant as a demo for FlexMix driver programming, use package
  mclust for real applications. 
}
\value{
  Returns an object of class \code{FLXmodel}.
}
\author{Friedrich Leisch}
\seealso{\code{\link{flexmix}}}
\keyword{cluster}
\examples{
## The function is currently defined as
FLXmclust

## are packages mvtnorm and ellipse available?
owarn = getOption("warn")
options(warn=-1)
have.mvtnorm=require("mvtnorm", quietly=TRUE)
have.ellipse=require("ellipse", quietly=TRUE)
options(warn=owarn)


if(have.mvtnorm){
  require("MASS")

  ## generate some artificial data
  x <- rbind(rmvnorm(100, mean=rep(0,2)),
             rmvnorm(100, mean=c(8,0), sigma=diag(1:2)),
             rmvnorm(150, mean=c(-2,6), sigma=diag(2:1)),
             rmvnorm(200, mean=c(4,4), sigma=matrix(c(1,.9,.9,1), 2)))

  eqscplot(x)

  ## define a utility function for visualization of results
  plot.ex.mbc = function(object, data){    
    eqscplot(data, col=object@cluster)
    if(have.ellipse){
      for(k in 1:length(object@components)){
          p = parameters(object, k)
          lines(ellipse(p$cov, centre=p$center), col=k)
      } 
    }
  }

  ## This model is wrong (one component has a non-diagonal cov matrix)
  ex.mbc <- flexmix(x~1, k=4, model=FLXmclust())
  print(ex.mbc)
  plot.ex.mbc(ex.mbc, x)

  ## True model, wrong number of components
  ex.mbc <- flexmix(x~1, k=6, model=FLXmclust(diag=FALSE))  
  print(ex.mbc)

  plot.ex.mbc(ex.mbc, x)

  print(parameters(ex.mbc, component=1))
}else{
  cat("Sorry, I need package mvtnorm for these examples!\n\n")
}
}
\eof
\name{FLXmodel-class}
\docType{class}
\alias{FLXmodel-class}
\alias{show,FLXmodel-method}
\title{Class "FLXmodel"}
\description{FlexMix model specification.}
\section{Objects from the Class}{
  Objects can be created by calls of the form \code{new("FLXmodel", ...)},
  typically inside driver functions like \code{\link{FLXglm}} or
  \code{\link{FLXmclust}}. 
}
\section{Slots}{
  \describe{
    \item{\code{fit}:}{Function returning an \code{FLXmodel} object.}
    \item{\code{weighted}:}{Logical indicating whether \code{fit} can do
    weighted likelihood maximization.}
    \item{\code{name}:}{Character string used in print methods.}
    \item{\code{formula}:}{Formula describing the model.}
    \item{\code{x}:}{Model matrix.}
    \item{\code{y}:}{Model response.}
  }
}

\author{Friedrich Leisch}
\keyword{classes}
\eof
\name{flexmix-class}
\docType{class}
\alias{flexmix-class}
\title{Class "flexmix"}
\description{A fitted \code{\link{flexmix}} model.}
\section{Objects from the Class}{
Objects are typically created by calling function \code{\link{flexmix}}.
}
\section{Slots}{
  \describe{
    \item{\code{model}:}{List of \code{FLXmodel} objects.}
    \item{\code{prior}:}{Numeric vector with prior probabilities of clusters.}
    \item{\code{posterior}:}{Named list with elements \code{scaled}
      and \code{unscaled}, both matrices with one row per observation
      and one column per cluster.}
    \item{\code{iter}:}{Number of EM
      iterations.}
    \item{\code{cluster}:}{Cluster assignments of observations.}
    \item{\code{logLik}:}{Log-likelihood at EM convergence.}
    \item{\code{df}:}{Total number of
      parameters of the model.}
    \item{\code{components}:}{List describing
      the fitted components using \code{FLXcomponent} objects.}
    \item{\code{formula}:}{Object of class \code{"formula"}.}
    \item{\code{control}:}{Object of class \code{"FLXcontrol"}.}
    \item{\code{call}:}{The function call
      used to create the object.}
  }
}

\section{Methods}{
  \describe{
    \item{AIC}{\code{signature(object = "flexmix")}: calculate Akaike's
      information criterion.}
    \item{BIC}{\code{signature(object = "flexmix")}: calculate the
      Bayesian information criterion.}
    \item{logLik}{\code{signature(object = "flexmix")}: calculate the
      log-likelihood for the model.}
    \item{parameters}{\code{signature(object = "flexmix")}: extract
      parameters of model components.}
    \item{predict}{\code{signature(object = "flexmix")}: predict
      response for new data.}
  }
}
\author{Friedrich Leisch}
\keyword{classes}
\eof
\name{flexmix}
\alias{flexmix}
\alias{flexmix,formula,ANY,ANY,ANY,missing-method}
\alias{flexmix,formula,ANY,ANY,ANY,list-method}
\alias{flexmix,formula,ANY,ANY,ANY,FLXmodel-method}
\alias{parameters}
\alias{parameters,flexmix-method}
\alias{predict,flexmix-method}
\alias{show,flexmix-method}
\title{Flexible Mixture Modeling}
\description{
  FlexMix implements a general framework for finite
  mixtures of regression models. Parameter estimation is performed using
  the EM algorithm: the E-step is implemented by \code{flexmix}, while
  the user can specify the M-step.
}
\usage{
flexmix(formula, data = list(), k = NULL, cluster = NULL,
        model=NULL, control = NULL)
}
\arguments{
  \item{formula}{A symbolic description of the model to be fit. The details of
    model specification are given below.}
  \item{data}{An optional data frame containing the variables in the model.}
  \item{k}{Number of clusters (not needed if \code{cluster} is specified).}
  \item{cluster}{Factor or integer vector with the initial cluster
    assignments of observations at the 
    start of the EM algorithm (default is random assignment into \code{k}
    clusters).}
  \item{model}{Object of \code{FLXmodel} of list of \code{FLXmodel}
    objects. Default is the object returned by calling
    \code{\link{FLXglm}()}.}
  \item{control}{Object of class \code{FLXcontrol} or a named list.}
}
\details{
  FlexMix models are described by objects of class \code{FLXmodel},
  which in turn are created by driver functions like
  \code{\link{FLXglm}} or \code{\link{FLXmclust}}. Multivariate
  responses with independent components can be specified using a
  list of \code{FLXmodel} objects. 
}
\value{
  Returns an object of class \code{flexmix}.
}
\author{Friedrich Leisch}
\seealso{\code{\link{flexmix-class}}, \code{\link{FLXglm}},
  \code{\link{FLXmclust}}}
\keyword{regression}
\keyword{cluster}
\examples{

## generate some artificial data with a Gaussian response y and a
## Poisson response yp
x <- runif(200, 0, 10)
mydf <- data.frame(x=x,
                 y=c(5*x[1:100], 40-(x[101:200]-5)^2)+3*rnorm(200),
                 yp=rpois(200, exp(c(2-0.2*x[1:100], 1+0.1*x[101:200]))),
                 class=rep(1:2, c(100,100)))

plot(y~x, data=mydf, col=class)

## mixture of two linear regression models. Note that control parameters
## can be specified as named list and abbreviated if unique.
ex.qpol <- flexmix(y~x+I(x^2), data=mydf, k=2,
                   control=list(verb=5, iter=100))

ex.qpol
ex.qpol@components

## now use both responses simultanously
## first we have a look at the data
opar <- par("mfrow")
par(mfrow=1:2)
plot(y~x, data=mydf, col=class)
plot(yp~x, data=mydf, col=class)
par(mfrow=opar)

## now we fit a model with one Gaussian response and one Poisson
## response. Note that the formulas inside the call to FLXglm are
## relative to the overall model formula.
ex.qpol1 <- flexmix(y~x, data=mydf, k=2,
                    model=list(FLXglm(y~.+I(x^2)), 
                               FLXglm(yp~., family="poisson")))  

ex.qpol1
table(ex.qpol1@cluster, mydf$class)

## for Gaussian responses we get coefficients and standard deviation
parameters(ex.qpol1, component=1, model=1)

## for Poisson response we get only coefficients
parameters(ex.qpol1, component=1, model=2)
}

\eof
\name{logLik-methods}
\docType{methods}
\title{Methods for Function logLik}
\alias{logLik,flexmix-method}
\description{Evaluate the log-likelihood.  This function is defined as
  an old-style generic in the \code{base} package.  In this package is
  it converted to an S4 generic.}
\section{Methods}{
  \describe{
    \item{object = ANY}{Evaluate the log-likelihood of a general object}
    \item{object = flexmix}{Evaluate the log-likelihood of an
      \code{flexmix} object}
  }
}
\keyword{methods}
\eof
