### Name: itsDef
### Title: Irregularly Spaced Time-Series
### Aliases: its its-class is.its as.its its.format newIts
### Keywords: ts

### ** Examples

its.format("%Y-%m-%d")    #defines text format of dates read from dimnames
mat <- structure(1:6,dim=c(2,3),dimnames=list(c("2003-01-01","2003-01-04"),letters[1:3]))
its(mat)
its.format("%Y%m%d")    #defines text format of dates written to dimnames
times <- as.POSIXct(strptime(c("1999-12-31 01:00:00","2000-01-01 02:00:00"),format="%Y-%m-%d %X"))
its(mat,times)
its.format("%Y-%m-%d %X")
its(mat,times)
is.its(its(mat,times))
its.format("%Y%m%d %X")   #defines text format of dates written to dimnames
as.its(mat)
its.format("%a %d %b %Y")
newIts(start="2003-09-30",end="2005-05-05",format="%Y-%m-%d",period="month",find="last",extract=TRUE,weekday=TRUE)
newIts(start=ISOdate(2003,12,24,0),end=ISOdate(2004,1,10),extract=TRUE,weekday=TRUE)



