### Name: Map2poly
### Title: Create polygon lists and bounding boxes from imported shapefiles
### Aliases: Map2poly Map2lines Map2points Map2bbs shape2poly shape2lines
###   shape2points shape2bbs convert.pl
### Keywords: spatial

### ** Examples

shp <- try(library(shapefiles))
if (class(shp) != "try-error") {
  ShapeDir <- system.file("shapes", package="maptools")[1]
  try1 <- read.shapefile(paste(ShapeDir, "columbus", sep="/"))
  shppolys <- shape2poly(try1, as.character(try1$dbf$dbf$NEIGNO))
  plot(shppolys)
  title(main="Polygons for Columbus OH from shapefiles package")
  try3a <- read.shapefile(paste(ShapeDir, "baltim", sep="/"))
  baltptsa <- shape2points(try3a)
  xylims <- attr(baltptsa, "maplim")
  plot(xylims$x, xylims$y, asp=1, type='n', xlab="", ylab="")
  points(baltptsa)
  title(main="Baltimore points from shapefiles package")
  try4a <- read.shapefile(paste(ShapeDir, "fylk-val", sep="/"))
  fylk.vala <- shape2lines(try4a)
  xylims <- attr(fylk.vala, "maplim")
  plot(xylims$x, xylims$y, asp=1, type='n', xlab="", ylab="")
  for (i in 1:length(fylk.vala)) lines(fylk.vala[[i]])
  title(main="Norwegian river centrelines from shapefiles package")
}
try2 <- read.shape(system.file("shapes/columbus.shp", 
  package="maptools")[1])
mappolys <- Map2poly(try2, as.character(try2$att.data$NEIGNO))
plot(mappolys)
title(main="Polygons for Columbus OH from maptools package")
if (class(shp) != "try-error") {
  plot(shppolys)
  plot(mappolys, add=TRUE, border="red", lty="dotted")
  title(main="Polygons for Columbus OH overplotted from both packages")
}
try3 <- read.shape(system.file("shapes/baltim.shp", package="maptools")[1])
baltpts <- Map2points(try3)
xylims <- attr(baltpts, "maplim")
plot(xylims$x, xylims$y, asp=1, type='n', xlab="", ylab="")
points(baltpts)
title(main="Baltimore points from maptools package")
try4 <- read.shape(system.file("shapes/fylk-val.shp", package="maptools")[1])
fylk.val <- Map2lines(try4)
xylims <- attr(fylk.val, "maplim")
plot(xylims$x, xylims$y, asp=1, type='n', xlab="", ylab="")
for (i in 1:length(fylk.val)) lines(fylk.val[[i]])
title(main="Norwegian river centrelines from maptools package")



