### Name: plot.polylist
### Title: Plot polygons
### Aliases: plotpolys plot.polylist leglabs findInterval2
### Keywords: spatial

### ** Examples

try2 <- read.shape(system.file("shapes/columbus.shp", package="maptools")[1])
mappolys <- Map2poly(try2, as.character(try2$att.data$NEIGNO))
brks <- round(quantile(try2$att.data$CRIME, probs=seq(0,1,0.2)), digits=2)
colours <- c("salmon1", "salmon2", "red3", "brown", "black")
plot(mappolys, col=colours[findInterval2(try2$att.data$CRIME, brks)])
legend(x=c(5.8, 7.1), y=c(13, 14.5), legend=leglabs(brks),
  fill=colours, bty="n")
title(main=paste("Columbus OH: residential burglaries and vehicle\nthefts",
  "per thousand households, 1980"))
try3 <- read.shape(system.file("shapes/sids.shp", package="maptools")[1])
mappolys <- Map2poly(try3, as.character(try3$att.data$FIPSNO))
cols <- c("white", "orange", "red")
np <- integer(length(mappolys))
for (i in 1:length(mappolys)) np[i] <- attr(mappolys[[i]], "nPart")
plot(mappolys, col=cols[np])
title(main="White: one part, orange: two part, red: three part polygons")
plot(mappolys, density=c(10, 20, 30)[np], angle=c(-45, 0, 45)[np], axes=FALSE)



