% Copyright 2003 by Roger S. Bivand
\name{Map2poly}
\alias{Map2poly}
\alias{Map2lines}
\alias{Map2points}
%\alias{Map2maplim}
\alias{Map2bbs}
\alias{shape2poly}
\alias{shape2lines}
\alias{shape2points}
%\alias{shp2maplim}
\alias{shape2bbs}
\alias{convert.pl}
%\alias{ringDir}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Create polygon lists and bounding boxes from imported shapefiles}
\description{
  Map2poly() is a simple function to make imported GIS vector polygons into a "polylist" object from a "Map" object, and Map2bbs() retrieves polygon bounding boxes; analogous functions for the "shapefiles" package are shape2poly() and shape2bbs() (thanks to Stphane Dray for his contribution); convert.pl() serves to convert the deprecated "multipart" "polylist" format to an NA-separated format now used by plot() for polylist objects and poly2nb(). 
%\code{ringDir()} attempts to find out whether polygon ring 
%coordinates run clockwise (external boundary of polygon object), or 
%anti-clockwise (internal boundary - hole). 
\code{*2lines()} and \code{*2points()} do the same as \code{*2poly()} for shapefiles of types 3=lines and 1=points; polygons are type=5.
}
\usage{
Map2poly(Map, region.id = NULL)
Map2lines(Map)
Map2points(Map)
%Map2maplim(Map)
Map2bbs(Map)
shape2poly(shape, region.id = NULL)
shape2lines(shape)
shape2points(shape)
%shp2maplim(shape)
shape2bbs(shape)
convert.pl(pl)
%ringDir(xy, ring)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{Map}{object of class \code{"Map"}, imported from a GIS polygon vector file using unpublished package "maptools"}
  \item{shape}{list returned by \code{read.shapefile()}, imported from a GIS polygon vector file using the package "shapefiles"}
  \item{region.id}{character vector of region ids to be added to the neighbours list as attribute \code{region.id}}
  \item{pl}{list of old-style multipart polygons of class \code{polylist}}
%  \item{xy}{the coordinate object for a single member of a polygon list}
%  \item{ring}{the ring (one of \code{1:attr(xy, "nParts"))} index number}
}
\details{
  \url{http://sal.agecon.uiuc.edu/datasets/columbus.zip}
}

\value{
  \code{Map2poly}, \code{shape2poly}, \code{convert.pl} return polylist objects, lists of polygon boundary coordinates (divided by NA where the polygon object is represented by more than one polygon);
  \code{Map2lines}, \code{shape2lines} return lineslist objects;
  \code{Map2points}, \code{shape2points} return (n x 2) matrices; and
  \code{Map2bbs}, \code{shape2bbs} return bounding box matrixes, c(x1, y1, x2, y2) with coordinates for the lower left corner and upper right corner.
}

\author{Roger Bivand and Stphane Dray, \email{Roger.Bivand@nhh.no}}
 
\seealso{\code{\link{read.shape}}, \code{\link[shapefiles]{read.shapefile}}}


\examples{
shp <- try(library(shapefiles))
if (class(shp) != "try-error") {
  ShapeDir <- system.file("shapes", package="maptools")[1]
  try1 <- read.shapefile(paste(ShapeDir, "columbus", sep="/"))
  shppolys <- shape2poly(try1, as.character(try1$dbf$dbf$NEIGNO))
  plot(shppolys)
  title(main="Polygons for Columbus OH from shapefiles package")
  try3a <- read.shapefile(paste(ShapeDir, "baltim", sep="/"))
  baltptsa <- shape2points(try3a)
  xylims <- attr(baltptsa, "maplim")
  plot(xylims$x, xylims$y, asp=1, type='n', xlab="", ylab="")
  points(baltptsa)
  title(main="Baltimore points from shapefiles package")
  try4a <- read.shapefile(paste(ShapeDir, "fylk-val", sep="/"))
  fylk.vala <- shape2lines(try4a)
  xylims <- attr(fylk.vala, "maplim")
  plot(xylims$x, xylims$y, asp=1, type='n', xlab="", ylab="")
  for (i in 1:length(fylk.vala)) lines(fylk.vala[[i]])
  title(main="Norwegian river centrelines from shapefiles package")
}
try2 <- read.shape(system.file("shapes/columbus.shp", 
  package="maptools")[1])
mappolys <- Map2poly(try2, as.character(try2$att.data$NEIGNO))
plot(mappolys)
title(main="Polygons for Columbus OH from maptools package")
if (class(shp) != "try-error") {
  plot(shppolys)
  plot(mappolys, add=TRUE, border="red", lty="dotted")
  title(main="Polygons for Columbus OH overplotted from both packages")
}
try3 <- read.shape(system.file("shapes/baltim.shp", package="maptools")[1])
baltpts <- Map2points(try3)
xylims <- attr(baltpts, "maplim")
plot(xylims$x, xylims$y, asp=1, type='n', xlab="", ylab="")
points(baltpts)
title(main="Baltimore points from maptools package")
try4 <- read.shape(system.file("shapes/fylk-val.shp", package="maptools")[1])
fylk.val <- Map2lines(try4)
xylims <- attr(fylk.val, "maplim")
plot(xylims$x, xylims$y, asp=1, type='n', xlab="", ylab="")
for (i in 1:length(fylk.val)) lines(fylk.val[[i]])
title(main="Norwegian river centrelines from maptools package")
}

}
\keyword{spatial}

\eof
\name{get.Pcent}
\alias{get.Pcent}
\title{Polygon centroids}
\description{
  return the centroids of a map of polygons
}
\usage{
get.Pcent(theMap)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{theMap}{a Map object returned by read.shape()}
}

\value{
 a matrix of centroids.
}

\author{Nicholas J. Lewin-Koh, modified by Roger Bivand \email{Roger.Bivand@nhh.no}}

\examples{
x <- read.shape(system.file("shapes/sids.shp", package="maptools")[1])
get.Pcent(x)
}
\keyword{spatial}


\eof
\name{plot.Map}
\alias{plot.Map}
%\alias{color.ramp}

\title{Plot a Map object}
\description{
  The function plots a map object directly from the imported shapefile data.
}
\usage{
plot.Map(x, recs, auxvar = NULL, add = FALSE, fg = "gray", ol = "black", 
  prbg = NULL, glyph = 16, type = "q", nclass = 5, ...)
%color.ramp(nclass, color='red', nvec=NULL, type='q')
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{a Map object returned by read.shape()}
  \item{recs}{a vector with the shapes to plot, if missing defaults to all shapes}
  \item{auxvar}{if the Map has polygon shapes, a variable from which to derive polygon fill colours using the computed class intervals}
  \item{add}{default FALSE, if TRUE add to existing plot}
  \item{fg}{foreground colour, can be used to pass through point and polygon colours, permitting the built-in class interval calculation to be avoided}
  \item{ol}{line/boundary colour}
  \item{prbg}{if not NULL, draw a rectangle around the plot in this colour}
  \item{glyph}{points plotted as this pch code}
  \item{type}{default "q" for quantile classes, can also be "e" for equal intervals}
  \item{nclass}{number of classes for class intervals}
  \item{\dots}{passed through to plotting functions}
%  \item{color}{default "red"}
%  \item{nvec}{data vector to convert to class intervals}
}

%\value{
%  color.ramp() returns a list with componemts:
%  \item{ramp}{vector of colours}
%  \item{col.class}{vector of classes}
%}

\author{Nicholas J. Lewin-Koh, modified by Roger Bivand \email{Roger.Bivand@nhh.no}}

\seealso{\code{\link{read.shape}}}
\examples{
x <- read.shape(system.file("shapes/sids.shp", package="maptools")[1])
plot(x)
n <- attr(x$Shapes,'nshps')
nParts <- integer(n)
for (i in 1:n) nParts[i] <- attr(x$Shapes[[i]], "nParts")
table(nParts)
cols <- c("azure", "blue", "orange")
fgs <- cols[nParts]
plot(x, fg=fgs)

}
\keyword{spatial}


\eof
% Copyright 2001-3 by Roger S. Bivand
\name{plot.polylist}
\alias{plotpolys}
\alias{plot.polylist}
\alias{leglabs}
\alias{findInterval2}
\title{Plot polygons}
\description{
A helper function for plotting polygons in a global bounding box. \code{findInterval2} is a modified version of \code{findInterval2} that permits the vector of break points to start at -Inf and/or finish at Inf. \code{leglabs} makes character strings from the same break points. The \code{plot.polylist()} function may be used as a generic S3 method. NOTE! \code{plotpolys()} DEPRECATED: use generic plot() for polylist objects function instead.
}
\usage{
plot.polylist(x, col, border = par("fg"), add = FALSE, xlim=NULL,
 ylim=NULL, xpd = NULL, density = NULL, angle = 45, ...)
leglabs(vec, under="under", over="over", between="-")
findInterval2(y, vec, rightmost.closed = FALSE, all.inside = TRUE)
plotpolys(pl, bb, col = NA, border = par("fg"), add = FALSE, xlim, ylim, ...)
}

\arguments{
  \item{pl, x}{list of polygons of class \code{polylist}}
  \item{bb}{matrix of polygon bounding boxes - columns are LL(x), LL(y), UR(x), UR(y); note that this argument may be omitted if the polygon list object has an "maplim" attribute, or if both xlim and ylim arguments are given}
  \item{col}{colurs to use for filling the polygons}
  \item{border}{the color to draw the border}
  \item{add}{add to existing plot}
  \item{xlim, ylim}{numeric of length 2, giving the x and y coordinates ranges}
  \item{xpd}{(where) should clipping take place?}
  \item{density}{the density of shading lines, in lines per inch}
  \item{angle}{the slope of shading lines, given as an angle in degrees (counter-clockwise)}
  \item{...}{other arguments passed to plot to set the plot window - not passed to polygon}
  \item{vec}{vector of break values}
  \item{under}{character value for under}
  \item{over}{character value for over}
  \item{between}{character value for between}
  \item{y}{numeric vector to be broken into class intervals}
  \item{rightmost.closed}{as in findInterval()}
  \item{all.inside}{as in findInterval()}
}
\author{Roger Bivand \email{Roger.Bivand@nhh.no}}

\seealso{\code{\link{Map2poly}}, \code{\link{findInterval}}}

\examples{
try2 <- read.shape(system.file("shapes/columbus.shp", package="maptools")[1])
mappolys <- Map2poly(try2, as.character(try2$att.data$NEIGNO))
brks <- round(quantile(try2$att.data$CRIME, probs=seq(0,1,0.2)), digits=2)
colours <- c("salmon1", "salmon2", "red3", "brown", "black")
plot(mappolys, col=colours[findInterval2(try2$att.data$CRIME, brks)])
legend(x=c(5.8, 7.1), y=c(13, 14.5), legend=leglabs(brks),
  fill=colours, bty="n")
title(main=paste("Columbus OH: residential burglaries and vehicle\nthefts",
  "per thousand households, 1980"))
try3 <- read.shape(system.file("shapes/sids.shp", package="maptools")[1])
mappolys <- Map2poly(try3, as.character(try3$att.data$FIPSNO))
cols <- c("white", "orange", "red")
np <- integer(length(mappolys))
for (i in 1:length(mappolys)) np[i] <- attr(mappolys[[i]], "nPart")
plot(mappolys, col=cols[np])
title(main="White: one part, orange: two part, red: three part polygons")
plot(mappolys, density=c(10, 20, 30)[np], angle=c(-45, 0, 45)[np], axes=FALSE)
}
\keyword{spatial}

\eof
\name{read.shape}
\alias{read.shape}
%\alias{dbf.read}
\alias{getinfo.shape}

\title{Read shapefile into Map object}
\description{
  Read shapefile into Map object; the file should be given including its ".shp" extension, and the function will reconstruct the names of the database (dbf) file and the index (shx) file from these.
}
\usage{
read.shape(filen, dbf.data = TRUE)
%dbf.read(filen)
getinfo.shape(filen)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{filen}{name of file with *.shp extension, or *.dbf for dbf.read()}
  \item{dbf.data}{read DBF data together with shapes, default TRUE}
}
\details{
  The function calls code from shapelib to read shapefiles, a file format used by ESRI GIS software among others
}
\value{
read.shape() returns either a list of shapes of class ShapeList, or if dbf.data = TRUE a Map object with:
  \item{Shapes}{a list of shapes of class ShapeList; both the individual shapes and the list have attributes}
  \item{att.data}{a data frame of data from the associated DBF file; note that the field names are adjusted to use in R using \code{make.names()}, and so will permit the underscore character from R release 1.9.0.}
}
\references{\url{http://gdal.velocet.ca/projects/shapelib/}}
\author{Nicholas J. Lewin-Koh, modified by Roger Bivand \email{Roger.Bivand@nhh.no}; shapelib by Frank Warmerdam}

\seealso{\code{\link{plot.Map}}}
\examples{
x <- read.shape(system.file("shapes/sids.shp", package="maptools")[1])
length(x$Shapes)
unlist(lapply(x$att.data, class))
str(getinfo.shape(system.file("shapes/fylk-val.shp", package="maptools")[1]))
}
\keyword{spatial}


\eof
% Copyright 2003 by Roger S. Bivand
\name{subset.polylist}
\alias{subset.polylist}
\title{Subset polygon list objects}
\description{
  The function subsets a polygon list object, also subsetting region ID attributes and also map limits if required.
}
\usage{
subset.polylist(x, subset, fit.bbox = TRUE, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{a polylist object}
  \item{subset}{a logical vector valued TRUE if the element is to be retained}
  \item{fit.bbox}{if TRUE (default) modifies the maplim attribute to bound the subset}
  \item{...}{other arguments passed through}
}

\value{
  returns a polylist object, lists of polygon boundary coordinates (divided by NA where the polygon object is represented by more than one polygon);
}

\author{Roger Bivand \email{Roger.Bivand@nhh.no}}

\examples{
nc <- read.shape(system.file("shapes/sids.shp", package = "maptools")[1])
mappolys <- Map2poly(nc, as.character(nc$att.data$FIPSNO))
submap <- subset(mappolys, nc$att.data$SID74 > 0)
plot(mappolys, col="pink")
plot(submap, add=TRUE, col="white")
}
\keyword{spatial}


\eof
