\name{akj}
\alias{akj}
\title{
Density estimation using adaptive kernel method
}
\description{univariate adaptive kernel density estimation a la Silverman.  As used
by Portnoy and Koenker (1989)}
\usage{
akj(x, z, p, h, alpha, kappa, iker1, iker2)


}
\arguments{
\item{x}{
points used for centers of kernel assumed to be sorted}
\item{z}{
points at which density is calculated; default to seq( min(x), max(x), 2*length(x) )}
\item{p}{
vector of probabilities associated with x's; default to 1/len(x) for each x.}
\item{h}{
initial window size (overall); default to Silverman's normal reference}
\item{alpha}{a sensitivity parameter that determines the sensitivity of the local bandwidth to variations in the pilot density; default to .5}
\item{kappa}{
constant determining initial (default) window width}
\item{iker1}{
kernel indicator, 0 for normal kernel (default) while 1 for cauchy kernel}
\item{iker2}{ xxx}
}
\value{
a R structure is returned

\item{dens}{
the vector of estimated density}
\item{psi}{
a vector of \eqn{\psi=-f'/f} function}
\item{score}{
a vector of score \eqn{(f'/f)^2-f''/f} function}
\item{h}{
same as the input argument h}
}
\keyword{smooth}
\references{
Portnoy, S and R Koenker, (1989) Adaptive L Estimation of Linear Models, Annals, 17, 362-81.
Silverman, B. (1986) Density Estimation, pp100-104.
}

\eof
\name{anova.rq}
\alias{anova.rq}
\alias{anova.rqlist}
\alias{rq.test.rank}
\title{ Anova function for quantile regression fits }
\description{
	Compute test statistics for two or more quantile regression fits.
}
\usage{
anova.rq(object, ...)
anova.rqlist(object, ...,  test = "Wald", score = "tau")
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{object, ...}{ objects of class `rq', originating from a call to `rq'. }
  \item{test}{ A character string specifying the test statistic to use.
	Can be either `Wald' or `rank'.}
  \item{score}{ A character string specifying the score function to use,
	only needed or applicable for the `rank' form of the test.}
}
\details{
There are two (as yet) distinct forms of the test.  In the first the
fitted objects all have the same specified quantile (tau) and the intent
is to test the hypothesis that smaller models are adaquete relative to
the largest specified model.  In this case there are two options for
the argument `test', by default a Wald test is computed as in 
Bassett and Koenker (1982).  If test=`rank' is specified, then a rank
test statistic is computed as described in Gutenbrunner, Jureckova,
Koenker and Portnoy (1993).  In the latter case one can also specify
a form for the score function of the rank test, by default the Wilcoxon
score is used, the other options are score=`sign' for median (sign) scores,
or score=`normal' for normal (van der Waerden) scores.  A fourth option
is score=`tau' which is a generalization of median scores to an arbitrary
quantile, in this case the quantile is assumed to be the one associated
with the fitting of the specified objects.  The computing of
the rank form of the test is carried out in the \code{\link{rq.test.rank}}
function, see \code{\link{ranks}} for further details on the score function
options.

The Wald form of the test is local in sense that the null hypothesis
asserts only that a subset of the covariates are ``insignificant'' at
the specified quantile of interest.  The rank form of the test can also be
used to test the global hypothesis that a subset is ``insignificant''
over an entire range of quantiles.  The use of the score function
score = "tau" restricts the rank test to the local hypothesis of
the Wald test.  

In the second form of the test the linear predictor of the fits are
all the same, but the specified quantiles (taus) are different.  In
this case the hypothesis of interest is that the slope coefficients of
the models are identical.  The test statistic is a variant of the Wald 
test described in Koenker and Bassett (1982).

By default, the tests return an F-like statistic in the sense that the
an asymptotically Chi-squared statistic is divided by its degrees of
freedom and the reported p-value is computed for an F statistic based on 
the numerator degrees of freedom equal to the rank of the null hypothesis and
the denominator degrees of freedom is taken to be the sample size
minus the number of parameters of the maintained model.
}
\value{
 An object of class `"anova"' inheriting from class `"data.frame"'.
}
\references{
[1] Bassett, G. and R. Koenker  (1982). Tests of Linear Hypotheses
and L1 Estimation,
\emph{Econometrica}, \bold{50}, 1577--83.

[2] Koenker, R. W. and Bassett, G. W. (1982). Robust Tests for
Heteroscedasticity based on Regression Quantiles,
\emph{Econometrica}, \bold{50}, 43--61.
 
[3] Gutenbrunner, C., Jureckova, J., Koenker, R, and S. Portnoy  (1993).
Tests of Linear Hypotheses based on Regression Rank Scores,
\emph{J. of Nonparametric Statistics}, \bold{2}, 307--331.
}
\author{ Roger Koenker }

\section{WARNING }{
An attempt to verify that the models are nested in the first form
of the test is made, but this relies on checking set inclusion of
the list of variable names and is subject to obvious ambiguities
when variable names are generic.
The comparison between two or more models will only be valid if
they are fitted to the same dataset. This may be a problem if
there are missing values and R's default of `na.action = na.omit' is used. 
The rank version of the nested model tests involves computing the entire
regression quantile process using parametric linear programming and thus
can be rather slow and memory intensive on problems with more than 
several thousand observations.
} 

\seealso{ The model fitting function  \code{\link{rq}}, 
and the functions for testing hypothesis on the entire quantile
regression process \code{\link{rq.test.khmal}}.  For further details
on the rank tests see \code{\link{ranks}}}. 

\examples{
data(barro)
fit0 <- rq(y.net ~  lgdp2 + fse2 + gedy2 , data = barro)
fit1 <- rq(y.net ~  lgdp2 + fse2 + gedy2 + Iy2 + gcony2, data = barro)
fit2 <- rq(y.net ~  lgdp2 + fse2 + gedy2 + Iy2 + gcony2, data = barro,tau=.75)
fit3 <- rq(y.net ~  lgdp2 + fse2 + gedy2 + Iy2 + gcony2, data = barro,tau=.25)
anova(fit1,fit0)
anova(fit1,fit2,fit3)
}
\keyword{ htest }
\keyword{ regression}
\keyword{ robust}

\eof
\name{bandwidth.rq}
\alias{bandwidth.rq}
\title{ bandwidth selection for rq functions }
\description{
 function to compute bandwidth for sparsity estimation 
}
\usage{
bandwidth.rq(p, n, hs=TRUE, alpha=0.05)
}
\arguments{
  \item{p}{ quantile(s) of interest }
  \item{n}{ sample size }
  \item{hs}{ flag for hall-sheather method }
  \item{alpha}{ alpha level for intended confidence intervals }
}
\details{ If hs=TRUE (default) then the Hall-Sheather(1988) rule \eqn{O(n^{-1/3})}
is used, if hs=FALSE then the Bofinger \eqn{O(n^{-1/5})} is used.
}
\value{
returns a vector of bandwidths corresponding to the argument p.
}
\references{ Hall and Sheather(1988, JRSS(B)),Bofinger (1975, Aus. J. Stat)}
\author{ Roger Koenker rkoenker@uiuc.edu}
\keyword{ regression }

\eof
\name{barro}
\alias{barro}
\title{Barro Data}
\description{
Version of the Barro Growth Data used in Koenker and Machado(1999).
This is a regression data set consisting of 161 observations on determinants
of cross country GDP growth rates. There are 13 covariates with dimnames
corresponding to the original Barro and Lee source.  See
http://www.nber.org/pub/barro.lee/.  The first 71 observations are on
the period 1965-75, remainder on 1987-85.  
}
\usage{data(barro)}
\format{A data frame containing 161 observations on 14 variables:
\tabular{rl}{
        [,1] \tab "Annual Change Per Capita GDP"\cr
        [,2] \tab "Initial Per Capita GDP"\cr
        [,3] \tab "Male Secondary Education"\cr
        [,4] \tab "Female Secondary Education"\cr
        [,5] \tab "Female Higher Education"\cr
        [,6] \tab "Male Higher Education"\cr
        [,7] \tab "Life Expectancy"\cr
        [,8] \tab "Human Capital"\cr
        [,9] \tab "Education/GDP"\cr
        [,10] \tab "Investment/GDP"\cr
        [,11] \tab "Public Consumption/GDP"\cr
        [,12] \tab "Black Market Premium"\cr
        [,13] \tab "Political Instability"\cr
        [,14] \tab "Growth Rate Terms Trade"}

}
\references{
Koenker, R. and J.A.F. Machado (1999) Goodness of Fit and Related Inference Processes for Quantile Regression, JASA, 1296-1310.}
\keyword{datasets}

\eof
\name{boot.rq}
\alias{boot.rq}
\alias{boot.rq.xy}
\alias{boot.rq.pwy}
\alias{boot.rq.mcmb}
\title{ Bootstrapping Quantile Regression}
\description{
These functions can be used to construct standard errors, confidence
intervals and tests of hypotheses regarding quantile regression models.
}
\usage{
boot.rq(x, y, tau = 0.5, R = 200, bsmethod = "xy", mofn = length(y), ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{ The regression design matrix}
  \item{y}{ The regression response vector}
  \item{tau}{ The quantile of interest}
  \item{R}{ The number of bootstrap replications}
  \item{bsmethod}{ The method to be employed.  There are (as yet) three
	options:  method = "xy" uses the xy-pair method, and
	method = "pwy" uses the method of Parzen, Wei and Ying (1994)
	method = "mcmb" uses the Markov chain marginal bootstrap
	of He and Hu (2002) and Kocherginsky, He and Mu (2003).}
  \item{mofn}{ optional argument for the bootstrap method "xy" that
	permits subsampling (m out of n) bootstrap.  Obviously mofn
	should be substantially larger than the column dimension of x,
	and should be less than the sample size.}
  \item{...}{ Optional arguments to control bootstrapping}
}
\details{
Their are several refinements that are still unimplemented.  Percentile
methods should be incorporated, and extensions of the methods to be used 
in anova.rq should be made.
}
\value{
  A matrix of dimension R by p is returned with the R resampled
  estimates of the vector of quantile regression parameters. When
  mofn < n for the "xy" method this matrix has been deflated by
  the fact sqrt(m/n)
}
\references{ 
[1] Koenker, R. W. (1994). Confidence Intervals for regression quantiles, in
P. Mandl and M. Huskova (eds.), \emph{Asymptotic Statistics}, 349--359,
Springer-Verlag, New York.

[2] Kocherginsky, M., He, X. and Mu, Y. (2003).
Practical Confidence Intervals for Regression Quantiles. Preprint.

[3] He, X. and Hu, F. (2002). Markov Chain Marginal Bootstrap.
Journal of the American Statistical Association , Vol. 97, no. 459,
783-795. 

[4] Parzen, M. I., L. Wei,  and Z. Ying  (1994): A resampling
method based on pivotal estimating functions,'' Biometrika, 81, 341--350.
}

\author{ Roger Koenker (and Xuming He and M. Kocherginsky for the mcmb code)}
\seealso{  \code{\link{summary.rq}}}
\examples{
y <- rnorm(50)
x <- matrix(rnorm(100),50)
fit <- rq(y~x,tau = .4)
summary(fit,se = "boot", bsmethod= "xy")
summary(fit,se = "boot", bsmethod= "pwy")
#summary(fit,se = "boot", bsmethod= "mcmb")
}
\keyword{ regression}

\eof
\name{engel}
\alias{engel}
\title{Engel Data}
\description{
Engel Food Expenditure Data used in Koenker and Bassett(1982).
This is a regression data set consisting of 235 observations on 
income and expenditure on food for Belgian working class households.
}
\usage{data(engel)}
\format{A data frame containing 235 observations on 2 variables}
\tabular{rl}{
        [,1] \tab "Annual Household Income in Belgian Francs"\cr
        [,2] \tab "Annual Household Food Expenditure in Belgian Francs"\cr
}
\references{
Koenker, R. and Bassett, G (1982) Robust Tests of Heteroscedasticity based on
Regression Quantiles, Econometrica, 50,43--61.}
\keyword{datasets}

\eof
\name{latex.table}
\alias{latex.table}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ Writes a latex formatted table to a file}
\description{
	Automatically generates a latex formatted table from the matrix x
	Controls rounding, alignment, etc, etc
}
\usage{
latex.table(x, file=as.character(substitute(x)), rowlabel=file, rowlabel.just="l", cgroup, n.cgroup, rgroup, n.rgroup=NULL, digits, dec, rdec, cdec, append=FALSE, dcolumn=FALSE, cdot=FALSE, longtable=FALSE, table.env=TRUE, lines.page=40, caption, caption.lot, label=file, double.slash=FALSE,\dots)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{ A matrix \code{x} with dimnames}
  \item{file}{ Name of output \code{file} (.tex will be added) }
  \item{rowlabel}{ If `x' has row dimnames, rowlabel is a character 
	string containing the column heading for the row dimnames. 
	The default is the name of the argument for x. }
  \item{rowlabel.just}{ If `x' has row dimnames, specifies the 
	justification for printing them.  Possible values are `
	"l", "r", "c"'. The heading (`rowlabel') itself
	is left justified if `rowlabel.just="l"', otherwise it is centered. }
  \item{cgroup}{ a vector of character strings defining major column headings. 
	The default is to have none. }
  \item{n.cgroup}{ a vector containing the number of columns for which each 
	element in cgroup is a heading.  For example, specify `cgroup=
	c("Major 1","Major 2")', `n.cgroup=c(3,3)' if "Major 1" is to 
	span columns 1-3 and "Major 2" is to span columns 4-6.  
	`rowlabel' does not count in the column numbers.  You can omit 
	`n.cgroup' if all groups have the same number of columns.  }
  \item{rgroup}{ a vector of character strings containing headings for row 
	groups.  `n.rgroup' must be present when `rgroup' is given. The 
	first `n.rgroup[1]' rows are sectioned off and `rgroup[1]' is 
	used as a bold heading for them. The usual row dimnames (which must 
	be present if `rgroup' is) are indented. The next `n.rgroup[2]' 
	rows are treated likewise, etc.  }
  \item{n.rgroup}{integer vector giving the number of rows in each grouping. 
	If `rgroup' is not specified, `n.rgroup' is just used to divide off 
	blocks of rows by horizontal lines. If `rgroup' is given but 
	`n.rgroup' is omitted, `n.rgroup' will default so that each row 
	group contains the same number of rows.  }
  \item{digits}{ causes all values in the table to be formatted to `digits' 
	significant digits.  `dec' is usually preferred.  }
  \item{dec}{ If `dec' is a scalar, all elements of the matrix will be 
	rounded to `dec' decimal places to the right of the decimal. 
	`dec' can also be a matrix whose elements correspond to `x', for 
	customized rounding of each element.}
  \item{rdec}{ a vector specifying the number of decimal places to the right 
	for each row (`cdec' is more commonly used than `rdec') }
  \item{cdec}{ a vector specifying the number of decimal places for each 
	column }
  \item{append}{  defaults to `F'. Set to `T' to append output to an 
	existing file.}
  \item{dcolumn}{ Set to `T' to use David Carlisles `dcolumn' style for 
	decimal alignment.
	Default is `F', which aligns columns of numbers by changing leading
	blanks to "~", the LaTeX space-holder. You will probably want to
	use `dcolumn' if you use `rdec', as a column may then contain varying
	number of places to the right of the decimal. `dcolumn' can line up
	all such numbers on the decimal point, with integer values right-
	justified at the decimal point location of numbers that actually
	contain decimal places.  }
  \item{cdot}{ Set to `T' to use centered dots rather than ordinary periods 
	in numbers.}
  \item{longtable}{ Set to `T' to use David Carlisles LaTeX `longtable' style, 
	allowing long tables to be split over multiple pages with headers 
	repeated on each page.}
  \item{table.env}{Set `table.env=FALSE' to suppress enclosing the table
	in a LaTeX `table' environment.  `table.env' only applies when 
	`longtable=FALSE'.  You may not specify a `caption' if `table.env=FALSE'.  }
  \item{lines.page}{ Applies if `longtable=TRUE'. No more than `lines.page' 
	lines in the body of a table will be placed on a single page. 
	Page breaks will only occur at `rgroup' boundaries. }
  \item{caption}{ a text string to use as a caption to print at the top of the 
	first page of the table. Default is no caption.  }
  \item{caption.lot}{ a text string representing a short caption to be used 
	in the "List of Tables".  By default, LaTeX will use `caption'.  }
  \item{label}{ a text string representing a symbolic label for the table 
	for referencing with the LaTex `\\ref{label}' command. The default 
	is `file'.  `label' is only used if `caption' is given.  }
  \item{double.slash}{set to `T' to output `\\' as `\\\\' in LaTeX commands. 
	Useful when you are reading the output file back into an S vector 
	for later output.  }
  \item{\dots}{other optional arguments}
}
\value{
	returns invisibly
}
\references{ Minor modification of Frank Harrell's Splus code }
\author{ Roger Koenker }



\examples{
}
\keyword{ utilities }% at least one, from doc/KEYWORDS

\eof
\name{latex.table.rq}
\alias{latex.table.rq}
\title{ Function to make a latex table from table.rq output }
\description{
	Makes a latex formatted table from the output of table.rq
	As currently configured the table has a row  for each parameter
	of the model and columns for each quantile estimated.
}
\usage{
latex.table.rq(object, transpose = FALSE, caption="caption goes here.", 
	digits=3, file=as.character(substitute(object)),\dots)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{object}{ table.rq \code{object}  }
  \item{transpose}{  transpose the table so quantiles are the  row dimension  }
  \item{caption}{ latex \code{caption}  }
  \item{digits}{ number of significant \code{digits} }
  \item{file}{ name of output \code{file} }
  \item{\dots}{ other optional arguments }
}
\details{
	calls latex.table() a modified version of Frank Harrell's Splus function
}
\value{
	writes a file and returns invisably.
}
\author{ Roger Koenker }


\seealso{ \code{\link{table.rq}}}

\examples{
}
\keyword{ utilities }% at least one, from doc/KEYWORDS

\eof
\name{lm.fit.recursive}
\alias{lm.fit.recursive}
\title{ Recursive Least Squares }
\description{
This function fits a linear model by recursive least squares.  It is
a utility routine for the rq.test.khmal function of the quantile regression
package.
}
\usage{
lm.fit.recursive(X, y, int=TRUE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{X}{ Design Matrix }
  \item{y}{ Response Variable}
  \item{int}{ if TRUE then append intercept to X}
}
\value{
return p by n matrix of fitted parameters, where p. The
ith column gives the solution up to "time" i. 
}
\references{ A. Harvey, (1993) Time Series Models, MIT }
\author{ R. Koenker }
\seealso{khmaladzize }

\keyword{methods}

\eof
\name{plot.rq.process}
\alias{plot.rq.process}
\title{ plot the coordinates of the quantile regression process}
\description{ Function to plot quantile regression  process.  }
\usage{ plot.rq.process(x, nrow=3, ncol=2, ...) }
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{ an object produced by rq() fitting  }
  \item{nrow}{ rows in mfrow }
  \item{ncol}{ columns in mfrow}
  \item{...}{ optional arguments to plot}
}
\author{ Roger Koenker rkoenker@uiuc.edu}
\seealso{ \code{\link{rq}}}

\keyword{ regression }

\eof
\name{plot.table.rq}
\alias{plot.table.rq}
\title{
Plot Table of Quantile Regression Results
}
\description{
The function makes an array of p - plots based on an array produced
by \code{table.rq} of quantile regression results.  The plots each represent
one parameter of the model specified in the formula argument to
\code{table.rq}; the plots consist of the point estimates betahat(tau)
plotted against the taus specified in the \code{table.rq} command with
a confidence band as produced by \code{rq()}.
}
\usage{
plot.table.rq(x,nrow=3,ncol=2, alpha=.1, ...)
}
\arguments{
\item{x}{
  object of class \code{table.rq} containing the array to be plotted.
}
\item{nrow}{
  number of rows per page of plots
}
\item{ncol}{
  number of columns per page of plots
}
\item{alpha}{
  alpha level of the confidence band
}
\item{...}{
  optional arguments to plot
}
}
\section{Side Effects}{
  plots an array of figures on the current graphics device.
}
\details{
  See \code{rq()} and \code{rq.fit.br()} and \code{table.rq()} for
  further details on control of data.
  Obviously, further plotting parameters could be added in a more full-blown
  version.  This version is meant just to be illustrative.
}
\seealso{
  \code{\link{rq}}, \code{\link{rq.fit.br}}, \code{\link{table.rq}}
}
\keyword{hplot}
\keyword{regression}
% Converted by Sd2Rd version 0.3-3.

\eof
\name{print.rq}
\alias{print.rq}
\title{ Print an rq object}
\description{
Print an object generated by rq
}
\usage{
print.rq(x, ...)
}
\arguments{
\item{x}{
  Object returned from rq representing the fit of the model.
 }
\item{...}{
  Optional arguments passed to fitting routines
 }
}
\seealso{  \code{\link{rq}}}

\keyword{ regression}

\eof
\name{print.summary.rq}
\alias{print.summary.rq}
\title{ Print Quantile Regression Summary Object }
\usage{
print.summary.rq(x, digits=max(5, .Options$digits - 2), ...)
}
\arguments{
  \item{x}{
    This is an object of class \code{"summary.rq"} produced by a call to 
    \code{summary.rq()}.
  }
  \item{digits}{
    Significant digits reported in the printed table.
  }
  \item{...}{
    Optional arguments passed to printing function
  }
}
\description{Print summary of quantile regression object}
\seealso{  \code{\link{summary.rq}} }

\keyword{ regression }

\eof
\name{ranks}
\alias{ranks}
\title{
Quantile Regression Ranks
}
\description{
Function to compute ranks from the dual (regression rankscore) process.
}
\usage{
ranks(v, score="wilcoxon", tau=0.5)
}
\arguments{
\item{v}{
  object of class \code{"rq.process"} generated by \code{rq()}
}
\item{score}{
  The score function desired.  Currently  implemented score  functions  
  are \code{"wilcoxon"}, \code{"normal"}, and \code{"sign"}
  which are asymptotically optimal  for  
  the  logistic,  Gaussian  and Laplace location shift models respectively.
  The "normal" score  function is also sometimes called van der Waerden scores.
  Also implemented are the \code{"tau"} which generalizes sign scores to an
  arbitrary quantile, and \code{"interquartile"} which is appropriate
  for tests of scale shift.
}
\item{tau}{
  the optional value of \code{tau} if the \code{"tau"} score function is used.
}}
\value{
The function returns two components. One is the ranks,  the
other is a scale factor which is the \eqn{L_2} norm of the score
function.  All score functions should be normalized to have mean zero.
}
\details{
  See GJKP(1993) for further details.
}
\references{
  Gutenbrunner, C., J. Jureckova,  Koenker, R. and  Portnoy,
  S. (1993)  Tests  of linear hypotheses  based on regression
  rank scores, \emph{Journal of  Nonparametric  Statistics},  (2), 307--331.
}
\seealso{
  \code{\link{rq}}, \code{\link{rq.test.rank}} \code{\link{anova.rq}}
}
\examples{
data(stackloss)
ranks(rq(stack.loss ~ stack.x, tau=-1))
}
\keyword{regression}
% Converted by Sd2Rd version 0.3-3.

\eof
\name{rq}
\alias{rq}
\title{
Quantile Regression 
}
\description{
Returns an object of class \code{"rq"} or \code{"rq.process"} that represents 
a quantile regression fit. 
}
\usage{
rq(formula, tau=.5, data, weights, na.action,
   method="br", contrasts, \dots) 
}
\arguments{
  \item{formula}{
    a formula object, with the response on the left of a \code{~} operator, 
    and the terms, separated by \code{+} operators, on the right. 
  }
  \item{tau}{
    the quantile to be estimated, this is generally a number between 0 and 1, 
    but if specified outside this range, it is presumed that the solutions 
    for all values of \code{tau} in (0,1) are desired.  In the former case an
    object of class \code{"rq"} is returned, in the latter,
    an object of class \code{"rq.process"} is returned.
  }
  \item{data}{
    a data.frame in which to interpret the variables 
    named in the formula, or in the subset and the weights argument. 
    If this is missing, then the variables in the formula should be on the 
    search list.  This may also be a single number to handle some special  
    cases -- see below for details.   
  }
  \item{weights}{
    vector of observation weights; if supplied, the algorithm fits
    to minimize the sum of the weights multiplied into the
    absolute residuals. The length of weights must be the same as
    the number of observations.  The weights must be nonnegative
    and it is strongly recommended that they be strictly positive,
    since zero weights are ambiguous. 
  }
  \item{na.action}{
    a function to filter missing data. 
    This is applied to the model.frame after any subset argument has been used. 
    The default (with \code{na.fail}) is to create an error if any missing values are  
    found.  A possible alternative is \code{na.omit}, which 
    deletes observations that contain one or more missing values. 
  }
  \item{method}{
    the algorithmic method used to compute the fit.  There are currently 
    four options:   The default method is the modified  version of the
    Barrodale and Roberts algorithm for \eqn{l_1}{l1}-regression,
    used by \code{l1fit} in S, and is described in detail in 
    Koenker and d'Orey(1987, 1994),  default = \code{"br"}. 
    This is quite efficient for problems up to several thousand observations, 
    and may be used to compute the full quantile regression process.  It 
    also implements a scheme for computing confidence intervals for 
    the estimated parameters, based on inversion of a rank test described 
    in Koenker(1994).  For larger problems it is advantagous to use 
    the Frisch--Newton interior point method \code{"fn"}. 
    And very large problems one can use the Frisch--Newton approach after 
    preprocessing \code{"pfn"}.  Both of the latter methods are
    described in detail in Portnoy and Koenker(1997).   Finally, there
    is a fourth option \code{"fnc"} that enables the user to specify
    linear inequality constraints on the fitted coefficients; in this
    case one needs to specify the matrix \code{R} and the vector \code{r}
    representing the constraints in the form $Rb \geq r$.  See the
    examples 
  }
  \item{contrasts}{
    a list giving contrasts for some or all of the factors 
    default = \code{NULL} appearing in the model formula. 
    The elements of the list should have the same name as the variable 
    and should be either a contrast matrix (specifically, any full-rank 
    matrix with as many rows as there are levels in the factor), 
    or else a function to compute such a matrix given the number of levels. 
  }
  \item{...}{
    additional arguments for the fitting routines 
    (see \code{\link{rq.fit.br}} and \code{\link{rq.fit.fn}}
    and the functions they call). 
  }
}
\value{
  See \code{\link{rq.object}} and \code{\link{rq.process.object}} for details. 
}
\examples{
data(stackloss)
rq(stack.loss ~ stack.x,.5)  #median (l1) regression  fit for the stackloss data. 
rq(stack.loss ~ stack.x,.25)  #the 1st quartile, 
        #note that 8 of the 21 points lie exactly on this plane in 4-space! 
rq(stack.loss ~ stack.x, tau=-1)   #this returns the full rq process
rq(rnorm(50) ~ 1, ci=FALSE)    #ordinary sample median --no rank inversion ci
rq(rnorm(50) ~ 1, weights=runif(50),ci=FALSE)  #weighted sample median 
#plot of engel data and some rq lines see KB(1982) for references to data
data(engel)
attach(engel)
plot(x,y,xlab="household income",ylab="food expenditure",cex=.5)
taus <- c(.05,.1,.25,.75,.9,.95)
xx <- seq(min(x),max(x),100)
for(tau in taus){
        f <- coef(rq((y)~(x),tau=tau))
        yy <- (f[1]+f[2]*(xx))
        lines(xx,yy)
        }
#Example to illustrate inequality constrained fitting
n <- 100
p <- 5
X <- matrix(rnorm(n*p),n,p)
y <- .95*apply(X,1,sum)+rnorm(n)
#constrain slope coefficients to lie between zero and one
R <- cbind(0,rbind(diag(p),-diag(p)))
r <- c(rep(0,p),-rep(1,p))
rq(y~X,R=R,r=r,method="fnc")
}
\section{Method}{
The function computes an estimate on the tau-th conditional quantile
function of the response, given the covariates, as specified by the
formula argument.  Like \code{lm()}, the function presumes a linear
specification for the quantile regression model, i.e. that the formula
defines a model that is linear in parameters.  For non-linear quantile
regression see the package \code{nlrq()}.  
The function minimizes a weighted sum of absolute
residuals that can be formulated as a linear programming problem.  As
noted above, there are three different algorithms that can be chosen
depending on problem size and other characteristics.  For moderate sized
problems (\eqn{n \ll 5,000, p \ll 20}{n << 5,000, p << 20}) it is recommended 
that the default \code{"br"} method be used. There are several choices of methods for
computing confidence intervals and associated test statistics.  
See the documentation for \code{\link{summary.rq}} for further details
and options.  
}

\keyword{regression}
\references{
[1] Koenker, R. W. and Bassett, G. W. (1978). Regression quantiles, 
\emph{Econometrica}, \bold{46}, 33--50. 

[2] Koenker, R.W. and d'Orey (1987, 1994). Computing regression quantiles. 
\emph{Applied Statistics}, \bold{36}, 383--393, and \bold{43}, 410--414. 

[3] Gutenbrunner, C. Jureckova, J. (1991). 
Regression quantile and regression rank score process in the 
linear model and derived statistics, \emph{Annals of Statistics},
\bold{20}, 305--330.

[4] Koenker, R. W. (1994). Confidence Intervals for regression quantiles, in 
P. Mandl and M. Huskova (eds.), \emph{Asymptotic Statistics}, 349--359,  
Springer-Verlag, New York.   

[5] Koenker, R. and S. Portnoy (1997) The Gaussian Hare and the Laplacean 
Tortoise:  Computability of Squared-error vs Absolute Error Estimators, 
(with discussion).  \emph{Statistical Science,} \bold{12}, 279-300.

There is also recent information available at the URL:
\url{http://www.econ.uiuc.edu}.
}
\seealso{
  \code{\link{summary.rq}}, \code{\link{rq.object}},
  \code{\link{rq.process.object}}
}
% Converted by Sd2Rd version 0.3-3.

\eof
\name{rq.fit}
\alias{rq.fit}
\title{Function to choose method for Quantile Regression  }
\usage{
rq.fit(x, y, tau=0.5, method="br", ...)
}
\arguments{
\item{x}{
  the design matrix
}
\item{y}{
  the response variable
}
\item{tau}{
  the quantile desired, if tau lies outside (0,1) the whole process
  is estimated.
}
\item{method}{
  method of computation:  "br" is Barrodale and Roberts exterior point
  "fn" is the Frisch-Newton interior point method.
 }
\item{...}{
  Optional arguments passed to fitting routine.
 }
}

\description{Function to choose method for quantile regression}
\seealso{  \code{\link{rq}} \code{\link{rq.fit.br}} \code{\link{rq.fit.fn}}}

\keyword{ regression }

\eof
\name{rq.fit.br}
\alias{rq.fit.br}
\title{
Quantile Regression Fitting by Exterior Point Methods
}
\description{
  This function controls the details of QR fitting by the simplex approach
  embodied in the algorithm of Koenker and d'Orey based on the median
  regression algorithm of Barrodale and Roberts.  Typically, options
  controlling the construction of the confidence intervals would be passed
  via the \code{\dots{}} argument of \code{rq()}.
}
\usage{
rq.fit.br(x, y, tau=0.5, alpha=0.1, ci=FALSE, iid=TRUE, interp=TRUE, tcrit=TRUE)
}
\arguments{
\item{x}{
  the design matrix
}
\item{y}{
  the response variable
}
\item{tau}{
  the quantile desired, if tau lies outside (0,1) the whole process
  is estimated.
}
\item{alpha}{
  the nominal noncoverage probability for the confidence intervals, i.e. 1-alpha
  is the nominal coverage probability of the intervals. 
}
\item{ci}{
  logical flag if T then compute confidence intervals for the parameters
  using the rank inversion method of Koenker (1994).  See \code{rq()} for more
  details.  If F then return only the estimated coefficients.  Note that
  for large problems the default option ci = TRUE can be rather slow.
  Note also that rank inversion only works for p>1, an error message is
  printed in the case that ci=T and p=1.
}
\item{iid}{
  logical flag if T then the rank inversion is based on an assumption of
  iid error model, if F then it is based on an nid error assumption.
  See Koenker and Machado (1999) for further details on this distinction.
}
\item{interp}{
  As with typical order statistic type confidence intervals the test
  statistic is discrete, so it is reasonable to consider intervals that
  interpolate between values of the parameter just below the specified
  cutoff and values just above the specified cutoff.  If \code{interp =
    F} then
  the 2 ``exact'' values above and below on which the interpolation would
  be based are returned.
}
\item{tcrit}{
Logical flag if T -  Student t critical values are used, if F then normal
values are used.
}
}
\value{
  Returns an object of class \code{"rq"}
  for tau in (0,1), or else of class \code{"rq.process"}.
  See \code{\link{rq.object}} and \code{\link{rq.process.object}}
  for further details.
}
\details{
  If tau lies in (0,1) then an object of class \code{"rq"} is
  returned with various
  related inference apparatus.  If tau lies outside [0,1] then an object
  of class \code{rq.process} is returned.  In this case parametric programming
  methods are used to find all of the solutions to the QR problem for
  tau in (0,1), the p-variate resulting process is then returned as the
  array sol containing the primal solution and dsol containing the dual
  solution.  There are roughly \eqn{O(n \log n))}{O(n log n)} distinct
  solutions, so users should
  be aware that these arrays may be large and somewhat time consuming to
  compute for large problems.
}
\references{
Koenker, R. and J.A.F. Machado, (1999) Goodness of fit and related inference 
processes for quantile regression,
\emph{J. of Am Stat. Assoc.}, forthcoming
}
\seealso{
\code{\link{rq}}, \code{\link{rq.fit.fn}}
}
\examples{
data(stackloss)
rq.fit.br(stack.x, stack.loss, tau=.73 ,interp=FALSE)
}
\keyword{regression}
% Converted by Sd2Rd version 0.3-3.

\eof
\name{rq.fit.fn}
\alias{rq.fit.fn}
\title{
Quantile Regression Fitting via Interior Point Methods
}
\description{
This is a lower level routine called by \code{rq()} to compute quantile
regression methods using the Frisch-Newton algorithm.
}
\usage{
rq.fit.fn(x, y, tau=0.5, beta=0.99995, eps=1e-06)
}
\arguments{
\item{x}{
The design matrix
}
\item{y}{
The response vector
}
\item{tau}{
The quantile of interest, must lie in (0,1)
}
\item{beta}{
technical step length parameter -- alter at your own risk!
}
\item{eps}{
  tolerance parameter for convergence.  In cases of multiple optimal solutions
  there may be some discrepancy between solutions produced by method
  \code{"fn"} and method \code{"br"}.  This is due to the fact that
  \code{"fn"} tends to converge to a point near the centroid of the
  solution set, while \code{"br"} stops at a vertex of the set.  
}
}
\value{
  returns an object of class \code{"rq"}, which can be passed to
  \code{\link{summary.rq}} to obtain standard errors, etc.
}
\details{
  The details of the algorithm are explained in Koenker and Portnoy (1997).
  The basic idea can be traced back to the log-barrier methods proposed by
  Frisch in the 1950's for constrained optimization.  But the current
  implementation is based on proposals by Mehrotra and others in the
  recent (explosive) literature on interior point methods for solving linear 
  programming problems.  This version of the algorithm is designed for
  fairly large problems, for very large problems see \code{rq.fit.pfn}.
}
\references{
Koenker, R. and S. Portnoy (1997).
The Gaussian Hare and the Laplacian Tortoise:
Computability of squared-error vs. absolute-error estimators, with discussion,
\emph{Statistical Science}, \bold{12}, 279-300.
}
\seealso{
  \code{\link{rq}}, \code{\link{rq.fit.br}},
  \code{\link{rq.fit.pfn}}
}
\keyword{regression}
% Converted by Sd2Rd version 0.3-3.

\eof
\name{rq.fit.fnb}
\alias{rq.fit.fnb}
\title{
Quantile Regression Fitting via Interior Point Methods
}
\description{
This is a lower level routine called by \code{rq()} to compute quantile
regression methods using the Frisch-Newton algorithm.
}
\usage{
rq.fit.fnb(x, y, tau=0.5, beta=0.99995, eps=1e-06)
}
\arguments{
\item{x}{
The design matrix
}
\item{y}{
The response vector
}
\item{tau}{
The quantile of interest, must lie in (0,1)
}
\item{beta}{
technical step length parameter -- alter at your own risk!
}
\item{eps}{
  tolerance parameter for convergence.  In cases of multiple optimal solutions
  there may be some discrepancy between solutions produced by method
  \code{"fn"} and method \code{"br"}.  This is due to the fact that
  \code{"fn"} tends to converge to a point near the centroid of the
  solution set, while \code{"br"} stops at a vertex of the set.  
}
}
\value{
  returns an object of class \code{"rq"}, which can be passed to
  \code{\link{summary.rq}} to obtain standard errors, etc.
}
\details{
  The details of the algorithm are explained in Koenker and Portnoy (1997).
  The basic idea can be traced back to the log-barrier methods proposed by
  Frisch in the 1950's for constrained optimization.  But the current
  implementation is based on proposals by Mehrotra and others in the
  recent (explosive) literature on interior point methods for solving linear 
  programming problems.  This is a slightly modified version of \code{rq.fit.fn}
  currently to be regarded as under betatest.  This 'method' allows the
  user to specify an infeasible starting point for the dual problem, that
  is one that may not satisfy the dual equality constraints.  It still 
  assumes that the starting value satisfies the upper and lower bounds.
}
\references{
Koenker, R. and S. Portnoy (1997).
The Gaussian Hare and the Laplacian Tortoise:
Computability of squared-error vs. absolute-error estimators, with discussion,
\emph{Statistical Science}, \bold{12}, 279-300.
}
\seealso{
  \code{\link{rq}}, \code{\link{rq.fit.br}},
  \code{\link{rq.fit.pfn}}
}
\keyword{regression}

\eof
\name{rq.fit.fnc}
\alias{rq.fit.fnc}
\title{
Quantile Regression Fitting via Interior Point Methods
}
\description{
This is a lower level routine called by \code{rq()} to compute quantile
regression methods using the Frisch-Newton algorithm.  It allows the
call to specify linear inequality constraints to which the fitted
coefficients will be subjected. 
}
\usage{
rq.fit.fnc(x, y, R, r, tau=0.5, beta=0.9995, eps=1e-06)
}
\arguments{
\item{x}{
The design matrix
}
\item{y}{
The response vector
}
\item{R}{
The matrix describing the inequality constraints
}
\item{r}{
The right hand side vector of inequality constraints
}
\item{tau}{
The quantile of interest, must lie in (0,1)
}
\item{beta}{
technical step length parameter -- alter at your own risk!
}
\item{eps}{
  tolerance parameter for convergence.  In cases of multiple optimal solutions
  there may be some discrepancy between solutions produced by method
  \code{"fn"} and method \code{"br"}.  This is due to the fact that
  \code{"fn"} tends to converge to a point near the centroid of the
  solution set, while \code{"br"} stops at a vertex of the set.  
}
}
\value{
  returns an object of class \code{"rq"}, which can be passed to
  \code{\link{summary.rq}} to obtain standard errors, etc.  It is
  an open research problem to provide an inference apparatus for
  inequality constrained quantile regression.
}
\details{
  The details of the algorithm are explained in Koenker and Ng (2002).
  The basic idea can be traced back to the log-barrier methods proposed by
  Frisch in the 1950's for constrained optimization.  But the current
  implementation is based on proposals by Mehrotra and others in the
  recent (explosive) literature on interior point methods for solving linear 
  programming problems.  See \code{"rq"} helpfile for an example.
}
\references{
Koenker, R. and S. Portnoy (1997).
The Gaussian Hare and the Laplacian Tortoise:
Computability of squared-error vs. absolute-error estimators, with discussion,
\emph{Statistical Science}, \bold{12}, 279-300.

Koenker, R. and P. Ng(2002).
Inequality Constrained Quantile Regression, in process
}
\seealso{
  \code{\link{rq}}, \code{\link{rq.fit.br}},
  \code{\link{rq.fit.pfn}}
}
\keyword{regression}
% Converted by Sd2Rd version 0.3-3.

\eof
\name{rq.fit.pfn}
\alias{rq.fit.pfn}
\title{ Preprocessing Algorithm for Quantile Regression}
\description{
A preprocessing algorithm for the Frisch Newton algorithm 
for quantile regression. This is one possible method for rq().}
}
\usage{
rq.fit.pfn(x, y, tau=0.5, Mm.factor=0.8, max.bad.fixup=3, eps=1e-06)
}
\arguments{
  \item{x}{design matrix usually supplied via rq() }
  \item{y}{ response vector usually supplied via rq() }
  \item{tau}{ quantile of interest }
  \item{Mm.factor}{  constant to determine sub sample size m}
  \item{max.bad.fixup}{ number of allowed mispredicted signs of residuals }
  \item{eps}{ convergence tolerance }
}
\details{
Preprocessing algorithm to reduce the effective sample size for QR
problems with (plausibly) iid samples.  The preprocessing relies
on subsampling of the original data, so situations in which the
observations are not plausibly iid, are likely to cause problems.
The tolerance eps may be relaxed somewhat.
}
\value{
Returns an object of type rq
}
\references{ Portnoy and Koenker, Statistical Science, (1997) 279-300}
\author{ Roger Koenker <rkoenker@uiuc.edu>}
\seealso{ \code{\link{rq}}}

\keyword{ regression }

\eof
\name{rq.object}
\alias{rq.object}
\title{
Linear Quantile Regression Object 
}
\description{
  These are objects of class \code{"rq"}.
  They represent the fit of a linear conditional quantile function model. 
}
\section{Generation}{
  This class of objects is returned from the \code{rq} function 
  to represent a fitted linear quantile regression model. 
}
\section{Methods}{
  The \code{"rq"} class of objects has methods for the following generic 
functions: 
\code{coef}, \code{effects}
, \code{formula}
, \code{labels}
,  \code{model.frame}
, \code{model.matrix}
, \code{plot}
, \code{predict}
, \code{print}
, \code{print.summary}
, \code{residuals}
, \code{summary}
}
\section{Structure}{
  The following components must be included in a legitimate \code{rq} object. 
  \describe{
    \item{\code{coefficients}}{
      the coefficients of the quantile regression fit. 
      The names of the coefficients are the names of the 
      single-degree-of-freedom effects (the columns of the 
      model matrix). 
      If the model was fitted by method \code{"br"} with \code{ci=TRUE}, then
      the coefficient component consists of a matrix whose
      first column consists of the vector of estimated coefficients
      and the second and third columns are the lower and upper
      limits of a confidence interval for the respective coefficients.
    }
    \item{\code{residuals}}{
      the residuals from the fit. 
    }
    \item{\code{contrasts}}{
      a list containing sufficient information to construct the contrasts 
      used to fit any factors occurring in the model. 
      The list contains entries that are either matrices or character vectors. 
      When a factor is coded by contrasts, the corresponding contrast matrix 
      is stored in this list. 
      Factors that appear only as dummy variables and variables in the model 
      that are matrices correspond to character vectors in the list. 
      The character vector has the level names for a factor or the column 
      labels for a matrix. 
    }
    \item{\code{model}}{
      optionally the model frame, if \code{model=TRUE}. 
    }
    \item{\code{x}}{
      optionally the model matrix, if \code{x=TRUE}. 
    }
    \item{\code{y}}{
      optionally the response, if \code{y=TRUE}. 
    }
  }
}
\details{
  The coefficients, residuals, and effects may be extracted 
  by the generic functions of the same name, rather than 
  by the \code{$} operator.   
  For pure \code{rq} objects this is less critical 
  than for some of the inheritor classes.  
  Note that the extractor function \code{coef} returns a vector with missing values 
  omitted.  
}
\seealso{
  \code{\link{rq}},  \code{\link{coefficients}}.   
}
\keyword{regression}
% Converted by Sd2Rd version 0.3-3.

\eof
\name{rq.process.object}
\alias{rq.process.object}
\title{
Linear Quantile Regression Process Object 
}
\description{
These are objects of class \code{rq.process.}
They represent the fit of a linear conditional quantile function model. 
}
\section{Generation}{
This class of objects is returned from the \code{rq}
 function 
to represent a fitted linear quantile regression model. 
}
\section{Methods}{
The \code{"rq.process"} class of objects has 
methods for the following generic 
functions: 
\code{effects}, \code{formula}
, \code{labels}
, \code{model.frame}
, \code{model.matrix}
, \code{plot}
, \code{predict}
, \code{print}
, \code{print.summary}
, \code{summary}
}
\section{Structure}{
  The following components must be included in a legitimate \code{rq.process}
  object. 

  \describe{
    \item{\code{sol}}{
      The primal solution array.  This is a (p+3)  by  J  matrix  whose  
      first  row  contains  the 'breakpoints'
      \eqn{tau_1, tau_2, \dots, tau_J},   
      of  the  quantile function, i.e. the values in [0,1] at which  the  
      solution changes,  row  two  contains  the  corresponding quantiles 
      evaluated at the mean design point, i.e. the inner product of  
      xbar  and  \eqn{b(tau_i)}, the third row contains the value of the objective
      function evaluated at the corresponding \eqn{tau_j}, and the last p rows 
      of the matrix give \eqn{b(tau_i)}.  The solution \eqn{b(tau_i)} prevails from  
      \eqn{tau_i} to \eqn{tau_i+1}.  Portnoy (1991) shows that
      \eqn{J=O_p(n \log n)}{J=O_p(n log n)}.
    }
    \item{\code{dsol}}{
      The dual solution array.  This is a
      n by J matrix  containing the  dual  solution  corresponding to sol,
      the ij-th entry is 1 if \eqn{y_i > x_i b(tau_j)}, is 0 if \eqn{y_i <  x_i
      b(tau_j)},  and is between 0 and 1 otherwise, i.e. if the
      residual is zero. See  Gutenbrunner and Jureckova(1991)
      for a detailed discussion of the statistical
      interpretation of dsol.  The use of dsol in inference is described
      in Gutenbrunner, Jureckova, Koenker, and Portnoy (1994).
    }
  }
}
\details{
  These arrays are computed by parametric linear programming methods
  using using the exterior point (simplex-type) methods of the 
  Koenker--d'Orey algorithm based on Barrodale and Roberts median
  regression algorithm.
}
\references{
  [1] Koenker, R. W. and Bassett, G. W. (1978). Regression quantiles,
  \emph{Econometrica}, \bold{46}, 33--50.

  [2] Koenker, R. W. and d'Orey (1987, 1994).
  Computing Regression Quantiles.
  \emph{Applied Statistics}, \bold{36}, 383--393, and \bold{43}, 410--414.

  [3] Gutenbrunner, C. Jureckova, J. (1991).
  Regression quantile and regression rank score process in the
  linear model and derived statistics, \emph{Annals of Statistics},
  \bold{20}, 305--330.

  [4] Gutenbrunner, C., Jureckova, J., Koenker, R. and
  Portnoy, S. (1994)  Tests of linear hypotheses based on regression  
  rank scores.   \emph{Journal of Nonparametric Statistics}, 
  (2), 307--331.

  [5]  Portnoy, S. (1991).  Asymptotic behavior of the number of regression
  quantile breakpoints, \emph{SIAM Journal of Scientific
    and  Statistical Computing}, \bold{12}, 867--883.
}
\seealso{
\code{\link{rq}}.
}
\keyword{regression}
% Converted by Sd2Rd version 0.3-3.

\eof
\name{rq.wfit}
\alias{rq.wfit}
\title{Function to choose method for Weighted Quantile Regression  }
\description{ Weight the data and then call the chosen fitting algorithm.  }
\usage{
rq.wfit(x, y, tau=0.5, weights, method="br", ...)
}
\arguments{ 
\item{x}{ 
  the design matrix 
} 
\item{y}{ 
  the response variable 
} 
\item{tau}{ 
  the quantile desired, if tau lies outside (0,1) the whole process 
  is estimated. 
} 
\item{weights}{ 
  weights used in the fitting
} 
\item{method}{ 
  method of computation:  "br" is Barrodale and Roberts exterior point 
  "fn" is the Frisch-Newton interior point method. 
} 
\item{...}{ 
  Optional arguments passed to fitting routine.
} 
}
 
\seealso{  \code{\link{rq}} \code{\link{rq.fit.br}} \code{\link{rq.fit.fn}}}

\keyword{ regression }

\eof
\name{rrs.test}
\alias{rrs.test}
\title{
Quantile Regression Rankscore Test
}
\description{
  Function to compute regression rankscore test of a linear hypothesis
  based on the dual quantile regression process.  A test of  the 
  hypothesis, 
  is carried out by estimating the restricted model and constructing
  a test based on the dual process under the restricted model.  The
  details of the test are described in GJKP(1993).  The test has a
  Rao-score, Lagrange-multiplier interpretation since in effect it
  is based on the value of the gradient of unrestricted quantile regression
  problem evaluated under the null.  This function will eventually be
  superseded by a more general \code{anova()} method for \code{rq}.
}
\usage{
rrs.test(x0, x1, y, v, score="wilcoxon")
}
\arguments{
\item{x0}{
  the matrix of maintained regressors, a column of ones is
  appended automatically.
}
\item{x1}{
  matrix of covariates under test.
}
\item{y}{
  response variable, may be omitted if \code{v} is provided.
}
\item{v}{
  object of class \code{"rq.process"} generated e.g. by
  \code{rq(y ~ x0, tau=-1)}
}
\item{score}{
  Score function for test (see \code{\link{ranks}})
}
}
\value{
  Test statistic \code{sn} is asymptotically Chi-squared with rank(X1) dfs.
  The vector of ranks is also returned as component \code{rank}.
}
\details{
  See GJKP(1993)
}
\references{
  [1] Gutenbrunner, C., Jureckova, J., Koenker, R. and
  Portnoy, S. (1993)  Tests of linear hypotheses based on
  regression rank scores.   \emph{Journal of Nonparametric
  Statistics}, (2), 307-331.


  [2] Koenker, R. W. and d'Orey (1994).  Remark on Alg. AS
  229:  Computing dual regression quantiles and regression
  rank scores.  \emph{Applied Statistics}, \bold{43}, 410-414.
}
\seealso{
  \code{\link{rq}}, \code{\link{ranks}}
}
\examples{
# Test that covariates 2 and 3 belong in stackloss model using Wilcoxon scores.
data(stackloss)
rrs.test(stack.x[,1], stack.x[,2:3], stack.loss)
}
\keyword{regression}
% Converted by Sd2Rd version 0.3-3.

\eof
\name{summary.rq}
\alias{summary.rq}
\title{
Summary method for Quantile Regression
}
\description{
Returns a summary list for a quantile regression fit.  A null value
will be returned if printing is invoked.
}
\usage{
summary.rq(object, se="nid", covariance=TRUE, hs = TRUE,  ...)
}
\arguments{
  \item{object}{
    This is an object of class \code{"rq"} produced by a call to \code{rq()}.
  }
  \item{se}{
    specifies the method used to compute standard standard errors.  There
    are currently five available methods:  
    \enumerate{
      \item \code{"rank"} which produces confidence intervals for the
      estimated parameters by inverting a rank test as described in
      Koenker (1994).  The default option assumes that the errors are
      iid, while the option iid = FALSE implements the proposal of Koenker
      Machado (1999).

      \item \code{"iid"} which presumes that the errors are iid and computes
      an estimate of the asymptotic covariance matrix as in KB(1978).
      
      \item \code{"nid"} which presumes local (in \code{tau})
      linearity (in \code{x}) of the
      the conditional quantile functions and computes a Huber
      sandwich estimate using a local estimate of the sparsity.
      
      \item \code{"ker"} which uses a kernel estimate of the sandwich
      as proposed by Powell(1990).

      \item \code{"boot"} which implements one of several possible bootstrapping
      alternatives for estimating standard errors.
    }
  }
  \item{covariance}{
    logical flag to indicate whether the full covariance matrix of the 
    estimated parameters should be returned. 
  }
  \item{hs}{
    Use Hall Sheather bandwidth for sparsity estimation
    If false revert to Bofinger bandwidth.
   }
  \item{...}{
    Optional arguments to summary, e.g. bsmethod to use bootstrapping.
    see \code{\link{boot.rq}}
   }
}
\value{
  a list is returned with the following components

\item{coefficients}{
  a p by 4 matrix consisting of the coefficients, their estimated standard
  errors, their t-statistics, and their associated p-values.
}
\item{cov}{
  the estimated covariance matrix for the coefficients in the model,
  provided that \code{cov=TRUE} in the called sequence.
}
\item{Hinv}{
  inverse of the estimated Hessian matrix returned if \code{cov=TRUE} and
  \code{se != "iid"}.
}
\item{J}{
  Outer product of gradient matrix returned if \code{cov=TRUE} and \code{se
    != "iid"}. The Huber sandwich is \code{cov = Hinv \%*\% J \%*\% Hinv}.
}}
\details{
When the default summary method is used, it tries to estimate a sandwich
form of the asymptotic covariance matrix and this involves estimating
the conditional density at each of the sample observations, negative
estimates can occur if there is crossing of the neighboring quantile
surfaces used to compute the difference quotient estimate.  If the
number of these is large relative to the sample size it is sometimes
an indication that some additional nonlinearity in the covariates
would be helpful, for instance quadratic effects.}
 

\references{
  Koenker, R. (2004) \emph{Quantile Regression}.
}
\seealso{
  \code{\link{rq}}
  \code{\link{bandwidth.rq}}
}
\examples{
data(stackloss)
y <- stack.loss
x <- stack.x
summary(rq(y ~ x, method="fn")) # Compute se's for fit using "nid" method.
summary(rq(y ~ x, ci=FALSE),se="ker")
# default "br" alg, and compute kernel method se's
}
\keyword{regression}
% Converted by Sd2Rd version 0.3-3.

\eof
\name{table.rq}
\alias{table.rq}
\title{
  Table of Quantile Regression Results
}
\description{
  Function to produce a table of quantile regression results for a group
  of specified quantiles.
}
\usage{
table.rq(formula, taus=c(0.25, 0.5, 0.75), method="br", \dots)
}
\arguments{
  \item{formula}{
    formula for the linear model, see \code{rq()}
  }
  \item{taus}{
    quantiles of interest
  }
  \item{method}{
    algorithmic method, for large problems \code{method="fn"}
    would be preferred.
  }
  \item{...}{
    other optional arguments passed to \code{rq()}.
  }
}
\value{
  The function returns an array with dimensions (p, m, 3), where p is the
  dimension of the parameter vector of the model specified by formula, m
  is the number of quantiles specified by tau.  For each coefficient at
  each tau there is a point estimate and lower and upper limits of a
  confidence interval.  The object returned is of class \code{table.rq}
  and can be plotted, or formatted into a latex style table.
}
\details{
  This is only implemented for \code{method="br"}, but modifications for
  \code{"fn"} would be quite straightforward.  There is also an
  implementation for making a latex table in the Splus version,
  but this wasn't incorporated into the \R package due to some
  incompatibilities in the unix/system commands.
}
\seealso{
\code{\link{rq}}, \code{\link{rq.fit.br}}, \code{\link{plot.table.rq}}
}
\examples{
data(stackloss)
plot(table.rq(stack.loss~stack.x))#plot results of a quantile regression
}
\keyword{regression}
% Converted by Sd2Rd version 0.3-3.



\eof
