rq.fit.fnc             package:quantreg             R Documentation

_Q_u_a_n_t_i_l_e _R_e_g_r_e_s_s_i_o_n _F_i_t_t_i_n_g _v_i_a _I_n_t_e_r_i_o_r _P_o_i_n_t _M_e_t_h_o_d_s

_D_e_s_c_r_i_p_t_i_o_n:

     This is a lower level routine called by 'rq()' to compute quantile
     regression methods using the Frisch-Newton algorithm.  It allows
     the call to specify linear inequality constraints to which the
     fitted coefficients will be subjected.

_U_s_a_g_e:

     rq.fit.fnc(x, y, R, r, tau=0.5, beta=0.9995, eps=1e-06)

_A_r_g_u_m_e_n_t_s:

       x: The design matrix 

       y: The response vector 

       R: The matrix describing the inequality constraints 

       r: The right hand side vector of inequality constraints 

     tau: The quantile of interest, must lie in (0,1) 

    beta: technical step length parameter - alter at your own risk! 

     eps: tolerance parameter for convergence.  In cases of multiple
          optimal solutions there may be some discrepancy between
          solutions produced by method '"fn"' and method '"br"'.  This
          is due to the fact that '"fn"' tends to converge to a point
          near the centroid of the solution set, while '"br"' stops at
          a vertex of the set.   

_D_e_t_a_i_l_s:

     The details of the algorithm are explained in Koenker and Ng
     (2002). The basic idea can be traced back to the log-barrier
     methods proposed by Frisch in the 1950's for constrained
     optimization.  But the current implementation is based on
     proposals by Mehrotra and others in the recent (explosive)
     literature on interior point methods for solving linear 
     programming problems.  See '"rq"' helpfile for an example.

_V_a_l_u_e:

     returns an object of class '"rq"', which can be passed to
     'summary.rq' to obtain standard errors, etc.  It is an open
     research problem to provide an inference apparatus for inequality
     constrained quantile regression.

_R_e_f_e_r_e_n_c_e_s:

     Koenker, R. and S. Portnoy (1997). The Gaussian Hare and the
     Laplacian Tortoise: Computability of squared-error vs.
     absolute-error estimators, with discussion, _Statistical Science_,
     *12*, 279-300.

     Koenker, R. and P. Ng(2002). Inequality Constrained Quantile
     Regression, in process

_S_e_e _A_l_s_o:

     'rq', 'rq.fit.br', 'rq.fit.pfn'

