\name{Surv}
\alias{Surv}
\alias{is.Surv}
\alias{print.Surv}
\alias{Math.Surv}
\alias{Summary.Surv}
\alias{[.Surv}
\alias{format.Surv}
\alias{as.data.frame.Surv}
\alias{as.character.Surv}
\alias{is.na.Surv}
\alias{Ops.Surv}
\title{
Create a Survival Object
}
\description{
Create a survival object, usually used as a response variable in a model
formula.
}
\synopsis{Surv(time,time2,event,type,origin)}
\usage{
Surv(time, event)
or
Surv(time, time2, event, type=<<see below>>, origin=0)
is.Surv(x)
}
\arguments{
\item{time}{
for right censored data, this is the follow up time.  For interval data, the
first argument is the starting time for the interval.
}
\item{x}{
any S-PLUS object.
}
\item{event}{
The status indicator, normally 0=alive, 1=dead.  Other choices are T/F
(TRUE = death) or 1/2 (2=death).
For interval censored data, the status indicator is 0=right censored,
1= event at \code{time}, 2=left censored, 3=interval censored.
Although unusual, the event indicator can be omitted,
in which case all subjects are assumed to have an event.
}
\item{time2}{
ending time of the interval for interval censored  or counting process 
data only. 
Intervals are
assumed to be open on the left and closed on the right, \code{(start, end]}.
For counting process data,
\code{event} indicates whether an event occurred at the end of the interval.
}
\item{type}{
character string specifying the type of censoring. Possible values
are \code{"right"}, \code{"left"}, \code{"counting"}, \code{"interval"}, or \code{"interval2"}.
The default is \code{"right"} or \code{"counting"} depending on whether the \code{time2}
argument is absent or present, respectively.
}
\item{origin}{
for counting process data, the hazard function origin.  This is most often
used in conjunction with a model containing time dependent strata in order
to align the subjects properly when they cross over from one strata to
another.
}}
\value{
An object of class \code{Surv}.  There are methods for \code{print}, \code{is.na}, and
subscripting survival objects.  To include a survival object inside a
data frame, use the \code{I()} function.  \code{Surv} objects are implemented as
a matrix of 2 or 3 columns.


In the case of \code{is.Surv}, a logical value \code{T} if \code{x} inherits from 
class \code{"Surv"}, otherwise an \code{F}.
}
\section{DETAILS}{
In theory it is possible to represent interval censored data without a
third column containing the explicit status.  Exact, right censored,
left censored and interval censored observation would be represented as
intervals of (a,a), (a, infinity), (-infinity,b), and (a,b) respectively;
each specifying the interval within which the event is known to have occurred.


If \code{type = "interval2"} then the representation given above is
assumed, with NA taking the place of infinity.  If `type="interval"
\code{event} must be given.  If \code{event} is \code{0}, \code{1}, or \code{2}, the relevant
information is assumed to be contained in \code{time}, the value in \code{time2}
is ignored, and the second column of the result will contain a
placeholder.


Presently, the only methods allowing interval censored data are the
parametric models computed by \code{survreg}, 
so the distinction between open and closed intervals
is unimportant.  
The distinction is important for counting process data and
the Cox model.


The function tries to distinguish between the use of 0/1 and 1/2 coding for
left and right censored data using \code{if (max(status)==2)}.
If 1/2 coding is used and all the subjects are censored, it will
guess wrong.  Use 0/1 coding in this case.
}
\seealso{
\code{\link{coxph}}, \code{\link{survfit}}, \code{\link{survreg}}.}
\examples{
data(aml)
Surv(aml$time, aml$status)
}
\keyword{survival}
% Converted by Sd2Rd version 0.3-2.

\eof
\name{aml}
\alias{aml}
\alias{leukemia}
\title{Acute Myelogenous Leukemia survival data}
\usage{data(aml)
data(leukemia)}
\description{Survival in patients with Acute Myelogenous Leukemia}
\format{
    \tabular{ll}{
	time:\tab survival or censoring time\cr
	status:\tab censoring status\cr
	x: \tab maintenance chemotherapy given? (factor)\cr
     }
 }
\source{Miller "Survival Analysis"}
\keyword{datasets}

\eof
\name{anova.coxph}
\alias{anova.coxph}
\alias{anova.coxphlist}
\title{Analysis of Deviance for Cox model.}
\usage{
\method{anova}{coxph}(object, \dots,  test = NULL)
}
\description{
  Compute an analysis of deviance table for one Cox model fit.
}
\arguments{
  \item{object}{An object of class \code{coxph}}
  \item{\dots}{Further \code{coxph} objects}
  \item{test}{a character string, (partially) matching one of \code{"Chisq"},
    \code{"F"} or \code{"Cp"}. See \code{\link{stat.anova}}.}
}
\details{
  Specifying a single object gives a sequential analysis of deviance
  table for that fit.  That is, the reductions in the residual deviance
  as each term of the formula is added in turn are given in as
  the rows of a table, plus the residual deviances themselves.


  If more than one object is specified, the table has a row for the
  residual degrees of freedom and deviance for each model. For all
  but the first model, the change in degrees of freedom and deviance
  is also given. (This only make statistical sense if the models are
  nested.)  It is conventional to list the models from smallest to
  largest, but this is up to the user.
  
  The table will optionally contain test statistics (and P values)
  comparing the reduction in deviance for the row to the residuals.
    Mallows' \eqn{C_p}{Cp} statistic is the residual
    deviance plus twice the  residual degrees of freedom, which is closely
  related to AIC. Don't use \code{test=F}, it doesn't make sense.
}
\value{
  An object of class \code{"anova"} inheriting from class \code{"data.frame"}.
}
\section{Warning}{
  The comparison between two or more models by \code{anova} or
   will only be valid if they
  are fitted to the same dataset. This may be a problem if there are
  missing values.}
\seealso{
  \code{\link{coxph}}, \code{\link{anova}}.
}
\examples{
data(ovarian)
fit <- coxph(Surv(futime, fustat) ~ resid.ds *rx + ecog.ps, data = ovarian) 
anova(fit)
anova(fit,test="Chisq")
fit2 <- coxph(Surv(futime, fustat) ~ resid.ds +rx + ecog.ps, data
=ovarian)
anova(fit2,fit)
 }
\keyword{models}
\keyword{regression}
\keyword{survival}


\eof
\name{as.date}
\alias{as.date}
\title{Coerce Data to Dates}
\description{
  Converts any of the following character forms to a Julian date:
  8/31/56, 8-31-1956, 31 8 56, 083156, 31Aug56, or August 31 1956.
}
\usage{
as.date(x, order = "mdy", ...)
}
\arguments{
  \item{x}{input data vector.}
  \item{order}{if x is character, defines the order in which the terms
    are assumed to appear in a xx/xx/xx date.  The default is
    month/day/year; any permutation of mdy is legal.}
  \item{...}{if x is character, then any other arguments from
    \code{mdy.date()} can be used as well.}
}
\value{
  For each date, the number of days between it and January 1, 1960.
  The date will be missing if the string is not interpretable.
}
\details{
  If \code{x} is numeric, then \code{floor(x)} is returned, e.g.,
  \code{as.date(35)} is the same as \code{as.date(35.2)} and gives
  \code{Feb 2, 1960}.  If \code{x} is character, the program attempts
  to parse it.
}
\seealso{
  \code{\link{mdy.date}},
  \code{\link{date.mmddyy}}, 
  \code{\link{date.ddmmmyy}}
}
\examples{
as.date(c("1jan1960", "2jan1960", "31mar1960", "30jul1960"))
}
\keyword{chron}

\eof
\name{attrassign}
\alias{attrassign.default}
\alias{attrassign}
\alias{attrassign.lm}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Create new-style "assign" attribute}
\description{
The \code{"assign"} attribute on model matrices describes which columns
come from which terms in the model formula. It has two version. R uses
the original version, but the newer version is sometimes useful.
}
\usage{
\method{attrassign}{default}(object, tt,...)
\method{attrassign}{lm}(object,...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{object}{model matrix or linear model object}
  \item{tt}{terms object}
  \item{...}{ignored}
}

\value{
 A list with names corresponding to the term names and elements
 that are vectors indicating which columns come from which terms
}
\seealso{\code{\link{terms}},\code{\link{model.matrix}}}

\examples{
data(pbc)
formula<-Surv(time,status)~factor(edtrt)
tt<-terms(formula)
mf<-model.frame(tt,data=pbc)
mm<-model.matrix(tt,mf)
## a few rows of data
mm[1:3,]
## old-style assign attribute
attr(mm,"assign")
## new-style assign attribute
attrassign(mm,tt)
}
\keyword{models}%-- one or more ...

\eof
\name{bladder}
\alias{bladder}
\alias{bladder2}
\title{Bladder Cancer Recurrences}
\usage{data(bladder)}
\description{Data on recurrences of bladder cancer, used by many people
  to demonstrate methodology for recurrent event modelling.}
  
\format{
 bladder
    \tabular{ll}{
	id:\tab Patient id\cr
	rx:\tab Treatment 1=placebo  2=thiotepa\cr
	number:\tab Initial number of tumours (8=8 or more)\cr
	size:\tab size (cm) of largest initial tumour\cr
	stop:\tab recurrence or censoring time\cr
	enum:\tab which recurrence (up to 4)\cr
     }
 bladder2 
    \tabular{ll}{
	id:\tab Patient id\cr
	rx:\tab Treatment 1=placebo  2=thiotepa\cr
	number:\tab Initial number of tumours (8=8 or more)\cr
	size:\tab size (cm) of largest initial tumour\cr
	start:\tab start of interval (0 or previous recurrence time)\cr
	stop:\tab recurrence or censoring time\cr
	enum:\tab which recurrence (up to 4)\cr
     }

 }
\source{Wei, Lin, Weisfeld, JASA 1989}
\keyword{datasets}
\keyword{survival}

\eof
\name{clogit}
\alias{clogit}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Conditional logistic regression }
\description{
  Estimates a logistic regression model by maximising the conditional
  likelihood. Uses a model formula of the form
  \code{case.status~exposure+strata(matched.set)}.
  The default is to use the exact conditional likelihood, a commonly
  used approximate conditional likelihood is provided for compatibility
  with older software.
}
\usage{
clogit(formula, data, method=c("exact", "approximate"), na.action=getOption("na.action"), subset=NULL,control=coxph.control())
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{formula}{Model formula}
  \item{data}{data frame }
  \item{method}{correct or approximate conditonal likelihood?}
  \item{na.action}{missing value handling}
  \item{subset}{subset of records to use }
  \item{control}{control values}
}

\value{
  An object of class \code{"clogit"}, which is a wrapper for a
  \code{"coxph"} object.
}
\author{Thomas Lumley}


\seealso{\code{\link{strata}},\code{\link{coxph}},\code{\link{glm}} }

\examples{
data(infert)
clogit(case~spontaneous+induced+strata(stratum),data=infert)
}
\keyword{survival}%-- one or more ...
\keyword{models}

\eof
\name{cluster}
\alias{cluster}
\title{
Identify Clusters
}
\description{
This is a special function used in the context of the Cox model.  It
identifies correlated groups of observations, and is used on the right hand
side of a formula.
}
\usage{
cluster(x)
}
\arguments{
\item{x}{
A character, factor, or numeric variable.
}}
\value{
\code{x}
}
\details{
The function's only action is semantic, to mark a variable as the
cluster indicator.
}
\seealso{
\code{\link{coxph}}, \code{\link{Surv}}}
\examples{\dontrun{
coxph(Surv(futime, fustat) ~ age + cluster(group), data = ovarian)
}}
\keyword{survival}
% Converted by Sd2Rd version 0.3-2.

\eof
\name{colon}
\alias{colon}
\title{Chemotherapy for Stage B/C colon cancer}
\usage(data(colon))
\description{These are data from one of the first successful trials of
    adjuvant chemotherapy for colon cancer. Levamisole is a low-toxicity
    compound previously used to treat worm infestations in animals; 5-FU
    is a moderately toxic (as these things go) chemotherapy agent. There
  are two records per person, one for recurrence and one for death}
\format{
\tabular{ll}{
id:\tab id\cr
study:\tab 1 for all patients\cr
rx:\tab Treatment - Obs(ervation), Lev(amisole), Lev(amisole)+5-FU\cr
sex:\tab  1=male\cr
age:\tab in years\cr
obstruct:\tab obstruction of colon by tumour\cr
perfor:\tab perforation of colon\cr
adhere:\tab adherence to nearby organs\cr
nodes:\tab number of lymph nodes with detectable cancer\cr
status:\tab censoring status\cr
differ:\tab differentiation of tumour (1=well, 2=moderate, 3=poor)\cr
extent:\tab Extent of local spread (1=submucosa, 2=muscle, 3=serosa,
4=contiguous structures)\cr
surg:\tab time from surgery to registration (0=short, 1=long)\cr
node4:\tab more than 4 positive lymph nodes\cr
time:\tab days until death\cr
etype:\tab 1=recurrence,2=death\cr
}}

\source{Danyu Lin}
\keyword{survival}

\eof
\name{cox.zph}
\alias{cox.zph}
\alias{[.cox.zph}
\alias{print.cox.zph}
\title{
Test the Proportional Hazards Assumption of a Cox Regression
}
\description{
Test the proportional hazards assumption for a Cox regression model fit
(\code{coxph}).
}
\usage{
cox.zph(fit, transform="km", global=TRUE)
}
\arguments{
\item{fit}{
the result of fitting a Cox regression model, using the \code{coxph} function.
}
\item{transform}{
a character string specifying how the survival times should be transformed
before the test is performed.
Possible values are \code{"km"}, \code{"rank"}, \code{"identity"} or  a
function of one argument.
}
\item{global}{
should a global chi-square test be done, in addition to the
per-variable tests.
}
}}
\value{
an object of class \code{"cox.zph"}, with components:
}
\item{table}{
a matrix with one row for each variable, and optionally a last row for
the global test.
Columns of the matrix contain the correlation coefficient between transformed
survival time and the scaled Schoenfeld residuals, a chi-square,
and the two-sided p-value.
For the global test there is no appropriate correlation, so an NA is
entered into the matrix as a placeholder.
}
\item{x}{
the transformed time axis.
}
\item{y}{
the matrix of scaled Schoenfeld residuals.  There will be one column per
variable and one row per event.  The row labels contain the original event
times (for the identity transform, these will be the same as \code{x}).
}
\item{call}{
the calling sequence for the routine.


The computations require the original \code{x} matrix of the Cox model fit.
Thus it saves time if the \code{x=TRUE} option is used in \code{coxph}.
This function would usually be followed by both a plot and a print of the
result.
The plot gives an estimate of the time-dependent coefficient \code{beta(t)}.
If the proportional hazards assumption is true, \code{beta(t)} will be a horizontal
line.  The printout gives a test for \code{slope=0}.
}}
\references{
P. Grambsch and T. Therneau (1994),
Proportional hazards tests and diagnostics based on weighted residuals.
\emph{Biometrika,}
\bold{81}, 515-26.
}
\seealso{
\code{\link{coxph}}, \code{\link{Surv}}.}
\note{The \code{plot} method requires the \code{splines} library}
\examples{
data(ovarian)
fit <- coxph( Surv(futime, fustat) ~ age + rx, ovarian)
temp<- cox.zph(fit)
print(temp)                  #display the results
plot(temp)                   #plot curves
}
\keyword{survival}
% Converted by Sd2Rd version 0.3-2.

\eof
\name{coxph}
\alias{coxph}
\alias{vcov.coxph}
\alias{print.coxph.null}
\alias{print.coxph.penal}
\alias{model.frame.coxph}
\alias{coxph.penalty}
\alias{[.coxph.penalty}
\alias{coxph.getdata}
\alias{summary.coxph.penal}
\title{
Fit Proportional Hazards Regression Model
}
\description{
Fits a Cox proportional hazards regression model.
Time dependent variables, time dependent strata, multiple events per subject,
and other extensions are incorporated using the counting process formulation
of Andersen and Gill.
}
\usage{
coxph(formula, data=parent.frame(), weights, subset,
       na.action, init, control, method=c("efron","breslow","exact"),
       singular.ok=TRUE, robust=FALSE,
       model=FALSE, x=FALSE, y=TRUE,...
       )
}
\arguments{
\item{formula}{
a formula object, with the response on the left of a \code{~} operator, and
the terms on the right.  The response must be a survival object as
returned by the \code{Surv} function.
}
\item{data}{
a data.frame in which to interpret the variables named in
the \code{formula}, or in the \code{subset} and the \code{weights} argument.
}
\item{subset}{
expression saying that only a subset of the rows of the data
should be used in the fit.
}
\item{na.action}{
a missing-data filter function, applied to the model.frame, after any
subset argument has been used.  Default is \code{options()$na.action}.
}
\item{weights}{
case weights.
}
\item{init}{
vector of initial values of the iteration.  Default initial
value is zero for all variables.
}
\item{control}{
Object of class \code{\link{coxph.control}} specifying iteration limit
and other control options. Default is \code{coxph.control(...)}.
}
\item{method}{
a character string specifying the method for tie handling.  If there 
are no tied death times all the methods are equivalent.
Nearly all Cox regression programs use the Breslow method by default,
but not this one.
The Efron approximation is used as the default here, as it is much more
accurate when dealing with tied death times, and is as efficient
computationally.
The exact method computes the exact partial likelihood, which is equivalent
to a conditional logistic model.  If there are a large number of ties the
computational time will be excessive.
}
\item{singular.ok}{
logical value indicating how to handle collinearity in the model matrix.
If \code{TRUE}, the program will automatically skip over columns of the X matrix
that are linear combinations of earlier columns.  In this case the
coefficients for such columns will be NA, and the variance matrix will contain
zeros.  For ancillary calculations, such as the linear predictor, the missing
coefficients are treated as zeros.
}
\item{robust}{
if TRUE a robust variance estimate is returned.  Default is \code{TRUE} if the
model includes a \code{cluster()} operative, \code{FALSE} otherwise.
}
\item{model}{
flags to control what is returned.  If these are true, then the model
frame, the model matrix, and/or the response is returned as components
of the fitted model, with the same names as the flag arguments. 
}\item{x}{Return the design matrix in the model object?}\item{y}{return
  the response in the model object?}
\item{...}{Other arguments will be passed to \code{\link{coxph.control}}}}
\value{
an object of class \code{"coxph"}. See \code{coxph.object} for details.
}
\section{Side Effects}{
Depending on the call, the \code{predict}, \code{residuals}, and \code{survfit} routines may
need to reconstruct the x matrix created by \code{coxph}.  Differences in the
environment, such as which data frames are attached or the value of
\code{options()$contrasts}, may cause this computation to fail or worse, to be
incorrect.  See the survival overview document for details.
}
\details{
The proportional hazards model is usually expressed in terms of a
single survival time value for each person, with possible censoring.
Andersen and Gill reformulated the same problem as a counting process;
as time marches onward we observe the events for a subject, rather
like watching a Geiger counter.
The data for a subject is presented as multiple rows or "observations", each
of which applies to an interval of observation (start, stop].
}
\section{SPECIAL TERMS}{
There are two special terms that may be used in the model equation.
A 'strata' term identifies a stratified Cox model; separate baseline hazard
functions are fit for each strata.
The \code{cluster} term is used to compute a robust variance for the model.
The term \code{+ cluster(id)}, where \code{id == unique(id)}, is equivalent to
specifying the \code{robust=T} argument, and produces an approximate jackknife
estimate of the variance.  If the \code{id} variable were not unique, but instead
identifies clusters of correlated observations, then the variance estimate
is based on a grouped jackknife.
}
\section{CONVERGENCE}{
In certain data cases the actual MLE estimate of a
coefficient is infinity, e.g., a dichotomous variable where one of the
groups has no events.  When this happens the associated coefficient
grows at a steady pace and a race condition will exist in the fitting
routine: either the log likelihood converges, the information matrix
becomes effectively singular, an argument to exp becomes too large for
the computer hardware, or the maximum number of interactions is exceeded.
The routine attempts to detect when this has happened, not always
successfully.
}
\section{PENALISED REGRESSION}{
  \code{coxph} can now maximise a penalised partial likelihood with
arbitrary user-defined penalty.  Supplied penalty functions include
ridge regression (\link{ridge}), smoothing splines
(\link{pspline}), and frailty models (\link{frailty}).
} 

\references{ P. Andersen and R. Gill. "Cox's regression model for
counting processes, a large sample study", \emph{Annals of Statistics,
} 10:1100-1120, 1982.


T. Therneau, P. Grambsch, and T. Fleming. "Martingale based residuals
for survival models", 
\emph{Biometrika, }
March 1990.

}
\seealso{
\code{\link{cluster}}, \code{\link{survfit}}, \code{\link{Surv}}, \code{\link{strata}},\code{\link{ridge}}, \code{\link{pspline}},\code{\link{frailty}}.}
\examples{
# Create the simplest test data set
#
 test1 <- list(time=  c(4, 3,1,1,2,2,3),
                status=c(1,NA,1,0,1,1,0),
                x=     c(0, 2,1,1,1,0,0),
                sex=   c(0, 0,0,0,1,1,1))
 coxph( Surv(time, status) ~ x + strata(sex), test1)  #stratified model


#
# Create a simple data set for a time-dependent model
#
test2 <- list(start=c(1, 2, 5, 2, 1, 7, 3, 4, 8, 8),
                stop =c(2, 3, 6, 7, 8, 9, 9, 9,14,17),
                event=c(1, 1, 1, 1, 1, 1, 1, 0, 0, 0),
                x    =c(1, 0, 0, 1, 0, 1, 1, 1, 0, 0) )


summary( coxph( Surv(start, stop, event) ~ x, test2))

}
\keyword{survival}
% Converted by Sd2Rd version 0.3-2.

\eof
\name{coxph.detail}
\alias{coxph.detail}
\title{
Details of a Cox Model Fit
}
\description{
Details of a Cox model fit.
Returns the individual contributions to the first and second derivative
matrix, at each unique event time.
}
\usage{
coxph.detail(object)
}
\arguments{
\item{object}{
a Cox model object, i.e., the result of \code{coxph}.
}}
\value{
a list with components

\item{time}{
the vector of unique event times
}
\item{nevent}{
the number of events at each of these time points.
}
\item{means}{
a matrix with one row for each event time and one column for each variable
in the Cox model, containing the weighted mean of the variable at that time,
over all subjects still at risk at that time.  The weights are the risk
weights \code{exp(x \%*\% fit$coef)}.
}
\item{nrisk}{
number of subjects at risk.
}
\item{hazard}{
the hazard increment.
}
\item{score}{
the contribution to the score vector (first derivative of the log
partial likelihood) at each time point.
}
\item{imat}{
the contribution to the information matrix (second derivative of the
log partial likelihood) at each time point.
}
\item{varhaz}{
the variance of the hazard increment.
}
\item{x,y}{
copies of the input data.
}
\item{strata}{
only present for a stratified Cox model, this is
a table giving the number of time points of component \code{time} that
were contributed by each of the strata.
}}
\details{
This function may be useful for those who wish to investigate new methods or
extensions to the Cox model.  The example below shows one way to calculate
the Schoenfeld residuals.
}
\seealso{
\code{\link{coxph}}, \code{\link{residuals.coxph}}}
\examples{
data(ovarian)
fit   <- coxph(Surv(futime,fustat) ~ age + rx + ecog.ps, ovarian, x=TRUE)
fitd  <- coxph.detail(fit)
events <- fit$y[,2]==1
etime  <- fit$y[events,1]   #the event times --- may have duplicates
indx   <- match(etime, fitd$time)
sresid <- fit$x[events,] - fitd$means[indx,]
}
\keyword{survival}
% Converted by Sd2Rd version 0.3-2.

\eof
\name{coxph.object}
\alias{coxph.object}
\alias{print.coxph}
\alias{summary.coxph}
\title{
Proportional Hazards Regression Object
}
\description{
This class of objects is returned by the \code{coxph} class of functions
to represent a fitted proportional hazards model.


Objects of this class have methods for the functions \code{print},
\code{summary}, \code{residuals}, \code{predict} and \code{survfit}.
}
\section{COMPONENTS}{
The following components must be included in a legitimate \code{coxph} object.
\describe{
\item{coefficients}{
the coefficients of the linear predictor, which multiply the columns of the
model matrix.  If the model is over-determined there will be missing
values in the vector corresponding to the redundant columns in the model
matrix.
}
\item{var}{
the variance matrix of the coefficients.  Rows and columns corresponding to
any missing coefficients are set to zero.
}
\item{naive.var}{
this component will be present only if the \code{robust} option was true.  If so,
the \code{var} component will contain the robust estimate of variance, and this
component will contain the ordinary estimate.
}
\item{loglik}{
a vector of length 2 containing the log-likelihood with the initial values and
with the final values of the coefficients.
}
\item{score}{
value of the efficient score test, at the initial value of the coefficients.
}
\item{rscore}{
the robust log-rank statistic, if a robust variance was requested.
}
\item{wald.test}{
the Wald test of whether the final coefficients differ from the initial values.
}
\item{iter}{
number of iterations used.
}
\item{linear.predictors}{
the vector of linear predictors, one per subject.
}
\item{residuals}{
the martingale residuals.
}
\item{means}{
vector of column means of the X matrix.  Subsequent survival curves are
adjusted to this value.
}
\item{n}{
the number of observations used in the fit.
}
\item{weights}{
the vector of case weights, if one was used.
}
\item{method}{
the computation method used.
}
\item{na.action}{
the \code{na.action} attribute, if any, that was returned by the \code{na.action} routine.
}

The object will also contain the following, for documentation see the \code{lm}
object: \code{terms}, \code{assign}, \code{formula}, \code{call}, and, optionally, \code{x}, \code{y},
and/or \code{frame}.
}}
\seealso{
\code{\link{coxph}}, \code{\link{coxph.detail}}, \code{\link{cox.zph}}, \code{\link{survfit}}, \code{\link{residuals.coxph}}, \code{\link{survreg}}
}
\keyword{survival}
% Converted by Sd2Rd version 0.3-2.

\eof
\name{date.ddmmmyy}
\alias{date.ddmmmyy}
\title{Format a Julian date}
\description{
  Given a vector of Julian dates, this returns them in the form
  ``10Nov89'', ``28Jul54'', etc.
}
\usage{
date.ddmmmyy(sdate)
}
\arguments{
  \item{sdate}{A vector of Julian dates, e.g., as returned by
    \code{mdy.date()}.}
}
\value{
  A vector of character strings containing the formatted dates.
}
\seealso{
  \code{\link{mdy.date}},
  \code{\link{date.mdy}}
}
\examples{
date.ddmmmyy(1:10)
}
\keyword{chron}

\eof
\name{date.mdy}
\alias{date.mdy}
\title{Convert from Julian Dates to Month, Day, and Year}
\description{
  Convert a vector of Julian dates to a list of vectors with the
  corresponding values of month, day and year, and optionally weekday.
}
\usage{
date.mdy(sdate, weekday = FALSE)
}
\arguments{
  \item{sdate}{a Julian date value, as returned by \code{mdy.date()},
    number of days since 1/1/1960.}
  \item{weekday}{if \code{TRUE}, then the returned list also will
    contain the day of the week (Sunday=1, Saturday=7).}
}
\value{
  A list with components \code{month}, \code{day}, and \code{year}.
}
\examples{
day <- 7
temp <- date.mdy(mdy.date(month = 7, day = day, year = 1960))
## Check for illegal dates, such as 29 Feb in a non leap year
if (temp$day != day) {
  cat("Some illegal dates\n")
} else {
  cat("All days are legal\n")
}
}
\references{
  Press, W. H., Teukolsky, S. A., Vetterling, W. T., and Flannery,
  B. P. (1992).
  \emph{Numerical Recipes: The Art of Scientific Computing (Second
    Edition)}.
  Cambridge University Press.
}
\keyword{chron}

\eof
\name{date.mmddyy}
\alias{date.mmddyy}
\title{Format a Julian date}
\description{
  Given a vector of Julian dates, this returns them in the form
  ``10/11/89'', ``28/7/54'', etc.
}
\usage{
date.mmddyy(sdate, sep = "/")
}
\arguments{
  \item{sdate}{A vector of Julian dates, e.g., as returned by
    \code{mdy.date()}.}
  \item{sep}{Character string used to separate the month, day, and
    year portions of the returned string.}
}
\value{
  A vector of character strings containing the formatted dates.
}
\seealso{
  \code{\link{date.mdy}},
  \code{\link{mdy.date}}, 
  \code{\link{date.ddmmmyy}}
}
\examples{
date.mmddyy(as.date(10))
}
\keyword{chron}

\eof
\name{date.mmddyyyy}
\alias{date.mmddyyyy}
\title{Format a Julian date}
\description{
  Given a vector of Julian dates, this returns them in the form
  ``10/11/1989'', ``28/7/1854'', etc.
}
\usage{
date.mmddyyyy(sdate, sep = "/")
}
\arguments{
  \item{sdate}{A vector of Julian dates, e.g., as returned by
    \code{mdy.date()}.}
  \item{sep}{Character string used to separate the month, day, and
    year portions of the returned string.}
}
\value{
  A vector of character strings containing the formatted dates.
}
\seealso{
  \code{\link{date.mdy}},
  \code{\link{mdy.date}}, 
  \code{\link{date.ddmmmyy}}
}

\examples{
date.mmddyyyy(as.date(1:10))
}
\keyword{chron}

\eof
\name{date.object}
\alias{is.date}
\alias{Math.date}
\alias{Ops.date}
\alias{Summary.date}
\alias{[.date}
\alias{[[.date}
\alias{as.character.date}
\alias{as.data.frame.date}
\alias{as.vector.date}
\alias{is.na.date}
\alias{plot.date}
\alias{print.date}
\alias{summary.date}
\title{Date Objects}
\description{
  Objects of class \code{"date"}.
}
\usage{
is.date(x)
}
\arguments{
  \item{x}{any R object.}
}
\details{
  Dates are stored as the number of days since 1/1/1960, and are kept
  in integer format.  (This is the same baseline value as is used by
  SAS).  The numerical methods for dates treat \code{date - date} as a
  numeric, and \code{date +- numeric} as a date.

  \code{is.date} returns \code{TRUE} if \code{x} has class
  \code{"date"}, and \code{FALSE} otherwise.  Its behavior is unaffected
  by any attributes of \code{x}; for example, \code{x} could be a date
  array (in contrast to the behavior of \code{is.vector}).

  \code{as.date} returns \code{x} if \code{x} is a simple object of
  class \code{"date"}, and otherwise a date vector of the same length as
  \code{x} and with data resulting from coercing the elements of
  \code{x} to class \code{"date"}.  See the manual page for
  \code{as.date()} for details.

  Logical operations as well as the numeric functions \code{exp()},
  \code{log()}, and so on are invalid.

  Other methods exist for missing value, \code{as.character()},
  printing, and summarizing. 
}
\seealso{
  \code{\link{date.mdy}},
  \code{\link{mdy.date}},
  \code{\link{date.ddmmmyy}}, 
  \code{\link{as.date}}.
}
\keyword{chron}

\eof
\name{frailty}
\alias{frailty}
\alias{frailty.gamma}
\alias{frailty.gaussian}
\alias{frailty.t}
\alias{frailty.brent}
\alias{frailty.controlaic}
\alias{frailty.controldf}
\alias{frailty.controlgam}
\alias{frailty.controlgauss}
\alias{frailty.gammacon}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{(Approximate) Frailty models}
\usage{
frailty(x, distribution="gamma", ...)
frailty.gamma(x, sparse = (nclass > 5), theta, df, eps = 1e-05, method = c("em","aic", "df", "fixed"), ...) 
frailty.gaussian(x, sparse = (nclass > 5), theta, df, method = c("reml","aic", "df", "fixed"), ...)
frailty.t(x, sparse = (nclass > 5), theta, df, eps = 1e-05, tdf = 5,method = c("aic", "df", "fixed"), ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
 \item{x}{ group indicator}
 \item{distribution}{ frailty distribution }
 \item{\dots}{Arguments for specific distribution, including (but not
   limited to) }
 \item{sparse}{Use sparse Newton-Raphson algorithm}
 \item{df}{Approximate degrees of freedom}
 \item{theta}{Penalty}
 \item{eps}{Accuracy of \code{df}}
 \item{method}{maximisation algorithm}
 \item{tdf}{df of t-distribution}
}

\description{ 
When included in a \link{coxph} or \link{survreg}, fits
by penalised likelihood a random effects (frailty) model. \code{frailty} is generic, with methods for t, Gaussian and Gamma distributions.
}

\details{
The penalised likelihood method is equivalent to maximum (partial)
likelihood for the gamma frailty but not for the others.

The sparse algorithm uses the diagonal of the information matrix for
the random effects, which saves a lot of space. 

The frailty distributions are really the log-t and lognormal: t and
Gaussian are random effects on the scale of the linear predictor.
}
\value{
  An object of class \code{coxph.penalty} containing a factor with attributes specifying the control functions.
}

\seealso{\code{\link{coxph}},\code{\link{survreg}},\code{\link{ridge}},\code{\link{pspline}}  }
\references{Therneau TM, Grambsch PM, Pankratz VS (2003) "Penalized
  survival models and frailty" Journal of Computational and Graphical
  Statistics 12, 1: 156-175}
\examples{
data(kidney)
kfit <- coxph(Surv(time, status)~ age + sex + disease + frailty(id), kidney)
kfit0 <- coxph(Surv(time, status)~ age + sex + disease, kidney)
kfitm1 <- coxph(Surv(time,status) ~ age + sex + disease + 
		frailty(id, dist='gauss'), kidney)
coxph(Surv(time, status) ~ age + sex + frailty(id, dist='gauss', method='aic',caic=TRUE), kidney)
# uncorrected aic
coxph(Surv(time, status) ~ age + sex + frailty(id, method='aic', caic=FALSE), kidney)

data(rats)
rfit2a <- survreg(Surv(time, status) ~ rx +
		  frailty.gaussian(litter, df=13, sparse=FALSE), rats )
rfit2b <- survreg(Surv(time, status) ~ rx +
		  frailty.gaussian(litter, df=13, sparse=TRUE), rats )
rfit2a
rfit2b
}
\keyword{survival}%-- one or more ...

\eof
\name{heart}
\alias{jasa1}
\alias{jasa}
\alias{heart}
\title{Stanford Heart Transplant data}
\usage{data(heart)
data(jasa)
data(jasa1)}
\synopsis{data(heart)}
\description{Survival of patients on the waiting list for the Stanford
  heart transplant program.}
\format{
    jasa: original data
  \tabular{ll}{
   birth.dt:\tab birth date \cr
   accept.dt:\tab acceptance into program \cr
   tx.date:\tab transplant date \cr
   fu.date:\tab end of followup \cr
   fustat:\tab dead or alive \cr
   surgery:\tab prior bypass surgery\cr
   age: \tab age (in days)\cr
   futime:\tab followup time\cr
   wait.time:\tab time before transplant\cr
   transplant:\tab transplant indicator\cr
   mismatch:\tab mismatch score\cr
   hla.a2:\tab particular type of mismatch\cr
   mscore:\tab another mismatch score\cr
   reject:\tab rejection occurred\cr
   }
   jasa1, heart: processed data
  \tabular{ll}{
    start, stop, event: \tab Entry and exit time and status for this interval of time\cr
    age:\tab age-48 years\cr
    year:\tab year of acceptance (in years after 1 Nov 1967)\cr
    surgery:\tab prior bypass surgery 1=yes\cr
    transplant: \tab received transplant 1=yes\cr
    id:\tab patient id\cr
     }
   }
   \seealso{\code{\link{stanford2}}}
\source{Crowley and Hu, JASA}
\keyword{datasets}
\keyword{survival}

\eof
\name{is.ratetable}
\alias{is.ratetable}
\alias{Math.ratetable}
\alias{Ops.ratetable}
\title{
Verify that an Object is of Class `ratetable'
}
\description{
The function verifies not only the \code{class} attribute, but the
structure of the object.
}
\usage{
is.ratetable(x, verbose=FALSE)
}
\arguments{
\item{x}{
the object to be verified.
}
\item{verbose}{
if \code{TRUE} and the object is not a ratetable, then return a character string
describing the way(s) in which \code{x} fails to be a proper ratetable object.
}}
\value{
returns \code{TRUE} if \code{x} is a ratetable, and \code{FALSE} or a description if it is not.
}
\details{
Rate tables are used by the \code{pyears} and \code{survexp} functions, and normally
contain death rates for some population, categorized by age, sex, or other
variables.  They have a fairly rigid structure, and the \code{verbose} option
can help in creating a new rate table.
}
\seealso{
\code{\link{pyears}}, \code{\link{survexp}}
}
\examples{\dontrun{
library(ratetables)
is.ratetable(survexp.us)  ##Yes
data(cancer)
is.ratetable(cancer)  ##No
}}
\keyword{survival}
% Converted by Sd2Rd version 0.3-2.

\eof
\name{kidney}
\alias{kidney}
\title{Kidney data from survival5  }
\format{
\tabular{ll}{
patient:\tab id\cr
time:\tab time\cr
status:\tab event status\cr
age:\tab in years\cr
sex:\tab 1=male, 2=female\cr
disease:\tab  disease type (0=GN, 1=AN, 2=PKD, 3=Other)\cr
frail:\tab frailty estimate from original paper\cr
}}
\description{
Data on the recurrence times to infection, at the point of insertion of
  the catheter, for kidney patients using portable dialysis equipment.
  Catheters may be removed for reasons other than infection, in which case
  the observation is censored.  Each patient has exactly 2 observations.
}
\section{Note}{
  The original analysis had incorrect handling of ties and so is not
  exactly reproduced by survival.
}
\examples{
data(kidney)
kfit <- coxph(Surv(time, status)~ age + sex + disease + frailty(id), kidney)
kfit0 <- coxph(Surv(time, status)~ age + sex + disease, kidney)
kfitm1 <- coxph(Surv(time,status) ~ age + sex + disease + 
		frailty(id, dist='gauss'), kidney)

}
\source{McGilchrist and Aisbett, Biometrics 47, 461-66, 1991}
\keyword{survival}

\eof
\name{lines.survfit}
\alias{lines.survfit}
\alias{points.survfit}
\title{
Add Lines or Points to a Survival Plot
}
\description{
Often used to add the expected survival curve(s) to a Kaplan-Meier plot
generated with \code{plot.survfit}.
}
\usage{
\method{lines}{survfit}(x, type="s", mark=3, col=1, lty=1,
lwd=1, mark.time=TRUE , xscale=1,  firstx=0, firsty=1, xmax, fun, conf.int=FALSE,  ...)
\method{points}{survfit}(x, ...)
}
\arguments{
\item{x}{
a survival object, generated from the \code{survfit} or \code{survexp} functions.
}
\item{type}{
the line type, as described in \code{lines}.  The default is a step function
for \code{survfit} objects, and a connected line for \code{survexp} objects.
}
\item{mark}{
vectors giving the mark symbol, color, line type and line width for the
added curves.
}
\item{mark.time}{
controls the labeling of the curves.  
If \code{FALSE}, no labeling is done.  
If \code{TRUE}, then curves are marked at each censoring time.  
If \code{mark.time} is a numeric vector, then curves are marked at 
the specified time points.
}
\item{xscale}{
a number used to divide the x values.  If time was originally in days, a
value of 365.24 would give a plotted scale in years.
}
\item{firstx,firsty}{
the starting point for the survival curves.  If either of these is set to
\code{NA} or <blank> the plot will start at the first time point of the curve.
}
\item{col,lty,lwd,...}{passed to \code{\link{lines}}}
\item{xmax}{
the maximum horizontal plot coordinate.    
This shortens the curve before plotting it, so unlike using the
\code{xlim} graphical parameter, warning messages about out of bounds points are
not generated.
}
\item{fun}{
an arbitrary function defining a transformation of the survival curve.
For example \code{fun=log} is an alternative way to draw a log-survival curve
(but with the axis labeled with log(S) values).
Four often used transformations can be specified with a character
argument instead: \code{"log"} is the same as using the \code{log=T} option,
\code{"event"} plots cumulative events (f(y) =1-y),
\code{"cumhaz"} plots the cumulative hazard function (f(y) = -log(y))
and \code{"cloglog"} creates a complementary log-log survival plot 
(f(y) = log(-log(y)) along with log scale for the x-axis).}
\item{conf.int}{
if TRUE, confidence bands for the curves are also plotted.
If set to \code{"only"}, then only the CI bands are plotted, and the curve
itself is left off.  
This can be useful for fine control over the colors or line types of a plot.
}}
\value{
a list with components \code{x} and \code{y}, containing the coordinates of the
last point on each of the curves (but not of the confidence limits).
This may be useful for labeling.
}
\section{Side Effects}{
one or more curves are added to the current plot.
}
\seealso{
\code{\link{lines}}, \code{\link{par}}, \code{\link{plot.survfit}}, \code{\link{survfit}}, \code{\link{survexp}}.}
\examples{
data(pbc)
fit <- survfit(Surv(time, status) ~ sex, pbc,subset=1:312)
plot(fit, mark.time=FALSE, xscale=365.24,
	xlab='Years', ylab='Survival')
lines(fit[1], lwd=2, xscale=365.24)    #darken the first curve and add marks


# add expected survival curves for the two groups,
#   based on the US expected
tdata <- data.frame(age=pbc$age*365.24, sex=pbc$sex +1,
		    year= rep(mdy.date(1,1,1976), nrow(pbc)))
tdata<-tdata[1:312,] ## only the randomised people, with no missing data
data(ratetables)
efit <- survexp(~ sex+ratetable(sex=sex,age=age,year=year), data=tdata, ratetable=survexp.us, times=(0:24)*182)
temp <- lines(efit, lty=2, xscale=365.24, lwd=2:1)
text(temp, c("Male", "Female"), adj= -.1) #labels just past the ends
title(main="Primary Biliary Cirrhosis, Observed and Expected")
}
\keyword{survival}

\eof
\name{lung}
\alias{cancer}
\alias{lung}
\title{Mayo Clinic Lung Cancer Data}
\usage{data(lung)
data(cancer)}
\format{
  \tabular{ll}{
    inst:\tab Institution code\cr
    time:\tab Survival time in days\cr
    status:\tab censoring status 1=censored, 2=dead\cr
    age:\tab Age in years\cr
    sex:\tab  Male=1 Female=2\cr
    ph.ecog:\tab ECOG performance score (0=good 5=dead)\cr
    ph.karno:\tab Karnofsky performance score (bad=0-good=100) rated by physician\cr
    pat.karno:\tab Karnofsky performance score  rated by patient\cr
    meal.cal:\tab Calories consumed at meals\cr
    wt.loss:\tab Weight loss in last six months\cr
     }
 }
 \description{Survival in patients with lung cancer at Mayo
     Clinic. Performance scores rate how well the patient can perform
     usual daily activities.}
\source{Terry Therneau
}
\keyword{datasets}

\eof
\name{mdy.date}
\alias{mdy.date}
\title{Convert to Julian Dates}
\description{
  Given a month, day, and year, returns the number of days since
  January 1, 1960.
}
\usage{
mdy.date(month, day, year, nineteen = TRUE, fillday = FALSE,
         fillmonth = FALSE)
}
\arguments{
  \item{month}{vector of months.}
  \item{day}{vector of days.}
  \item{year}{vector of years.}
  \item{nineteen}{if \code{TRUE}, year values between 0 and 99 are
    assumed to be in the 20th century A.D.; otherwise, if \code{FALSE},
    they are assumed to be in the 1st century A.D.}
  \item{fillday}{if \code{TRUE}, then missing days are replaced with
    15.}
  \item{fillmonth}{if \code{TRUE}, then a missing month causes the
    month and day to be set to 7/1.}
}
\value{
  a vector of Julian dates.
}
\details{
  The date functions are particularly useful in computing time spans,
  such as number of days on test, and similar functions can be found in
  other statistical packages.  The baseline date of Jan 1, 1960 is, of
  course, completely arbitrary (it is the same one used by SAS).

  The \code{fillday} and \code{fillmonth} options are perhaps useful
  only to the author and a very few others: we sometimes deal with
  patients whose birth date was in the 1800's, and only the month or
  even only the year is known.  When the interval is greater than 80
  years, a filler seems defensible.
}
\references{
  Press, W. H., Teukolsky, S. A., Vetterling, W. T., and Flannery,
  B. P. (1992).
  \emph{Numerical Recipes: The Art of Scientific Computing (Second
    Edition)}.
  Cambridge University Press.

}
\seealso{
  \code{\link{date.mmddyy}}, 
  \code{\link{date.ddmmmyy}},
  \code{\link{date.mmddyyyy}}
}
\examples{
mdy.date(3, 10, 53)
xzt <-1:10
xzy <- as.date(xzt)
test <- data.frame(x = xzt, date = xzy)
summary(test)
}
\keyword{chron}

\eof
\name{ovarian}
\alias{ovarian}
\title{Ovarian cancer survival data}
\usage{data(ovarian)}
\description{Survival in a randomised trial comparing two treatments for
    ovarian cancer (? from an Eastern Cooperative Oncology Group study)}
\format{
    \tabular{ll}{
	futime:\tab survival or censoring time\cr
	fustat:\tab censoring status\cr
	age: \tab in years\cr
	resid.ds:\tab residual disease present (1=no,2=yes)\cr
	rx:\tab treatment group\cr
	ecog.ps:\tab ECOG performance status (1 is better, see reference)\cr
     }
 }
\source{Terry Therneau}
\references{for ECOG performance status: \url{http://ecog.dfci.harvard.edu/~ecogdba/general/perf_stat.html}}
\keyword{datasets}
\keyword{survival}

\eof
\name{pbc}
\alias{pbc}
\title{Mayo Clinic Primary Biliary Cirrhosis Data}
\usage{data(pbc)}
\description{Followup of 312 randomised and 108 unrandomised patients with primary biliary cirrhosis, a rare autoimmune liver disease, at Mayo Clinic. 
}
\format{
    \tabular{ll}{
	age:\tab in years\cr
	alb:\tab serum albumin\cr
	alkphos:\tab alkaline phosphotase\cr
	ascites:\tab presence of ascites\cr
 	bili:\tab serum bilirunbin\cr
	chol:\tab serum cholesterol\cr
	edema:\tab presence of edema\cr
	edtrt:\tab 0 no edema, 0.5 untreated or successfully treated\cr
\tab 1 unsuccessfully treated edema\cr
	hepmeg:\tab enlarged liver\cr
	time: \tab survival time\cr
	platelet:\tab platelet count\cr
	protime:\tab standardised blood clotting time\cr
	sex:\tab 1=male\cr
	sgot:\tab liver enzyme (now called AST)\cr
	spiders:\tab blood vessel malformations in the skin\cr
	stage:\tab histologic stage of disease (needs biopsy)\cr
	status:\tab censoring status\cr
	trt:\tab 1/2/-9 for control, treatment, not randomised\cr
	trig:\tab triglycerides\cr
	copper:\tab urine copper\cr
     }
 }
\source{Fleming TR, Harrington DP. "Counting Processes and Survival Analysis" Wiley:New York}
\keyword{datasets}

\eof
\name{plot.cox.zph}
\alias{plot.cox.zph}
\title{
Graphical Test of Proportional Hazards
}
\description{
Displays a graph of the scaled Schoenfeld residuals, along with a smooth curve.
}
\usage{
plot.cox.zph(x, resid=TRUE, se=TRUE, df=4, nsmo=40, var, \dots)
}
\arguments{
\item{x}{
result of the \code{cox.zph} function.
}
\item{resid}{
a logical value, if \code{TRUE} the residuals are included on the plot, as well as the smooth fit.
}
\item{se}{
a logical value, if \code{TRUE}, confidence bands at two standard errors
will be added.
}
\item{df}{
the degrees of freedom for the fitted natural spline, \code{df=2} leads
to a linear fit.
}
\item{nsmo}{
number of points used to plot the fitted spline.
}
\item{var}{
the set of variables for which plots are desired.  By default, plots are
produced in turn for each variable of a model.  Selection of a single variable
allows other features to be added to the plot, e.g., a horizontal line at
zero or a main title.


This has been superseded by a subscripting method; see the example below.
}
\item{...}{
additional arguments passed to the \code{plot} function.
}}
\section{Side Effects}{
a plot is produced on the current graphics device.
}
\seealso{
\code{\link{cox.zph}}, \code{\link{coxph}}}
\examples{
data(veteran)
vfit <- coxph(Surv(time,status) ~ trt + factor(celltype) +
              karno + age, data=veteran, x=TRUE)
temp <- cox.zph(vfit)
plot(temp, var=5)      # Look at Karnofsy score, old way of doing plot
plot(temp[5])     # New way with subscripting
abline(0, 0, lty=3)
# Add the linear fit as well 
abline(lm(temp$y[,5] ~ temp$x)$coefficients, lty=4, col=3) 
title(main="VA Lung Study")
}
\keyword{survival}
% Converted by Sd2Rd version 0.3-2.

\eof
\name{plot.survfit}
\alias{plot.survfit}
\title{
Plot Method for `survfit'
}
\usage{
plot.survfit(x, conf.int=<<see below>>, mark.time=TRUE,
 mark=3, col=1, lty=1, lwd=1, cex=1, log=FALSE, xscale=1, yscale=1, 
 firstx=0, firsty=1, xmax, ymin=0, fun,
 xlab="", ylab="", xaxs="S", bty=NULL,
legend.text=NULL,legend.pos=0,legend.bty="n",main=NULL,\dots)
}
\arguments{
\item{x}{
an object of class \code{survfit}, usually returned by the \code{survfit} function.
}
\item{conf.int}{
determines whether confidence intervals will be plotted.  The default is to
do so if there is only 1 curve, i.e., no strata.
}
\item{mark.time}{
controls the labeling of the curves.  If set to \code{FALSE}, no labeling is done.
If \code{TRUE}, then curves are marked at each censoring time which is not also 
a death time.  If \code{mark.time} is a
numeric vector, then curves are marked at the specified time points.
}
\item{mark}{
vector of mark parameters, which will be used to label the curves.
The \code{lines} help file contains examples of the possible marks.
The vector is reused cyclically if it is shorter than the number of curves.
}
\item{col}{
a vector of integers specifying colors for each curve.
The default value is 1.
}
\item{lty}{
a vector of integers specifying line types for each curve.
The default value is 1.
}
\item{lwd}{
a vector of numeric values for line widths. The default value is 1.
}
\item{cex}{
a numeric value specifying the size of the marks.
Not a vector; all marks have the same size.
}
\item{log}{
a logical value, if TRUE the y axis wll be on a log scale.
Alternately, one of the standard character strings "x", "y", or "xy"
can be given to specific logarithmic horizontal and/or vertical axes.
}
\item{xscale}{
scale the x-axis values before plotting.
If time were in days, then a value of
365.25 will give labels in years instead of the original days.
}
\item{yscale}{
will be used to multiply the labels on the y axis.
A value of 100, for instance, would be used to give a percent scale.
Only the labels are
changed, not the actual plot coordinates, so that adding a curve with
"\code{lines(surv.exp(\dots{}))}", say, 
will perform as it did without the \code{yscale} argument.
}
\item{firstx,firsty}{
the starting point for the survival curves.  If either of these is set to
\code{NA} the plot will start at the first time point of the curve.
}
\item{xmax}{
the maximum horizontal plot coordinate.  This can be used to shrink the range
of a plot.  It shortens the curve before plotting it, so that unlike using the
\code{xlim} graphical parameter, warning messages about out of bounds points are
not generated.
}
\item{ymin}{
lower boundary for y values.  Survival curves are most often drawn in the
range of 0-1, even if none of the curves approach zero.
The parameter is ignored if the \code{fun} argument is present, or if it has been
set to \code{NA}.
}
\item{fun}{
an arbitrary function defining a transformation of the survival curve.
For example \code{fun=log} is an alternative way to draw a log-survival curve
(but with the axis labeled with log(S) values),
and \code{fun=sqrt} would generate a curve on square root scale.
Four often used transformations can be specified with a character
argument instead: \code{"log"} is the same as using the \code{log=T} option,
\code{"event"} plots cumulative events (f(y) = 1-y), 
\code{"cumhaz"} plots the cumulative hazard function (f(y) = -log(y)), and
\code{"cloglog"} creates a complimentary log-log survival plot (f(y) =
log(-log(y)) along with log scale for the x-axis). 
}
\item{xlab}{
label given to the x-axis.
}
\item{ylab}{
label given to the y-axis.
}
\item{xaxs}{
either \code{"S"} for a survival curve or a standard x axis style as listed in \code{par}.
Survival curves are usually displayed with the curve touching the y-axis,
but not touching the bounding box of the plot on the other 3 sides.
Type \code{"S"} accomplishes this by manipulating the plot range and then using
the \code{"i"} style internally.
}\item{bty}{see \code{\link{par}}}\item{legend.pos}{position for the legend: a vector of length 2, or
  0 to put the legend in the lower left, 1 to put it in the upper
  right. These may not work well with transformed curves.}
\item{legend.bty}{Box type, see \code{\link{legend}}}
\item{legend.text}{Text for legend, see \code{\link{legend}}}
\item{main}{Plot title}
\item{...}{other graphical parameters}
}
\value{
a list with components \code{x} and \code{y}, containing the coordinates of the last point
on each of the curves (but not the confidence limits).  
This may be useful for labeling.
}
\description{
A plot of survival curves is produced, one curve for each strata.
The \code{log=T} option does extra work to avoid log(0), and to try to create a
pleasing result.  If there are zeros, they are plotted by default at
0.8 times the smallest non-zero value on the curve(s).

If \code{legend.text} is supplied a legend is created.
}
\section{BUGS}{
Survival curve objects created from a \code{coxph} model does not include
the censoring times. Therefore, specifying \code{mark.time=T} does not work.
If you want to mark censoring times on the curve(s) resulting 
from a \code{coxph} fit, provide a vector of times as the \code{mark.time} argument 
in the call to \code{plot.survfit} or \code{lines.survfit}. 
}
\seealso{
  \code{\link{par}}, \code{\link{survfit}}, \code{\link{lines.survfit}}
\code{\link{legend}}
}.
\examples{
data(aml)
leukemia.surv <- survfit(Surv(time, status) ~ x, data = aml)
plot(leukemia.surv, lty = 2:3)
legend(100, .9, c("Maintenance", "No Maintenance"), lty = 2:3)
title("Kaplan-Meier Curves\nfor AML Maintenance Study")


lsurv2 <- survfit(Surv(time, status) ~ x, aml, type='fleming')
plot(lsurv2, lty=2:3, fun="cumhaz",
	xlab="Months", ylab="Cumulative Hazard")

plot(leukemia.surv,lty=1:2,legend.pos=0,col=c("Red","Blue"),legend.text=c("Maintenance",
"No Maintenance"))
if (interactive()){
cat("Click on the graphics device to place a legend\n")
plot(leukemia.surv,lty=2:3,legend.pos=locator(1),legend.text=c("Maintenance",
"No Maintenance"))
}
}
}
\keyword{survival}
\keyword{hplot}
% Converted by Sd2Rd version 0.3-2.

\eof
\name{predict.coxph}
\alias{predict.coxph}
\alias{predict.coxph.penal}

\title{Predictions for Cox model}
\description{
Compute fitted values and regression terms for a model fitted by \code{\link{coxph}}
}
\usage{
predict.coxph(object, newdata, type=c("lp", "risk", "expected", "terms"), se.fit=FALSE, terms=names(object$assign), collapse, safe=FALSE,...)
}

\arguments{
  \item{object}{A \code{coxph} object}
  \item{newdata}{Optional new data to predict at}
  \item{type}{Type of prediction wanted}
  \item{se.fit}{Return standard errors as well?}
  \item{terms}{If \code{type="terms"}, which terms to return.}
  \item{collapse}{identifier for which rows correspond to different individuals}
  \item{safe}{Use a more intensive `safe' prediction method}
  \item{...}{other unused arguments}
}

\value{
  A vector or matrix of fitted values. If \code{se.fit=TRUE} a list
  whose first component is the fitted values and second is the standard errors.
}

\seealso{\code{\link{predict}},\code{\link{coxph}},\code{\link{termplot}} }

\examples{
data(aml)
fit<-coxph(Surv(time,status)~x,data=aml)
predict(fit,type="lp")
predict(fit,type="risk")
predict(fit,type="expected")
predict(fit,type="terms")
predict(fit,type="lp",se.fit=TRUE)
predict(fit,type="risk",se.fit=TRUE)
predict(fit,type="expected",se.fit=TRUE)
predict(fit,type="terms",se.fit=TRUE)
}
\keyword{survival}%-- one or more ...

\eof
\name{predict.survreg}
\alias{predict.survreg}
\alias{predict.survreg.penal}
\title{
Predicted Values for a `survreg' Object
}
\description{
Predicted values for a \code{survreg} object
}
\usage{
\method{predict}{survreg}(object, newdata, 
type=c("response", "link", "lp", "linear",  "terms", "quantile", 
	"uquantile"), 
se.fit=FALSE, terms=NULL, p=c(0.1, 0.9),...)
}
\arguments{
\item{object}{
result of a model fit using the \code{survreg} function.
}
\item{newdata}{
data for prediction.  If absent, predictions are for the
subjects used in the original fit.
}
\item{type}{
the type of predicted value. 
This can be on the original scale of the data (response),
the linear predictor (\code{"linear"}, with \code{"lp"} as an allowed abbreviation),
a predicted quantile on the original scale of the data (\code{"quantile"}),
a quantile on the linear predictor scale (\code{"uquantile"}),
or the matrix of terms for the linear predictor (\code{"terms"}).
At this time \code{"link"} and linear predictor (\code{"lp"}) are identical.
}
\item{se.fit}{
if TRUE, include the standard errors of the prediction in the result.
}
\item{terms}{
subset of terms.  The default for residual type \code{"terms"} is a matrix with
one column for every term (excluding the intercept) in the model.
}
\item{p}{
vector of percentiles.  This is used only for quantile predictions.
}\item{...}{other arguments}
}
\value{
a vector or matrix of predicted values.
}
\references{
Escobar and Meeker (1992). Assessing influence in regression analysis with
censored data. \emph{Biometrics,} 48, 507-528.
}
\seealso{
\code{\link{survreg}}, \code{\link{residuals.survreg}}}
\examples{
# Draw figure 1 from Escobar and Meeker
data(stanford2)
fit <- survreg(Surv(time,status) ~ age + age^2, data=stanford2,
	dist='lognormal')
plot(stanford2$age, stanford2$time, xlab='Age', ylab='Days',
	xlim=c(0,65), ylim=c(.01, 10^6), log='y')
pred <- predict(fit, newdata=list(age=1:65), type='quantile',
	         p=c(.1, .5, .9))
matlines(1:65, pred, lty=c(2,1,2), col=1)
}
\keyword{survival}


\eof
\name{print.survfit}
\alias{print.survfit}
\title{
Print a Short Summary of a Survival Curve
}
\description{
  Print number of observations, number of events, the restricted
  mean survival and its standard error, and the median survival with confidence limits for the median.
}
\usage{
\method{print}{survfit}(x, scale=1,digits = max(options()$digits - 4,
3), print.n=getOption("survfit.print.n"), show.rmean=getOption("survfit.print.mean"),...)
}
\arguments{
\item{x}{
the result of a call to the \code{survfit} function.
}\item{print.n}{What to use for number of subjects (see below)}
\item{digits}{Number of digits to print}
\item{scale}{
a numeric value to rescale the survival time, e.g.,
if the input data to survfit were in days,
\code{scale=365} would scale the printout to years.
}\item{show.rmean}{Show the restricted mean survival?}\item{...}{other unused arguments}}
\value{
\code{x}, with the invisible flag set.
}
\section{Side Effects}{
The number of observations (see Details), the number of events, the
restricted mean survival (\code{rmean}) and its standard error, and the median survival
with its confidence interval are printed.  If there are multiple curves, there is one line of output for each.
}
\details{
The restricted mean (\code{rmean}) and its standard error \code{se(rmean)} are based on a truncated estimator.  If the
last observation(s) is not a death, then the survival curve estimate does not
go to zero and the mean survival time cannot be estimated. Instead, the
quantity reported is the mean of survival restricted to the time before
the last censoring. When the last censoring time is not random this
quantity is occasionally of interest.

Any randomness in the last censoring time is not taken into account in
computing the standard error of the restricted mean.  The restricted
mean is shown mainly for compatibility with S, and may not be shown by
default in future versions.


The median and its confidence interval are defined by drawing a horizontal
line at 0.5 on the plot of the survival curve and its confidence bands.
The intersection of the line with the lower CI band defines the lower limit
for the median's interval, and similarly for the upper band.  If any of the
intersections is not a point, then we use the smallest point of intersection,
e.g., if the survival curve were exactly equal to 0.5 over an
interval. 

The "number of observations" is not well-defined for counting process
data. Previous versions of this code used the number at risk at the
first time point. This is misleading if many individuals enter late or
change strata. The original S code for the current version uses the
number of records, which is misleading when the counting process data
actually represent a fixed cohort with time-dependent covariates.

Four possibilities are provided, controlled by \code{print.n} or by
\code{options(survfit.print.n)}: \code{"none"} prints \code{NA},
\code{"records"} prints the number of records, \code{"start"} prints the
number at the first time point and \code{"max"} prints the maximum
number at risk. The initial default is \code{"start"}.

}

\seealso{
\code{\link{summary.survfit}}, \code{\link{survfit.object}}, \code{\link{survfit}}
}
\examples{
##effect of print.n and show.rmean
data(heart)
a<-coxph(Surv(start,stop,event)~age+strata(transplant),data=heart)
b<-survfit(a)
print(b,print.n="none")
print(b,print.n="records")
print(b,print.n="start")
print(b,print.n="max")
print(b,show.rmean=FALSE)
}

\keyword{survival}

\eof
\name{pspline}
\alias{pspline}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Penalised smoothing splines}
\usage{
pspline(x, df=4, theta, nterm=2.5 * df, degree=3, eps=0.1, method, ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
 \item{x}{predictor }
 \item{df}{ approximate degrees of freedom. \code{df=0} means use AIC }
 \item{theta}{roughness penalty }
 \item{nterm}{ number of splines in the basis }
 \item{degree}{ degree of splines }
 \item{eps}{accuracy for \code{df} }
 \item{method}{Method for automatic choice of \code{theta}}
 \item{\dots}{I don't know what this does }
}
\description{
 Specifies a penalised spline basis for the predictor.  This is done by fitting a comparatively small set of splines and penalising the integrated second derivative. Results are similar to smoothing splines with a knot at each data point but computationally simpler.
}

\value{
  Object of class \code{coxph.penalty} containing the spline basis with 
attributes specifying control functions.
}

\seealso{\code{\link{coxph}},\code{\link{survreg}},\code{\link{ridge}},\code{\link{frailty}}   }

\examples{
data(cancer)
lfit6 <- survreg(Surv(time, status)~pspline(age, df=2), cancer)
plot(cancer$age, predict(lfit6), xlab='Age', ylab="Spline prediction")
title("Cancer Data")
fit0 <- coxph(Surv(time, status) ~ ph.ecog + age, cancer)
fit1 <- coxph(Surv(time, status) ~ ph.ecog + pspline(age,3), cancer)
fit3 <- coxph(Surv(time, status) ~ ph.ecog + pspline(age,8), cancer)
fit0
fit1
fit3
}
\keyword{ survival}%-- one or more ...

\eof
\name{pyears}
\alias{pyears}
\title{
Person Years
}
\description{
This function computes the person-years of follow-up time contributed by a
cohort of subjects, stratified into subgroups.
It also computes the number of subjects who contribute to each cell of the
output table, and optionally the number of events and/or expected number of
events in each cell.
}
\usage{
pyears(formula, data, weights, subset, na.action, ratetable=survexp.us,
scale=365.25, expect=c('event', 'pyears'), model=FALSE, x=FALSE, y=FALSE)
}
\arguments{
\item{formula}{
a formula object.  The response variable will be a vector of follow-up times
for each subject, or a \code{Surv} object containing the follow-up time and an
event indicator.
The predictors consist of optional grouping variables
separated by + operators (exactly as in \code{survfit}), time-dependent grouping
variables such as age (specified with \code{tcut}), and optionally a
\code{ratetable()} term.  This latter matches each subject to his/her expected
cohort.
}
\item{data}{
a data frame in which to interpret the variables named in
the \code{formula}, or in the \code{subset} and the \code{weights} argument.
}
\item{weights}{
case weights.
}
\item{subset}{
expression saying that only a subset of the rows of the data
should be used in the fit.
}
\item{na.action}{
a missing-data filter function, applied to the model.frame, after any
\code{subset} argument has been used.  Default is \code{options()$na.action}.
}
\item{ratetable}{
a table of event rates, such as \code{survexp.uswhite}.
}
\item{scale}{
a scaling for the results.  As most rate tables are in units/day, the
default value of 365.25 causes the output to be reported in years.
}
\item{expect}{
should the output table include the expected number of events, or the
expected number of person-years of observation.  This is only valid with
a rate table.
}
\item{model,x,y}{
If any of these is true, then the
model frame, the model matrix, and/or the vector of response times will be
returned as components of the final result.
}}
\value{
a list with components

\item{pyears}{
an array containing the person-years of exposure. (Or other units, depending
on the rate table and the scale).
}
\item{n}{
an array containing the number of subjects who contribute time to each cell
of the \code{pyears} array.
}
\item{event}{
an array containing the observed number of events.  This will be present only
if the response variable is a \code{Surv} object.
}
\item{expected}{
an array containing the expected number of events (or person years).
This will be present only
if there was a ratetable term.
}
\item{offtable}{
the number of person-years of exposure in the cohort that was not part of
any cell in the \code{pyears} array.  This is often useful as an error check; if
there is a mismatch of units between two variables, nearly all the person
years may be off table.
}
\item{summary}{
a summary of the rate-table matching.  This is also useful as an error
check.
}
\item{call}{
an image of the call to the function.
}
\item{na.action}{
the \code{na.action} attribute contributed by an \code{na.action} routine, if any.
}}
\details{
Because \code{pyears} may have several time variables, it is necessary that all
of them be in the same units.  For instance, in the call
 py <- pyears(futime ~ rx + ratetable(age=age, sex=sex, year=entry.dt))
with a \code{ratetable} whose natural unit is days, it is important that \code{futime},
\code{age} and \code{entry.dt} all be in days.  Given the wide range of possible inputs,
it is difficult for the routine to do sanity checks of this aspect.


A special function \code{tcut} is needed to specify time-dependent cutpoints.
For instance, assume that age is in years, and that the desired final
arrays have as one of their margins the age groups 0-2, 2-10, 10-25, and 25+.
A subject who enters the study at age 4 and remains under observation for
10 years will contribute follow-up time to both the 2-10 and 10-25
subsets.  If \code{cut(age, c(0,2,10,25,100))} were used in the formula, the
subject would be classified according to his starting age only.
The \code{tcut} function has the same arguments as \code{cut},
but produces a different output object which allows the \code{pyears} function
to correctly track the subject.


The results of \code{pyears} are normally used as input to further calculations.
The example below is from a study of hip fracture rates from 1930 - 1990
in Rochester, Minnesota.  Survival post hip fracture has increased over
that time, but so has the survival of elderly subjects in the population at
large.  A model of relative survival helps to clarify what has happened:
Poisson regression is used, but replacing exposure time with expected
exposure (for an age and sex matched control).
Death rates change with age, of course, so the result is carved into
1 year increments of time.  Males and females were done separately.
}
\seealso{
\code{\link{ratetable}}, \code{\link{survexp}}, \code{\link{Surv}}}
\examples{
data(ratetables)
# 
# Simple case: a single male subject, born 6/6/36 and entered on study 6/6/55.
#

temp1 <- mdy.date(6,6,36)
temp2 <- mdy.date(6,6,55)
# Now compare the results from person-years
#
temp.age <- tcut(temp2-temp1, floor(c(-1, (18:31 * 365.24))),
        labels=c('0-18', paste(18:30, 19:31, sep='-')))
temp.yr  <- tcut(temp2, mdy.date(1,1,1954:1965), labels=1954:1964)
temp.time <- 3700   #total days of fu
py1 <- pyears(temp.time ~ temp.age + temp.yr, scale=1) #output in days
data(ratetables)
survexp.uswhite<-survexp.usr[,,"white",]
py2 <- pyears(temp.time ~ temp.age + temp.yr
		+ ratetable(age=temp2-temp1, year=temp2, sex=1),
	     scale=1, ratetable=survexp.uswhite ) #output in days
}
\keyword{survival}
% Converted by Sd2Rd version 0.3-2.

\eof
\name{ratetable}
\alias{ratetable}
\alias{[.ratetable}
\alias{[.ratetable2}
\alias{print.ratetable}
\alias{is.na.ratetable}
\alias{summary.ratetable}
\title{Ratetable reference in formula}
\description{
This function matches variable names in data to those in a ratetable for
\code{\link{survexp}}
}
\usage{
ratetable(...)
}

\arguments{
  \item{\dots}{tags matching dimensions of the ratetable and variables
    in the data frame (see example)}
}

\value{
  A data frame
}

\seealso{\code{\link{survexp}},\code{\link{survexp.us}},\code{\link{is.ratetable}}}

\examples{
data(pbc)
fit <- survfit(Surv(time, status) ~ sex, pbc,subset=1:312)
if (require(date)){
tdata <- data.frame(agedays=pbc$age*365.24, sex=pbc$sex +1,
		    year= rep(mdy.date(1,1,1976), nrow(pbc)))
tdata<-tdata[1:312,] ## only the randomised people, with no missing data
data(ratetables)
efit <- survexp(~ sex+ratetable(sex=sex,age=agedays,year=year), data=tdata, ratetable=survexp.us, times=(0:24)*182)
}

}
\keyword{survival}%-- one or more ...

\eof
\name{rats}
\alias{rats}
\title{Rat data from survival5}
\usage{
data(rats)
}
\format{
\tabular{ll}{
  rat:\tab id\cr
  rx:\tab treatment,(1=drug, 0=control) \cr
  observation:\tab within rat\cr
  start:\tab entry time\cr
  stop:\tab exit time\cr
  status:\tab event status\cr
}
}
\source{Gail, Sautner and Brown, Biometrics 36, 255-66, 1980}

\description{48 rats were injected with a carcinogen, and then
  randomized to either drug or placebo.  The number of tumors ranges
  from 0 to 13; all rats were  censored at 6 months after randomization.
}
\keyword{survival}
\keyword{datasets}

\eof
\name{residuals.coxph}
\alias{residuals.coxph.penal}
\alias{residuals.coxph.null}
\alias{residuals.coxph}
\title{
Calculate Residuals for a `coxph' Fit
}
\description{
Calculates martingale, deviance, score or Schoenfeld residuals for a
Cox proportional hazards model.
}
\usage{
\method{residuals}{coxph}(object,
       type=c("martingale", "deviance", "score", "schoenfeld",
	      "dfbeta", "dfbetas", "scaledsch","partial"),
       collapse=FALSE, weighted=FALSE, ...)
\method{residuals}{coxph.null}(object,
       type=c("martingale", "deviance","score","schoenfeld"),
       collapse=FALSE, weighted=FALSE, ...)
}
\arguments{
\item{object}{
an object inheriting from class \code{coxph}, representing a fitted Cox
regression model.
Typically this is the output from the \code{coxph} function.
}
\item{type}{
character string indicating the type of residual desired.
Possible values are \code{"martingale"}, \code{"deviance"}, \code{"score"}, \code{"schoenfeld"},
"dfbeta"', \code{"dfbetas"}, and \code{"scaledsch"}.
Only enough of the string to determine a unique match is required.
}
\item{collapse}{
vector indicating which rows to collapse (sum) over.
In time-dependent models more than one row data can pertain
to a single individual.
If there were 4 individuals represented by 3, 1, 2 and 4 rows of data
respectively, then \code{collapse=c(1,1,1, 2, 3,3, 4,4,4,4)} could be used to
obtain per subject rather than per observation residuals.
}
\item{weighted}{
if \code{TRUE} and the model was fit with case weights, then the weighted
residuals are returned.
}\item{...}{other unused arguments}}
\value{
For martingale and deviance residuals, the returned object is a vector
with one element for each subject (without \code{collapse}).
For score residuals it is a matrix
with one row per subject and one column per variable.
The row order will match the input data for the original fit.
For Schoenfeld residuals, the returned object is a matrix with one row
for each event and one column per variable.  The rows are ordered by time
within strata, and an attribute \code{strata} is attached that contains the
number of observations in each strata.
The scaled Schoenfeld residuals are used in the \code{cox.zph} function.


The score residuals are each individual's contribution to the score vector.
Two transformations of
this are often more useful: \code{dfbeta} is the approximate change in the
coefficient vector if that observation were dropped,
and \code{dfbetas} is the approximate change in the coefficients, scaled by
the standard error for the coefficients.
}
\section{NOTE}{
For deviance residuals, the status variable may need to be reconstructed.
For score and Schoenfeld residuals, the X matrix will need to be reconstructed.
}
\references{
T. Therneau, P. Grambsch, and T. Fleming. "Martingale based residuals
for survival models", \emph{Biometrika}, March 1990.
}
\seealso{
\code{\link{coxph}}}
\examples{
 data(heart)
 fit <- coxph(Surv(start, stop, event) ~ (age + surgery)* transplant,
               data=heart)
 mresid <- resid(fit, collapse=heart$id)
}
\keyword{survival}
% Converted by Sd2Rd version 0.3-2.

\eof
\name{residuals.survreg}
\alias{residuals.survreg}
\alias{residuals.survreg.penal}
\title{Compute Residuals for `survreg' Objects}
\description{
This is a method for the function \code{\link{residuals}} for objects
inheriting from class \code{survreg}.  
}
\usage{
residuals.survreg(object, type=c("response", "deviance","dfbeta","dfbetas",
"working","ldcase","ldresp","ldshape", "matrix"), rsigma=TRUE,
collapse=FALSE, weighted=FALSE, ...)
}
\arguments{
\item{object}{
an object inheriting from class \code{survreg}.
}
\item{type}{
type of residuals, with choices of \code{"response"}, \code{"deviance"},
\code{"dfbeta"}, \code{"dfbetas"}, \code{"working"}, \code{"ldcase"}, \code{"lsresp"},
\code{"ldshape"}, and \code{"matrix"}.  See the LaTeX documentation
(\code{survival/doc/survival.ps.gz}) for more
detail.
}
\item{rsigma}{
include the scale parameters in the variance matrix, when doing computations.
(I can think of no good reason not to).
}
\item{collapse}{
optional vector of subject groups.  If given, this must be of the same
length as the residuals, and causes the result to be per group residuals.
}
\item{weighted}{
give weighted residuals?  Normally residuals are unweighted.
}\item{...}{other unused arguments}}
\value{
A vector or matrix of residuals is returned.
Response residuals are on the scale of the original data,
working residuals are on the scale of the linear predictor,
and deviance residuals are on log-likelihood scale.
The dfbeta residuals are a matrix, where the ith row gives the
approximate change in the coefficients due to the addition of subject i.
The dfbetas matrix contains the dfbeta residuals, with each column
scaled by the standard deviation of that coefficient.


The matrix type produces a matrix based on derivatives of the log-likelihood
function.  Let \eqn{L} be the log-likelihood, \eqn{p} be the linear predictor \eqn{X\beta}{X \%*\% coef},
and \eqn{s} be \eqn{\log(\sigma)}.  Then the 6 columns of the matrix are
\eqn{L}, \eqn{dL/dp},\eqn{\partial^2L/\partial p^2}{ddL/(dp dp)},
\eqn{dL/ds}, \eqn{\partial^2L/\partial s^2}{ddL/(ds ds)}  and
\eqn{\partial^2L/\partial p\partial s}{ddL/(dp ds)}.  Diagnostics based on these quantities
are discussed in an article by Escobar and Meeker.
The main ones are the likelihood displacement residuals for perturbation
of a case weight (\code{ldcase}), the response value (\code{ldresp}), and the \code{shape}.
}
\references{
Escobar, L. A. and Meeker, W. Q. (1992).
Assessing influence in regression analysis with censored data.
\emph{Biometrics}
\bold{48}, 507-528.
}
\seealso{\code{\link{predict.survreg}}}
\examples{
data(aml)
fit <- survreg(Surv(time,status) ~x, aml)
rr  <- residuals(fit, type='matrix')
}
\keyword{survival}
% Converted by Sd2Rd version 0.3-2.

\eof
\name{ridge}
\alias{ridge}
\title{ Ridge regression}
\usage{
ridge(..., theta, df=nvar/2, eps=0.1, scale=TRUE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
 \item{\dots}{predictors to be ridged }
 \item{theta}{penalty is \code{theta}/2 time sum of squared coefficients }
 \item{df}{Approximate degrees of freedom }
 \item{eps}{ Accuracy required for \code{df} }
 \item{scale}{ Scale variables before applying penalty? }
}
\description{
 When used in a \link{coxph} or \link{survreg} model formula,
specifies a ridge regression term.  The likelihood is penalised by
\code{theta}/2 time the sum of squared coefficients. If \code{scale=T}
the penalty is calculated for coefficients based on rescaling the
predictors to have unit variance. If \code{df} is specified then \code{theta} is chosen based on an approximate degrees of freedom.
 } 

\value{
 An object of class \code{coxph.penalty} containing the data and
control functions.  } 

\references{
Gray (1992) "Flexible methods of analysing survival data using splines, with applications to breast cancer prognosis" JASA 87:942--951
 }

\seealso{ \code{\link{coxph}},\code{\link{survreg}},\code{\link{pspline}},\code{\link{frailty}} }

\examples{
data(ovarian)
fit1 <- coxph(Surv(futime, fustat) ~ rx + ridge(age, ecog.ps, theta=1),
	      ovarian)
fit1
data(cancer)
lfit0 <- survreg(Surv(time, status) ~1, cancer)
lfit1 <- survreg(Surv(time, status) ~ age + ridge(ph.ecog, theta=5), cancer)
lfit2 <- survreg(Surv(time, status) ~ sex + ridge(age, ph.ecog, theta=1), cancer)
lfit3 <- survreg(Surv(time, status) ~ sex + age + ph.ecog, cancer)

lfit0
lfit1
lfit2
lfit3
}
\keyword{survival }%-- one or more ...

\eof
\name{stanford2}
\alias{stanford2}
\title{More Stanford Heart Transplant data}
\usage{data(stanford2)}

\format{
    \tabular{ll}{
        id:  \tab ID number\cr
	time:\tab survival or censoring time\cr
	status:\tab censoring status\cr
	age: \tab in years\cr
        t5: \tab T5 mismatch score\cr
     }
 }
\description{This contains the Stanford Heart Transplant data in
a different format. The main data set is in \code{\link{heart}}}

\seealso{\code{\link{predict.survreg}},\code{\link{heart}}}
\source{Escobar & Meeker, Biometrics 1992 p519}
\keyword{datasets}
\keyword{survival}

\eof
\name{strata}
\alias{strata}
\title{
Identify Strata Variables
}
\description{
This is a special function used in the context of the Cox survival model.
It identifies stratification variables when they appear on the right hand
side of a formula.
}
\usage{
strata(\dots, na.group=FALSE, shortlabel=FALSE)
}
\arguments{
\item{...}{
any number of variables.  All must be the same length.
}
\item{na.group}{
a logical variable, if \code{TRUE}, then missing values are treated as a
distinct level of each variable.
}\item{shortlabel}{if \code{TRUE} omit variable names from resulting
  factor labels}}
\value{
a new factor, whose levels are all possible combinations of the factors
supplied as arguments.
}
\details{
The result is identical to the \code{interaction} function,
but for the labeling of the factors (\code{strata} is more verbose).
}
\seealso{
\code{\link{coxph}},\code{\link{interaction}}}
\examples{
a<-factor(rep(1:3,4))
b<-factor(rep(1:4,3))
levels(strata(a))
levels(strata(a,b,shortlabel=TRUE))
data(ovarian)
coxph(Surv(futime, fustat) ~ age + strata(rx), data=ovarian)
}
\keyword{survival}
% Converted by Sd2Rd version 0.3-2.

\eof
\name{summary.survfit}
\alias{summary.survfit}
\alias{print.summary.survfit}
\title{
Summary of a Survival Curve
}
\description{
Returns a list containing the survival curve, confidence limits for the
curve, and other information.
}
\usage{
summary.survfit(object, times, censored=FALSE, scale=1, ...)
}
\arguments{
\item{object}{
output from a call to \code{survfit}.
}
\item{times}{
vector of times;
the returned matrix will contain 1 row for each time.
This must be in increasing order and missing values are not allowed.
If \code{censored=T}, the default \code{times} vector contains all the unique times in
\code{fit},
otherwise the default \code{times} vector uses only the event (death) times.
}
\item{censored}{
logical flag: should the censoring times be included in the output?
This is ignored if the \code{times} argument is present.
}
\item{scale}{
rescale the survival time, e.g., if the input data to \code{survfit} were in
days, \code{scale=365.25} would scale the output to years.
} 
\item{...}{other unused arguments}
}
\value{
a list with the following components
}
\item{time}{
the timepoint on the curve.
}
\item{surv}{
the value of the survival curve at time t+0.
}
\item{n.risk}{
the number of subjects at risk at time t-0
(but see the comments on weights in the \code{survfit} help file).
}
\item{n.event}{
if the \code{times} argument is missing, then this column is the number of
events that occurred at time t.
Otherwise, it is the cumulative number of events that have occurred
since the last time listed until time t+0.
}
\item{std.err}{
the standard error of the survival value.
}
\item{conf.int}{
level of confidence for the confidence intervals of survival.
}
\item{lower}{
lower confidence limits for the curve.
}
\item{upper}{
upper confidence limits for the curve.
}
\item{strata}{
indicates stratification of curve estimation.  If \code{strata} is not \code{NULL},
there are multiple curves in the result and the \code{surv}, \code{time}, \code{n.risk}, etc. 
vectors will contain multiple curves, pasted end to end. 
The levels of \code{strata} (a factor) are the labels for the curves.
}
\item{call}{
the statement used to create the \code{fit} object.
}
\item{na.action}{
passed through from \code{fit}, if present.
}}
\seealso{
\code{\link{survfit}}, \code{\link{print.summary.survfit}}.}
\examples{
data(ovarian)
summary( survfit( Surv(futime, fustat),data=ovarian))
}
\keyword{survival}
% Converted by Sd2Rd version 0.3-2.

\eof
\name{survSplit}
\alias{survSplit}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Split a survival data set at specified times }
\description{
  Given a survival data set and a set of specified cut times, split
  each record into multiple subrecords at each cut time.  The new data
  set will be in `counting process' format, with a start time, stop
  time, and event status for each record. 
}
\usage{
survSplit(data, cut, end, event, start, id = NULL, zero = 0,
  episode=NULL)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{data}{data frame}
  \item{cut}{vector of timepoints to cut at}
  \item{end}{character string with name of event time variable }
  \item{event}{character string with name of censoring indicator }
  \item{start}{character string with name of start time variable (will
    be created if it does not exist) }
  \item{id}{character string with name of new id variable to create (optional)}
  \item{zero}{If \code{start} doesn't already exist, this is the time
    that the original records start. May be a vector or single value.}
  \item{episode}{character string with name of new episode variable (optional)}
}

\value{
 New, longer, data frame.
}

\seealso{\code{\link{Surv}}, \code{\link{cut}}, \code{\link{reshape}} }

\examples{
data(aml)
aml3<-survSplit(aml,cut=c(5,10,50),end="time",start="start",
      event="status",episode="i")

summary(aml)
summary(aml3)

coxph(Surv(time,status)~x,data=aml)
## the same
coxph(Surv(start,time,status)~x,data=aml3)

}
\Keyword{survival }% at least one, from doc/KEYWORDS
\keyword{utilities}% __ONLY ONE__ keyword per line

\eof
\name{survdiff}
\alias{survdiff}
\alias{print.survdiff}
\title{
Test Survival Curve Differences
}
\description{
Tests if there is a difference between two or more survival curves using
the \eqn{G^\rho}{G-rho} family of tests, or for a single curve against a known alternative.
}
\usage{
survdiff(formula, data, subset, na.action, rho=0)
}
\arguments{
\item{formula}{
a formula expression as for other survival models, of the form
\code{Surv(time, status) ~ predictors}.  For a one-sample test, the predictors
must consist of a single \code{offset(sp)} term, where \code{sp} is a vector giving the
survival probability of each subject.  For a k-sample test, each unique
combination of predictors defines a subgroup.
A \code{strata} term may be used to produce a stratified test.
To cause missing values in the predictors to be treated as a separate
group, rather than being omitted, use the \code{strata} function with its
\code{na.group=T} argument.
}
\item{data}{
an optional data frame in which to interpret the variables occurring in the
formula.
}
\item{subset}{
expression indicating which subset of the rows of data should be used in
the fit.  This can be a logical vector (which is replicated to have
length equal to the number of observations), a numeric vector indicating
which observation numbers are to be included (or excluded if negative),
or a character vector of row names to be included.  All observations are
included by default.
}
\item{na.action}{
a missing-data filter function.  This is applied to the \code{model.frame} after any
subset argument has been used.  Default is \code{options()$na.action}.
}
\item{rho}{
a scalar parameter that controls the type of test.
}}
\value{
a list with components:

\item{n}{
the number of subjects in each group.
}
\item{obs}{
the weighted observed number of events in each group.
If there are strata, this will be a matrix with one column per stratum.
}
\item{exp}{
the weighted expected number of events in each group.
If there are strata, this will be a matrix with one column per stratum.
}
\item{chisq}{
the chisquare statistic for a test of equality.
}
\item{var}{
the variance matrix of the test.
}
\item{strata}{
optionally, the number of subjects contained in each stratum.
}}
\section{METHOD}{
This function implements the G-rho family of
Harrington and Fleming (1982), with weights on each death of \eqn{S(t)^\rho}{S(t)^rho},
where \eqn{S(t)}{S} is the Kaplan-Meier estimate of survival.
With \code{rho = 0} this is the log-rank or Mantel-Haenszel test,
and with \code{rho = 1} it is equivalent to the Peto & Peto modification
of the Gehan-Wilcoxon test.


If the right hand side of the formula consists only of an offset term,
then a one sample test is done.
To cause missing values in the predictors to be treated as a separate
group, rather than being omitted, use the \code{factor} function with its
\code{exclude} argument.
}
\references{
Harrington, D. P. and Fleming, T. R. (1982).
A class of rank test procedures for censored survival data.
\emph{Biometrika}
\bold{69}, 553-566.}
\examples{
## Two-sample test
data(ovarian)
survdiff(Surv(futime, fustat) ~ rx,data=ovarian)
rm(ovarian)
## Stratified 7-sample test
data(lung)
survdiff(Surv(time, status) ~ pat.karno + strata(inst), data=lung)
rm(lung)

  data(heart)
  data(ratetables)
  ## Expected survival for heart transplant patients based on
  ## US mortality tables
  expect <- survexp(futime ~ ratetable(age=(accept.dt - birth.dt),
sex=1,year=accept.dt,race="white"), jasa, cohort=FALSE,
ratetable=survexp.usr)
  ## actual survival is much worse (no surprise)
  print(survdiff(Surv(jasa$futime, jasa$fustat) ~ offset(expect)))
  rm(jasa,jasa1,heart,survexp.az,survexp.azr,survexp.fl,survexp.flr,survexp.mn,survexp.mnwhite,survexp.us,survexp.usr,survexp.wnc)

}
\keyword{survival}
% Converted by Sd2Rd version 0.3-2. and hand edited.

\eof
\name{survexp}
\alias{survexp}
\alias{survexp.cfit}
\alias{print.survexp}
\title{
Compute Expected Survival
}
\description{
Returns either the expected survival of a cohort of subjects, or the
individual expected survival for each subject.
}
\usage{
survexp(formula, data, weights, subset, na.action, times, cohort=T,
        conditional=F, ratetable=survexp.us, scale=1, npoints,
        se.fit=<<see below>>, model=F, x=F, y=F)
}
\arguments{
\item{formula}{
formula object.  The response variable is a vector of follow-up times
and is optional.  The predictors consist of optional grouping variables
separated by the \code{+} operator (as in \code{survfit}), along with a \code{ratetable} 
term.  The \code{ratetable} term matches each subject to his/her expected cohort.
}
\item{data}{
data frame in which to interpret the variables named in
the \code{formula}, \code{subset} and \code{weights} arguments.
}
\item{weights}{
case weights.
}
\item{subset}{
expression indicating a subset of the rows of \code{data} to be used in the fit.
}
\item{na.action}{
function to filter missing data. This is applied to the model frame after 
\code{subset} has been applied.  Default is \code{options()$na.action}. A possible
value for \code{na.action} is \code{na.omit}, which deletes observations that contain
one or more missing values.
}
\item{times}{
vector of follow-up times at which the resulting survival curve is 
evaluated.  If absent, the result will be reported for each unique 
value of the vector of follow-up times supplied in \code{formula}.
}
\item{cohort}{
logical value: if \code{FALSE}, each subject is treated as a subgroup of size 1.
The default is \code{TRUE}.
}
\item{conditional}{
logical value: if \code{TRUE}, the follow-up times supplied in \code{formula}
are death times and conditional expected survival is computed.
If \code{FALSE}, the follow-up times are potential censoring times. 
If follow-up times are missing in \code{formula}, this argument is ignored.  
}
\item{ratetable}{
a table of event rates, such as \code{survexp.uswhite}, or a fitted Cox model.
}
\item{scale}{
numeric value to scale the results.  If \code{ratetable} is in units/day,
\code{scale = 365.25} causes the output to be reported in years.
}
\item{npoints}{
number of points at which to calculate intermediate results, evenly spaced 
over the range of the follow-up times.  The usual (exact) calculation is done 
at each unique follow-up time. For very large data sets specifying \code{npoints} 
can reduce the amount of memory and computation required.
For a prediction from a Cox model \code{npoints} is ignored.
}
\item{se.fit}{
compute the standard error of the predicted survival.
The default is to compute this whenever the routine can, which at this time
is only for the Ederer method and a Cox model as the rate table.
}
\item{model,x,y}{
flags to control what is returned.  If any of these is true, then the
model frame, the model matrix, and/or the vector of response times will be
returned as components of the final result, with the same names as the
flag arguments.
}}
\value{
if \code{cohort=T} an object of class \code{survexp}, otherwise a vector of per-subject
expected survival values.  The former contains the number of subjects at
risk and the expected survival for the cohort at each requested time.
}
\details{
Individual expected survival is usually used in models or testing, to
'correct' for the age and sex composition of a group of subjects.  For
instance, assume that birth date, entry date into the study, sex and
actual survival time are all known for a group of subjects.
The \code{survexp.uswhite} population tables contain expected death rates
based on calendar year, sex and age.  Then
haz <- -log(survexp(death.time ~ ratetable(sex=sex, year=entry.dt, age=(birth.dt-entry.dt)), cohort=F))
gives for each subject the total hazard experienced up to their observed
death time or censoring time.
This probability can be used as a rescaled time value in models:
glm(status ~ 1 + offset(log(haz)), family=poisson)
glm(status ~ x + offset(log(haz)), family=poisson)
In the first model, a test for intercept=0 is the one sample log-rank
test of whether the observed group of subjects has equivalent survival to
the baseline population.  The second model tests for an effect of variable
\code{x} after adjustment for age and sex.


Cohort survival is used to produce an overall survival curve.  This is then
added to the Kaplan-Meier plot of the study group for visual comparison
between these subjects and the population at large.  There are three common
methods of computing cohort survival.
In the "exact method" of Ederer the cohort is not censored; this corresponds
to having no response variable in the formula.  Hakulinen recommends censoring
the cohort at the anticipated censoring time of each patient, and Verheul
recommends censoring the cohort at the actual observation time of each
patient.
The last of these is the conditional method.
These are obtained by using the respective time values as the
follow-up time or response in the formula.
}
\references{
G. Berry.  The analysis of mortality by the subject-years method.
\emph{Biometrics} 1983, 39:173-84.
F Ederer, L Axtell, and S Cutler.  The relative survival rate: a statistical
methodology. \emph{Natl Cancer Inst Monogr} 1961, 6:101-21.
T. Hakulinen.  Cancer survival corrected for heterogeneity in patient
withdrawal.  \emph{Biometrics} 1982, 38:933.
H. Verheul, E. Dekker, P. Bossuyt, A. Moulijn, and A. Dunning.  Background
mortality in clinical survival studies.  \emph{Lancet} 1993, 341:872-5.
}
\seealso{
\code{\link{survfit}}, \code{\link{survexp.us}}, \code{\link{survexp.fit}}, \code{\link{pyears}}, \code{\link{date}}}
\examples{
## comparing data to population
data(ratetables)	
data(cancer)
## compare survival to US population
cancer$year<-rep(as.date("1/1/1980"),nrow(cancer))
efit <- survexp( ~ ratetable(sex=sex, year=year, age=age*365), times=(1:4)*365,data=cancer)
plot(survfit(Surv(time, status) ~1,data=cancer))
lines(efit)
## compare data to Cox model
## Mayo PBC data
data(pbc)
## fit to randomised patients
m<-coxph(Surv(time,status)~edtrt+log(bili)+log(protime)+age+platelet,data=pbc,
      subset=trt>0)
##compare Kaplan-Meier to fitted model for 2 edema groups in
##unrandomised patients
plot(survfit(Surv(time,status)~edtrt,data=pbc,subset=trt==-9))
lines(survexp(~edtrt+ratetable(edtrt=edtrt,bili=bili,platelet=platelet,age=age,
  protime=protime),data=pbc,subset=trt==-9,ratetable=m,cohort=TRUE),col="purple")

}
\keyword{survival}
% Converted by Sd2Rd version 0.3-2.

\eof
\name{survexp.fit}
\alias{survexp.fit}
\title{
Work Function to Compute Expected Survival
}
\description{
Compute expected survival. This function is not to be called by the user.
}
\usage{
survexp.fit(x, y, times, death, ratetable)
}
\arguments{
\item{x}{
a matrix. The first column contains the group,
an integer value that divides the subjects into subsets.
Remaining columns must match the dimensions of the \code{ratetable},
in the correct order.
}
\item{y}{
the follow up time for each subject.
}
\item{times}{
the vector of times at which a result will be computed.
}
\item{death}{death indicator}
\item{ratetable}{
a rate table, such as \code{survexp.uswhite}.
}}
\value{
A list containing the number of subjects and the expected survival(s)
at each time point.
If there are multiple groups, these will be
matrices with one column per group.
}
\details{
  For cohort survival it must be the potential censoring time for
each subject, ignoring death.


For an exact estimate \code{times} should be a superset of \code{y}, so that each
subject at risk is at risk for the entire sub-interval of time.
For a large data set, however, this can use an inordinate amount of
storage and/or compute time.  If the \code{times} spacing is more coarse than
this, an actuarial approximation is used which should, however, be extremely
accurate as long as all of the returned values are > .99.


For a subgroup of size 1 and \code{times} > \code{y},
the conditional method reduces to exp(-h) where
h is the expected cumulative hazard for the subject over his/her
observation time.  This is used to compute individual expected survival.
}
\section{WARNING}{
Most users will call the higher level routine \code{survexp}.
Consequently, this function has very few error checks on its input arguments.
}
\seealso{
\code{\link{survexp}}, \code{\link{survexp.us}}
}
\keyword{survival}
% Converted by Sd2Rd version 0.3-2.

\eof
\name{ratetables}
\alias{ratetables}
\alias{survexp.us}
\alias{survexp.uswhite}
\alias{survexp.usr}
\alias{survexp.az}
\alias{survexp.azr}
\alias{survexp.fl}
\alias{survexp.flr}
\alias{survexp.mn}
\alias{survexp.mnwhite}
\alias{survexp.wnc}
\title{
Census Data Sets for the Expected Survival and Person Years Functions
}
\description{
Census data sets for the expected survival and person years functions

}\usage{
data(ratetables)
survexp.uswhite<-survexp.usr[,,"white",]
}

\details{
\describe{
\item{us}{
total United States population, by age and sex, 1960 to 1980.
}
\item{uswhite}{
United States white population, by age and sex, 1950 to 1980. This is
no longer included, but can be extracted from \code{survexp.usr} as
shown above.
}
\item{usr}{
United States population, by age, sex and race, 1960 to 1980.  Race is
white, nonwhite, or black.  For 1960 and 1970 the black population values
were not reported separately, so the nonwhite values were used.
}
\item{mn}{
total Minnesota population, by age and sex, 1970 and 1980.
}
\item{mnwhite}{
Minnesota white population, by age and sex, 1960 to 1980.
}
\item{fl}{
total Florida population, by age and sex, 1970 and 1980.
}
\item{flr}{
Florida population, by age, sex and race, 1970-1980.  Race is
white, nonwhite, or black.  For 1970 the black population values
were not reported separately, so the nonwhite values were used.
}
\item{az}{
total Arizona population, by age and sex, 1970 and 1980.
}
\item{azr}{
Arizona population, by age, sex and race, 1970-1980.  Race is
white versus nonwhite.  For 1970 the nonwhite population values
were not reported separately.
In order to make the rate table be a matrix, the 1980 values were
repeated.  (White and non-white values are quite different).
}}

Each of these tables contains the daily hazard rate for a matched subject
from the population, defined as -log(1-q)/365.24 where q is the 1 year
probability of death as reported in the original tables.
For age 25 in 1970, for instance, p = 1-q is is the probability that a subject
who becomes 25 years of age in 1970 will achieve his/her 26th birthday.
The tables are recast in terms of hazard per day entirely for computational
convenience.
(The fraction .24 in
the denominator is based on 24 leap years per century.)


Each table is stored as an array, with additional attributes, and
can be subset and manipulated as standard S arrays.
Interpolation between calendar years is done "on the fly" by the survexp
routine. 


Some of the deficiencies, e.g. 1970 Arizona non-white, are a result of
local conditions.  The data probably exists, but we don't have a copy
it in the library.


The tables have  been augmented to contain extrapolated
values for 1990 and 2000.  The details can be found in Mayo Clinic Biostatistics 
technical report 63 at \url{http://www.mayo.edu/hsr/techrpt.html}
}
\keyword{survival}
\keyword{datasets}






\eof
\name{survfit}
\alias{survfit}
\alias{[.survfit}
\alias{survfit.km}
\alias{survfit.coxph.null}
\alias{survfit.coxph}
\alias{basehaz}
\title{
Compute a Survival Curve for Censored Data
}
\description{
Computes an estimate of a survival curve for censored data
using either the Kaplan-Meier or the Fleming-Harrington method
or computes the predicted survivor function for a Cox proportional
hazards model.
}
\synopsis{survfit(formula, data, weights, subset, na.action, ...)}
\usage{
survfit(formula, data, weights, subset, na.action, 
        newdata, individual=F, conf.int=.95, se.fit=T, 
        type=c("kaplan-meier","fleming-harrington", "fh2"),
        error=c("greenwood","tsiatis"),
        conf.type=c("log","log-log","plain","none"),
        conf.lower=c("usual", "peto", "modified"))
basehaz(fit,centered=TRUE)
}
\arguments{
\item{formula}{
A formula object or a \code{coxph} object.
If a formula object is supplied it must have a \code{Surv} object as the 
response on the left of the \code{~} operator and, if desired, terms 
separated by + operators on the right.
One of the terms may be a \code{strata} object.  For a single survival curve
the \code{"~ 1"} part of the formula is not required.
}
\item{data}{
a data frame in which to interpret the variables named in the formula,
or in the \code{subset} and the \code{weights} argument.
}
\item{weights}{
The weights must be nonnegative and it is strongly recommended that 
they be strictly positive, since zero weights are ambiguous, compared
to use of the \code{subset} argument.
}
\item{subset}{
expression saying that only a subset of the rows of the data
should be used in the fit.
}
\item{na.action}{
a missing-data filter function, applied to the model frame, after any
\code{subset} argument has been used.
Default is \code{options()$na.action}.
}
\item{newdata}{
a data frame with the same variable names as those that appear
in the \code{coxph} formula.  Only applicable when \code{formula} is a \code{coxph} object.
The curve(s) produced will be representative of a cohort who's
covariates correspond to the values in \code{newdata}.
Default is the mean of the covariates used in the \code{coxph} fit.
}
\item{individual}{
a logical value indicating whether the data frame represents different
time epochs for only one individual (T), or whether multiple rows indicate
multiple individuals (F, the default).  If the former only one curve
will be produced; if the latter there will be one curve per row in \code{newdata}.
}
\item{conf.int}{
the level for a two-sided confidence interval on  the survival curve(s).
Default is 0.95.
}
\item{se.fit}{
a logical value indicating whether standard errors should be
computed.  Default is \code{TRUE}.
}
\item{type}{
a character string specifying the type of survival curve.
Possible values are \code{"kaplan-meier"}, \code{"fleming-harrington"} or \code{"fh2"}
if a formula is given
and \code{"aalen"} or \code{"kaplan-meier"} if the first argument is a \code{coxph} object,
(only the first two characters are necessary).
The default is \code{"aalen"} when a \code{coxph} object is given,
and it is \code{"kaplan-meier"} otherwise.
}
\item{error}{
either the string \code{"greenwood"} for the Greenwood formula or
\code{"tsiatis"} for the Tsiatis formula, (only the first character is
necessary).  The default is \code{"tsiatis"} when a \code{coxph} object is
given, and it is \code{"greenwood"} otherwise.
}
\item{conf.type}{
One of \code{"none"}, \code{"plain"}, \code{"log"} (the default), or \code{"log-log"}.  Only
enough of the string to uniquely identify it is necessary.
The first option causes confidence intervals not to be
generated.  The second causes the standard intervals
\code{curve +- k *se(curve)}, where k is determined from
\code{conf.int}.  The log option calculates intervals based on the
cumulative hazard or log(survival). The last option bases
intervals on the log hazard or log(-log(survival)).  These
last will never extend past 0 or 1.
}
\item{conf.lower}{
controls modified lower limits to the curve,
the upper limit remains unchanged.  The modified lower limit
is based on an 'effective n' argument.  The confidence
bands will agree with the usual calculation at each death time, but unlike
the usual bands the confidence interval becomes wider at each censored
observation.  The extra width is obtained by multiplying the usual
variance by a factor m/n, where n is the number currently at risk and
m is the number at risk at the last death time.  (The bands thus agree
with the un-modified bands at each death time.)
This is especially useful for survival curves with a long flat tail.


The Peto lower limit is based on the same 'effective n' argument as the
modified limit, but also replaces the usual Greenwood variance term with
a simple approximation.  It is known to be conservative.
}
\item{fit}{a \code{coxph} object}
\item{centered}{Compute the baseline hazard at the covariate mean rather than at zero?}
}
\value{
a \code{survfit} object; see the help on \code{survfit.object} for
details. Methods defined for \code{survfit} objects are provided for
\code{print}, \code{plot}, \code{lines}, and \code{points}.

For \code{basehaz}, a dataframe with the baseline hazard, times, and strata.
}
\details{
Actually, the estimates used are the Kalbfleisch-Prentice
(Kalbfleisch and Prentice, 1980, p.86) and the Tsiatis/Link/Breslow,
which reduce to the Kaplan-Meier and Fleming-Harrington estimates,
respectively, when the weights are unity.  When curves are fit for a
Cox model, subject weights of \code{exp(sum(coef*(x-center)))} are used, 
ignoring any value for \code{weights} input by the user.  There is also an extra
term in the variance of the curve, due to the variance ofthe coefficients and
hence variance in the computed weights.


The Greenwood formula for the variance is a sum of terms
d/(n*(n-m)), where d is the number of deaths at a given time point, n
is the sum of \code{weights} for all individuals still at risk at that time, and
m is the sum of \code{weights} for the deaths at that time.  The
justification is based on a binomial argument when weights are all
equal to one; extension to the weighted case is ad hoc.  Tsiatis
(1981) proposes a sum of terms d/(n*n), based on a counting process
argument which includes the weighted case.


The two variants of the F-H estimate have to do with how ties are handled.
If there were 3 deaths out of 10 at risk, then the first would increment
the hazard by 3/10 and the second by 1/10 + 1/9 + 1/8.  For curves created
after a Cox model these correspond to the Breslow and Efron estimates,
respectively, and the proper choice is made automatically.
The \code{fh2} method will give results closer to the Kaplan-Meier.


Based on the work of Link (1984), the log transform is expected to produce
the most accurate confidence intervals.  If there is heavy censoring, then
based on the work of Dorey and Korn (1987) the modified estimate will give
a more reliable confidence band for the tails of the curve.
}
\references{
Dorey, F. J. and Korn, E. L. (1987).  Effective sample sizes for confidence
intervals for survival probabilities.  \emph{Statistics in Medicine} 6, 679-87.


Fleming, T. H. and Harrington, D.P. (1984).  Nonparametric estimation of the
survival distribution in censored data.  \emph{Comm. in Statistics} 13, 2469-86.


Kalbfleisch, J. D. and Prentice, R. L. (1980). 
\emph{The Statistical Analysis of Failure Time Data.}
Wiley, New York.


Link, C. L. (1984). Confidence intervals for the survival
function using Cox's proportional hazards model with 
covariates.  \emph{Biometrics} 40, 601-610.


Tsiatis, A. (1981). A large sample study of the estimate
for the integrated hazard function in Cox's regression
model for survival data. \emph{Annals of Statistics} 9, 93-108.
}
\seealso{
\code{\link{print.survfit}}, \code{\link{plot.survfit}}, \code{\link{lines.survfit}}, \code{\link{summary.survfit}},
\code{\link{coxph}}, \code{\link{Surv}}, \code{\link{strata}}.}
\examples{
#fit a Kaplan-Meier and plot it
data(aml)
fit <- survfit(Surv(time, status) ~ x, data=aml)
plot(fit)

# plot only 1 of the 2 curves from above
plot(fit[2])


#fit a cox proportional hazards model and plot the 
#predicted survival curve
data(ovarian)
fit <- coxph( Surv(futime,fustat)~resid.ds+rx+ecog.ps,data=ovarian)
plot( survfit( fit))
}
\keyword{survival}
% Converted by Sd2Rd version 0.3-2.

\eof
\name{survfit.object}
\alias{survfit.object}
\title{
Survival Curve Object
}
\description{
This class of objects is returned by the \code{survfit} class of functions
to represent a fitted survival curve. 

Objects of this class have methods for the functions \code{print},
\code{summary}, \code{plot}, \code{points} and \code{lines}. The
\code{\link{print.survfit}} method does more computation than is typical
for a print method and is documented on a separate page.
}
\section{COMPONENTS}{
The following components must be included in a legitimate \code{survfit} object.
\describe{
\item{time}{
the time points at which the curve has a step.
}
\item{n.risk}{
the number of subjects at risk at t.
}
\item{n.event}{
the number of events that occur at time t.
}
\item{surv}{
the estimate of survival at time t+0.
This may be a vector or a matrix.
}
\item{strata}{
if there are multiple curves, this component gives the number of elements of
the \code{time} etc. vectors corresponding to the first curve, the second curve,
and so on.  The names of the elements are labels for the curves.
}
\item{std.err}{
the standard error of the cumulative hazard or -log(survival).
}
\item{upper}{
upper confidence limit for the survival curve.
}
\item{lower}{
lower confidence limit for the survival curve.
}
\item{conf.type}{
the approximation used to compute the confidence limits.
}
\item{conf.int}{
the level of the confidence limits, e.g. 90 or 95\%.
}
\item{na.action}{
the returned value from the na.action function, if any.  It will be used
in the printout of the curve, e.g., the number of observations deleted due
to missing values.
}
\item{call}{
the call that produced the object.
}}}
\section{SUBSCRIPTS}{
Survfit objects that contain multiple survival curves can be subscripted.
This is most often used to plot a subset of the curves.
Usually a single subscript will be used.  In one particular case --
survival curves for multiple covariate values, from a Cox model that includes
a \code{strata} statement -- there is a matrix of curves and 2 subscripts may
be used.
(In this case \code{summary.survfit} will also print the data as a matrix).
}
\seealso{
\code{\link{survfit}}, \code{\link{plot.survfit}},
\code{\link{summary.survfit}}, \code{\link{print.survfit}}.
}
\keyword{survival}
% Converted by Sd2Rd version 0.3-2.

\eof
\name{survival-internal}
\alias{survival-internal}
\alias{survreg.fit}
\alias{survpenal.fit}
\alias{survdiff.fit}
\alias{is.category}
\alias{is.na.ratetable2}
\alias{is.na.coxph.penalty}
\alias{[.terms}
\alias{match.ratetable}
\alias{as.matrix.ratetable}
\alias{model.newframe}
\alias{as.data.frame.difftime}
\alias{coxpenal.df}
\alias{coxpenal.fit}
\alias{coxph.fit}
\alias{coxph.wtest}
\alias{agreg.fit}
\alias{agexact.fit}
\title{Internal survival functions}
\description{Internal survival functions}
\usage{
survreg.fit(x, y, weights, offset, init, controlvals, dist, scale = 0,
    nstrat = 1, strata, parms = NULL)
survpenal.fit(x, y, weights, offset, init, controlvals, dist, scale = 0,
    nstrat = 1, strata, pcols, pattr, assign, parms = NULL)
survdiff.fit(y, x, strat, rho = 0)
is.category(x)
termobj[i]
match.ratetable(R, ratetable)
as.matrix.ratetable(x)
is.na.ratetable2(x)
is.na.coxph.penalty(x)
model.newframe(object, newdata, safe = FALSE, response = FALSE, ...)
as.data.frame.difftime(x, row.names = NULL, optional = FALSE)
coxpenal.df(hmat, hinv, fdiag, assign.list, ptype, nvar, pen1,
    pen2, sparse)
coxpenal.fit(x, y, strata, offset, init, control, weights, method,
    rownames, pcols, pattr, assign)
coxph.fit(x, y, strata, offset, init, control, weights, method,
    rownames)
coxph.wtest(var, b, toler.chol = 1e-09)
agreg.fit(x, y, strata, offset, init, control, weights, method,
    rownames)
 agexact.fit(x, y, strata, offset, init, control, weights, method,
    rownames) 
}
\details{These are not to be called by the user}
\keyword{survival}
\keyword{internal}

\eof
\name{survobrien}
\alias{survobrien}
\title{
O'Brien's Test for Association of a Single Variable with Survival
}
\description{
Peter O'Brien's test for association of a single variable with survival
This test is proposed in Biometrics, June 1978.
}
\usage{
survobrien(formula, data)
}
\arguments{
\item{formula}{
a valid formula for a cox model, without time dependent covariates.
}
\item{data}{
a data frame.
}}
\value{
a new data frame.  The original time and status variables are removed,
and have been replaced with \code{start}, \code{stop}, and \code{event}.  If a
predictor variable is a factor or is protected with \code{I()}, it is
retained as is.  Other predictor variables have been replaced with
time-dependent logit scores.


Because of the time dependent variables, the new data frame will have many
more rows that the original data, approximately \#rows * \#deaths /2.
}
\section{METHOD}{
A time-dependent cox model can now be fit to the new data.
The univariate statistic, as originally proposed, is equivalent to
single variable score tests from the time-dependent model.
This equivalence is the rationale for using the time dependent model as a
multivariate extension of the original paper.


In O'Brien's method, the x variables are re-ranked at each death time.  A
simpler method, proposed by Prentice, ranks the data only once at the
start. The results are usually similar.
}
\references{
O'Brien, Peter, "A Nonparametric Test for Association with Censored Data",
\emph{Biometrics} 34: 243-250, 1978.
}
\seealso{
\code{\link{survdiff}}
}
\keyword{survival}
\examples{
data(ovarian)
xx <- survobrien(Surv(futime, fustat) ~ age + factor(rx) + I(ecog.ps),
			       data=ovarian)
coxph(Surv(start, stop, event) ~ age, data=xx)
coxph(Surv(start, stop, event) ~ age + rx + ecog.ps, data=xx)
}
% Converted by Sd2Rd version 0.3-2.

\eof
\name{survreg}
\alias{survreg}
\alias{model.frame.survreg}
\alias{labels.survreg}
\alias{print.survreg.penal}
\alias{print.summary.survreg}
\alias{survReg}
\alias{anova.survreg}
\alias{vcov.survreg}
\alias{anova.survreglist}
\alias{censorReg}
\title{
Regression for a Parametric Survival Model
}
\description{
Regression for a parametric survival model. These are all
time-transformed location models, with the most useful case being the
accelerated failure models that use a log transformation.
}
\usage{
survreg(formula=formula(data), data=parent.frame(), weights, 
subset,na.action,dist="weibull",  init=NULL, scale=0,
 control=survreg.control(),parms=NULL,model=FALSE, x=FALSE,
 y=TRUE, \dots)
}
\arguments{
\item{formula}{
a formula expression as for other regression models.
See the documentation for \code{lm} and \code{formula} for details.
}
\item{data}{
optional data frame in which to interpret the variables occurring in the
formula.
}
\item{weights}{Optional observation weights}
\item{subset}{
subset of the observations to be used in the fit.
}
\item{na.action}{
function to be used to handle any NAs in the data.
}
\item{dist}{
assumed distribution for y variable. 
If the argument is a character string, then it is assumed to name an
element from \code{\link{survreg.distributions}}. These include
\code{"weibull"}, \code{"exponential"}, \code{"gaussian"}, \code{"logistic"}, \code{"lognormal"} and \code{"loglogistic"}.
Otherwise, it is assumed to be a user defined list conforming to the
format described in \code{\link{survreg.distributions}}.
}
\item{parms}{
a list of fixed parameters.  For the t-distribution for instance this is
the degrees of freedom; most of the distributions have no parameters.
}
\item{init}{
optional vector of initial values for the parameters.
}
\item{scale}{
optional fixed value for the scale.  If set to <=0 then the scale is
estimated.
}
\item{control}{
a list of control values, in the format producted by \code{survreg.control}.
}
\item{model}{
if TRUE, the model frame is returned.
}
\item{x}{
if TRUE, then the X matrix is returned.
}
\item{y}{
if TRUE, then the y vector (or survival times) is returned.
}
\item{...}{
other arguments which will be passed to \code{survreg.control}.
}}
\value{
an object of class \code{survreg} is returned.
}

\section{Compatibility note}{
This routine underwent significant changes from survival4 to
survival5. The \link{survreg.old} function gives a backwards-compatible
interface.  In S-PLUS the new function is called \code{survReg} and
the old one \code{survreg}.
}

\seealso{
\code{\link{survreg.object}}, \code{\link{survreg.distributions}},
\code{\link{pspline}}, \code{\link{frailty}}, \code{\link{ridge}},
\code{\link{survreg.old}}
}
\examples{
data(ovarian)
## These are all the same
survreg(Surv(futime, fustat) ~ ecog.ps + rx, ovarian, dist='weibull',scale=1)
survreg(Surv(futime, fustat) ~ ecog.ps + rx, ovarian,
dist="exponential")
survreg.old(Surv(futime, fustat) ~ ecog.ps + rx, ovarian, dist='extreme',fixed=list(scale=1),link="log")

}
\keyword{survival}
% Converted by Sd2Rd version 0.3-2.

\eof
\name{survreg.control}
\alias{survreg.control}
\alias{coxph.control}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Package options for survreg and coxph}
\description{
These functions check and package the fitting options for \code{\link{survreg}} and \code{\link{coxph}}
}
\usage{
survreg.control(maxiter=30, rel.tolerance=1e-09, failure=1,
toler.chol=1e-10, iter.max, debug=0, outer.max=10)
coxph.control (eps = 1e-09, toler.chol = .Machine$double.eps^0.75, 
    iter.max = 20, toler.inf = sqrt(eps), outer.max = 10) 

}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{maxiter}{maximum number of iterations }
  \item{rel.tolerance}{relative tolerance to declare convergence }
  \item{failure}{value of status variable indicating failure}
  \item{toler.chol}{Tolerance to declare Cholesky decomposition singular}
  \item{iter.max}{same as \code{maxiter}}
  \item{debug}{print debugging information}
  \item{outer.max}{maximum number of outer iterations for choosing
    penalty parameters}
  \item{eps}{Tolerance to declare convergence for Cox model}
  \item{toler.inf}{An undocumented parameter}
}
\value{
 A list with the same elements as the input
}

\seealso{ \code{\link{survreg}}, \code{\link{coxph}}  }

\examples{

}
\keyword{survival}


\eof
\name{survreg.distributions}
\alias{survreg.distributions}
\title{Parametric Survival Distributions}
\usage{
survreg.distributions
}
\description{ List of distributions for accelerated failure models. These are
  location-scale families for some transformation of time. The entry
  describes  the cdf \eqn{F} and density \eqn{f} of a canonical member of
  the family.
}

\format{
 
  There are three basic formats; only the first two are used in the
  built-in distributions
  \tabular{ll}{
    name:\tab name of distribution\cr
    variance:\tab Variance \cr
    init(x,weights,...):\tab Function returning an initial\cr mean and
    \tab variance\cr
    deviance(y,scale,parms):\tab Function returning the deviance\cr
    density(x,parms):\tab Function returning \eqn{F},\cr
    \tab \eqn{1-F},\eqn{f},\eqn{f'/f},\eqn{f''/f}\cr
    quantile(p,parms):\tab Quantile function\cr
    scale:\tab Optional fixed value for scale parameter\cr
  }
  and for transformations of the time variable
  \tabular{ll}{
    name:\tab name of distribution\cr
    dist:\tab name of transformed distribution\cr
    trans:\tab transformation (eg log)\cr
    dtrans:\tab derivative of transformation\cr
    itrans:\tab inverse of transformation\cr
    scale:\tab Optional fixed value for scale parameter\cr
  }
  For transformations of user-defined families use
  \tabular{ll}{
    name:\tab name of distribution\cr
    dist:\tab transformed distribution in first format\cr
    trans:\tab transformation (eg log)\cr
    dtrans:\tab derivative of transformation\cr
    itrans:\tab inverse of transformation\cr
    scale:\tab Optional fixed value for scale parameter\cr
  }
  
}

\details{
There are four basic distributions:\code{extreme}, \code{gaussian},
\code{logistic} and \code{t}. The last three
are parametrised in the same way as the distributions already present in
\R. The extreme value cdf is
\deqn{F=1-e^{-e^t}.}

When the logarithm of survival time has one of the first three distributions
we obtain respectively \code{lognormal},\code{loglogistic} and
\code{weibull}.

The other predefined distributions are defined in terms of these. The
\code{exponential} and \code{rayleigh} distributions are Weibull
distributions with fixed \code{scale} of 1 and 0.5 respectively, and
\code{loggaussian} is a synonym for \code{lognormal}.

Parts of the built-in distributions are hardcoded in C, so the elements
of \code{survreg.distributions} in the first format above must not be
changed and new ones must not be added.  The examples show how to
specify user-defined distributions to \code{survreg}.


} \seealso{\code{\link{survreg}},
  \code{\link{pnorm}},\code{\link{plogis}}, \code{\link{pt}}}}
\examples{
data(ovarian)
## not a good fit, but a useful example
survreg(Surv(futime,fustat)~ecog.ps+rx,data=ovarian,dist='extreme')
## 
my.extreme<-survreg.distributions$extreme
my.extreme$name<-"Xtreme"
survreg(Surv(futime,fustat)~ecog.ps+rx,data=ovarian,dist=my.extreme)

## time transformation
survreg(Surv(futime,fustat)~ecog.ps+rx,data=ovarian,dist='weibull',scale=1)
my.weibull<-survreg.distributions$weibull
my.weibull$dist<-my.extreme
survreg(Surv(futime,fustat)~ecog.ps+rx,data=ovarian,dist=my.weibull,scale=1)

## change the transformation to work in years
## intercept changes by log(365), other coefficients stay the same
my.weibull$trans<-function(y) log(y/365)
my.weibull$itrans<-function(y) exp(365*y)
survreg(Surv(futime,fustat)~ecog.ps+rx,data=ovarian,dist=my.weibull,scale=1)


}
\keyword{survival}

\eof
\name{survreg.object}
\alias{survreg.object}
\alias{print.survreg}
\alias{summary.survreg}

\title{
Parametric Survival Model Object
}
\description{
This class of objects is returned by the \code{survreg} function
to represent a fitted parametric survival model.
Objects of this class have methods for the functions \code{print},
\code{summary}, \code{predict}, and \code{residuals}.
}
\section{COMPONENTS}{
The following components must be included in a legitimate \code{survreg} object.
\describe{
\item{coefficients}{
the coefficients of the \code{linear.predictors}, which multiply  the
columns of the model
matrix.
It does not include the estimate of error (sigma).
The names of the coefficients are the names of the
single-degree-of-freedom effects (the columns of the
model matrix).
If the model is over-determined there will
be missing values in the coefficients corresponding to non-estimable
coefficients.
}
\item{icoef}{
coefficients of the baseline model, which will contain the intercept
and log(scale), or mulitple scale factors for a stratified model.
}
\item{var}{
the variance-covariance matrix for the parameters, including the log(scale)
parameter(s).
}
\item{loglik}{
a vector of length 2, containing the log-likelihood for the baseline and
full models. 
}
\item{iter}{
the number of iterations required
}
\item{linear.predictors}{
the linear predictor for each subject.
}
\item{df}{
the degrees of freedom for the final model.  For a penalized model
this will be a vector with one element per term.
}
\item{scale}{
the scale factor(s), with length equal to the number of strata.
}
\item{idf}{
degrees of freedom for the initial model.
}
\item{means}{
a vector of the column means of the coefficient matrix.
}
\item{dist}{
the distribution used in the fit.


The object will also have the following components found in 
other model results (some are optional):
\code{linear predictors}, \code{weights}, \code{x}, \code{y}, \code{model}, 
\code{call}, \code{terms} and \code{formula}.
See \code{lm}.
}}}
\seealso{
\code{\link{survreg}}, \code{\link{lm}}
}
\keyword{regression}
\keyword{survival}
% Converted by Sd2Rd version 0.3-2.

\eof
\name{survreg.old}
\alias{survreg.old}
\title{
Old (survival4) Regression for a parametric survival model
}
\usage{
survreg.old(formula, data=sys.frame(sys.parent()), \dots, link=c("log",
"identity"),dist=c("extreme", "logistic", "gaussian",
"exponential","rayleigh","weibull"), fixed=list())
}
\description{
  This routine is a backwards-compatible interface to the improved \link{survreg} function, which is better.
}
\arguments{
\item{formula}{
a formula expression as for other regression models.
See the documentation for \code{lm} and \code{formula} for details.
}
\item{data}{
optional data frame in which to interpret the variables occuring in the
formula.
}
\item{\dots}{other arguments to \code{\link{survreg}}}
\item{link}{
transformation to be used on the y variable.
}
\item{dist}{
assumed distribution for the transformed y variable.
}
\item{fixed}{
a list of fixed parameters, most often just the scale.
}
}
\value{
an object of class \code{survreg} is returned, which inherits from class \code{glm}.
}

\examples{
data(ovarian)
survreg.old(Surv(futime, fustat) ~ ecog.ps + rx, ovarian, dist='extreme',
		link='log', fixed=list(scale=1))   #Fit an exponential
}
\keyword{survival}
% Converted by Sd2Rd version 0.2-a3.

\eof
\name{tcut}
\alias{tcut}
\alias{[.tcut}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Factors for person-year calculations}
\description{
Attaches categories for person-year calculations to a variable without
losing the underlying continuous representation
}
\usage{
tcut(x, breaks, labels, scale=1)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{numeric/date variable }
  \item{breaks}{breaks between categories, which are right-continuous }
  \item{labels}{labels for categories }
  \item{scale}{Multiply \code{x} and \code{breaks} by this.}
}

\value{
  An object of class \code{tcut}
}

\seealso{ \code{\link{cut}}, \code{\link{pyears}} }

\examples{
temp1 <- mdy.date(6,6,36)
temp2 <- mdy.date(6,6,55)# Now compare the results from person-years
#
temp.age <- tcut(temp2-temp1, floor(c(-1, (18:31 * 365.24))),
	labels=c('0-18', paste(18:30, 19:31, sep='-')))
temp.yr  <- tcut(temp2, mdy.date(1,1,1954:1965), labels=1954:1964)
temp.time <- 3700   #total days of fu
py1 <- pyears(temp.time ~ temp.age + temp.yr, scale=1) #output in days
py1
}
\keyword{survival}% at least one, from doc/KEYWORDS
\keyword{manip}% __ONLY ONE__ keyword per line

\eof
\name{tobin}
\alias{tobin}
\docType{data}
\title{Tobin's Tobit data}
\description{
Economists fit a parametric censored data model called the
`tobit'. These data are from Tobin's original paper.
}
\usage{data(tobin)}
\format{
  A data frame with 20 observations on the following 3 variables.
  \describe{
    \item{durable}{Durable goods purchase}
    \item{age}{Age in years}
    \item{quant}{Liquidity ratio (x 1000)}
  }
}

\source{
J. Tobin, Estimation of relationships for limited dependent variables, Econometrica, v26, 24-36, 1958.
}
\examples{
data(tobin)
tfit <- survreg(Surv(durable, durable>0, type='left') ~age + quant,
                data=tobin, dist='gaussian')

predict(tfit,type="response")

}
\keyword{datasets}

\eof
\name{untangle.specials}
\alias{untangle.specials}
\title{
Help Process the `specials' Argument of the `terms' Function.
}
\description{
Given a \code{terms} structure and a desired special name, this returns an
index appropriate for subscripting the \code{terms} structure and another
appropriate for the data frame.
}
\usage{
untangle.specials(tt, special, order=1)
}
\arguments{
\item{tt}{
a \code{terms} object.
}
\item{special}{
the name of a special function, presumably used in the terms object.
}
\item{order}{
the order of the desired terms.  If set to 2, interactions with the special
function will be included.
}}
\value{
a list with two components:
}
\item{vars}{
a vector of variable names, as would be found in the data frame, of the
specials.
}
\item{terms}{
a numeric vector, suitable for subscripting the terms structure, that indexes
the terms in the expanded model formula which involve the special.
}}
\examples{
formula<-Surv(tt,ss)~x+z*strata(id)
tms<-terms(formula,specials="strata")
## the specials attribute
attr(tms,"specials")
## main effects 
untangle.specials(tms,"strata")
## and interactions
untangle.specials(tms,"strata",order=1:2)
}
\keyword{survival}
% Converted by Sd2Rd version 0.3-2.

\eof
\name{veteran}
\alias{veteran}
\title{Veterans' Administration Lung Cancer study}
\usage{data(veteran)}
\description{Randomised trial of two treatment regimens for lung
    cancer. This is a standard survival analysis data set}
\format{
    \tabular{ll}{
	trt:\tab 1=standard 2=test\cr
	celltype:\tab 1=squamous,  2=smallcell,  3=adeno,  4=large\cr
	time:\tab survival time\cr
	status:\tab censoring status\cr
	karno:\tab Karnofsky performance score (100=good)\cr
	diagtime:\tab months from diagnosis to randomisation\cr
	age:\tab in years\cr
	prior:\tab prior therapy 0=no, 1=yes\cr
     }
 }
\source{Kalbfleisch and Prentice "The Statistical Analysis of Failure Time Data"}
\keyword{datasets}

\eof
