\name{leaps}
\title{all-subsets regressiom}
\usage{
leaps(x=, y=, wt=rep(1, NROW(x)), int=TRUE, method=c("Cp", "adjr2", "r2"), nbest=10, names=NULL, df=NROW(x), strictly.compatible=TRUE)
}
\alias{leaps}
\arguments{
\item{x}{A matrix of predictors}
\item{y}{A response vector}
\item{wt}{Optional weight vector}
\item{int}{Add an intercept to the model}
\item{method}{Calculate Cp, adjusted R-squared or R-squared}
\item{nbest}{Number of subsets of each size to report}
\item{names}{vector of names for columns of \code{x}}
\item{df}{Total degrees of freedom to use instead of \code{nrow(x)} in calculating Cp and adjusted R-squared}
\item{strictly.compatible}{Implement misfeatures of leaps() in S}
}
\description{
leaps() performs an exhaustive search for the best subsets of the variables in x for predicting y in linear regression, using an efficient branch-and-bound algorithm.  It is a compatibility wrapper for \code{\link{regsubsets}} does the same thing better.
}
\value{
A list with components
\item{which}{logical matrix. Each row can be used to select the columns of \code{x} in the respective model}
\item{size}{Number of variables, including intercept if any, in the model}
\item{cp}{or \code{adjr2} or \code{r2} is the value of the chosen model selectionstatistic for each model}
\item{label}{vector of names for the columns of x}
}
\references{
Alan Miller "Subset Selection in Regression" Chapman \& Hall
}
\note{
With \code{strictly.compatible=T} the function will stop with an error if \code{x} is not of full rank or if it has more than 31 columns. It will ignore the column names of \code{x} even if \code{names==NULL} and will replace them with "0" to "9", "A" to "Z".
}

\seealso{
\code{\link{regsubsets}}, \code{\link{regsubsets.formula}}, \code{\link{regsubsets.default}}}
}
\examples{
x<-matrix(rnorm(100),ncol=4)
y<-rnorm(25)
leaps(x,y)
}
\keyword{regression}

\eof
\name{leaps.setup}
\title{Internal functions for leaps(), subsets()}
\usage{
leaps.setup(x,y,wt=rep(1,length(y)),force.in=NULL,force.out=NULL,intercept=TRUE,nvmax=8,nbest=1,warn.dep=TRUE)
leaps.seqrep(leaps.obj)
leaps.exhaustive(leaps.obj,really.big=FALSE)
leaps.backward(leaps.obj)
leaps.forward(leaps.obj)
}
\alias{leaps.setup}
\alias{leaps.exhaustive}
\alias{leaps.forward}
\alias{leaps.backward}
\alias{leaps.seqrep}
\arguments{
\item{x}{A matrix of predictors}
\item{y}{A response vector}
\item{wt}{Optional weight vector}
\item{intercept}{Add an intercept to the model}
\item{force.in}{vector indicating variable that must be in the model}
\item{force.out}{vector indicating variable that must not be in the model}
\item{nbest}{Number of subsets of each size to report}
\item{nvmax}{largest subset size to examine}
\item{warn.dep}{warn if \code{x} is not of full rank}
\item{leaps.obj}{An object of class \code{leaps} as produced by \code{leaps.setup}}
\item{really.big}{required before R gets sent off on a long uninterruptible computation}
}
\description{
These functions are used internally by \code{regsubsets} and \code{leaps}. They are wrappers for Fortran routines that construct and manipulate a QR decomposition.}

\seealso{
\code{\link{regsubsets}}, \code{\link{leaps}}
}
\keyword{regression}

\eof
\name{plot.regsubsets}
\alias{plot.regsubsets}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Graphical table of best subsets}
\usage{
\method{plot}{regsubsets}(x, labels=obj$xnames, main=NULL, scale=c("bic", "Cp", "adjr2", "r2"), col=gray(seq(0, 0.9, length = 10)),...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
 \item{x}{\code{regsubsets} object }
 \item{labels}{variable names}
 \item{main}{title for plot }
 \item{scale}{which summary statistic to use for ordering plots}
 \item{col}{Colors: the last color should be close to but distinct from
   white }
 \item{...}{other arguments}
}
\description{
Plots a table of models showing which variables are in each model. The
models are ordered by the specified model selection statistic. This plot 
is particularly useful when there are more than ten or so models and the simple table 
produced by \code{\link{summary.regsubsets}} is too big to read.
}
\value{
None
}
\author{Thomas Lumley, based on a concept by Merlise Clyde}
\seealso{\code{\link{regsubsets}},\code{\link{summary.regsubsets}} }

\examples{
data(swiss)
a<-regsubsets(Fertility~.,nbest=3,data=swiss)
par(mfrow=c(1,2))
plot(a)
plot(a,scale="r2")
}
\keyword{hplot}
\keyword{regression}

\eof
\name{regsubsets}
\title{functions for model selection}
\usage{
regsubsets(x=, ...)

\method{regsubsets}{formula}(x=, data=, weights=NULL, nbest=1, nvmax=8, force.in=NULL, force.out=NULL, intercept=TRUE, method=c("exhaustive", "backward", "forward", "seqrep"), really.big=FALSE,...)

\method{regsubsets}{default}(x=, y=, weights=rep(1, length(y)), nbest=1, nvmax=8,
force.in=NULL, force.out=NULL, intercept=TRUE, method=c("exhaustive",
"backward", "forward", "seqrep"), really.big=FALSE,...)

\method{summary}{regsubsets}(object,all.best=TRUE,matrix=TRUE,matrix.logical=FALSE,df=NULL,...)

}
\alias{regsubsets}
\alias{regsubsets.default}
\alias{print.regsubsets}
\alias{print.summary.regsubsets}
\alias{regsubsets.formula}
\alias{summary.regsubsets}
\arguments{
\item{x}{design matrix or model formula for full model}
\item{data}{Optional data frame}
\item{y}{response vector}
\item{weights}{weight vector}
\item{nbest}{number of subsets of each size to record}
\item{nvmax}{maximum size of subsets to examine}
\item{force.in}{index to columns of design matrix that should be in all models}
\item{force.out}{index to columns of design matrix that should be in no models}
\item{intercept}{Add an intercept?}
\item{method}{Use exhaustive search, forward selection, backward selection or sequential replacement to search.}
\item{really.big}{Must be TRUE to perform exhaustive search on more than 50 variables.}

\item{object}{regsubsets object}
\item{all.best}{Show all the best subsets or just one of each size}
\item{matrix}{Show a matrix of the variables in each model or just summary
    statistics}
\item{matrix.logical}{With \code{matrix=TRUE}, the matrix is logical
    \code{TRUE}/\code{FALSE} or string \code{"*"}/code{" "}}
\item{df}{Specify a number of degrees of freedom for the summary
  statistics. The default is \code{n-1}}
\item{...}{Other arguments for future methods}
}
\description{
Generic function for regression subset selection with methods for formula and matrix arguments. 
}
\value{
An object of class "regsubsets" containing no user-serviceable parts. It is designed to be processed by \code{\link{summary.regsubsets}}. 
}
\note{
This function improves on \code{\link{leaps}} in several ways.  The design matrix need not be of full rank. The ability to restrict \code{nvmax} speeds up exhaustive searches considerably. There is no hard-coded limit to the number of variables.
}
\seealso{
\code{\link{leaps}}
}
\examples{
data(swiss)
a<-regsubsets(as.matrix(swiss[,-1]),swiss[,1])
summary(a)
b<-regsubsets(Fertility~.,data=swiss)
summary(a)
}
\keyword{regression}

\eof
