\name{mAr.eig}
\alias{mAr.eig}
\title{ Eigendecomposition of m-variate AR(p) model}
\description{
  Computation of the oscillation periods and damping rates of a system modeled by a m-variate AR(p) model from eigen-decomposition of the
estimated matrix of autoregressive coefficients
}
\usage{
mAr.eig(A, C, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{A}{ matrix of estimated autoregression coefficients}
  \item{C}{ noise covariance matrix}
  \item{\dots}{additional arguments for specific methods}
}

\value{
  A list with components: 
  \item{dampTime }{damping times associated with each eigenmode}
  \item{period }{periods associated with each eigenmode}
  \item{excitations}{relative dynamical importance of modes}
  \item{eigv}{m*p m-dimensional eigenvectors}
}

\references{
Neumaier, A. and Schneider, T. (2001), Estimation of parameters and eigenmodes of multivariate autoregressive models. ACM Transactions on Mathematical Software, 27, 1, 27-57. \cr\cr
Schneider, T. and Neumaier, A. (2001), A Matlab package fo the estimation of parameters and eigenmodes of multivariate autoregressive models, 27, 1, 58-65. \cr\cr
}

\author{ S. M. Barbosa }

\examples{
data(pinkham)
y=mAr.est(pinkham,2,5)
mAr.eig(y$AHat,y$CHat)
}
\keyword{ multivariate}


\eof

\name{mAr.est}
\alias{mAr.est}
\title{ Estimation of multivariate AR(p) model }
\description{
  Stepwise least-squares estimation of multivariate AR(p) model (based on Neumaier and Schneider 2001); given a minimal and maximal model order, the optimal model order is chosen based on Schwartz Bayesian Criterion (SBC).
}
\usage{
mAr.est(x, pmin, pmax, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{matrix of multivariate time series }
  \item{pmin}{minimal model order }
  \item{pmax}{maximal model order }
  \item{\dots}{additional arguments for specific methods}
}

\details{
  Fits a m-variate AR(p) model given by 
  \deqn{X[t]=w + A1 X[t-1] +...+ Ap X[t-p] +e[t]}
  where \cr
  X[t]=[X1(t)...Xm(t)]' is a vector of length m \cr
  w is a m-length vector of intercept terms \cr
  A=[A1 ... Ap] is a mp x m matrix of autoregressive coefficients \cr
  e(t) is a m-length uncorrelated noise vector with mean 0 and m x m covariance matrix C
}

\value{
  A list with components:
  \item{pHat }{order of the fitted model,chosen by SBC}
  \item{SBC }{Schwartz Bayesian Criterion}
  \item{wHat }{vector of intercept terms}
  \item{AHat }{matrix of estimated autoregression coefficients for the fitted model} 
  \item{CHat }{noise covariance matrix}  
  \item{res }{residuals from the fitted model}
}
\references{Neumaier, A. and Schneider, T. (2001), Estimation of parameters and eigenmodes of multivariate autoregressive models. ACM Transactions on Mathematical Software, 27, 1, 27-57. \cr\cr
Schneider, T. and Neumaier, A. (2001), A Matlab package fo the estimation of parameters and eigenmodes of multivariate autoregressive models, 27, 1, 58-65. \cr\cr
Lutkepohl, H. (1993), Introduction to Multiple Time Series Analysis. Springer-Verlag, Berlin.
 } 
 
\author{ S. M. Barbosa }

\seealso{
	\code{\link[ts]{ar}}
}

\examples{
data(pinkham)
y=mAr.est(pinkham,2,5)
}

\keyword{ multivariate }


\eof
\name{mAr.sim}
\alias{mAr.sim}
\title{ Simulation from multivariate AR(p) model }
\description{
  Simulation from a m-variate AR(p) model
}
\usage{
mAr.sim(w, A, C, N, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{w}{ vector of intercept terms }
  \item{A}{ matrix of AR coefficients }
  \item{C}{ noise covariance matrix }
  \item{N}{ length of output time series }
  \item{\dots}{ additional arguments}
}
\details{
  Simulation from a m-variate AR(p) model given by 
  \deqn{X[t]=w + A1 X[t-1] +...+ Ap X[t-p] +e[t]}
  where \cr
  X[t]=[X1(t)...Xm(t)]' is a vector of length m \cr
  w is a m-length vector of intercept terms \cr
  A=[A1 ... Ap] is a mp x m matrix of autoregressive coefficients \cr
  e(t) is a m-length uncorrelated noise vector with mean 0 and m x m covariance matrix C
}
\value{
  returns a list containg the N simulated observations for each of the m time series
}

\references{Neumaier, A. and Schneider, T. (2001), Estimation of parameters and eigenmodes of multivariate autoregressive models. ACM Transactions on Mathematical Software, 27, 1, 27-57. \cr\cr
Schneider, T. and Neumaier, A. (2001), A Matlab package fo the estimation of parameters and eigenmodes of multivariate autoregressive models, 27, 1, 58-65. \cr\cr
Lutkepohl, H. (1993), Introduction to Multiple Time Series Analysis. Springer-Verlag, Berlin.
 } 

\author{ S. M. Barbosa}


\examples{
w=c(0.25,0.1)
C=rbind(c(1,0.5),c(0.5,1.5))
A=rbind(c(0.4,1.2,0.35,-0.3),c(0.3,0.7,-0.4,-0.5))
x=mAr.sim(w,A,C,N=300)
}

\keyword{ multivariate }


\eof
\name{pinkham}
\alias{pinkham}
\docType{data}
\title{ Lydia Pinkham Annual Advertising and Sales data}
\description{
  Annual domestic advertising and sales of Lydia E. Pinkham Medicine Company in thousands of dollars 1907-1960
}
\usage{data(pinkham)}
\format{
  A data frame with 54 observations on the 2 variables.
}
\source{
 Pankratz, A. (1991) Forecasting With Dynamic Regression Models, Wiley.  \cr\cr
}

\references{
  Wei, W. (1994) Time series analysis -  univariate and multivariate methods  
}
\examples{
data(pinkham)
}
\keyword{datasets}

\eof
