### Name: cdens
### Title: Component Density for Parameterized MVN Mixture Models
### Aliases: cdens
### Keywords: cluster

### ** Examples

n <- 100 ## create artificial data

set.seed(0)
x <- rbind(matrix(rnorm(n*2), n, 2) %*% diag(c(1,9)),
           matrix(rnorm(n*2), n, 2) %*% diag(c(1,9))[,2:1])
xclass <- c(rep(1,n),rep(2,n))
clPairs(x, cl = xclass, sym = c("1","2")) ## display the data

set.seed(0)
I <- sample(1:(2*n)) ## random ordering of the data
x <- x[I, ]
xclass <- xclass[I]

odd <- seq(1, 2*n, by = 2)
oddBic <- EMclust(x[odd, ]) 
oddSumry <- summary(oddBic, x[odd, ]) ## best parameter estimates
names(oddSumry)

even <- odd + 1
temp <- cdens(modelName = oddSumry$modelName, data = x[even, ],
              mu = oddSumry$mu, decomp = oddSumry$decomp)
cbind(class = xclass[even], temp)

## alternative call 

temp <- do.call( "cdens", c(list(data = x[even, ]), oddSumry))
cbind(class = xclass[even], temp)



