### Name: cdensE
### Title: Component Density for a Parameterized MVN Mixture Model
### Aliases: cdensE cdensV cdensEII cdensVII cdensEEI cdensVEI cdensEVI
###   cdensVVI cdensEEE cdensEEV cdensVEV cdensVVV
### Keywords: cluster

### ** Examples

n <- 100 ## create artificial data

set.seed(0)
x <- rbind(matrix(rnorm(n*2), n, 2) %*% diag(c(1,9)),
           matrix(rnorm(n*2), n, 2) %*% diag(c(1,9))[,2:1])
xclass <- c(rep(1,n),rep(2,n))
clPairs(x, cl = xclass, sym = c("1","2")) ## display the data

modelVII <- meVII(x, z = unmap(xclass))
modelVVI <- meVVI(x, z = unmap(xclass))
modelVVV <- meVVV(x, z = unmap(xclass))

names(modelVII)
args(cdensVII)
cdenVII <- cdensVII(data = x, mu = modelVII$mu, pro = modelVII$pro,
                    decomp = modelVII$decomp)
names(modelVVI)
args(cdensVVI)
cdenVVI <- cdensVII(data = x, mu = modelVVI$mu, pro = modelVVI$pro,
                    decomp = modelVVI$decomp)
names(modelVVV)
args(cdensVVV)
cdenVVV <- cdensVVV( data = x, mu = modelVVV$mu, pro = modelVVV$pro,
                     cholsigma = modelVVV$cholsigma)

cbind(class=xclass,VII=map(cdenVII),VVI=map(cdenVVI),VVV=map(cdenVVV))

## alternative call
 
cdenVII <- do.call("cdensVII", c(list(data = x), modelVII))
cdenVVI <- do.call("cdensVVI", c(list(data = x), modelVVI))
cdenVVV <- do.call("cdensVVV", c(list(data = x), modelVVV))

cbind(class=xclass,VII=map(cdenVII),VVI=map(cdenVVI),VVV=map(cdenVVV))



