### Name: dens
### Title: Density for Parameterized MVN Mixtures
### Aliases: dens
### Keywords: cluster

### ** Examples

n <- 100 ## create artificial data

set.seed(0)
x <- rbind(matrix(rnorm(n*2), n, 2) %*% diag(c(1,9)),
           matrix(rnorm(n*2), n, 2) %*% diag(c(1,9))[,2:1])
xclass <- c(rep(1,n),rep(2,n))
clPairs(x, cl = xclass, sym = c("1","2")) ## display the data

set.seed(0)
I <- sample(1:(2*n))
x <- x[I, ]
xclass <- xclass[I]

odd <- seq(1, 2*n, by = 2)
oddBic <- EMclust(x[odd, ]) 
oddSumry <- summary(oddBic, x[odd, ]) ## best parameter estimates
names(oddSumry)

oddDens <- dens(modelName = oddSumry$modelName, data = x,
   mu = oddSumry$mu, decomp = oddSumry$decomp, pro = oddSumry$pro)
oddDens <- do.call("dens", c(list(data = x), oddSumry))  ## alternative call

even <- odd + 1
evenBic <- EMclust(x[even, ]) 
evenSumry <- summary(evenBic, x[even, ]) ## best parameter estimates
evenDens <- do.call( "dens", c(list(data = x), evenSumry))

cbind(class = xclass, odd = oddDens, even = evenDens)



