### Name: estep
### Title: E-step for parameterized MVN mixture models.
### Aliases: estep
### Keywords: cluster

### ** Examples

data(iris)
irisMatrix <- as.matrix(iris[,1:4])
irisClass <- iris[,5]

msEst <- mstep(modelName = "EII", data = irisMatrix, 
               z = unmap(irisClass))
names(msEst)

estep(modelName = msEst$modelName, data = irisMatrix,
      mu = msEst$mu, sigmasq = msEst$sigmasq, pro = msEst$pro)           
do.call("estep", c(list(data = irisMatrix), msEst))   ## alternative call



