### Name: estepE
### Title: E-step in the EM algorithm for a parameterized MVN mixture
###   model.
### Aliases: estepE estepV estepEII estepVII estepEEI estepVEI estepEVI
###   estepVVI estepEEE estepEEV estepVEV estepVVV
### Keywords: cluster

### ** Examples

data(iris)
irisMatrix <- as.matrix(iris[,1:4])
irisClass <- iris[,5]

msEst <- mstepEII(data = irisMatrix, z = unmap(irisClass))
names(msEst)

estepEII(data = irisMatrix, mu = msEst$mu, pro = msEst$pro, 
         sigmasq = msEst$sigmasq)
do.call("estepEII", c(list(data=irisMatrix), msEst)) ## alternative call



