### Name: randProj
### Title: Random projections for data in more than two dimensions modelled
###   by an MVN mixture.
### Aliases: randProj
### Keywords: cluster

### ** Examples

data(iris)
irisMatrix <- as.matrix(iris[,1:4])
irisClass <- iris[,5]

msEst <- mstepVVV(irisMatrix, unmap(irisClass))

par(pty = "s", mfrow = c(2,3))
randProj(irisMatrix, seeds = 0:5, truth=irisClass, 
         mu = msEst$mu, sigma = msEst$sigma, z = msEst$z)
do.call("randProj", c(list(data = irisMatrix, seeds = 0:5, truth=irisClass),
                           msEst))



