### Name: coding
### Title: combines two or more surrogate/auxiliary variables into a vector
### Aliases: coding
### Keywords: utilities

### ** Examples


## Not run: 
##D The ectopic data set has 3 categorical first-stage variables in columns 
##D 3 to 5, which together with column 2 are the predictor variables of the
##D dichotomous outcome in column 1 (see help(ectopic) for further details). Typing
## End(Not run)
data(ectopic)
coding(x=ectopic[,2:5],y=ectopic[,1], z=ectopic[,3:5])

## Not run: 
##D gives the following coding scheme and first-stage and second-stage 
##D sample sizes (n1 and n2 respectively)
## End(Not run)

## Not run: 
##D  ylevel gonnorhoea contracept sexpatr new.z  n1 n2
##D       0          0          0       0     1  56 13
##D       0          0          1       0     2 146 36
##D       0          0          0       1     3 119 33
##D       0          1          0       1     4  19  8
##D       0          0          1       1     5 344 93
##D       0          1          1       1     6  31  9
##D       1          0          0       0     1  26 11
##D       1          0          1       0     2   9  5
##D       1          0          0       1     3 160 79
##D       1          1          0       1     4  29 18
##D       1          0          1       1     5  35 20
##D       1          1          1       1     6   5  2
## End(Not run)



