### Name: ms.nprev
### Title: Logistic regression of two-stage data using second stage sample
###   and first stage sample sizes or proportions (prevalences) as input
### Aliases: ms.nprev
### Keywords: regression

### ** Examples


## Not run: 
##D As an illustrative example, we use a simulated data set, simNA.
##D Use
## End(Not run) 

data(simNA)        #to load the data
## Not run: and
help(simNA)        #for details

## Not run: The "complete cases" (i.e. second-stage data) can be extracted by:

complete=simNA[!is.na(simNA[,3]),]

## Not run: Running a logistic regression analysis on the complete data:

summary(glm(complete[,1]~complete[,3], family="binomial"))

## Not run: gives the following result
##D 
##D Call:
##D glm(formula = complete[, 1] ~ complete[, 3], family = "binomial")
##D 
##D Coefficients:
##D               Estimate Std. Error z value Pr(>|z|)    
##D (Intercept)    0.05258    0.09879   0.532    0.595    
##D complete[, 3]  1.01942    0.12050   8.460   <2e-16 ***
## End(Not run)

## Not run: 
##D The first and second stage sample sizes can be viewed by running
##D the "coding" function (see help(coding) for details)
## End(Not run)

coding(x=simNA[,3], y=simNA[,1], z=simNA[,2])
## Not run: which gives the following:
##D 
##D  [1] "For calls to ms.nprev, input n1 or prev in the following order!!"
##D      ylevel z new.z  n1  n2
##D [1,]      0 0     0 310 150
##D [2,]      0 1     1 166  85
##D [3,]      1 0     0 177  86
##D [4,]      1 1     1 347 179
## End(Not run)

## Not run: An analysis of all first- and second-stage data using Mean Score:

# supply the first stage sample sizes in the correct order
n1=c(310,166,177,347)
ms.nprev(x=complete[,3],z=complete[,2],y=complete[,1],n1=n1)

## Not run: gives the results:
##D [1] "please run coding function to see the order in which you"
##D [1] "must supply the first-stage sample sizes or prevalences"
##D [1] " Type ?coding for details!"
##D [1] "For calls to ms.nprev,input n1 or prev in the following order!!"
##D      ylevel z new.z  n2
##D [1,]      0 0     0 150
##D [2,]      0 1     1  85
##D [3,]      1 0     0  86
##D [4,]      1 1     1 179
##D [1] "Check sample sizes/prevalences"
##D $table
##D      ylevel zlevel  n1  n2
##D [1,]      0      0 310 150
##D [2,]      0      1 166  85
##D [3,]      1      0 177  86
##D [4,]      1      1 347 179
##D 
##D $parameters
##D                   est         se          z    pvalue
##D (Intercept) 0.0493998 0.07155138  0.6904103 0.4899362
##D x           1.0188437 0.10187094 10.0013188 0.0000000
## End(Not run)

## Not run: If we supply the prevalances instead of first stage sample sizes
p1=c(310,166,177,347)/1000
ms.nprev(x=complete[,3],z=complete[,2],y=complete[,1],prev=p1)

## Not run: we get the output:
##D 
##D       ylevel zlevel  prev  n2
##D [1,]      0      0 0.310 150
##D [2,]      0      1 0.166  85
##D [3,]      1      0 0.177  86
##D [4,]      1      1 0.347 179
##D 
##D $parameters
##D                    est
##D (Intercept) 0.04939797
##D x           1.01885599
## End(Not run)

## Not run: 
##D Note that the Mean Score algorithm produces smaller 
##D standard errors of estimates than the complete-case
##D analysis, due to the additional information in the
##D incomplete cases.
## End(Not run)



