\name{aphids}
\alias{aphids}
\title{
Data on the rate of infection of tobacco plants by a virus
spread by aphids.
}
\description{
The \code{aphids} data frame has 51 rows and 2 columns.
These correspond to 51 independent experiments in which varying
numbers of aphids were released in a flight chamber containing
12 infected and 69 healthy tobacco plants.  The resulting number
of infected plants was recorded.
}
\usage{
data(aphids)
}
\format{
This data frame contains the following columns:
\describe{
\item{\code{n.aphids}}{
the number of aphids released in the flight chamber in
each instance
}
\item{\code{n.inf}}{
the resulting number (out of a possible 69) of infected plants
}}}
\source{
These data appear courtesy of Gilles Boiteau and George Tai of the
Potato Research Centre, Agriculture and Agri-Food Canada,
Fredericton, New Brunswick.  Any published work using these data
should cite the paper given in the \bold{References}.
}
\references{
Boiteau, G., M. Singh, R. P. Singh, G. C. C. Tai, and T. R. Turner
(1998).  Rate of spread of PVY-n by alate Myzus persicae (Sulzer)
from infected to healthy plants under laboratory conditions.  Potato
Research, vol. 41, pp. 335 -- 344.
}
\section{DETERMINATION OF INFECTION}{
After 24 hours, the flight chamber was fumigated to kill the aphids, and the
previously healthy plants were moved to a greenhouse and monitored to
detect symptoms of infection.  The number of plants displaying such
symptons was recorded.
}
\keyword{datasets}
% Converted by Sd2Rd version 1.21.

\eof
\name{bootcomp}
\alias{bootcomp}
\title{
Perform a bootstrap test for the number of components in a mixture
of regressions.
}
\description{
Produces nboot bootstrap realizations of the likelihood ratio statistic,
either parametrically or semi-parametrically, and calculates the
corresponding p-value of the test.
}
\usage{
bootcomp(x, y, ncomp=2, ncincr=1, intercept=TRUE, nboot=1000,
         ts1=NULL, ts2=NULL, sem.par=FALSE, verb=FALSE,
         print.prog=TRUE, \dots)
}
\arguments{
\item{x}{
A matrix of predictors for each of the regression models in the
mixture.  It should NOT include an initial column of 1s.  If there is
only one predictor, x may be a vector.
}
\item{y}{
The vector of responses for the regression models.
}
\item{ncomp}{
The null-hypothesized number of components in the mixture.
}
\item{ncincr}{
The increment from the null-hypothesized number of components in the mixture
to the number under the alternative hypothesis; i.e. the number
of components under the alternative hypothesis is ncomp + ncincr.
}
\item{intercept}{
Logical argument indicating whether the regression models in the mixture
should have intercept terms.
}
\item{nboot}{
The number of bootstrap replicates of the log likelihood ratio statistic
to be produced.
}
\item{ts1}{
Starting values for fitting the ncomp component model.  If ts1 is
null, random starting values are used.  (This is not recommended.)
}
\item{ts2}{
Starting values for fitting the ncomp+nincr component model.  If ts2 is
null, random starting values are used.  (This is not recommended.)
}
\item{sem.par}{
Logical argument indicating whether semi-parametric bootstrapping
should be used.
}
\item{verb}{
Logical argument indicating whether the fitting processes should
be verbose (i.e. whether details should be printed out at each
step of the EM algorithm).  If TRUE a huge amount of
screen output is produced.
}
\item{print.prog}{
Logical argument indicating whether the index of the bootstrap
replicate just completed should be printed out, to give an idea
of how the process is progressing.
}
\item{...}{
Further arguments to be passed to mixreg to control the fitting
procedure.
}}
\value{
A list (of class "mixreg") with components

\item{lrs}{
The log likelihood ratio statistic for testing that the number of
components is ncomp versus that it is ncomp + nincr.
}
\item{aic.ncomp}{
The vector (with dimension nboot) of Akaike Information Criterion
values for each of the fitted ncomp component models fitted to
bootstrap data sets.  The value of ncomp is substituted in the
name; e.g. if ncomp = 2 then the name of this component of
the returned list is "aic.2".
}
\item{aic.ncomp+ncincr}{
The vector (with dimension nboot) of Akaike Information Criterion
values for each of the fitted ncomp+ncincr component models fitted to
bootstrap data sets.  The value of ncomp+ncincr is substituted in the
name; e.g. if ncomp = 2 and ncrinc=1, then the name of this component
of the returned list is "aic.3".
}
\item{pval.boot}{
The p-value of the hypothesis test from the bootstrapping
procedure.  It is calculated as sum(lrs <= lrs.boot)/nboot.
}
\item{lrs.boot}{
The vector of bootstrap replicates of the log likelihood ratio statistic
}
\item{screw.ups}{
A list giving information about the screw-ups that have occured in the
bootstrapping procedure; it includes the values of .Random.seed that
lead to the data causing the screw-up so that the difficulty may
be re-produced and examined if so desired.  See the comments in
the code for the meaning of the various ``types'' of screw-up.
The "times" component of the screw.ups list gives the index of
the bootstrap replicate that was being worked on when the screw-up
occured.  Note that if a screw-up does occur, the replicate is
redone completely.
}}
\details{
In parametic bootstrapping the bootstrap data sets are generated
by simulating from the fitted ncomp model parameters, using Gaussian
errors.  In semi-parametric bootstrapping the errors are generated
by resampling from the residuals.  Since at each predictor vector
there are ncomp residuals, one for each component of the model,
the errors are selected from these ncomp possibilities.  The
selection probabilities at this step are the conditional probabilities,
of the observation being generated by each component of the model,
given that observation.  These probabilities depend on the parameters
of the model whence the procedure is semi-parametric.
}
\references{
Turner, T. R.  Estimating the rate of spread of a viral infection
of potato plants via mixtures of regressions.  Submitted for
publication, 1998.
}
\seealso{
\link{cband}, \link{covmix}, \link{mixreg}, \link{plot.cband},
\link{plot.mresid}, \link{qq.mix}, \link{resid.mix}
}
\examples{
TS1 <- list(list(beta=c(3.0,0.1),sigsq=16,lambda=0.5),
            list(beta=c(0.0,0.0),sigsq=16,lambda=0.5))
TS2 <- list(list(beta=c(3.0,0.1),sigsq=9,lambda=1/3),
            list(beta=c(1.5,0.05),sigsq=9,lambda=1/3),
            list(beta=c(0.0,0.0),sigsq=9,lambda=1/3))
data(aphids)
x <- aphids$n.aphids
y <- aphids$n.inf
\dontrun{
  nboot <- 1000
}
\testonly{
  nboot <- 10
}
boot.23 <- bootcomp(x,y,nboot=nboot,ts1=TS1,ts2=TS2)
}
% Converted by Sd2Rd version 1.21.
\keyword{models}
\keyword{regression}

\eof
\name{cband}
\alias{cband}
\title{
Calculate confidence and prediction bands for mixtures of one-variable
regressions.
}
\description{
Produces confidence and prediction bands, two-sided or upper or
lower, for the lines fitted in a model consisting of a mixture of
one-variable regressions.
}
\usage{
cband(object, cov.mat, x, y, alpha=0.05, xlen=100, plotit=FALSE,
      type=NULL)
}
\arguments{
\item{object}{
Object describing the fitted mixture of regressions, as returned
by mixreg.
}
\item{cov.mat}{
The estimated covariance matrix of the parameter estimates of the
fit, as returned by covmix.
}
\item{x}{
The vector of predictors for each of the regression models in the
mixture.  Only one-dimensional predictors are permitted here.
}
\item{y}{
The vector of responses for the regression models.
}
\item{alpha}{
One minus the confidence level for the confidence and prediction
bands; e.g. alpha = 0.05 for 95\% confidence.
}
\item{xlen}{
The number of points to be plotted in the band envelopes.  The
x-values of the points will be equi-spaced from min(x) to max(x).
}
\item{plotit}{
Logical argument indicating whether to plot the fitted model
and confidence bands.
}
\item{type}{
Character argument specifying the type of band.  Must have one
of the values "both", "upper", or "lower".  Defaults to "both".
}}
\value{
A list (of class "cband") with components

\item{theta}{
The parameter list from object (as returned by mixreg).
}
\item{intercept}{
The logical value from object indicating whether intercepts were fitted.
}
\item{x}{
The argument x of the call to cband.
}
\item{y}{
The argument y of the call to cband.
}
\item{xf}{
The equispaced sequence of values from min(x) to max(x) at which the
values of the band envelopes were calculated.
}
\item{bnds}{
A list with one entry for each component of the mixture.  Each entry
is a matrix with 4 columns (lower and upper confidence, lower and upper
prediction bounds) if type is "both", or with 2 columns (confidence
bounds, prediction bounds) if type is "upper" or "lower".
}}
\section{Side Effects}{
If plotit is TRUE a plot of the fit and the confidence and prediction
bands is produced in whatever device is currently open.
}
\details{
The prediction bands are conditional in that the associated probability
is condtional upon the associated observation being generated by
the relevant component of the mixture.
}
\references{
Turner, T. R.  (2000) Estimating the rate of spread of a viral infection
of potato plants via mixtures of regressions.  Appl. Statist. vol. 49,
Part 3, pp. 371 -- 384.
}
\seealso{
\link{bootcomp}, \link{covmix}, \link{mixreg}, \link{plot.cband},
\link{plot.mresid}, \link{qq.mix}, \link{resid.mix}
}
\examples{
#See \link{mixreg} for examples.
}
% Converted by Sd2Rd version 1.21.
\keyword{models}
\keyword{regression}

\eof
\name{covmix}
\alias{covmix}
\title{
Calculate the covariance matrix of the parameter estimates for a
mixture of regressions.
}
\description{
Produces an estimate of the covariance matrix of the parameter
estimates for a fitted mixture of linear regressions, by inverting
the observed Fisher information matrix.
}
\usage{
covmix(object, x, y)
}
\arguments{
\item{object}{
Object describing the fitted mixture of regressions, as returned
by mixreg.
}
\item{x}{
A matrix of predictors for each of the regression models in the
mixture.  It should NOT include an initial column of 1s.  If there is
only one predictor, x may be a vector.
}
\item{y}{
The vector of responses for the regression models.
}}
\value{
The estimated covariance matrix.
}
\details{
If different variances are allowed amongst the components, the
parameters are taken in the order beta.1, sigsq.1, lambda.1, \dots,
beta.K, sigsq.K for a K component model --- lambda.K is redundant and
hence omitted.  If equal variances are assumed, the parameters are
taken in the order beta.1, lambda.1, \dots, beta.K, sigsq.


In the foregoing beta refers to the linear coefficients, sigsq to
the variance, and lambda to the mixing probability.
}
\references{
Turner, T. R.  (2000) Estimating the rate of spread of a viral infection
of potato plants via mixtures of regressions.  Appl. Statist. vol. 49,
Part 3, pp. 371 -- 384.

Louis, T. A.  Finding the observed information matrix when using the
EM algorithm, J. R. Statist. Soc. B, vol. 44, pp. 226 -- 233, 1982.
}
\seealso{
\link{bootcomp}, \link{cband}, \link{mixreg}, \link{plot.cband},
\link{plot.mresid}, \link{qq.mix}, \link{resid.mix}
}
\examples{
#See \link{mixreg} for examples.
}
% Converted by Sd2Rd version 1.21.
\keyword{models}
\keyword{regression}

\eof
\name{mixreg-internal}
\alias{aux1}
\alias{aux2}
\alias{aux3}
\alias{boot.sam}
\alias{dir.sum}
\alias{gfun}
\alias{hatfun}
\alias{info1}
\alias{info2}
\alias{init.rand}
\alias{simmix}

\title{Internal mixreg functions}
\description{
  Internal mixreg functions.
}
\usage{
aux1(gma,k,l)
aux2(t11,t12,t13,t21,t22,t23,t31,t32,t33)
aux3(m,ind)
boot.sam(mu,resid,prob)
dir.sum(...)
gfun(x,y,theta)
hatfun(x,g)
info1(x,y,theta,gma)
info2(x,y,theta,gma)
init.rand(x,y,K,intercept)
simmix(theta,intercept,x) 
}

\details{
  These are usually not to be called by the user.
}
\keyword{internal}

\eof
\name{mixreg}
\alias{mixreg}
\title{
Fit a mixture of linear regressions.
}
\description{
Estimates the parameters for a mixture of linear regressions, assuming
Gaussian errors, using the EM algorithm.
}
\usage{
mixreg(x, y, ncomp=2, intercept=TRUE, eq.var=FALSE,
       theta.start=NULL, itmax=1000, eps=1e-06, verb=TRUE,
       digits=7, max.try=5, data.name=NULL)
}
\arguments{
\item{x}{
A matrix of predictors for each of the regression models in the
mixture.  It should NOT include an initial column of 1s.  If there is
only one predictor, x may be a vector.
}
\item{y}{
The vector of responses for the regression models.
}
\item{ncomp}{
The number of components in the mixture.
}
\item{intercept}{
Logical argument specifying whether the linear regressions should
have intercepts fitted.
}
\item{eq.var}{
Logical argument specifying whether the error variance should be the
same for all components, or each component should be allowed
a different error variance.
}
\item{theta.start}{
A list giving starting values for the estimation procedure.  Each
component of the list is in turn a list with components beta
(vector of linear coefficients), sigsq (variance) and lambda
(mixing probability).  If eq.var is TRUE, then it is sensible
to have all the starting values of sigsq equal, but this is not
strictly necessary.  If theta.start is not specified, starting
values are generated randomly.  This is NOT recommended.
}
\item{itmax}{
The maximum number of EM steps to be undertaken.
}
\item{eps}{
A value specifying the convergence criterion for the EM algorithm.
If the maximum absolute value of the change in the parameters is
less than eps the algorithm is considered to have converged.
}
\item{verb}{
Logical argument; if verb is TRUE then details of the progress
of the algorithm are printed out at each EM step.
}
\item{digits}{
The number of digits to which the details are printed out, when
verb is TRUE.
}
\item{max.try}{
If the algorithm encounters a singularity in the likelihood
(as may occur when eq.var is FALSE) the algorithm is restarted
using new (randomly generated) starting values.  The restart
is attempted a maximum of max.try times.
}
\item{data.name}{
A character string specifying a name associated with the data
being analyzed, for identification purposes.
}}
\value{
A list, of class mixreg, with components

\item{parmat}{
The parameters of the fitted model arranged as a matrix, each
row corresponding to one component of the mixture.
}
\item{theta}{
The parameters of the fitted model as a list, each entry of
the list being itself a list (like those in theta.start) corresponding
to one component of the mixture.
}
\item{log.like}{
The log likelihood of the fitted model, based on Gaussian errors.
}
\item{aic}{
The Akaike Information Criterion value for the fitted model;
aic is equal to -2 * log.like + 2*M where M is the number of
parameters in the model.
}
\item{intercept}{
The intercept argument of the call to mixreg.
}
\item{eq.var}{
The eq.var argument of the call to mixreg.
}
\item{bnms}{
A vector of names associated with the linear components of the
regression models.  The names are formed from the column names of the
argument x if these exist; otherwise they are "beta1", "beta2", \dots.
The name "Int" is prepended if intecept is TRUE.
}
\item{nsteps}{
The number of steps the EM algorithm took to converge.
}
\item{converged}{
Logical value indicating whether the algorithm did converge or
stopped because it reach the itmax EM step.
}
\item{data.name}{
The data.name argument if supplied; otherwise is formed as
"name-of-y.on.name-of-x".
}}
\details{
Even if eq.var is TRUE, each component of theta still has its own sigsq
component.  The values of these will all be equal however if eq.var
is TRUE.
}
\references{
Turner, T. R.  (2000) Estimating the rate of spread of a viral infection
of potato plants via mixtures of regressions.  Appl. Statist. vol. 49,
Part 3, pp. 371 -- 384.

Dempster, A. P., Laird, N. M., and Rubin, D. B.  Maximum likelihood
from incomplete data via the EM algorithm, J. Royal Statist. Soc. B,
vol. 39, pp. 1--22, 1977.
}
\seealso{
\link{bootcomp}, \link{cband}, \link{covmix}, \link{plot.cband},
\link{plot.mresid}, \link{qq.mix}, \link{resid.mix}
}
\examples{
data(aphids)
x   <- aphids$n.aphids
y   <- aphids$n.inf
TS  <- list(list(beta=c(3.0,0.1),sigsq=16,lambda=0.5),
            list(beta=c(0.0,0.0),sigsq=16,lambda=0.5))
fit <- mixreg(x,y,ncomp=2,theta.start=TS,data.name='aphids')
cvm <- covmix(fit,x,y)
cbd <- cband(fit,cvm,x,y)
plot(cbd)
r <- resid.mix(fit,x,y)
plot(r)
r <- resid.mix(fit,x,y,std=TRUE)
qq.mix(r)
}
% Converted by Sd2Rd version 1.21.
\keyword{models}
\keyword{regression}

\eof
\name{plot.cband}
\alias{plot.cband}
\title{
Plot confidence bands for a mixture of regressions.
}
\description{
Plots the fitted lines and confidence and prediction bands as
calculated by cband, for a mixture of regressions on one variable.
}
\usage{
plot.cband(x, cbands=TRUE, pbands=TRUE, xlab=NULL, ylab=NULL,
           main=NULL, \dots)
}
\arguments{
\item{x}{
An object specifying the fitted lines and confidence and
prediction bands, as produced by cband.
}
\item{cbands}{
Logical argument specifying whether to plot the confidence bands.
}
\item{pbands}{
Logical argument specifying whether to plot the prediction bands.
}
\item{xlab}{
Character string specifying a label for the x-axis; defaults to "x".
}
\item{ylab}{
Character string specifying a label for the y-axis; defaults to "y".
}
\item{main}{
Character string specifying a title for the plot; if it is not
specified a default title is formed.  If no title at all is desired,
specify main="".
}
\item{\dots}{
Optional extra arguments; not currently used.
}
}
\section{Side Effects}{
A plot is produced in whatever device is currently open.
}
\details{
This function is a "method" for plot.  Note that a simple plot
of the fit may be produced by specifying both cbands=FALSE and pbands=FALSE.
}
\seealso{
\link{bootcomp}, \link{cband}, \link{covmix}, \link{mixreg},
\link{plot.mresid}, \link{qq.mix}, \link{resid.mix}
}
\examples{
#See \link{mixreg} for examples.
}
% Converted by Sd2Rd version 1.21.
\keyword{models}
\keyword{regression}

\eof
\name{plot.mresid}
\alias{plot.mresid}
\title{
Plot residuals for a fitted mixture of linear regressions.
}
\description{
Plots the residuals against predictors or fitted values using symbols
whose size is proportional to the probability that the associated
observation was generated by the associated component of the model.
}
\usage{
plot.mresid(x, vs.fit=FALSE, whichx=1, shape="disc",
            ngon=20, size=1, xlab=NULL, \dots)
}
\arguments{
\item{x}{
A list with components containing the residuals, the relevant
probabilities, the predictors, and the observations, as returned
by resid.mix.  When plotting against fitted values, it is probably
better to used the standardized residuals, i.e. resid.mix should
be called with std=TRUE.
}
\item{vs.fit}{
Logical argument.  If TRUE the residuals are plotted versus the
fitted values.
}
\item{whichx}{
Indicates which predictor to plot against if there is more than
one; i.e. indicates which column of the x matrix to use.  If vs.fit
is TRUE, whichx is ignored.
}
\item{shape}{
The shape of the plotting symbol; possible values are "disc",
"square", and "diamond".  Partial matching is used so only
the first few letters need be given.
}
\item{ngon}{
The "disc" shape is actually a regular polygon; ngon specifies
how many sides it should have; ignored if shape is not equal
to "disc".
}
\item{size}{
A scale factor to change the absolute sizes of the plotting
symbols; values larger than 1 make the symbols larger; values
less than 1 make them smaller.
}
\item{xlab}{
The x label for the plot; defaults to "x".
}
\item{...}{
Additional arguments to be passed to the polygon function which
actually draws the plotting symbols.
}}
\section{Side Effects}{
A residual plot is produced in whatever device is currently open.
}
\details{
This function is a "method" for plot.  The plot produced is visually
assessed by ignoring or discounting small symbols.
}
\references{
Turner, T. R.  (2000) Estimating the rate of spread of a viral infection
of potato plants via mixtures of regressions.  Appl. Statist. vol. 49,
Part 3, pp. 371 -- 384.
}
\section{ACKNOWLEDGEMENT}{
The idea of creating residual plots for regression mixtures
by making the symbol size proportional to the associated
probability is due to Adrian Baddeley of the University
of Western Australia.
}
\seealso{
\link{bootcomp}, \link{cband}, \link{covmix}, \link{mixreg},
\link{plot.cband}, \link{qq.mix}, \link{resid.mix}
}
\examples{
#See \link{mixreg} for examples.
}
% Converted by Sd2Rd version 1.21.
\keyword{models}
\keyword{regression}
\keyword{hplot}

\eof
\name{qq.mix}
\alias{qq.mix}
\title{
Draw a normal quantile-quantile plot of the residuals from
a fitted mixture of linear regressions.
}
\description{
Draws a normal quantile-quantile plot using symbols
whose size is proportional to the probability that the associated
observation was generated by the associated component of the model.
}
\usage{
qq.mix(object, xlim=NULL, ylim=NULL, shape="disc", ngon=20,
       size=1, \dots)
}
\arguments{
\item{object}{
A list with components containing the residuals, the relevant
probabilities, the predictors, and the observations, as returned
by resid.mix; probably the residuals should be standardized for
use by qq.mix, i.e. resid.mix should be called with std=TRUE.
}
\item{xlim}{
The limits (endpoints) of the x axis of the plot; chosen in
the "usual" way by the plotting software if xlim is NULL.
}
\item{ylim}{
The limits (endpoints) of the y axis of the plot; chosen in
the "usual" way by the plotting software if ylim is NULL.
}
\item{shape}{
The shape of the plotting symbol; possible values are "disc",
"square", and "diamond".  Partial matching is used so only
the first few letters need be given.
}
\item{ngon}{
The "disc" shape is actually a regular polygon; ngon specifies
how many sides it should have; ignored if shape is not equal
to "disc".
}
\item{size}{
A scale factor to change the absolute sizes of the plotting
symbols; values larger than 1 make the symbols larger than
the default; values less than 1 make them smaller.
}
\item{...}{
Additional arguments to be passed to the polygon function which
actually draws the plotting symbols.
}}
\section{Side Effects}{
A normal quantile-quantile plot is drawn in whatever device
is currently open.
}
\details{
The plot produced is visually assessed by ignoring or discounting
small symbols.
}
\references{
Turner, T. R.  (2000) Estimating the rate of spread of a viral infection
of potato plants via mixtures of regressions.  Appl. Statist. vol. 49,
Part 3, pp. 371 -- 384.
}
\section{ACKNOWLEDGEMENT}{
The idea of creating quantile-quantile plots for regression mixtures
by making the symbol size proportional to the associated probability
is due to Adrian Baddeley of the University of Western Australia
}
\seealso{
\link{bootcomp}, \link{cband}, \link{covmix}, \link{mixreg},
\link{plot.cband}, \link{plot.mresid}, \link{resid.mix}
}
\examples{
#See \link{mixreg} for examples.
}
% Converted by Sd2Rd version 1.21.
\keyword{models}
\keyword{regression}
\keyword{hplot}

\eof
\name{resid.mix}
\alias{resid.mix}
\title{
Calculate the residuals of a mixture of linear regressions.
}
\description{
Calculates the residuals from each component of the mixture
and the matrix of probabilities that each observation was generated
by each component.
}
\usage{
resid.mix(object, x, y, std=FALSE)
}
\arguments{
\item{object}{
List describing the fitted mixture of regressions as returned by
mixreg.
}
\item{x}{
The matrix of predictors to which the mixture has been fitted.
If there is only one predictor then x may be a vector.
}
\item{y}{
The vector of observed values to which the mixture has been fitted.
}
\item{std}{
Logical argument; if TRUE then the residuals are standardized
(by dividing them by their estimated standard deviation).
}}
\value{
A list (of class "mresid") with components

\item{resid}{
The residuals of the model in a matrix.  The k-th column of
this matrix is the vector of residuals from the k-th component
of the model.
}
\item{gamma}{
The matrix of probabilities that each observation was generated
by each component
}
\item{x}{
The x argument of the call to resid.mix
}
\item{y}{
The y argument of the call to resid.mix
}}
\details{
The calculation of the estimated standard deviations of the
residuals is a little bit complicated since each component of
the model is fitted using weighted regression in a setting in
which the weights are NOT the reciprocals of error variances.
See the reference below for more detail.
}
\references{
Turner, T. R.  (2000) Estimating the rate of spread of a viral infection
of potato plants via mixtures of regressions.  Appl. Statist. vol. 49,
Part 3, pp. 371 -- 384.
}
\seealso{
\link{bootcomp}, \link{cband}, \link{covmix}, \link{mixreg},
\link{plot.cband}, \link{plot.mresid}, \link{qq.mix}
}
\examples{
#See \link{mixreg} for examples.
}
% Converted by Sd2Rd version 1.21.
\keyword{models}
\keyword{regression}

\eof
