### Name: mmlcr
### Title: Mixed Mode Latent Class Regression
### Aliases: mmlcr mmlcr.default mmlcr.mmlcr anova.mmlcr formula.mmlcr
###   logLik.mmlcr print.mmlcr print.summary.mmlcr summary.mmlcr vcov.mmlcr
### Keywords: models

### ** Examples

data(mmlcrdf)

mmlcrdf.mmlcr2 <- mmlcr(outer =  ~ sex + cov1 | id, 
components = list(
        list(formula = resp1 ~ 1, class = "cnormonce", min = 0, max = 50),
        list(formula = resp2 ~ poly(age, 2) + tcov1, class = "poislong"),
        list(formula = resp3 ~ poly(age, 2), class = "multinomlong")
), data = mmlcrdf, n.groups = 2)

mmlcrdf.mmlcr2.inter <- mmlcr(outer =  ~ sex * cov1 | id, 
components = list(
        list(formula = resp1 ~ 1, class = "cnormonce", min = 0, max = 50),
        list(formula = resp2 ~ poly(age, 2) + tcov1, class = "poislong"),
        list(formula = resp3 ~ poly(age, 2), class = "multinomlong")
), data = mmlcrdf, n.groups = 2,
post.prob = mmlcrdf.mmlcr2$post.prob, no.fit = TRUE)

mmlcrdf.mmlcr2.inter <- mmlcr(mmlcrdf.mmlcr2.inter)



