
\name{BIC.mmlcr}
\title{Bayesian Information Criterion}
\usage{
\method{BIC}{mmlcr}(object, ...)
}
\alias{BIC.mmlcr}

\arguments{
 \item{object}{a fitted mmlcr object.}
 \item{\dots}{optional fitted model objects.}
}
\description{
  This generic function calculates the Bayesian information criterion,
  also known as Schwarz's Bayesian criterion (SBC), for an mmlcr object for which a log-likelihood value can be obtained,
  according to the formula \eqn{-2 \mbox{log-likelihood} + n_{par}
    \log(n_{obs})}{-2*log-likelihood + npar*log(nobs)}, where
  \eqn{n_{par}}{npar}  represents the
  number of parameters and \eqn{n_{obs}}{nobs} the number of
  observations in the fitted model. 
}
\value{
 if just one object is provided, returns a numeric value with the
 corresponding BIC; if more than one object are provided, returns a
 \code{data.frame} with rows corresponding to the objects and columns
 representing the number of parameters in the model (\code{df}) and the
 BIC.
}
\references{
  Schwarz, G. (1978) "Estimating the Dimension of a Model", Annals of
  Statistics, 6, 461-464.
}
\seealso{\code{\link{AIC}}, \code{\link{mmlcrObject}}}
\examples{
\dontrun{data(mmlcrdf)}
\dontrun{mmlcrdf.mmlcr2 <- mmlcr(outer =  ~ sex + cov1 | id, 
components = list(
	list(formula = resp1 ~ 1, class = "cnormonce", min = 0, max = 50),
	list(formula = resp2 ~ poly(age, 2) + tcov1, class = "poislong"),
	list(formula = resp3 ~ poly(age, 2), class = "multinomlong")
), data = mmlcrdf, n.groups = 2)}

\dontrun{BIC(mmlcrdf.mmlcr2)}
}
\keyword{models}


\eof
\name{Srcdfull}
\alias{Srcdfull}
\title{ Longitudinal Dataset of Aggression and Reading Ability in Children. }
\usage{data(Srcdfull)}
\description{
The \code{Srcdfull} data frame has 1620 rows and 9 columns.
It is a longitudinal dataset from 405 children  with scores for aggression 
and reading ability.}
\format{
  This data frame contains the following columns:
  \describe{
    \item{id}{Subject id.}
    \item{sex}{A factor variable with the sex of each subject.}
    \item{age}{Age of subject at time of interview.}
    \item{anti}{Antisocial score, an integer from 0 to 12.}
    \item{read}{Reading ability score, ranging from 0 to 8.4.}
    \item{momage}{Mother's age at first interview.}
    \item{kidage}{Subject's age at first interview.}
    \item{homecog}{An integer score, ranging from 0 to 14, 
        at the first interview for cognitive stimulation at home.}
    \item{homeemo}{An integer score, ranging from 0 to 14, 
        at the first interview for emotional support at home.}
  }
}
\details{
 The sample consists of N=405 children drawn from the Children of 
 the National Longitudinal Survey of Youth, about half of whom are 
 missing one or more of the repeated measures on aggression or reading 
 ability. 
 The measures of interest include four repeated measures of aggressive 
 behavior taken at two-year intervals, four repeat measures of reading 
 achievement taken at two-year intervals, initial interview measures of 
 cognitive stimulation and social support of the child in the home, and 
 background measures of child gender, child age, and mother age.
}
\source{
\url{http://www.unc.edu/~curran/srcd-docs/srcddata.txt}
}
\references{
\url{http://www.unc.edu/~curran/srcd-docs/srcdmeth.pdf}
}
\examples{
data(Srcdfull)
Srcdfull.mmlcr4 <- mmlcr(outer = ~1 | id, components = list(
    list(formula = anti ~ poly(age, 2), min = 0, max = 12, 
    class = "cnormlong"), 
    list(formula = read ~ poly(age, 2), class = "normlong")), 
    data = Srcdfull, n.groups = 4)
}
\keyword{datasets}


\eof
\name{dcnorm}
\alias{dcnorm}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Density function for Censored Normal Distribution }
\description{
  Density function for the censored (not truncated!) normal distribution
  in a form suitable for mmlcrlike
}
\usage{
dcnorm(x, mean = rep(0, length(x)), sigma = rep(1, length(x)), 
	min = rep(.Machine$double.xmin, length(x)), 
	max = rep(.Machine$double.xmax, length(x)))
}
\arguments{
  \item{x}{ vector of quantiles }
  \item{mean}{ vector of means}
  \item{sigma}{ vector of standard deviations }
  \item{min}{ vector of left censoring cutoffs }
  \item{max}{ vector of right censoring cutoffs }
}

\value{
  A vector of densities.
}

\seealso{\code{\link{mmlcr}}, \code{\link{mmlcrlike}} }

\examples{

dcnorm(0, mean = 0, sigma = 1)

dcnorm(0, mean = 0, sigma = 1, min = 0)
}
\keyword{distribution}


\eof
\name{dnb2}
\alias{dnb2}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Density for negative binomial, used in mmlcr}
\description{
The density for the negative binomial function, in a form suitable for the mmlcrlike function.}
\usage{
dnb2(y, mu, th)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{y}{Observations }
  \item{mu}{The mean of the distribution }
  \item{th}{ The parameter \eqn{\theta}. }
}
\details{
  The variance function of the distribution is \eqn{\mu +\mu^2/\theta}.
  
  The density is 
  \deqn{
  f(y) = \frac{\Gamma(\theta + y) \mu^y \theta^\theta}{\Gamma(\theta) y! (\mu + \theta)^(\mu+\theta)}.
}{%
f(y) = [Gamma(th + y) mu^y theta^th] 
		/ [Gamma(th) y! (mu + th)^(mu + th)].
}
}
\value{
  The density.
}
\references{Venables, W. N. and Ripley, B. D. 2002 \emph{Modern Applied Statistics with S}, Springer Verlag. }

\seealso{ \code{\link{mmlcr}}, \code{\link{mmlcrlike}} }
\keyword{distribution}

\eof
\name{fitted.mmlcr}
\alias{fitted.mmlcr}
\alias{residuals.mmlcr}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ Extract mmlcr Model Component Fitted or Residual Values }
\description{
  Extract fitted or residual values from components of a mmlcr object.
}
\usage{
fitted.mmlcr(object, which = 1:length(object$components), ...)
residuals.mmlcr(object, which = 1:length(object$components), ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{object}{ Fitted mmlcr object. }
  \item{which}{ Which components to extract fit or residuals from}
  \item{\dots}{ Included for compatibility with generic functions. }
}
\details{
  For each observation in a component, the fit is the weighted mean of
  the fits from the individual class fits. The weights are the posterior class
  membership probabilities.
}
\value{
  A list, with a vector of fits or residuals for each component in which.
}

\section{WARNING }{Although the function works on multinom components,
the results are not meaningful.}

\keyword{models}


\eof
\name{mmlcr}
\alias{mmlcr}
\alias{mmlcr.default}
\alias{mmlcr.mmlcr}
\alias{anova.mmlcr}
\alias{formula.mmlcr}
\alias{logLik.mmlcr}
\alias{print.mmlcr}
\alias{print.summary.mmlcr}
\alias{summary.mmlcr}
\alias{vcov.mmlcr}         


\title{
Mixed Mode Latent Class Regression
}
\description{
This function fits a latent class regression model, where the responses may be of
different types, as well as longitudinal or time-invariant.
}
\usage{
mmlcr(object = NULL, ...)
\method{mmlcr}{default}(object = NULL, outer, components, data, 
	subset = TRUE, n.groups = 2, prior.prob = NULL, 
	post.prob = NULL, no.fit = FALSE, max.iter = 50, trace = TRUE, 
	tol = 0.005, ...)
\method{mmlcr}{mmlcr}(object, max.iter = 50, trace = TRUE, tol = 0.005, ...)
}
\arguments{
\item{outer}{
a formula of the form  \code{~ predictors | id} where the model statement for predictors is
as for regression models and \code{id} is the subject factor.  The expression \code{1} can be used 
for the predictors when there is no other suitable candidate. 
}
\item{components}{
a list of the response components. Each element of the list is itself a list. 
At a minimum, that list consists of a formula of the form \code{resp ~ covars}, where \code{resp} is the
response variable for that component and \code{covars} are any additional 
covariates (\code{resp ~ 1} is commonly used, or something like \code{resp ~ age} for longitudinal classes), 
and a class. Implemented classes include 
\code{cnormlong}, \code{cnormonce}, \code{multinomlong}, \code{multinomonce}, \code{nb1long},  \code{nblong}, \code{nbonce}, 
\code{normlong}, \code{normonce}, \code{poislong}, and \code{poisonce}. Some classes require additional list 
elements. Details can be found with the \code{mmlcrcomponentinit} help files.
}
\item{data}{
a data frame in which to interpret the variables occurring in outer and in the 
formulas for the individual components.
}

\item{subset }{
expression giving which subset of the rows of the data should be used in the fit. 
All observations are included by default.
}
\item{n.groups}{
the number of latent classes.
}
\item{prior.prob }{
a data.frame giving the prior probabilities of class membership according 
to covariate information, not ``prior knowledge.'' The row.names should
match the subject id given in outer. If no value is given, which is recommended, the
default is equal probabilities.
}
\item{post.prob }{
a data.frame giving the posterior probabities of class membership. The row.names 
should match the subject id given in outer. If \code{post.prob} is not given, starting values
are assigned randomly. If one is fitting a modification of a prior fit called \code{fit1}, 
perhaps by changing the covariates, the recommendation is to include the term
\code{post.prob = fit1$post.prob}.
}
\item{no.fit }{
if TRUE, returns a \code{mmlcrObject} without fitting. The \code{mmlcrObject}
could be fit later by a call to \code{mmlcr(mmlcrObject)}.
}
\item{object}{
an \code{mmlcr} object. See the \code{mmlcrObject} help file for details.
}
\item{max.iter}{
the maximum number of iterations
}
\item{trace}{
if TRUE, traces through the iterations, giving the loglikelihood, a convergence speed
index, the loglikelihood goal, and the current class percentages.
}
\item{tol}{
the tolerance between the loglikelihood and the loglikelihood goal, used as a
stopping criterion.
}
\item{...}{possible additional arguments.}
}
\value{
a fitted \code{mmlcrObject}
}
\details{
The components portion of the call refers to components of the response, not
components in the sense, used in much of the mixtures literature, that is here
called latent classes or groups.


It is not yet possible to specify a prior, or even starting values, for the parameters
of the individual latent classes. Instead, one can assign starting values to the posterior
probabilities of each individual via the post.prob part of the function call.
}
\seealso{
\code{\link{mmlcrObject}}, \code{\link{mmlcrcomponentinit}}, 
\code{\link{summary.mmlcr}}, \code{\link{plot.mmlcr}}
}
\examples{
data(mmlcrdf)

mmlcrdf.mmlcr2 <- mmlcr(outer =  ~ sex + cov1 | id, 
components = list(
	list(formula = resp1 ~ 1, class = "cnormonce", min = 0, max = 50),
	list(formula = resp2 ~ poly(age, 2) + tcov1, class = "poislong"),
	list(formula = resp3 ~ poly(age, 2), class = "multinomlong")
), data = mmlcrdf, n.groups = 2)


mmlcrdf.mmlcr2.inter <- mmlcr(outer =  ~ sex * cov1 | id, 
components = list(
	list(formula = resp1 ~ 1, class = "cnormonce", min = 0, max = 50),
	list(formula = resp2 ~ poly(age, 2) + tcov1, class = "poislong"),
	list(formula = resp3 ~ poly(age, 2), class = "multinomlong")
), data = mmlcrdf, n.groups = 2,
post.prob = mmlcrdf.mmlcr2$post.prob, no.fit = TRUE)


mmlcrdf.mmlcr2.inter <- mmlcr(mmlcrdf.mmlcr2.inter)
}
\keyword{models}
% Converted by Sd2Rd version 1.21.







\eof
\name{plot.mmlcronce}
\alias{plot.mmlcronce}

\title{Plot a mmlcronce Component}
\description{
  Generates a plot for mmlcronce component of a mmlcr object, showing weighted means plus and minus one standard deviation for
  each class.
   Generally called by \code{plot.mmlcr}.
}
\usage{
plot.mmlcronce(x, post.prob, ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{ A mmlcr object. }
  \item{post.prob}{ Data.frame of class membership posterior probabilities. }
  \item{\dots}{ Other arguments to be passed to \code{plot}.  }
}
\note{
 There is no component plot for the multinomonce components.
}

\seealso{ \code{\link{plot.mmlcr}}, \code{\link{mmlcr}}, \code{\link{mmlcrObject}} }
\keyword{models}
\keyword{hplot}

\eof
\name{mmlcrObject}
\alias{mmlcrObject}
\title{
Mixed Mode Latent Class Regression Object
}
\description{
Classes of objects returned by fitting mixed mode latent class regression objects.  This class of objects is returned by the \code{mmlcr} function to represent a fitted 
mixed mode latent class regression model.  Objects of this class have methods for the functions \code{print}, \code{plot}, \code{summary}, \code{anova}, \code{vcov}, \code{fitted}, and \code{residuals}, among others.
}
\details{
The following components must be included in a legitimate \code{mmlcr} object. 
\item{components}{
a list of the response components. Each element of the list is itself a 
list, which includes the data for that response, the fit coefficients, 
the fitted response and the response residuals, among others.
}
\item{outer}{
a formula for latent class membership.
}
\item{outer.df}{
a data.frame with the variables used in outer.
}
\item{gamma.matrix}{
the coefficients from the multinomial fit for latent classes. The values 
are log(odds ratios) compared to the first class.
}
\item{prior.prob}{
a data.frame giving the prior probabilities (that is, based on the fit from
outer) of class membership for each subject.
}
\item{post.prob}{
a data.frame giving the posterior probabilities (that is, based on the 
prior probabilities as well as the data from the components) of class 
membership for each subject.
}
\item{loglikelihood}{
the loglikelihood of the final fit.
}
\item{BIC}{
the BIC of the final fit.
}
\item{df}{
the degrees of freedom of the model
}
\item{resid.df}{
the residual degrees of freedom of the model
}
\item{call}{
the call to the \code{mmlcr} function
}}
\seealso{
\code{\link{mmlcr}}
}
\keyword{models}
% Converted by Sd2Rd version 1.21.


\eof
\name{mmlcrclassify}
\alias{mmlcrclassify}
\title{
Classification of Individuals by Modal Posterior Probabilities
}
\description{
This function gives a latent class classification for each individual by
giving the class to which the individual has the highest posterior probabilities.
}
\usage{
mmlcrclassify(object)
}
\arguments{
\item{object}{an \code{mmlcrObject}.}
}
\value{
a data.frame with row.names equal to the ids and with a single column giving the
classification
}
\seealso{
\code{\link{mmlcrObject}}, \code{\link{mmlcr}}
}
\examples{
\dontrun{
data(mmlcrdf)

mmlcrdf.mmlcr2 <- mmlcr(outer =  ~ sex + cov1 | id, 
components = list(
	list(formula = resp1 ~ 1, class = "cnormonce", min = 0, max = 50),
	list(formula = resp2 ~ poly(age, 2) + tcov1, class = "poislong"),
	list(formula = resp3 ~ poly(age, 2), class = "multinomlong")
), data = mmlcrdf, n.groups = 2)

mmlcrclassify(mmlcrdf.mmlcr2)}
}
\keyword{models}


\eof
\name{mmlcrcomponentinit}
\alias{mmlcrcomponentinit}
\alias{mmlcrcomponentinit.cnormlong}
\alias{mmlcrcomponentinit.cnormonce}
\alias{mmlcrcomponentinit.default}
\alias{mmlcrcomponentinit.multinomlong}
\alias{mmlcrcomponentinit.multinomonce}
\alias{mmlcrcomponentinit.nblong}
\alias{mmlcrcomponentinit.nbonce}
\alias{mmlcrcomponentinit.normlong}
\alias{mmlcrcomponentinit.normonce}
\alias{mmlcrcomponentinit.poislong}
\alias{mmlcrcomponentinit.poisonce}    
\alias{summary.cnormlong}
\alias{summary.multinomlong}
\alias{summary.nblong}
\alias{summary.normlong}
\alias{summary.poislong}

\title{
Initialize an `mmlcr' component
}
\description{


Used internally by \code{mmlcr} to initialize an \code{mmlcr} component. The function is generic.
}
\usage{
mmlcrcomponentinit(object, n.groups,  prob, data, grouping)
}
\arguments{
\item{object}{
	see details below
}
\item{n.groups}{
	the number of classes. Provided by \code{mmlcr}.
}
\item{prob}{
	a data.frame of (initial) posterior probabilities of class
	membership. Provided by \code{mmlcr}.
}
\item{data}{
	a data.frame. Provided by \code{mmlcr}.
}
\item{grouping}{
	the variable of data indicating subject id. Provided by \code{mmlcr}.
}}
\value{


an \code{mmlcr} component object.
}
\details{


The object argument is a list, originally provided to the \code{mmlcr} function as a 
component of a list in the components argument. At a minimum, that list consists 
of a formula of the form \code{resp ~ covars}, where resp is the response variable for 
that component and covars are any additional covariates (\code{resp ~ 1} is commonly 
used), and a class. For longitudinal responses, the covariates should include 
the chronological variable, e.g., \code{resp ~ poly(age, 2)}. Implemented classes include 
\code{cnormlong}, \code{cnormonce}, \code{multinomlong}, \code{multinomonce}, \code{nblong}, \code{nbonce}, 
\code{normlong}, \code{normonce}, \code{poislong}, and \code{poisonce}. The *\code{long} classes are for longitudinal
responses, while the *\code{once} classes are for one-time responses. So that a rectangular
data structure can be used for the data argument in \code{mmlcr}, the *\code{once} classes use
just the first occurence of a response for each subject.


The \code{cnorm}* classes are for censored normal distributions. They take a \code{min} and \code{max}
argument for the minimum and maximum possible observed value. The \code{multinom}* classes
are for multinomial, or categorical responses. The response variable should be
a factor.  The \code{nb}* classes are for 
negative binomial models (the usual overdispersed Poisson model). The \code{norm}* classes 
are for normal models, and the \code{pois}* classes are for Poisson models. For the \code{cnorm}* 
and \code{norm}* classes the minimum and maximum variances are constrained to be within a 
factor of 100 of each other. For the \code{pois}* classes an overdispersion estimate is 
calculated but not used.
}

\seealso{




\code{\link{mmlcr}}, \code{\link{mmlcrObject}}
}
\keyword{models}


\eof
\name{mmlcrdf}
\alias{mmlcrdf}
\title{
An artificial data frame for `mmlcr' examples.
}
\description{
The \code{mmlcrdf} data frame has 750 rows and 8 columns. It is a simulated data frame
used for the \code{mmlcr} examples.
}
\usage{
data(mmlcrdf)
}
\format{
\describe{
This data frame contains the following columns:
\item{\code{id}}{subject id number. Each subject has 5 observations.}
\item{\code{age}}{subject's age}
\item{\code{sex}}{subject's sex}
\item{\code{cov1}}{a continuous covariate, fixed over time}
\item{\code{tcov1}}{a time-varying, continuous covariate}
\item{\code{resp1}}{a continuous response variable, left-censored at 0}
\item{\code{resp2}}{a count variable}
\item{\code{resp3}}{a factor response variable}
}}
\source{
simulation
}
\seealso{
\code{\link{mmlcr}}
}
\examples{
\dontrun{data(mmlcrdf)}
\dontrun{mmlcrdf.mmlcr2 <- mmlcr(outer =  ~ sex + cov1 | id, 
	components = list(
		list(formula = resp1 ~ 1, class = "cnormonce", min = 0, max = 50),
		list(formula = resp2 ~ poly(age, 2) + tcov1, class = "poislong"),
		list(formula = resp3 ~ poly(age, 2), class = "multinomlong")
	), data = mmlcrdf, n.groups = 2)}
}
\keyword{datasets}

\eof
\name{mmlcrfit}
\alias{mmlcrfit}
\alias{mmlcrfit.cnormlong}
\alias{mmlcrfit.default}
\alias{mmlcrfit.multinomlong}
\alias{mmlcrfit.nblong}
\alias{mmlcrfit.nofit}
\alias{mmlcrfit.normlong}
\alias{mmlcrfit.poislong}
\title{
Used internally by mmlcr to fit mmlcr component objects.
}
\description{
fits an \code{mmlcr} component object. Used internally by the 
function \code{mmlcr}
}
\usage{
mmlcrfit(object, weights, classnumber)
}
\arguments{
\item{object}{
an \code{mmlcr} component
}
\item{weights}{
a data.frame of weights, with row.names indicating subject ids.
}
\item{classnumber}{
a number indicating the latent class to use, i.e., which column of weights to use.
}}
\value{
the same \code{mmlcr} component object with an updated fit.
}
\seealso{
\code{\link{mmlcr}}, \code{\link{mmlcrObject}}, \code{\link{mmlcrlike}}
}
\keyword{models}
% Converted by Sd2Rd version 1.21.

\eof
\name{mmlcrlike}
\alias{mmlcrlike}
\alias{mmlcrlike.cnormlong}
\alias{mmlcrlike.default}
\alias{mmlcrlike.multinomlong}
\alias{mmlcrlike.nb1long}
\alias{mmlcrlike.nblong}
\alias{mmlcrlike.normlong}
\alias{mmlcrlike.poislong}
\title{
Used internally by mmlcr to calculate component likelihoods. 
}
\description{Find the likelihoods for each subject in an \code{mmlcr} component object. Meant to be
internally by the function \code{mmlcr}
}
\usage{
mmlcrlike(object, weights, classnumber, final = FALSE)

}
\arguments{
\item{object}{
a component of an \code{mmlcr} object
}
\item{weights}{
weights for the observations in object
}
\item{classnumber}{
the class number for the likelihoods
}
\item{final}{
see below
}}
\value{

if final = FALSE, a vector of likelihoods corresponding to the
weights. The weights are not used except for their row.names.


if final = TRUE, the component is returned, with fitted and residual
components added. The fitted and residual components will only be
correct if mmlcrlike is called sequentially over the full set of 
classnumbers, as is the case when mmlcrlike is called by \code{mmlcr}.
}
\section{Warning}{
the mmlcrlike.multinomlong method returns fitted and residual components
that have no real meaning. It is included only for completeness.
}
\seealso{
\code{\link{mmlcr}}, \code{\link{mmlcrObject}}
}
\keyword{models}

\eof
\name{plot.mmlcr}
\alias{plot.mmlcr}
\alias{plot.multinomlong}
\alias{plot.multinomonce}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Plot Components of mmlcr Object}
\description{
  Generates a plot for each component of a mmlcr object.
  Longitudinal components are plotted against time for each class, 
  while ``once'' components show means and standard deviations for
  each class.
}
\usage{
plot.mmlcr(x, which = 1:length(x$components), ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{ A mmlcr object. }
  \item{which}{ Which components to plot (by number). }
  \item{\dots}{ Arguments to be passed to component plots. In particular, a ``smooth'' parameter, equal to \code{supsmu}'s \code{bass} can be used in 
longitudinal components.  }
}
\details{
  Longitudinal components show plots of means for each class over the
  first covariate.  Non-longitudinal components show the weighted mean plus and minus one weighted standard deviation for each class. There is no component plot for the multinom components.
}

\seealso{ \code{\link{mmlcr}}, \code{\link{plot.mmlcrlong}}, \code{\link{plot.mmlcronce}}, \code{\link{mmlcrObject}} }
\keyword{models}
\keyword{hplot}

\eof
\name{plot.mmlcrlong}
\alias{plot.mmlcrlong}

\title{Plot a mmlcrlong Component}
\description{
  Generates a plot for mmlcrlong component of a mmlcr object.
  Class means are plotted against ``time.'' Generally called by \code{plot.mmlcr}.
}
\usage{
plot.mmlcrlong(x, post.prob, smooth = 0, xlab = names(data)[2], ylab = 
	names(data)[1], ylim = c(min(yy, na.rm = TRUE), 
	max(yy, na.rm = TRUE)), cols = rep(1, dim(post.prob)[2]), 
	pch = as.character(1:(dim(post.prob)[2])), ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{ A mmlcr object. }
  \item{post.prob}{ Data.frame of class membership posterior probabilities. }
  \item{smooth}{  A smoothing parameter, equal to \code{supsmu}'s \code{bass}.}
  \item{xlab}{ Label for the x-axis. }
  \item{ylab}{ Label for the y-axis. }
  \item{ylim}{ Limits for the y-axis. }
  \item{cols}{ The cols argument for \code{par}. }
  \item{pch}{ The pch argument for \code{par}. }
  \item{\dots}{ Other arguments to be passed to \code{plot}.  }
}
\note{
 There is no component plot for the multinomlong components.
}

\seealso{ \code{\link{plot.mmlcr}}, \code{\link{mmlcr}}, \code{\link{mmlcrObject}} }
\keyword{models}
\keyword{hplot}

\eof
\name{postprob}
\alias{postprob}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ Extract Posterior Probabilities from mmlcr Object}
\description{
  Extract posterior class probabilities from an mmlcr object.
}
\usage{
postprob(object)
}
\arguments{
  \item{object}{ A mmlcr object. }
}
\value{
  A data.frame of posterior probabilities of class membership
}

\seealso{  \code{\link{mmlcr}}, \code{\link{mmlcrObject}} }


\examples{
\dontrun{
data(mmlcrdf)

mmlcrdf.mmlcr2 <- mmlcr(outer =  ~ sex + cov1 | id, 
components = list(
	list(formula = resp1 ~ 1, class = "cnormonce", min = 0, max = 50),
	list(formula = resp2 ~ poly(age, 2) + tcov1, class = "poislong"),
	list(formula = resp3 ~ poly(age, 2), class = "multinomlong")
), data = mmlcrdf, n.groups = 2)

postprob(mmlcrdf.mmlcr2)

}}
\keyword{models}

\eof
\name{theta.mmmod}
\alias{theta.mmmod}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ Estimate theta of the Negative Binomial by Moments }
\description{
  Estimate theta of the negative binomial by moments, adapted to
  mmlcrfit from theta.mm of the MASS library
}
\usage{
theta.mmmod(y, u, dfr, wts, limit = 10, eps = .Machine$double.eps^0.25)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{y}{ Vector of observed values. }
  \item{u}{ Estimated mean vector. }
  \item{dfr}{ Residual degrees of freedom. }
  \item{wts}{ Weights for the observations. }
  \item{limit}{ Limit on iterations. }
  \item{eps}{ Convergence tolerance. }
}

}
\value{
  Estimate of theta.
}

\seealso{ \code{\link{theta.mm}},  \code{\link{mmlcrfit}}, \code{theta.mm} from the MASS library}

\keyword{distribution}
\keyword{models}


\eof
