\name{AIC.moc}
\alias{AIC.moc}
\alias{logLik.moc}
\alias{entropy}
\alias{entropy.default}
\alias{entropy.moc}

\title{Information Criterion for MOC models}

\description{

  \code{AIC.moc} generates a table of \eqn{\log-Likelihood}, AIC, BIC ,
  ICL-BIC and entropy values along with the degrees of freedom of multiple \code{moc}
  objects. 

  \code{logLik} returns on object of class logLik containing the
  \eqn{\log-Likelihood},degrees of freedom and number of observations.

  \code{entropy} is a generic method to compute the entropy of
  sets of probabilities.

  \code{entropy.default} the default method compute entropy and
  standardized entropy of a set of probablilities.
  
  \code{entropy.moc} generates a table containing total and mean
  standardized entropy of mixture (prior) and posterior probabilities of
  MOC models.
  
  The entropy of a set of \eqn{k} probabilities (\eqn{\pi_1,\ldots,\pi_k}) is computed as
   \eqn{- \sum_{i=1}^k(\pi_i \log(\pi_i) )}{- \sum( wt * post * \log(post) )},
  it reaches its minimum of \eqn{0} when one of the \eqn{\pi_i=1}
  (minimum uncertainty) and its maximum of \eqn{\log(k)} when all the
  probabilities are equal \eqn{\pi_i=1/k} (maximum uncertainty). 
  Standardized entropy is just \eqn{entropy/\log(k)} which lies in the
  interval \eqn{[0,1]}. The total and mean mixture entropy are the sum and the mean
  of the mixture probabilities entropy of all subjects. These are
  computed for both the prior ( without knowledge of the response
  patterns ) and the posterior mixture probabilities ( with knowledge of
  the responses).
    
}

\usage{

       \method{AIC}{moc}(object,\dots,k=2)

       \method{logLik}{moc}(object,\dots)

       \method{entropy}{moc}(object,\dots)
}

\arguments{

  \item{object,\ldots}{Objects of class \code{moc}.}

  \item{k}{ can be any real number or the string "BIC".}
}

\details{
  The computed value is \eqn{-2\cdot \log(Likelihood) + k\cdot npar}{-2*\log-Likelihood + k*npar}.
  Specific treatment is carried for BIC
  (\eqn{k=\log(nsubject\cdot nvar)}{k = \log(nsubject*nvar)}),
  AIC (\eqn{k = 2}) and log-Likelihood (\eqn{k = 0}).
  Setting k = "BIC", will produce a table with BIC,
  \eqn{entropy =  - \sum( wt\cdot post \log(post) )}{entropy = - \sum( wt * post * \log(post) )}
  which is an indicator of mixture separation, df and
  \eqn{ICL-BIC = BIC + 2\cdot entropy}{ICL-BIC = BIC + 2 * entropy} which is
  an entropy corrected BIC, see McLachlan, G. and Peel, D. (2000).
}

\value{ A data frame with the relevant information for one or more
  objects is returned .}

\note{

  Be aware that degrees of freedom (df) for mixture models are usually
  useless ( if not meaningless ) and likelihood-ratio of
  \emph{apparently} nested models often doesn't converge to a
  Chi-Square with corresponding df.
}   

  
\references{

  McLachlan, G. and Peel, D. (2000) \emph{Finite mixture
    models},Wiley-Interscience, New York.
}

\author{Bernard Boulerice <\email{Bernard.Boulerice@umontreal.ca}>}

\seealso{\code{\link{moc}}}

\keyword{methods}
\keyword{utilities}

\eof
\name{moc}
\alias{moc}
\title{Fit a General Nonlinear Multivariate Mixture Model}

\description{
    \code{moc} fits user-specified mixture models with one,two
    and three parameters distributions to multivariate data that can be of
    discrete or continuous type and a mix of both types. The likelihood for the
    vector of observations or repeated measurements for
    subject \eqn{i} has the form

    \deqn{f( Y_i = y_i |\, Z_i = z_i, X_i = x_i)  = \sum_k \pi_k(z_i,x_i)
    \,h_k( y_i |\, x_i)}{f( Y[i] = y[i] | z[i], x[i]) =
    \Sum_k p_k(z[i],x[i]) h_k( y[i] | x[i])}
 
    The \eqn{\pi_k()}{p_k()} represent the mixture probability
    function and \eqn{h_k()} the conditional joint density of the
    observations \eqn{Y_i}{Y[i]} given the covariates
    \eqn{X_i}{X[i]} and mixture \eqn{k}.
    The user supplies either the joint or marginal conditional
    density(ies) of the components of \eqn{Y_i}{Y[i]}. In the latter case,
    the joint conditional density is constructed by taking the product of
    the marginal densities ( assuming conditional independence of the components ).
  }
  
\usage{

moc(y, density=NULL, joint=FALSE, groups=1,
gmu=NULL, gshape=NULL, gextra=NULL, gmixture=inv.glogit, expected = NULL,
pgmu=NULL, pgshape=NULL, pgextra=NULL, pgmix=NULL,
check.length=TRUE, scale.weight=FALSE, wt=1, data=NULL,
ndigit=10, gradtol=0.0001, steptol=gradtol,iterlim=100,print.level=2,\dots)
}

\arguments{
  \item{y}{ A matrix or data frame giving the vectors of observations
  (of length \eqn{nvar}) for each subject.}

  \item{density}{ A function returning the conditional joint or marginal
  density of the observations and calling the location, shape and extra functions.}

  \item{joint}{ Specify if the density gives the joint or common marginal
    density of the vector of observations. When using a joint density
    remenber that this density will receive its parameters as matrices.}

  \item{groups}{ Number of mixtures.}

  \item{gmu, gshape, gextra}{ User-specified \code{lists} of functions
  returning the location, shape and extra density parameters for each
  mixture group and observation as a function of the parameters
  \emph{pgmu}, \emph{pgshape}, \emph{pgextra} and covariates.}

  \item{gmixture}{ A user-specified function of \emph{pgmix}, giving the regression 
  function of the mixture probabilities. The default is the
  inverse generalized logit with respect to the first group.}

  \item{expected}{ A \code{list} of functions returning the expected response value with
  respect to all the parameters \code{c(pgmu,pgshape,pgextra,pgmix)} for
  each mixture groups. Defaults to \code{gmu}.}

  \item{pgmu, pgshape, pgextra, pgmix}{ Vector of initial estimates for the
  parameters of the location, shape, extra and mixture functions.}


  \item{wt}{ Vector of subjects sampling weights. Actually the program uses
  standard sample-weighted log-Likelihood assuming fixed weights. }

  \item{scale.weight}{ Logical value specifying if the vector of weights 
  \emph{wt} should be rescaled to sum to the sample size.}

\item{check.length}{ Logical value specifying weither to check the rows
  length returned by the functions in \code{gextra} against the number
  of variables in \eqn{y}. Especially usefull when the \code{density}
  requires more paramaters then the number of variables like covariance
  parameters for multivariate normal.}

  \item{data}{ An optional \emph{data frame} or \emph{list} containing
  some or all variables and functions required to fit the model. It is
  \code{attach}ed at run time and subsequently by \code{moc}
  \code{methods} applied to the fitted model. Be aware that
  \code{objects} in \emph{.GlobalEnv} will mask any \code{object} with
  the same name in \emph{data}.
  }
  
  \item{ndigit, gradtol, steptol, iterlim, print.level, \ldots}{
    Arguments controlling \code{nlm}.}
}

\details{
    The procedure minimizes the resulting \eqn{-\log(Likelihood)} without
    constraints, the parameters are all assumed to be real numbers.
    Thus the user should supply appropriate link functions and parameterize
    the density and parameters functions accordingly ( see the examples
    ). By default missing values in the response variables \eqn{Y} are assumed
    to be missing at random, that is the \eqn{Likelihood} for the subset
    of valid observations is just the marginal \eqn{Likelihood} for this
    subset in each mixture. Specific treatment of missing values in the
    response variables can be achieved by handling them explicitly in
    the functions \code{density},\code{gmixture},\code{gmu},\code{gshape}
    and \code{gextra}. The function \code{density} can return \code{NA}
    and yields the default treatment of missing values in the response.
    The functions
    \code{gmixture},\code{gmu},\code{gshape} and \code{gextra},
    can not return \code{NA} thus missing values in the covariates
    should be treated explicitly by these functions.

    The \code{lists} of functions \code{gmu}, \code{gshape},
    \code{gextra} returns the location, shape and extra parameters
    to the density for each observation and mixture group as a function
    of \emph{pgmu}, \emph{pgshape} and \emph{pgextra} and covariates.
    Each function should return a vector of length \eqn{nvar} or a
    matrix of such vectors. The first function in the \code{list} is
    for the first group, the second function for the second group and so
    on. The functions in the same \code{list} share the same parameters
    but the different \code{lists} have different parameters
    ( see the examples ). 

    Setting the \code{attributes} \emph{parameters} for functions
    \code{gmu},\code{gshape},\code{gextra} and \code{gmixture} will
    generate parameter labels in the printout of the object.
    
    The deviance residuals, fitted values and posterior probabilities
    are obtained through the use of the methods \code{residuals},\code{fitted}
    and \code{post}.
}


\value{
    A list of class \emph{moc} is returned that contains all of the
    relevant information calculated, including error code generated by
    \code{nlm}.
    The printed output includes  \eqn{-2 \log(Likelihood)},
    the corresponding df , AIC, BIC, entropy and ICL-BIC
    ( entropy corrected BIC ), mean mixture probabilities,
    mean expected and observed values for each mixture group,
    the maximum likelihood estimates and standard errors.}

\note{
    The \code{expected} function is used to compute the fitted values
    and response residuals (not deviance). It is especially useful when
    the expected value differs from the location parameters as for censored
    normal or zero inflated Poisson distributions.
  
    The method of fixed sample-weight provides design-consistent parameters
    estimates. However, for the moment the program does not provide any
    methods to include sampling variances resulting from weights
    estimation. If the user wants to incorporate weights estimation
    sampling variances it could be achieved, for example, by including
    \code{moc} model estimation in a \emph{jackknife} loop.

    Be aware that degrees of freedom (df) for mixture models are usually
    useless ( if not meaningless ) and likelihood-ratio of
    \emph{apparently} nested models often does not converge to a
    Chi-Square with corresponding df.
  }   


  \references{
McLachlan, Geoffrey and Peel, David (2000) \emph{Finite mixture models},Wiley-Interscience, New York.

Roeder, K., Lynch, K. and Nagin, D. (1999) \emph{Modeling Uncertainty in
  Latent Class Membership: A Case Study in Criminology}, J. Amer. Statist. Assoc., \bold{94}, pp. 766--776.

Lindsay, Bruce G. and Roeder, K. (1992) \emph{Residual diagnostics for mixture models}, J. Amer. Statist. Assoc., \bold{87},
     pp. 785--794.
   }
   
\author{Bernard Boulerice <\email{Bernard.Boulerice@umontreal.ca}>}

\seealso{\code{\link{print.moc}},\code{\link{plot.moc}},\code{\link{residuals.moc}},
  \code{\link{plot.residuals.moc}},\code{\link{fitted.moc}},\code{\link{post.moc}},\code{\link{AIC.moc}},
    \code{\link{logLik.moc}},\code{\link{obsfit.moc}},\code{\link{nlm}}}

\examples{

data(moc.dat)

cnorm.dat<-list()   #This is used as a container for functions and data

# Censored Normal (marginal density)

cnorm.dat$cnorm<-function(x,mu,sig,min,max)
{mi<-(x==min)*1
ma<-(x==max)*1
mi*pnorm((min-mu)/sig)+ma*(1-pnorm((max-mu)/sig))+
(1-mi-ma)*dnorm((x-mu)/sig)/sig}

# For this data set the range of the dependent variables is [0,14]

cnorm.dat$cnorm1<-function(x,mu,sig,...) {cnorm(x,mu,sig,0,14)}

# We have 4 observations

cnorm.dat$gmu1<- list(
   Group1=function(pmu) {t(1)\%*\%rep(pmu[1],4)},
   Group2=function(pmu) {t(1)\%*\%rep(pmu[2],4)},
   Group3=function(pmu) {t(1)\%*\%rep(pmu[3],4)})

attr(cnorm.dat$gmu1,"parameters")<-c("  cons1","  cons2","  cons3")

# Expected value of a general censored normal

cnorm.dat$cmean<-function(mu,sig,min,max) {
max-(max-mu)*pnorm((max-mu)/sig)+(min-mu)*pnorm((min-mu)/sig)-
sig*(dnorm((max-mu)/sig)-dnorm((min-mu)/sig)) }

# Homogeneous variances

cnorm.dat$gshape1<- list(
   Group1=function(psh) {t(1)\%*\%rep(exp(psh[1]),4)},
   Group2=function(psh) {t(1)\%*\%rep(exp(psh[1]),4)},
   Group3=function(psh) {t(1)\%*\%rep(exp(psh[1]),4)})

attr(cnorm.dat$gshape1,"parameters")<-c("  log(std.dev)")

cnorm.dat$cmean1<- list(
   Group1=function(p) {cmean(gmu1[[1]](p[1:3]),gshape1[[1]](p[4]),0,14) },
   Group2=function(p) {cmean(gmu1[[2]](p[1:3]),gshape1[[2]](p[4]),0,14) },
   Group3=function(p) {cmean(gmu1[[3]](p[1:3]),gshape1[[3]](p[4]),0,14) })

moc1<-
moc(moc.dat[,1:4],density=cnorm1,groups=3,gmu=gmu1,gshape=gshape1,expected=cmean1,
pgmu=c(0.5, 2, 5),pgshape=c(0.7),pgmix=c(-0.6, -2.0), data=cnorm.dat,gradtol=1E-4)

print(moc1)

\dontrun{
# Heterogeneous variances across mixture groups

cnorm.dat$gshape2<-list(
   Group1=function(psh) {t(1)\%*\%rep(exp(psh[1]),4)},
   Group2=function(psh) {t(1)\%*\%rep(exp(psh[2]),4)},
   Group3=function(psh) {t(1)\%*\%rep(exp(psh[3]),4)})

cnorm.dat$cmean2<-list(
   Group1=function(p) {cmean(gmu1[[1]](p[1:3]),gshape2[[1]](p[4:6]),0,14) },
   Group2=function(p) {cmean(gmu1[[2]](p[1:3]),gshape2[[2]](p[4:6]),0,14) },
   Group3=function(p) {cmean(gmu1[[3]](p[1:3]),gshape2[[3]](p[4:6]),0,14) })

moc2<-
moc(moc.dat[,1:4],density=cnorm1,groups=3,gmu=gmu1,gshape=gshape2,expected=cmean2,
pgmu=moc1$coef[1:3],pgshape=c(rep(moc1$coef[4],3)),pgmix=moc1$coef[5:6]
,data=cnorm.dat,gradtol=1E-4)
}
# Heterogeneous variances across time

cnorm.dat$gshape3<-list(
   Group1=function(psh) {exp(t(1)\%*\%psh[1:4])},
   Group2=function(psh) {exp(t(1)\%*\%psh[1:4])},
   Group3=function(psh) {exp(t(1)\%*\%psh[1:4])})

cnorm.dat$cmean3<-list(
   Group1=function(p) {cmean(gmu1[[1]](p[1:3]),gshape3[[1]](p[4:7]),0,14)},
   Group2=function(p) {cmean(gmu1[[2]](p[1:3]),gshape3[[2]](p[4:7]),0,14)},
   Group3=function(p) {cmean(gmu1[[3]](p[1:3]),gshape3[[3]](p[4:7]),0,14)})

moc3<-
moc(moc.dat[,1:4],density=cnorm1,groups=3,gmu=gmu1,gshape=gshape3,expected=cmean3,
pgmu=moc1$coef[1:3],pgshape=c(rep(moc1$coef[4],4)),pgmix=moc1$coef[5:6],
data=cnorm.dat,gradtol=1E-4)

print(moc3)

cnorm.dat$ages<-cbind(1.7,3,4.2,5.6)

\dontrun{
# Last group is a linear function of time

cnorm.dat$gmu1t<-list(
   Group1=function(pmu) {pmu[1]*ages^0},
   Group2=function(pmu) {pmu[2]+pmu[3]*ages},
   Group3=function(pmu) {pmu[4]*ages^0})

cnorm.dat$cmean1t<-list(
   Group1=function(p) {cmean(gmu1t[[1]](p[1:4]),gshape1[[1]](p[5]),0,14)},
   Group2=function(p) {cmean(gmu1t[[2]](p[1:4]),gshape1[[2]](p[5]),0,14)},
   Group3=function(p) {cmean(gmu1t[[3]](p[1:4]),gshape1[[3]](p[5]),0,14)})

moc4<-
moc(moc.dat[,1:4],density=cnorm1,groups=3,gmu=gmu1t,gshape=gshape1,expected=cmean1t,
pgmu=append(moc1$coef[1:3],0,after=2),pgshape=c(moc1$coef[4]),pgmix=moc1$coef[5:6],
data=cnorm.dat,gradtol=1E-4)


# Zero inflated Poisson log-linear in time for the third group
# Be carefull dpois requires integer values

zip<- function(x,la,shape=1,extra)
{ mix<- exp(extra)/(1+exp(extra))
  mix*(x==0)+(1-mix)*dpois(x,la) }
}

ages<-cbind(1.7,3,4.2,5.6)

gmup<-list(
   Group1=function(pmu) {exp(pmu[1]*ages^0)},
   Group2=function(pmu) {exp(pmu[2]+pmu[3]*ages)},
   Group3=function(pmu) {exp(pmu[4]*ages^0)})

\dontrun{
zipfit<-list(
   Group1=function(p) { gmup[[1]](p)/(1+exp(p[5]))},
   Group2=function(p) { gmup[[2]](p)/(1+exp(p[5]))},
   Group3=function(p) { gmup[[3]](p)/(1+exp(p[5]))})

gextrap<-list(
   Group1=function(pxt) {t(1)\%*\%rep(pxt[1],4)},
   Group2=function(pxt) {t(1)\%*\%rep(pxt[1],4)},
   Group3=function(pxt) {t(1)\%*\%rep(pxt[1],4)})

moc5<-
moc(moc.dat[,1:4],density=zip,groups=3,gmu=gmup,gextra=gextrap,expected = zipfit,
pgmu=c(-0.6, 0.64,0, 1.6),pgextra=c(-3),pgmix=c(-0.7, -2), gradtol=1E-4)
}

# Standard Poisson with mixture depending on time independent
# dichotomous covariate
# Be aware that dpoiss require integer values

dumm<-moc.dat[,5]-1
gmixt<-function(pm){
mix<-cbind(1,dumm)\%*\%matrix(pm[1:4],2,2)
cbind(1,exp(mix))/(1+apply(exp(mix),1,sum))}

poiss<-function(x,la,...) {dpois(x,la)}

moc6<-
moc(moc.dat[,1:4],density=poiss,groups=3,gmu=gmup,gmixture=gmixt,
pgmu=c(-0.6,0.64, 0, 1.6),pgmix=c(-0.2,-1, -1 ,-2),gradtol=1E-4)

print(moc6)

obsfit.moc(moc6,along=dumm)

entropy(moc1,moc3,moc6)

\dontrun{
 plot(moc6,against=ages,main="MOC profiles",xlab="age",ylab="Y")
 plot(residuals(moc6))
}
}
\keyword{models}
\keyword{nonlinear}
\keyword{cluster}
\keyword{classif}
\keyword{multivariate}

\eof
\name{moc.dat}
\alias{moc.dat}
\docType{data} 
\title{Example data for MOC}
\usage{data(moc.dat)}
   
\description{
  Simulated data from a mixture model.
}

\format{
  This data frame contains 500 rows (subjects) with the following columns
  (variables) :
  \describe{
    \item{Y1, Y2, Y3, Y4}{simulated observation at 4 occasions.}
    \item{X1}{a dichotomous covariate.}
  }
}


\author{Bernard Boulerice <\email{Bernard.Boulerice@umontreal.ca}>}


\keyword{datasets}

\eof
\name{plot.moc}
\alias{plot.moc}
\alias{profilesplot}
\alias{profilesplot.moc}
\alias{plot.residuals.moc}
\alias{entropyplot}
\alias{entropyplot.moc}
\alias{mix.colors.moc}

\title{Plotting methods for MOC models}


\description{

  \code{plot.moc} plots the fitted and observed values of a fitted
  \emph{moc} model.

  \code{profilesplot} is a generic method to plot subject profiles of
  fitted model.
   
  \code{profilesplot.moc} plots the subject response (variables or
  posterior) profiles of each subject of fitted \emph{moc} object with
  colors that are a mix of group colors according to posterior
  probability. 

  \code{plot.residuals.moc} nicely plots and object of type
  \code{residuals.moc}.

  \code{mix.colors.moc} computes subject colors by mixing group base colors
  accordind to the subject posterior probabilities.

   \code{entropyplot} is a generic method to plot entropy.

   \code{entropyplot.moc} plots the prior and posterior subject entropy
   (standardized or not) corresponding to a \emph{moc} model. The
   entropy being first sorted on prior then on posterior within prior.
}

\usage{

  \method{plot}{moc}(x,against=1:x$nvar,main=paste(substitute(x)),xlab="",ylab="",
                      prob.legend=TRUE,scale=FALSE,group.colors=rainbow(x$groups),\dots)

  \method{plot}{residuals.moc}(x,against="Index",groups=1:dim(x)[3],sunflower=FALSE,group.colors=NULL,\dots)

  profilesplot(x,\dots)
  
  \method{profilesplot}{moc}(x,against=1:x$nvar,main=NULL,xlab="",ylab="",
                     col.legend=TRUE,scale=FALSE,
                     group.colors=rainbow(x$groups),type="subject",\dots)

  mix.colors.moc(object,group.colors=rainbow(object$groups))

  entropyplot(x,\dots)

  \method{entropyplot}{moc}(x,main=NULL,std=TRUE,lwd=1.5,col=c("red3","green3","gray95"),legend=TRUE,\dots)

 }

\arguments{

  \item{x,object}{ Objects of class \code{moc} or \code{residuals.moc}.}
 
  \item{against}{ x axis for plotting the profiles.
      A variable against which to plot the residuals or the strings
    \describe{
  \item{Index:}{ The default, use the index of the residuals array.}
  \item{Observation:}{Use the column (variable) index of the response matrix.}
  \item{Subject:}{Use the row (subject) index of the response matrix.}
  }}

  \item{main, xlab, ylab, \ldots}{ Arguments to be passed to \code{plot},
    \code{matplot}.}

  \item{prob.legend, col.legend, legend}{ Add a mixture probabilities,
      color legend and lines to the plot.}

  \item{sunflower}{Specify if a sunflower or standard plot is requested.}

  \item{scale}{ Specify if each variable should be scaled.(see \code{scale})}

 \item{group.colors}{ The groups colors to be used in the plot.}

  \item{groups}{ Specify for which groups \code{residuals.moc} plot is
    requested.}

  \item{type}{ A string givint the type of profiles to plot
  \describe{
  	\item{subject:}{(default) for subject profiles.}
        \item{variable:}{for pairs plot of response variables.}
	\item{posterior:}{for pairs of posterior probabilities. }
	}}

    \item{std}{ If TRUE standardized entropy are plotted.}

    \item{lwd, col}{ entropyplot.moc will plot the prior and posterior
      entropy with lines of width \eqn{lwd} and colors \code{col[1:2]}, the
      third color is used for the area between the two curves.}
 }

\value{ \code{plot.moc} invisibly returns a \code{list} containing the
  plotted values and scaling information. \code{plot.residuals.moc}
  invisibly returns the plotted residual values. \code{mix.colors.moc} 
  invisibly returns subject mixed colors in hexadecimal RGB values.}
  
\author{Bernard Boulerice <\email{Bernard.Boulerice@umontreal.ca}>}

\seealso{\code{\link{moc}},\code{\link{residuals.moc}},\code{\link{print.moc}},
  \code{\link{AIC.moc}}}

\keyword{methods}
\keyword{hplot}

  

  
  

\eof
\name{print.moc}
\alias{print.moc}
\alias{fitted.moc}
\alias{obsfit.moc}
\title{Fitted MOC model}

\description{

   \code{print.moc} prints information contained in a fitted \code{moc}
   object. The \code{attributes} \emph{parameters} of the functions
   \code{gmu},\code{gshape},\code{gextra} and \code{gmixture} will be
   used to label the output.

   \code{fitted.moc} computes the expected values for each observation
   of a \code{moc} object.

   \code{obsfit.moc} computes and prints the mean posterior
   probabilities and the posterior means of a user specified function of
   the expected and observed values, splitted with respect
   to the specified variable.
 }

 \usage{

   \method{print}{moc}(x,digits=5,\dots)

   \method{fitted}{moc}(object,\dots)

   obsfit.moc(object,along=NULL,FUN=function(x) x)

 }

 \arguments{

   \item{x,object}{ Objects of class \code{moc}.}

   \item{digits}{ Number of digits to be printed.}
   
  \item{along}{ Splitting variable. }

   \item{FUN}{ User defined function to apply to observed and expected values.}

   \item{\ldots}{Unused.}
 
 }

 \details{ \code{Obsfit.moc} will first compute the posterior probabilities
   \deqn{\hat{\tau}_{i,k} = \frac{\hat{\pi}_k(z_i,x_i)
   \hat{h}_k( y_i | x_i)}{\sum_k \hat{\pi}_k(z_i, x_i)
   \hat{h}_k( y_i | x_i)}}{tau[i,k] = p_k( z[i], x[i])
   h_k( y[i] | x[i]) /  \Sum_k (p_k(z[i], x[i])
   h_k( y[i] | x[i]) )}
 using \code{post.moc} and then the weighted posterior mean probabilities
 \deqn{\hat{\bar{\tau}}_k = \frac{\sum_i wt_i\,\hat{\tau}_{i,k}}
   {\sum_i wt_i}}{\Sum_i (wt[i] * tau[i,k]) / \Sum_i wt[i]}
 The weighted posterior means of a function \eqn{f()} of the data are computed as
 \deqn{\frac{\sum_i wt_i\,\hat{\tau}_{i,k}\,f(y_i)}{\sum_i
     wt_i\,\hat{\tau}_{i,k}}}{\Sum_i (wt[i] * tau[i,k] * f(y[i])) /
   \Sum_i (wt[i] * tau[i,k])}
where both sums are taken over index of valid data \eqn{y_i}{y[i]}.}


 \value{ All these methods return their results invisibly.}

 \author{Bernard Boulerice <\email{Bernard.Boulerice@umontreal.ca}>}

 \seealso{\code{\link{moc}},\code{\link{residuals.moc}},\code{\link{plot.moc}},
 \code{\link{AIC.moc}}}

\keyword{methods}
\keyword{print}
\keyword{utilities}

\eof
\name{residuals.moc}
\alias{residuals.moc}
\alias{post.moc}
\alias{post}

\title{Posterior and residuals methods for MOC models}

\description{
   
   \code{post} is a generic method for computing posterior probabilities of a fitted model.
  
   \code{post.moc} computes the posterior mixture probabilities of each subject.

   \code{residuals.moc} computes response or deviance residuals.
   The residuals are optionally weighted by the posterior mixture probabilities,
   globally ( with \emph{post} ) or within each group ( in that case
   \emph{post} is divided by its mean for each group ).

}

\usage{

   post(object,\dots)
   
   \method{post}{moc}(object,\dots)

   \method{residuals}{moc}(object,\dots,type="deviance",post.weight=TRUE,within=FALSE)

}

\arguments{

  \item{object}{Object of class \code{moc}.}
 
  \item{type}{Type of residuals: either deviance ( the default ) or
  response.}
  
  \item{post.weight}{ Specify if the residuals must be weighted by the
  posterior mixture probabilities. Weighting is preferable, it is the
  default.}

  \item{within}{ Specify if the posterior weights are rescaled within each
    mixture group.}
  
  \item{\ldots}{Unused.}
}

\details{
  Response residuals are simply the difference between the
  observed and expected values, \deqn{response = y - expected}

  Deviance residuals are defined as properly scaled
  difference in the log likelihood at the observed and fitted value.
  \deqn{deviance = \sqrt{2 * wt * \log{\frac{\rm{density}(y,y,shape,extra)}{\rm{density}(y,mu,shape,extra)}}} * sign(response)}{deviance = \sqrt(2 * wt * (\log(density(y,y,shape,extra)/density(y,mu,shape,extra)))) * sign(response)}

  Globally weighted residuals are preferable to detect influential
  data, wrong number of groups and differences between groups.
  Rescaled weight residuals are more useful when plotted against some
  variables or variable index to detect misspecified regression function or profiles.
}  

\value{ \code{residuals.moc} returns an array of class
  \code{residuals.moc} and \code{residuals} with attributes \emph{type},
  \emph{post.weight} and \emph{within}. All these methods return their
  values invisibly.}
  
\references{

  McLachlan, G. and Peel, D. (2000) \emph{Finite mixture
  models},Wiley-Interscience, New York.
  
  
  Lindsay, B. G. and Roeder, K. (1992) \emph{Residual diagnostics for
  mixture models}, J. Amer. Statist. Assoc., \bold{87}, pp. 785--794.
}
   
\author{Bernard Boulerice <\email{Bernard.Boulerice@umontreal.ca}>}

\seealso{\code{\link{moc}},\code{\link{plot.moc}},\code{\link{print.moc}},
  \code{\link{AIC.moc}}}


\keyword{methods}
\keyword{utilities}

\eof
\name{utils.moc}
\alias{inv.glogit}
\alias{glogit}
\title{MOC utility functions}
\description{ Functions to compute generalized logit and inverse logit
  with respect to a reference group.
}
\usage{
   inv.glogit(gmix,ref=1)
   glogit(p,ref=1)
}
\arguments{
  \item{p}{vector of probabilities to transform in generalized logit
  with ref as a reference group.}

  \item{gmix}{vector of generalized logit with respect to ref to
  transform in probabilities.}

  \item{ref}{reference group.}
  }
  
\value{A vector of probabilities or generalized logit.}

\details{These functions do not perform any check on their arguments.}

\author{Bernard Boulerice <\email{Bernard.Boulerice@umontreal.ca}>}
\keyword{utilities}

\eof
