\name{README.mvbutils}
\alias{README.mvbutils}
\title{How to use mvbutils}
\description{For how to use \code{mvbutils}, see the DETAILS section below.}
\usage{README.mvbutils()}
\details{
\code{mvbutils} is a collection of utilities offering the following main features:

\itemize{
\item Hierarchical organization of projects and sub-projects, allowing switching within a single \R session, searching and moving objects through the hierarchy, objects in ancestor projects always visible from child (sub)projects, etc. See \code{\link{cd}}.
\item Improved function editing facilities, interfacing with whichever text editor you prefer. The \R command line is not frozen while editing, and you can have multiple edit windows open. There is also a complete automatic backup system, with (as a side-effect) the ability to sort objects by date. See \code{\link{fixr}}.
\item Support for flat-format (plain-text) documentation, stored along with a function and editable at the same time, and viewable through normal \code{help}. Automatic conversion to Rd format is available if certain rules are followed. See \code{\link{flatdoc}}.
\item Support for nesting of \code{source} calls, and for interspersing \R code and data in the same file. See \code{\link{source.mvb}}.
\item Support for easy macro-like functions which act in their caller's environment (see also RNews 1/3), and for "dynamically scoped" functions. See \code{\link{mlocal}} and \code{\link{do.in.envir}}.
\item Graphical display of which functions call which other functions. See \code{\link{foodweb}}.
}

There are also numerous lower-level utility functions and operators: see \code{?"mvbutils-utils"} and \code{?"mvbutils-operators"}.

To get the full features of \code{mvbutils} (in particular, the project organization), you need to start \R in the \emph{same} directory every time (your "ROOT task"), and then switch to whichever project from inside \R; see \code{\link{cd}}. Various \code{options} always need to be set to make \code{fixr} and the \pkg{debug} package work the way you want, so one advantage of the start-in-the-same directory-approach is that you can keep all your project-independent \code{options()}, library loads, etc., in a single \code{.First} function, called automatically when you start \R. However, most features (including support for the \pkg{debug} package) will probably work even if you don't follow this suggestion.

On loading, \code{mvbutils} creates a new environment in the search path, called \code{mvb.session.info}, which stores some housekeeping information. \code{mvb.session.info} is never written to disk, and disappears when the \R session finishes. [For Splus users: \code{mvb.session.info} is similar to frame 0.] You should never change anything in \code{mvb.session.info} by hand, but it is sometimes useful to look at some of the variables there:

\itemize{
\item \code{.First.top.search} is the directory \R started in (your ROOT task).
\item \code{.Path} shows the currently-attached part of the task hierarchy.
\item \code{base.xxx} is the original copy of an overwritten system function, e.g. \code{help}
\item \code{fix.list} keeps track of functions being edited via \code{\link{fixr}}
\item \code{session.start.time} is the value of \code{Sys.time()} when \code{mvbutils} was loaded
\item \code{source.list} is used by \code{source.mvb} to allow nesting of sources
\item \code{tracees} is used by the \pkg{debug} package to store debugging information
\item \code{r.window.handle} is used by the \pkg{handy} package (Windows only)
}
}
\note{
On loading, the present version of \code{mvbutils} overwrites two system functions: \code{library} and \code{help}. The modifications should have no side-effects, and/but I hope to be able to avoid them altogether in future versions of \R. Briefly:

\itemize{
\item \code{library} is modified so that its default \code{pos} argument becomes a call to \code{lib.pos()}. This means that packages get attached just below ROOT rather than always in position 2 (needed by \code{cd});
\item \code{help} is modified so that, if system \code{help} can't find help for a simple object (not a method or package), it will look for the \code{doc} attribute of that object (if any) and display it in a pager using \code{dochelp}.
}

If you are certain that you \emph{don't} want these replacements, set \code{options(mvbutils.replacements=FALSE)} before loading \code{mvbutils}. However, this will prevent \code{cd} and the flat-documentation help from working properly.

For ESS users: I'm not an Emacs user and so haven't tried ESS with the \pkg{mvbutils} package myself, but a read-through of the ESS documentation suggests that a couple of ESS variables may need changing to get the two working optimally. Please check the ESS documentation for further details on these points. I will update this helpfile when I have more info on what works.

\itemize{
\item \code{cd} changes the search list, so you may need to alter "ess-change-sp-regex" in ESS.
\item \code{cd} also changes the prompt, so you may need to alter "inferior-ess-prompt". Prompts have the form WORD1/WORD2/\dots/WORDn> where WORDx regexp-matches the string \code{"^[a-zA-Z][a-zA-Z._0-9]*$"}
\item \code{move} can add/remove objects in workspaces other than the top one, so if ESS relies on stored internal summaries of "what's where", these may need updating.
}

Display bugs: if you have a buggy Unix display where \code{readline()} always returns the cursor to the start of the line, overwriting any prompt, then try \code{options( cd.extra.CR=TRUE)}.
}
\seealso{ \code{\link{cd}}, \code{\link{fixr}}, \code{\link{flatdoc}}, \code{\link{dochelp}}, \code{\link{formalize.package}}, \code{\link{source.mvb}}, \code{\link{mlocal}}, \code{\link{do.in.envir}}, \code{\link{foodweb}}, \code{\link{clip}}, \code{\link{mvbutils-operators}}, \code{\link{mvbutils-utils}}, package \pkg{debug}}
\author{Mark Bravington}
\keyword{documentation}

\eof
\name{Save}
\alias{Save}
\alias{Save.pos}
\title{Save R objects}
\description{These function resemble \code{save} and \code{save.image}, except that any functions which have been \code{mtrace}d (see the \pkg{debug} package) will be temporarily untraced during saving (though the \pkg{debug} package is not needed to run them). \code{Save()} is like \code{save.image()} \code{Save.pos(i)} saves all objects from the \code{i}th position on the search list in the corresponding .Rdata file. There is less flexibility in the arguments than for the system equivalents.}
\usage{
Save()
Save.pos( pos, path, ascii=FALSE)
}
\arguments{
\item{ pos}{character or numeric position on search path}
\item{ path}{directory or file to save into (see DETAILS).}
\item{ ascii}{file type, as per \code{\link{save}}}
}
\details{
If a function \code{f} is saved while \code{mtrace}d and then restored into a different \R session, there will be an error message when you try to run \code{f}. Assuming that the \pkg{debug} package is loaded, this can be fixed by \code{mtrace(f,FALSE)} or \code{mtrace(f)} if you really want to debug \code{f}. However, you can avoid the problem in the first place by always calling \code{Save} and \code{Save.pos}; this is faster than manually untracing and retracing, and avoids losing any breakpoints. If you use the \code{cd} system in \code{mvbutils}, you will rarely need to call \code{Save.pos} directly; \code{cd}, \code{move} and \code{FF} will do it for you.

To exclude objects from saving, store their names in \code{options( dont.save)}. The default exclusion is \code{.packageName}; good additions might be \code{last.warning} and \code{.Last.value}.

\code{path} is normally inferred from the \code{path} attribute of the \code{pos} workspace. If no such attribute can be found (e.g. if the attached workspace was a list object), you will be prompted. If \code{path} is a directory, the file will be called ".Rdata". If you specify \code{path}, it must be a complete directory path or file path (i.e. it will not be interpreted relative to a \code{path} attribute).
}
\seealso{ \code{\link{save}}, \code{\link{save.image}}, mtrace in package \pkg{debug}}
\examples{
\dontrun{
Save() #
Save.pos( "package:mvbutils") # binary image of exported functions
Save.pos( 3, path="temp.Rdata") # path appended to attr( search()[3], "path")
}
}
\author{Mark Bravington}
\keyword{debugging}
\keyword{file}

\eof
\name{as.data.frame.I}
\alias{as.data.frame.I}
\title{Coerce to data.frame, preserving mode of columns}
\description{\code{as.data.frame.I(x)} protects all columns in \code{x} except factors and numerics using \code{I()} before calling \code{as.data.frame(x)}.}
\usage{as.data.frame.I( x, row.names=NULL, optional=FALSE)}
\arguments{
As per \code{as.data.frame}.
\item{ x}{a list}
\item{ row.names}{\code{NULL} or a character vector giving the row names for the data frame. Missing values are not allowed.}
\item{ optional}{logical. If \code{TRUE}, setting row names and converting column names (to syntactic names) is optional.}
}
\value{A \code{data.frame} with the same columns as \code{x}.}
\examples{
class( as.data.frame( list( x=letters[1:3]))$x) # factor
mode( as.data.frame( list( x=letters[1:3]))$x) # numeric
class( as.data.frame.I( list( x=letters[1:3]))$x) # AsIs
mode( as.data.frame.I( list( x=letters[1:3]))$x) # character
}
\seealso{ \code{\link{data.frame}}, \code{\link{I}}}
\keyword{classes}
\keyword{methods}

\eof
\name{autoFF}
\alias{autoFF}
\title{Callback function for automatic updates of edited functions.}
\description{\code{autoFF} should not be called directly. It can be installed via \code{addTaskCallback( autoFF)}, after which it will be invoked after every successful top-level command (i.e. things you type). It automatically updates any functions being edited via \code{fixr}.}
\usage{
autoFF(\dots) # but don't call it directly
# Use it like this: addTaskCallback( autoFF)
}
\details{\code{autoFF} just calls \code{\link{FF}}. Just typing <ENTER> isn't enough to trigger \code{autoFF}; 0<ENTER> will do, though. To use \code{autoFF}, include the USAGE call in your \code{.First}.}
\arguments{\item{ \dots}{a placeholder that absorbs the arguments passed into \code{autoFF} by the callback mechanism}}
\value{\item{ TRUE (for the benefit of callback handling)}{}}
\examples{
\dontrun{
## Need to set up "fixr" first
## If you use "fixr", try putting this in your ".First"
addTaskCallback( autoFF)
}
}
\seealso{ \code{\link{addTaskCallback}}, \code{\link{fixr}}}
\author{Mark Bravington}
\keyword{utilities}
\keyword{device}

\eof
\name{cd}
\alias{cd}
\title{Organizing R workspaces}
\description{\code{cd} allows you to set up and move through a hierarchically-organized set of \R workspaces, each corresponding to a directory. While working at any level of the hierarchy, all higher levels are attached on the search path, so you can see objects in the "parents". You can easily switch between workspaces in the same session, you can move objects around in the hierarchy, and you can do several hierarchy-wide things such as searching, even on parts of the hierarchy that aren't currently attached.}
\synopsis{cd( to, execute.First=TRUE, execute.Last=TRUE)}
\usage{
 cd()
 cd(to)
 cd(to, execute.First = TRUE, execute.Last = TRUE)
}
\arguments{
\item{ to}{the path of a task to move to or create, as an unquoted string. If omitted, you'll be given a menu. See DETAILS.}
\item{ execute.First}{should the \code{.First.task} code be executed on attachment? Yes, unless there's a bug in it.}
\item{ execute.Last}{should the \code{.Last.task} code be executed on detachment? Yes, unless there's a bug in it.}
}
\details{
\R workspaces can become very cluttered, so that it becomes difficult to keep track of what's what (I have seen workspaces with over 1000 objects in them\dots). If you work on several different projects, it can be awkward to work out where to put "shared" functions-- or to remember where things are, if you come back to a project after some months away. And if you just want to test out a bit of code without leaving permanent clutter, but while still being able to "see" your important objects, how do you do it? \code{cd} helps with all such problems, by letting you organize all your projects into a single tree structure, regardless of where they are stored on disk. Each workspace is referred to (for historical reasons) as a "task".

To use the \code{cd} system, you will need to start \R in the \emph{same} workspace every time. This will become your ROOT or home task, from which all other tasks stem. There need not be much in this workspace except for an object called \code{tasks} (see below), though you can use it for shared functions that you don't want to organize into a package or quasi-package. From the ROOT task, your first action in a new \R session will normally be to use \code{cd} to switch to a real task. The \code{cd} command is used both to switch between existing tasks, and to create new ones.

To set yourself up for working with \code{cd}, it's probably a good idea to make the ROOT task a completely new blank workspace. [In MS-Windows, I'd suggest putting it near the top of the disk directory structure, too.] Start \R in this workspace, type \code{library( mvbutils)}, and then start linking your existing projects into the hierarchy. To link in a project, just type \code{cd()} and a menu will appear. The first time, there will be only one option: "CREATE NEW TASK". Select it (or type 0 to quit if you are feeling nervous), and you will be prompted for a "task name", by which \R will always subsequently refer to the task. Keep the name short; it doesn't have to be related to the location of the disk directory where the .Rdata lives. Avoid spaces and weird characters-- use periods as separators. Task names are case-sensitive. Next, you'll be asked which disk directory this task refers to. By default, \code{cd} expects that you are creating a new task, and therefore suggests putting the directory immediately below the current task directory. However, if you are linking in an existing project, you'll need to supply the directory name. Next, you'll be returned to the \R command prompt-- but the prompt will have changed, so that the ">" is preceded by the task name. If you type \code{search()}, you'll see your ROOT task in position 2, below .GlobalEnv as usual. Despite the name, though, the new .GlobalEnv contains the project you've just linked, and if you type \code{ls()}, you should see some familiar objects. Now type \code{cd(0)} to move back to the ROOT task (note the changed prompt), type \code{search()} and \code{ls()} again to orient yourself, and proceed as before to link the rest of your pre-existing tasks into the hierarchy. When you type \code{cd()}, the menu will have more choices. If you select an existing task rather than creating a new one, you will switch straightaway to that workspace; watch the prompt.

Once you have a hierarchy set up, you can switch the current workspace within the hierarchy by calling e.g. \code{cd(existing.task)} (note the lack of quotes), or by calling \code{cd()} and picking off the menu. You can move through several levels of the hierarchy at once, using a path specifier such as \code{cd(mytask/data/funcs)} or \code{cd(../child.of.sibling)}. Path specifiers are just like Unix or DOS disk paths with "/" as the separator, so that "." means "current task" and ".." means "parent". However, the character 0 must be used to denote the ROOT task, so that you have to type \code{cd(0/different.task)} rather than \code{cd(/different.task}). You can display the entire hiearchy by calling \code{cdtree(0)}, or graphically via \code{plot( cdtree( 0))}.

When you first set up your task hierarchy, you'll also want to create or modify the \code{.First} function in your ROOT task. At a minimum, this should call \code{library( mvbutils)}, but you may also want to set some options controlling the behaviour of \code{cd} (see the OPTIONS section). If you use other features of \code{mvbutils} such as the function-editing interface, there will be further options to be set in \code{.First}.

You can create a fully hierarchical structure, with subtasks within subtasks within tasks, etc. Even if your projects don't naturally look like this, you may find the facility useful. When I create a new project, I tend to start with just one level of hierarchy, containing data, function code, and results. When this gets unspeakably messy, I often create one (or more) subtasks, usually putting the basic data at the top level, and functions and results at the lower level. Apart from tidiness, this provides some degree of protection against overwriting the original data. And when even this gets too messy-- in one task, I have more than 150 functions, and it is very easy to generate 100s of analysis results-- I create another level, keeping "established" functions at the second tier and using the third tier for temporary workspace and results. There are no hard-and-fast rules here, of course, and different people use \R in very different ways.

A task can have \code{.First.task} and/or \code{.Last.task} functions, which get called immediately after \code{cd}ing into the task from its parent, or immediately before \code{cd}ing back to its parent, respectively (see ARGUMENTS). These can be useful for dynamic loading, etc., and facilitate the use of tasks as informal libraries/packages (see also \code{flatdoc}).

Formal and semi-formal packages can also be tasks. For example, my \code{mvbutils}, \code{debug} and \pkg{handy} packages are loaded by \code{library} when I start \R (in my \code{.First}), but are also linked into my task hierarchy (see also \code{mlibrary}). This lets me \code{cd(debug)} when I intend to create or remove a number of functions in \code{debug}. It's also useful to be able to have subtasks below such packages, e.g. so that probably-obsolete functions can be moved there pending a final decision. When you \code{cd} to something that's already attached as a package, \code{search()} will show e.g. "PLACEHOLDER:debug" in the position formerly occupied by the package; when you \code{cd} back up, the package will return to the placeholder slot.

With the \code{cd} approach, the idea is really that everything (including functions) is stored in a single .Rdata file, rather than as separate files to be \code{source}d in when you switch to a project; this reflects my own preference for how to work. Before \code{cd} moves to a new project, either up or down the hierarchy, the current workspace is automatically \code{save.image}d (using default arguments). Nevertheless, I don't think \code{cd} is incompatible with other ways of working, as long as the .Rdata file (actually the \code{tasks} object) is not destroyed from session to session. At any rate, some people who work by \code{source}ing large code files still seem to find \code{cd} useful. With the .Rdata-only approach, it is highly advisable to have some way of keeping separate text backups, at least of function code. The \code{fixr} editing system is geared up to this, and I presume other systems such as ESS are too.
}
\section{Options}{
Various \code{options()} can be set, as follows. Remember to put these into your \code{.First} function, too.

\code{write.mvb.tasks=TRUE} causes a sourceable text representation of the \code{tasks} object to be maintained in each directory, in the file \code{tasks.r}. This helps in case you accidentally wipe out the .Rdata file and lose track of where the child tasks live. To create these text representations for the first time throughout the hierarchy, call \code{cd.write.mvb.tasks(0)}. You need to put the the \code{options} call in your \code{.First}.

\code{options(abbreviate.cdprompt(n))} controls the length of the prompt string. Only the first \code{n} characters of all ancestral task names will be shown. For example, \code{n=1} would replace the prompt \code{long.task.name/data/funcs>} with \code{l/d/funcs>}.
}
\note{
\code{cd} always calls \code{save.image} before attaching a child task on top or moving back up the hierarchy. \code{cd} also calls \code{setwd} so that file searches will default to the task directory (see also \code{task.home}).

\code{cd} is only meant to be called interactively, and has only been tested in that context.

The mechanism underlying the tree structure is very simple: each task that has any subtasks will contain a character vector called \code{tasks}, whose names are the \R names of the tasks, and whose elements are the corresponding disk directories. Your ROOT task need contain no more than a \code{.First} function and a \code{tasks} object. If you decide to move a disk directory, you can manually change the corresponding element of \code{tasks}. If you are moving a whole task hierarchy, e.g. when migrating to a new machine, consult \code{cd.change.all.paths}.

\code{cd} will issue a warning and refuse to move back up the hierarchy if it detects a non-task attached in position 2. You will need to manually detach any such objects before \code{cd}ing back up. \code{cd} is not really designed to work with \code{attach}, and fans of the latter may encounter problems; if so, please let me know.

To make sure that \code{library} always loads packages below ROOT, the \code{.First.lib} code in \code{mvbutils} makes a minor hack to \code{library}, setting the default \code{pos} argument to call \code{lib.pos()}.

Two objects in the \code{mvb.session.info} environment (see \code{search()}) help keep track of what parts of the hierarchy are currently attached; \code{.First.top.search} and \code{.Path}. The former is set when \code{mvbutils} loads, and the latter is updated by \code{cd}. Attached tasks can be identified by having a \code{path} attribute consisting of a NAMED character vector. Normal packages also have a \code{path} attribute, but lacking names.
}
\seealso{ \code{\link{move}}, \code{\link{task.home}}, \code{\link{cdtree}}, \code{\link{cdfind}}, \code{\link{cditerate}}, \code{\link{cd.change.all.paths}}, \code{\link{cd.write.mvb.tasks}}, \code{\link{cdprompt}}, \code{\link{fixr}}}
\author{Mark Bravington}
\keyword{utilities}

\eof
\name{cdfind}
\alias{cdfind}
\alias{cdtree}
\alias{cd.change.all.paths}
\alias{cd.write.mvb.tasks}
\alias{cditerate}
\title{Hierarchy-crawling functions for cd-organized workspaces}
\description{These functions work through part or all of a workspace (task) hierarchy set up via \code{cd}. \code{cdfind} searches for objects through the (attached and unattached) task hierarchy. \code{cdtree} displays the hierarchy structure. \code{cd.change.all.paths} is useful for moving or migrating all or part of the hierarchy to new disk directories. \code{cd.write.mvb.tasks} sets up sourceable text representations of the hierarchy, as a safeguard. \code{cditerate} is the engine that crawls through the hierarchy, underpinning the others; you can write your own functions to be called by \code{cditerate}.}
\usage{
cdfind( pattern, from = ., from.text)
cdtree( from = ., from.text = substitute(from), charlim = 90)
cd.change.all.paths( from.text = "0", old.path, new.path)
cd.write.mvb.tasks( from = ., from.text = substitute(from))
cditerate( from.text, what.to.do, so.far = vector("NULL", 0), \dots)
}
\arguments{
\item{ pattern}{regexpr to be checked against object names.}
\item{ from}{unquoted path specifier (see \code{\link{cd}}); make this 0 to operate on the entire hierarchy.}
\item{ from.text}{use this in place of \code{from} if you want to use a character string instead}
\item{ charlim}{maximum characters per line allowed in graphical display of \code{cdtree}; reduce if unreadable, or change par( \code{cex})}
\item{ old.path}{regexpr showing portion of directory names to be replaced}
\item{ new.path}{replacement portion of directory names}
\item{ what.to.do}{function to be called on each task (see DETAILS)}
\item{ so.far}{starting value for accumulated list of function results}
\item{ \dots}{further fixed arguments to be passed to \code{what.to.do}}
}
\value{
\code{cdfind} returns a list with one element for each object that is found somewhere; each such element is a character vector showing the tasks where the object was found.
\code{cdtree} returns an object of class \code{cdtree}, which is normally printed with indentations to show the hierarchy. You can also \code{plot(cdtree(\dots))} to see a graphical display.
\code{cd.change.all.paths} and \code{cd.write.mvb.tasks} do not return anything useful.
}
\details{
All these functions start by default from the task that is currently top of the search list, and only look further down the hiearchy (i.e. to unattached descendents). To make them work through the whole hierarchy, supply \code{0} as the \code{from} argument.

If you want to automatically crawl through the task hierarchy to do something else, you can write a wrapper function which calls \code{cditerate}, and an inner function to be passed as the \code{what.to.do} argument to \code{cditerate}. The wrapper function will typically be very short; see the code of \code{cdfind} for an example.

The inner function (typically called \code{cdsomething.guts}) must have arguments \code{found}, \code{task.dir}, \code{task.name}, and \code{env}, and may have any other arguments, which will be set according as the \code{\dots} argument of \code{cditerate}. \code{found} accumulates the results of previous calls to \code{what.to.do}. Your inner function can augment \code{found}, and should return the (possibly augmented) \code{found}. As for the other parameters: \code{task.dir} is obvious; \code{task.name} is a character(1) giving the full path specifier, e.g. \code{"ROOT/mytask"}; and \code{env} holds the environment into which the task has been (temporarily) loaded. \code{env} allows you to examine the task; for instance, you can check objects in the task by calling \code{ls(env=env)} inside your \code{what.to.do} function. See the code of \code{cdfind.guts} for an example.
}
\author{Mark Bravington}
\examples{cdfind( ".First", 0) # probably returns list( .First="ROOT")}
\keyword{utilities}

\eof
\name{cdprompt}
\alias{cdprompt}
\title{Support routine for cd-organized workspace hierarchy.}
\description{Sets the command-line prompt to the correct value (see \code{\link{cd}}, and the notes on the option \code{abbreviate.cdprompt}); useful if the prompt somehow becomes corrupted. \code{cdprompt} never seems necessary in \R but has been useful in the S+ manifestations of \code{mvbutils}, where system bugs are commoner.}
\usage{cdprompt()}
\seealso{ \code{\link{cd}}}
\examples{cdprompt()}
\author{Mark Bravington}
\keyword{utilities}

\eof
\name{do.in.envir}
\alias{do.in.envir}
\title{Modify a function's scope}
\description{\code{do.in.envir} lets you write a function whose scope (enclosing environment) is defined at runtime, rather than by the environment in which it was defined.}
\usage{
# Use only as wrapper of function body, like this:
# my.fun <- function(\dots) do.in.envir( fbody, envir=)
# \dots should be the arg list of "my.fun"
# fbody should be the code of "my.fun"
do.in.envir( fbody, envir=parent.frame(2)) # Don't use it like this!
}
\arguments{
\item{ fbody}{the code of the function, usually a braced expression}
\item{ envir}{the environment to become the function's enclosure}
}
\details{
By default, a \code{do.in.envir} function will have, as its enclosing environment, the environment in which it was \emph{called}, rather than \emph{defined}. It can therefore read variables in its caller's frame directly (i.e. without using \code{get}), and can assign to them via \code{<<-}. It's also possible to use \code{do.in.envir} to set a completely different enclosing environment; this is exemplified by some of the functions in \code{debug}, such as \code{go}.

Note the difference between \code{do.in.envir} and \code{mlocal}; \code{mlocal} functions evaluate in the frame of their caller (by default), whereas \code{do.in.envir} functions evaluate in their own frame, but have a non-standard enclosing environment defined by the \code{envir} argument.

Calls to e.g. \code{sys.nframe} won't work as expected inside \code{do.in.envir} functions. You need to offset the frame argument by 5, so that \code{sys.parent()} should be replaced by \code{sys.parent( 5)} and \code{sys.call} by \code{sys.call(-5)}.

\code{do.in.envir} functions are awkward inside namespaced packages, because the code in \code{fbody} will have "forgotten" its original environment when it is eventually executed. This means that objects in the namespace will not be found.

The \pkg{debug} package does not yet trace inside \code{do.in.envir} functions-- this will change.
}
\value{Whatever \code{fbody} returns.}
\examples{
fff <- function( abcdef) ffdie( 3)
ffdie <- function( x) do.in.envir( \{ x+abcdef\} )
fff( 9) # 12; ffdie wouldn't know about abcdef without the do.in.envir call
# Show sys.call issues
# Note that the "envir" argument in this case makes the
# "do.in.envir" call completely superfluous!
ffe <- function(\dots) do.in.envir( envir=sys.frame( sys.nframe()), sys.call( -5))
ffe( 27, b=4) # ffe( 27, b=4)
}
\seealso{ \code{\link{mlocal}}}
\author{Mark Bravington}
\keyword{programming}
\keyword{utilities}

\eof
\name{doc2Rd}
\alias{doc2Rd}
\title{Converts flat documentation to Rd format}
\description{For functions whose \code{help} documentation is stored as a \code{doc} attribute; the text in the \code{doc} attribute is converted into a Rd format character vector. The documentation of the \pkg{mvbutils} package and the \pkg{debug} package was produced this way.}
\usage{ doc2Rd( fun)}
\arguments{\item{ fun}{function object, or character string that names a function.}}
\value{Character vector containing the text as it would appear in an Rd file. Use \code{cat} with \code{sep="\\\\n"} to display this.}
\details{
Flat-format (plain-text) documentation in \code{doc} attributes can be displayed by the replacement \code{help} in \code{mvbutils} (see \code{\link{dochelp}}). For informal purposes, you can write such documentation any way you want. However, if you want to use \code{doc2Rd} to convert it to Rd format, the documentation must follow the rules below. At first sight, these might seem worse than having to learn how to write "native" Rd format, but in practice they are very simple. Check the file "sample.fun.rrr" in the "demo" subdirectory to see how it's done. The formal description below is harder to follow.

The first line should be the docfile name (without the Rd) followed by a few spaces and the package descriptor, like so:

utility-funs package:mypack

When \code{doc2Rd} runs, the docfile name will appear in both the name\{\} field and the first alias\{\} field. \code{\link{formalize.package}} will actually create the file "utility-funs.Rd".

The next non-blank lines form the other alias entries. Each line should consist of one word, preceded by one or more spaces for safety (not necessary if they have normal names).

After the blank line at the end of the aliases, put a one-line title, without any quotes.

Put section titles in capital letters. With multi-word section titles, replace the spaces by periods: e.g. write SEE.ALSO instead of SEE ALSO. The recognized sections are: DESCRIPTION, USAGE, SYNOPSIS, ARGUMENTS, VALUE, DETAILS, EXAMPLES, AUTHOR, SEE.ALSO, REFERENCES, NOTE, KEYWORDS.

Other unrecognized section titles (in capitals) can be used, and will be sentence-cased and wrapped in a section\{\} construct. If an unrecognized section title ends with a period, the text up to the next section will be treated like ARGUMENTS; otherwise, it will be treated like DESCRIPTION (basically, as plain text).

Bulleted lists within DESCRIPTION, DETAILS, AUTHOR, REFERENCES and NOTE sections are identified by lines starting with one or more spaces, then a "-", then another space. Such lists are converted into itemize\{item \dots, item \dots\} constructs.

Each ARGUMENTS item, and optionally each VALUE item, should be on a line beginning with one or more spaces. Lines that don't start with a space will be interpreted as normal text in these sections. Normal text is fine, but you need to itemize arguments to satisfy RCMD CHECK.

Almost anything between a pair of single quotes will be put into a code\{\} construct, and the quotes will be removed. Anything of the form "See XXX" or "see XXX" or "XXX (qv)", where XXX is in single quotes, will be put into a code\{ link\{ \} \} construct, and the " (qv)" will be removed (see also next para). In USAGE and EXAMPLES, and inside code fragments elsewhere, make sure that only double quotes " are used. The exception to code\{\} is that, with "[pP]ackage \code{x}" and "'x' package", \code{x} will go into a pkg\{\} construct rather than a code construct.

Function names in SEE.ALSO should \emph{not} be in single quotes, and should be separated by commas or semicolons; they will be put into code\{ link\{ \} \} constructs. Single-quoted words (with "-" and "." allowed internally) not terminated by a comma or semicolon go into code\{\} constructs (i.e. no link\{\}), or pkg\{\} constructs if preceded or followed by "package". Unquoted words not terminated by a comma or semicolon or end-of-line will not be put into constructs. End-of-line spaces are stripped first. You can split SEE.ALSO across several lines; this won't matter for pager help, but can help produce tidier output in the file "***-manual.tex" produced by RCMD CHECK.

For some reason, two successive closing braces without a space between them seem to cause problems for RCMD CHECK when creating "***-manual.tex"-- so don't do that!

For "don't run" examples, put a "\#\# Don't run" line before and a "\#\# End don't run" line after.

Start the keyword list with a space, and separate keywords with commas or semicolons.

Lines that start with a \% will have the \% removed before conversion. They aren't displayed by \code{dochelp}, though, so can be used to hide an unhelpful SYNOPSIS, say, or to hide an "\#ifdef windows".

Triple dots are converted to \\\\dots, regardless of whether they're in code or normal text. \R is converted to \\\\R.

Any "*emphatic*" constructions (no quotes, just the asterisks) will go into emph\{\} constructs. No other fancy constructs are supported (yet).
}
\examples{
\dontrun{
## Needs a function with the right kind of "doc" attr
text.doc <- doc2Rd( "source.mvb")
cat( doc2Rd( doc2Rd), sep="\\n")
}
}
\seealso{
 To do a whole group at once: \code{\link{formalize.package}}
 The file "sample.fun.rrr" and the demo "flatdoc.demo.r" in subdirectory "demo"
 Also: \code{\link{flatdoc}}, \code{\link{make.usage.section}}, \code{\link{make.arguments.section}}, \code{\link{write.sourceable.function}}
}
\author{Mark Bravington}
\keyword{documentation}

\eof
\name{dochelp}
\alias{dochelp}
\title{Documentation}
\description{\code{dochelp(topic)} will be invoked by the replacement \code{help} if conventional \code{help} fails to find documentation for topic \code{topic}. If \code{topic} has a \code{doc} attribute, the latter will be formatted and displayed by \code{file.show}. \code{dochelp} is not usually called directly.}
\usage{
# Not usually called directly
# If it is, then normal usage is: dochelp( topic)
dochelp( topic, doc)
}
\arguments{
\item{ topic}{(character) name of the object to look for help on.}
\item{ doc}{(character or list)-- normally not set, but deduced by default from \code{topic}; see DETAILS.}
}
\details{
\code{dochelp} will only be called if the original \code{help} call was a simple \code{help(topic=X,\dots)} form, with X not a call and with no \code{try.all.packages} or \code{type} or \code{lib.loc} arguments (the other \code{help} options are OK).

The \code{doc} argument defaults to the \code{doc} attribute of \code{get("topic")}. The only reason to supply a non-default argument would be to use \code{dochelp} as a pager; this might have some value, since \code{dochelp} does reformat character vectors to fit nicely in the system pager window, one paragraph per element, using \code{\link{strwrap}}. Elements starting with a "\%" symbol are not displayed.

To work with \code{dochelp}, a \code{doc} attribute should be either:

\itemize{
\item a character vector, of length >=1. New elements get line breaks in the pager. Or:
\item a length-one list, containing the name of another object with a \code{doc} attribute. \code{dochelp} will then use the \code{doc} attribute of that object instead. This referencing can be iterated.
}

If the documentation is very informal, start it with a blank line to prevent \code{find.documented( Rdformat=TRUE)} from finding it.

The file will be re-formatted to fit the pager; each paragraph should be a single element in the character vector. Elements starting with a \% will be dropped (but may still be useful for \code{doc2Rd}).

\code{\link{flatdoc}} offers an easy way to incorporate plain-text (flat-format) documentation-- formal or informal-- in the same text file as a function definition, allowing easy maintenance.
}
\seealso{ \code{\link{flatdoc}}, \code{\link{doc2Rd}}, \code{\link{find.documented}}, \code{\link{strwrap}}}
\examples{
myfun <- structure( function() 1,
 doc="Here is some informal documentation for myfun\\n")
dochelp( "myfun")
help( "myfun") # calls dochelp
}
\author{Mark Bravington}
\keyword{documentation}

\eof
\name{extract.named}
\alias{extract.named}
\title{Create variables from corresponding named list elements}
\description{This is a convenience function for creating named variables from lists. It's particularly useful for "unpacking" the results of calls to \code{.C}.}
\usage{extract.named( l, to=parent.frame())}
\arguments{
\item{ l}{a list, with some named elements (no named elements is OK but pointless)}
\item{ to}{environment}
}
\value{nothing directly, but will create variables}
\examples{
ff <- function(\dots) \{ extract.named( list(\dots)); print( ls()); bbb \}
# note bbb is not "declared"
ff( bbb=6, ccc=9) # prints [1] "\dots" "bbb" "ccc", returns 6
}
\author{Mark Bravington}
\keyword{programming}

\eof
\name{find.documented}
\alias{find.documented}
\title{Support for flat-format documentation}
\description{Finds functions with flat-format documentation.}
\usage{find.documented( pos=1, doctype=c( "Rd", "casual", "own", "any"))}
\arguments{
\item{ pos}{search path position(s), any length numeric or character}
\item{ doctype}{Defaults to "Rd". If supplied, it is partially matched against the choices in USAGE. "Rd" functions are named in the alias list at the start of any \code{doc} attribute of a function in \code{pos} (see \code{\link{doc2Rd}}); "casual" functions have their own \code{doc} attribute, and will be found by the replacement of \code{help}; "own" functions (a subset of "casual") have their own character-mode \code{doc} attribute, and are suitable for \code{doc2Rd}; "any" combines \code{casual} and \code{Rd}.}
}
\value{Character vector of function names.}
\note{
\code{doctype="Rd"} looks for the alias names, i.e. the first word of all lines occurring before the first blank line. This may include non-existent objects.

Start informal documentation (i.e. not intended for \code{doc2Rd}) with a blank line to avoid confusion.
}
\seealso{ \code{\link{doc2Rd}}, \code{\link{dochelp}}}
\author{Mark Bravington}
\keyword{documentation}
\keyword{programming}
\keyword{utilities}

\eof
\name{fix.order}
\alias{fix.order}
\title{Shows functions sorted by date of edit}
\description{\code{fix.order} sorts the functions according to the filedates of their backups (in the .Backup.mvb directory). This is very useful for reminding yourself what you were working on recently. It only works if functions have been edited using the \code{fixr} system.}
\usage{fix.order( env=1)}
\arguments{\item{ env}{a single number, character string, or environment. Numbers and characters are interpreted as search path positions. The environment must be an attached mvb-style task.}}
\details{Only functions that have a BU*** backup file will appear. Functions that have a BU*** file but have been deleted will not appear.}
\value{Character vector of functions sorted by date/time of last modification.}
\section{To do}{
Probably should modify this so it takes an arbitrary task path instead of a search position only. Task doesn't really need to be attached.

Add a \code{pattern} argument a la find.funs.
}
\examples{
\dontrun{
## Need to create backups and do some function editing first
fix.order() # functions in .GlobalEnv
fix.order( "ROOT") # functions in your startup task
}
}
\seealso{ \code{\link{fixr}}}
\author{Mark Bravington}
\keyword{utilities}

\eof
\name{fixr}
\alias{fixr}
\alias{FF}
\title{Editing functions}
\description{\code{fixr} opens a function in your preferred text editor. Control returns immediately to the \R command line, so you can keep working in \R and can be editing several functions simultaneously (cf \code{edit}). A session-duration list of files/functions being edited is maintained, so that the function can be easily sourced back in to the right workspace, either by calling \code{FF()} or automatically on file change. There is an optional automatic text backup facility.}
\usage{
 fixr( x, new=FALSE, install=FALSE)
 FF()
}
\arguments{
\item{ x}{a quoted or unquoted function name}
\item{ new}{(rarely used) if TRUE, edit a blank function template in .GlobalEnv rather than any existing copy in the search path}
\item{ install}{(rarely used) logical indicating whether to go through the process of asking you about your editor}
}
\note{
\code{fixr} is designed to be used with \code{cd}; I'm not sure it will work independently.

ESS users will not be very interested in \code{fixr}, even if they use \code{cd}!
}
\details{
When \code{fixr} is run for the first time (or if you set \code{install=TRUE}), it will ask you for some basic information about your text editor. In particular, you'll need to know what to type to invoke your text editor from the command shell (MS-DOS prompt on Windows) on a specific file. After supplying these details, \code{fixr} will launch the editor and print a message showing some \code{options} (\code{"backup.fix"}, \code{"edit.scratchdir"} and \code{"program.editor"}), that will need to be set in your \code{.First}. function-- which you can do via \code{fixr(.First)}.

\code{fixr} creates a blank function template if none existed, or if \code{new=TRUE} is specified.

If the function has attributes, it's wrapped in a \code{structure(\dots)} construct. If a \code{doc} attribute exists, it's printed as free-form text at the end of the file, and the call to \code{structure} will end with a line similar to:

,doc=flatdoc( EOF="<<end of doc>>"))

When the file is read later on (see next paragraph, and \code{source.mvb} for technical details), that line will cause the rest of the file to be read in as a \code{doc} attribute, which can be displayed by \code{help}. If you want to add "flat-format documentation", you can also add these lines yourself-- see \code{\link{flatdoc}}.

To read functions back in again, call \code{FF()}, which checks the modification times of any function files. If any have been updated, \code{FF} sources in the code and modifies the appropriate functions. It tries to write functions back into the workspace they came from, which might not be .GlobalEnv. If not, you'll be asked whether you want to \code{save.image} that workspace (provided it's a "task"-- see \code{\link{cd}}). \code{FF} should still put the function in the right place, even if you've called \code{cd} after calling \code{fixr} (unless you've detached the original task) or if you \code{move}d it.

\code{FF} can be called automatically whenever a valid command is executed (e.g. by typing 0<ENTER>; <ENTER> alone doesn't work)-- see \code{\link{autoFF}} for how to do this.

If the function was being \code{mtrace}d (see \code{help(package=debug)}), \code{FF} will re-apply \code{mtrace} after loading the edited version.

If there is a problem with parsing, the \code{source} attribute of the function is updated to the new code, but the function body is invisibly replaced with a \code{stop} call, stating that parsing failed. \code{FF} also prints an immediate warning.

The list of functions being edited by \code{fixr} is stored in the variable \code{fix.list} in the \code{mvb.session.info} environment. When you quit and restart \R, the function files you have been using will stay open in the editor, but \code{fix.list} will be empty; hence, updating the file "myfun.r" will not update the corresponding \R function. If this happens, just type \code{fixr(myfun)} in \R and when your editor asks you if you want to replace the on-screen version, say no. Save the file again (some editors require a token modification, such as space-then-delete, first) and \R will notice the update.

An automatic text backup facility is available from \code{fixr} and \code{FF}: see \code{?get.backup}. The backup system also allows you to sort functions by edit date; see \code{?fix.order}.
}
\seealso{ \code{\link{.First}}, \code{\link{edit}}, \code{\link{cd}}, \code{\link{get.backup}}, \code{\link{fix.order}}, \code{\link{move}}, \code{\link{autoFF}}}
\keyword{utilities}
\keyword{programming}

\eof
\name{flatdoc}
\alias{flatdoc}
\title{Flat-format documentation}
\description{\code{flatdoc} lets you edit plain-text documentation in the same file as your function definition. The documentation can be completely informal, or can be close to the standard on-screen appearance of \R help files (and if so can be converted to actual Rd files by \code{doc2Rd}). This can be useful for your own notes, for informal distribution, and for formal distribution when you are trying to avoid managing dozens of separate source and documentation files.}
\synopsis{flatdoc( EOF="<<end of doc>>")}
\usage{structure( function( \dots) \{body\}, doc=flatdoc( EOF="<<end of doc>>"))}
\arguments{
\item{ EOF}{character string showing when plain text ends, as in \code{readlines.mvb}}
\item{ body}{replace with your function code}
\item{ \dots}{replace with your function arg list}
}
\value{Character vector of class \code{docattr}, as read from the \code{current.source()} (qv) connection.}
\details{
A combined function-and-documentation text file should contain your function code wrapped in a \code{structure(} construct, followed by a line like this:

, doc=flatdoc())

The rest of the file is plain-text documentation, which will be formatted and shown by \code{\link{dochelp}} when \code{help} or \code{?} is called. The documentation can be very informal, but if you follow some guidelines you will be able to convert it automatically to an Rd-format file by calling \code{\link{doc2Rd}}.

When such a file is read in using \code{\link{source.mvb}}, the \code{flatdoc} call will cause the rest of the file to be read in as plain text, and assigned to the \code{doc} attribute of the function. Documentation can be terminated with this line:

<<end of doc>>

The above line will causes \code{source.mvb} to revert to normal statement processing mode for the rest of the file. Note that vanilla \code{source} will not respect \code{flatdoc}; you do need to use \code{source.mvb}.

Files in this format can be produced by \code{write.sourceable.function}, or by hand. The \code{fixr} editing system automatically outputs and inputs \code{flatdoc} format for functions with flat-format documentation.

On some text editors, you can modify syntax highlighting so that the "start of comment block" marker is set to the string "doc=flatdoc(".

It's possible to use \code{flatdoc} to read in more than one free-format text attribute. The \code{EOF} argument can be used to distinguish one block of free text from the next.

\code{flatdoc} should never be called from the command line; it should only appear in text files designed for \code{source.mvb}.

The \code{\link{fixr}} editor interface automatically uses the \code{flatdoc} approach to allow editing of source code and plain-text documentation in the same file. If you use a different editor interface, but like the idea of using \code{flatdoc}-style documentation, then you will need to:

\itemize{
\item make sure \code{source.mvb} rather than \code{source} is used to read in text files;
\item if your system produces text files for the editor directly from function objects (which \code{fixr} does), then make sure that the files are produced by \code{\link{write.sourceable.function}} rather than \code{print} or \code{write} or \code{cat}.
}
}
\note{
You can also write combined code-and-documentation functions whose documentation merely \emph{refers} to another function, like an alias in an Rd file. To refer to documentation stored with a function \code{x}, instead of setting \code{doc} to \code{flatdoc()} at the end of your structure(\dots) construct, set \code{doc} to \code{list("x")}. The referencing can be several layers deep; the documentation of \code{x} can refer to \code{y}, whose documentation refers to \code{z}, whose documentation is actually flatdoc()-style.

If you are writing documentation for a group of functions together, you only need to \code{flatdoc} one of them, say \code{myfun1}. Informal help will work if you modify the others to e.g.

myfun2 <- structure( function(\dots) \{ whatever\}, doc=list("myfun1"))

If you are writing with \code{doc2Rd} in mind and a number of such functions are to be grouped together, e.g. a group of "internal" functions in preparation for formal package release, you may find \code{make.usage.section} and \code{make.arguments.section} helpful.

One reason for needing \code{flatdoc}, rather than just putting \code{,doc="giant character string"}, is that \R requires a backslash at the end of each line of a multi-line string. This format is very painful to edit.
}
\seealso{
 \code{\link{source.mvb}}, \code{\link{doc2Rd}}, \code{\link{dochelp}}, \code{\link{write.sourceable.function}}, \code{\link{make.usage.section}},
 \code{\link{make.arguments.section}}, \code{\link{fixr}}, the demo in "flatdoc.demo.R"
}
\examples{
\dontrun{
## Put everything before the next comment into a text file <<your filename>>
structure( function( x) \{
 x*x
\}
,doc=flatdoc("<<end of doc>>"))
Here is some informal documentation for the "SQUARE" function
<<end of doc>>
## Now try SQUARE <- source.mvb( <<your filename>>); ?SQUARE
## Put everything before the next comment into a text file
myfun <- structure( function(\dots) \{\}
, att1=flatdoc( EOF="<<end of part 1>>")
, att2=flatdoc( EOF="<<end of part 2>>"))
This goes into "att1"
<<end of part 1>>
and this goes into "att2"
<<end of part 2>>
## Now "source.mvb" that file, to create "myfun"
cat( attr( myfun, "att1")) # This goes into "att1"
cat( attr( myfun, "att2")) # This goes into "att2"
}
}
\author{Mark Bravington}
\keyword{documentation}
\keyword{programming}

\eof
\name{foodweb}
\alias{foodweb}
\alias{plot.foodweb}
\alias{callers.of}
\alias{callees.of}
\title{Shows which functions call what}
\description{\code{foodweb} is applied to a group of functions (e.g. all those in a workspace); it produces a graphical display showing the hierarchy of which functions call which other ones. This is handy, for instance, when you have a great morass of functions in a workspace, and want to figure out which ones are meant to be called directly. \code{callers.of(funs)} and \code{callees.of(funs)} show which functions directly call, or are called directly by, \code{funs}.}
\usage{
 foodweb( funs, where=1, charlim=80, prune=character(0), rprune, ancestors=TRUE,
 descendents=TRUE, plotting =TRUE, plotmath=FALSE,
 generics=c( "c","print","plot", "["), lwd=0.5, xblank=0.18,
 border="transparent", boxcolor="white", textcolor="black",
 color.lines=TRUE, highlight="red", \dots)
 plot.foodweb(x, textcolor, boxcolor, xblank, border, textargs = list(),
 use.centres = TRUE, color.lines = TRUE, poly.args = list(),
 expand.xbox = 1.05, expand.ybox = expand.xbox * 1.2, plotmath = FALSE, \dots)
 callers.of( funs, fw=foodweb( plotting=FALSE))
 callees.of( funs, fw=foodweb( plotting=FALSE))
}
\arguments{
\item{ funs}{character vector OR (in \code{foodweb} only) the result of a previous \code{foodweb} call}
In \code{foodweb} but not \code{calle..}, \code{funs} defaults to \code{find.funs(where)}
\item{ where}{position(s) on search path}
\item{ charlim}{controls maximum number of characters per horizontal line of plot}
\item{ prune}{character vector. If omitted, all \code{funs} will be shown; otherwise, only ancestors and descendants of functions in \code{prune} will be shown. Augments \code{funs} if required.}
\item{ rprune}{regexpr version of \code{prune}; \code{prune <- funs \%matching\% rprune}. Does NOT augment \code{funs}. Overrides \code{prune} if set.}
\item{ ancestors}{show ancestors of \code{prune} functions?}
\item{ descendents}{show descendents of \code{prune} functions?}
\item{ plotting}{graphical display?}
\item{ plotmath}{leave alone}
\item{ generics}{calls TO functions in \code{generics} won't be shown}
\item{ lwd}{see \code{\link{par}}}
\item{ xblank}{leave alone}
\item{ border}{border around name of each object (\code{TRUE/FALSE})}
\item{ boxcolor}{background colour of each object's text box}
\item{ textcolor}{of each object}
\item{ color.lines}{will linking lines be coloured according to the level they originate at?}
\item{ highlight}{seemingly not used}
\item{ \dots}{passed to \code{plot.foodweb} and thence to \code{par}}
\item{ textargs}{not currently used}
\item{ use.centres}{where to start/end linking lines. \code{TRUE} is more accurate but less tidy with big webs.}
\item{ expand.xbox}{how much horizontally bigger to make boxes relative to text?}
\item{ expand.ybox}{how much vertically bigger to ditto?}
\item{ poly.args}{other args to \code{rect} when boxes are drawn}
\item{ fw}{an object of class \code{foodweb}, or the \code{funmat} element thereof (see VALUE)}
\item{ x}{a foodweb (as an argument to \code{plot.foodweb})}
}
\details{
The main value is in the graphical display. At the top ("level 0"), functions which don't call any others, and aren't called by any others, are shown without any linking lines. Functions which do call others, but aren't called themselves, appear on the next layer ("level 1"), with lines linking them to functions at other levels. Functions called only by level 1 functions appear next, at level 2, and so on. Functions which call each other will always appear on the same level, linked by a bent double arrow above them. The colour of a linking line shows what level of the hierarchy it came from.

\code{foodweb} makes some effort to arrange the functions on the display to keep the number of crossing lines low, but this is a hard problem! Judicious use of \code{prune} will help keep the display manageable. Perhaps counterintuitively, any functions NOT linked to those in \code{prune} (which all will be, by default) will be pruned from the display.

\code{foodweb} tries to catch names of functions that are stored as text, and it will pick up e.g. \code{glm} in "do.call( \code{glm}, glm.args)". There are limits to this, of course (?methods?).

The argument list may be somewhat daunting, but the only ones normally used are \code{funs}, \code{where}, and \code{prune}. Also, to get a readable display, you may need to reduce \code{cex} and/or \code{charlim}. A number of the less-obvious arguments are set by other functions which rely on \code{plot.foodweb} to do their display work. Several may disappear in future versions.

If the display from \code{foodweb} is unclear, try \code{foodweb( .Last.value, cex=<<something below 1>>, charlim=<<something probably less than 100>>)}. This works because \code{foodweb} will also accept a \code{foodweb}-class object as its argument. You can also assign the result of \code{foodweb} to a variable, which is useful if you expect to do a lot of tinkering with the display, or to inspect the who-calls-whom matrix by hand.

\code{callers.of} and \code{callees.of} process the output of \code{foodweb}, looking for immediate dependencies only. The second argument will call \code{foodweb} by default, so it may be more efficient to call \code{foodweb} first and assign the result to a variable.
}
\value{
\code{foodweb} returns an object of (S3) class \code{foodweb}. This has three components:
\item{ funmat}{a matrix of 0's and 1's showing what (row) calls what (column). The \code{dimnames} are the function names.}
\item{ x}{shows the x-axis location of the centre of each function's name in the display, in \code{par("usr")} units}
\item{ level}{shows the y-axis location of the centre of each function's name in the display, in \code{par("usr")} units. For small numbers of functions, this will be an integer; for larger numbers, there will some adjustment around the nearest integer}
Apart from graphical annotation, the main useful thing is \code{funmat}, which can be used to work out the "pecking order" and e.g. which functions directly call a given function.
\code{callers.of} and \code{callees.of} return a character vector of function names.
}
\examples{
foodweb( ) # functions in .GlobalEnv
foodweb( where="package:mvbutils", cex=0.4, charlim=60) # yikes!
foodweb( c( find.funs("package:mvbutils"), "paste"))
# functions in .GlobalEnv, and "paste"
foodweb( find.funs("package:mvbutils"), prune="paste")
# only those parts of the tree connected to "paste";
# NB that funs <- unique( c( funs, prune)) inside "foodweb"
foodweb( where='package:mvbutils', rprune="aste")
# doesn't include "paste" as it's not in "mvbutils", and rprune doesn't augment funs
foodweb( where='package:mvbutils', rprune="name") # does work
fw <- foodweb( where="package:mvbutils")
fw$funmat # a big matrix
callers.of( "mlocal", fw)
callees.of( find.funs() \%matching\% "name", fw)
}
\author{Mark Bravington}
\keyword{utilities}

\eof
\name{formalize.package}
\alias{formalize.package}
\title{Create a formal package skeleton from an informal package}
\description{\code{formalize.package} is useful when you have a set of functions with flat-format documentation that you want to make into a formal package. It creates a bare-bones package with \R source and Rd documentation ready for RCMD CHECK.}
\usage{
 formalize.package()
 formalize.package( funs=find.funs( where), package, where=1, dir.=,
 description.file=, new.index=TRUE, README.goes.first=TRUE)
}
\arguments{
\item{ funs}{character vector, defaulting to all functions in \code{where}.}
\item{ package}{name to give test package-- see DETAILS for default.}
\item{ where}{position in search path to make into package.}
\item{ dir.}{directory to contain test package. Defaults to \code{path} attribute of search pos \code{where}}
\item{ description.file}{filename of template DESCRIPTION file. If this doesn't exist, a default DESCRIPTION file will be concocted.}
\item{ new.index}{should it create a new INDEX file using \code{Rdindex}}
\item{ README.goes.first}{if there's a function whose name starts with \code{README}, should its documentation file be renamed so that it's found first? See "Package structure details".}
}
\details{
A bare-bones package skeleton is created (no C code etc.) in directory \code{dir.}. The skeleton will have a DESCRIPTION file, a single \R source file with name "<<package>>.r" in the "R" subdirectory, and the individual function-by-function Rd files in the "man" subdirectory. More details of the package structure are given below.

The recommended way to use \code{formalize.package} is to have your collection of functions as a task called e.g. \code{my.proto.package}, use \code{cd(my.proto.package)} to bring it to the top workspace, and then call \code{formalize.package()}. This will create the formal skeleton in the "my.proto.package" subdirectory of the task directory.

The name of the package is determined by the \code{package} parameter, which will default to the obvious, as above. If \code{package} is not supplied and no sensible default can be deduced, there will be an error message. The gory details are: \code{package} defaults to the \code{name} attribute of search pos \code{where}, without preceding "package:" if any; if this is NULL, \code{package} defaults to the \code{names} attribute of the \code{path} attribute of search pos \code{where}, which will have been set if the thing being packaged is a task.

The \code{mvbutils} and \pkg{debug} packages started life as simple tasks, automatically loaded by my \code{.First} as proto-packages using \code{mlibrary}. Eventually they acquired flat-format documentation-- informal at first, then massaged towards Rd format as CRAN release approached. I then used \code{formalize.package} and (repeatedly!) RCMD CHECK.

Package structure details:

All pre-existing files in the "man" and "R" subdirectories (only) will be removed. No other files or subdirectories are created or removed. You will certainly want to edit the DESCRIPTION file before actual CRAN release.

By default, the \R source file will only contain functions, but you can include other objects too by naming them in the \code{funs} argument. For functions, only source code will be included; in other words, any attributes except \code{source} are removed before printing. In particular, flat-format documentation in \code{doc} attributes does not go into the \R file. However, it is used to create the Rd files, by\code{\link{doc2Rd}}.

If any of the Rd files starts with a period (e.g. ".dotty.name"), it will be renamed to "01.dotty.name.Rd" (to avoid some problems with rcmd).

If \code{README.goes.first} is TRUE, any Rd file starting with \code{README} will be renamed \code{00README\dots}. This will ensure that the README\dots function appears first in the "package manual", and top of the list when \code{library(help=mypackage)} is called.
}
\seealso{ \code{\link{cd}}, \code{\link{flatdoc}}, \code{\link{doc2Rd}}, \code{\link{README.mvbutils}}, \code{\link{make.usage.section}}, \code{\link{make.arguments.section}}}
\author{Mark Bravington}
\keyword{programming}
\keyword{utilities}

\eof
\name{get.backup}
\alias{get.backup}
\alias{restore.all.backups}
\alias{create.backups}
\title{Text backups of function source code}
\description{\code{get.backup} retrieves backups of a function. \code{restore.all.backups} creates objects from their most recent backups. \code{create.backups} creates a whole set of backup files at once. All backups must have been created using the \code{fixr} system.}
\usage{
get.backup( name, where=1, rev=TRUE, zap.name=TRUE)
restore.all.backups( where=2)
create.backups()
}
\arguments{
\item{ name}{function name (character)}
\item{ where}{position in search path (character or numeric)}
\item{ rev}{if TRUE, most recent backup comes first in the return value}
\item{ zap.name}{if TRUE, the tag \code{"funname" <- } at the start of each backup is removed}
}
\value{
\item{ get.backup}{Either NULL with a warning, if no backups are found, or a list containing the backups, each as a character vector.}
\item{ restore.all.backups}{NULL, but numerous objects will be created or over-ridden}
\item{ create.backups}{NULL}
}
\details{
\code{fixr} and \code{FF} are able to maintain text-file backups of source code, in a directory ".Backup.mvb" below the task directory. The directory will contain a file called INDEX, plus files BU1, BU2, etc. INDEX shows the correspondence between function names and BUx files. Each BUx file contains multiple copies of the source code, with the oldest first.

The number of backups kept is controlled by \code{options(backup.fix)}, a numeric vector of length 2. The first element is how many backups to keep from the current \R session. The second is how many previous \R sessions to keep the final version of the source code from. Older versions get discarded. I use \code{c(5,2)}. If you want to use the backup facility, you'll need to set this option in your \code{.First}. If the option is not set, no backups happen.

\code{create.backups} can be used (probably once only) to create the backup directory, index, and backup files for all functions in the currently-top task. Otherwise, these things will be created as needed by \code{fixr} and \code{FF}, but only for those functions that actually get edited.

\code{restore.all.backups} always restores to the current workspace, regardless of where it is restoring from. This is a safety feature. If you screw up the .Rdata file in task \code{mytask} and want to restore the functions in it from backups, the safe way to do it is to \code{cd(mytask)}, then \code{cd(restore)} to create a subtask, then \code{restore.all.backups()} to create "masking" versions in \code{mytask/restore}. Then you can check the restorees and \code{move( what=<<some or all>>, ., ..)} to put them back into \code{mytask}. Set \code{overwrite.by.default=TRUE} in the \code{move} call if you don't want to check each file. The more risky way is just to \code{cd(mytask)} and \code{restore.all.backups(1)}-- this will overwrite any more recent versions that you may want to keep.

\code{get.backup} offers more control, in that you get all (available) backup versions of a given function, but can only be called for one function at a time. You can also examine the backup files by hand, of course.

The function \code{\link{fix.order}} uses the access dates of backup files to list your functions sorted by date order.

\code{move} will also move backup files and update INDEX files appropriately.
}
\examples{
\dontrun{
## Need some backups first
get.backup( "myfun", "package:myfun")[[1]] # returns most recent backup only
cat( get.backup( "myfun", "package:myfun", zap=FALSE)[[1]][1])
# shows "myfun" <- function\dots
# restore.all.backups(1) # really don't run this
}
}
\seealso{ \code{\link{fixr}}, \code{\link{cd}}, \code{\link{move}}}
\author{Mark Bravington}
\keyword{programming}
\keyword{utilities}
\keyword{documentation}

\eof
\name{local.return}
\alias{local.return}
\title{Macro-like functions}
\description{In an \code{\link{mlocal}} function, \code{local.return} should be used whenever \code{return} is called, wrapped inside the \code{return} call around the return arguments.}
\usage{
local.return(\dots) # Don't use it like this!
# Correct usage: return( local.return( \dots))
}
\arguments{\item{ \dots}{named and unnamed list, handled the same way as \code{return} before \R 1.8, or as \code{\link{returnList}}}}
\examples{
ffin <- function( nlocal=sys.parent()) mlocal( return( local.return( a)))
ffout <- function( a) ffin()
ffout( 3) # 3
# whereas:
ffin <- function( nlocal=sys.parent()) mlocal( return( a))
ffout( 3) # NULL; "return" alone doesn't work
}
\seealso{ \code{\link{mlocal}}}
\author{Mark Bravington}
\keyword{programming}

\eof
\name{make.usage.section}
\alias{make.usage.section}
\alias{make.arguments.section}
\title{Construct sections of documentation}
\description{These are really intended for expediting documentation of large numbers of "internal" functions in a proto-package. \code{make.usage.section} and \code{make.arguments.section} form prototype USAGE and ARGUMENTS section for the specified functions. These are ready for pasting into flat-format documentation (and subsequent editing).}
\usage{
make.usage.section( funs=, file=stdout())
make.arguments.section( funs=, file=stdout())
}
\arguments{
\item{ funs}{character vector, defaulting to \code{find.funs() \%except\% find.documented( doctype="Rd")}}
\item{ file}{where to put the output (\code{"clipboard"} is useful)}
}
\details{
The default \code{funs} argument will find all functions not mentioned in flat-format ready-for-doc2Rd documentation. This is useful for documenting a group of "internal" functions.

\code{make.usage.section} simply puts the name of each function before its deparsed and concatenated argument list, one function per line.

\code{make.arguments.section} puts one argument per line, then a colon, then the name of the function in parentheses. The idea is that something about the argument should be added manually in a text editor.
}
\examples{
make.usage.section( c( "make.usage.section", "find.funs")) # charvec returned invisibly
make.arguments.section( c( "make.usage.section", "find.funs")) # ditto
}
\seealso{ \code{\link{flatdoc}}, \code{\link{formalize.package}}}
\author{Mark Bravington}
\keyword{documentation}

\eof
\name{mlibrary}
\alias{mlibrary}
\title{Loading and listing of informal packages}
\description{\code{mlibrary} lets you use tasks as informal proto-packages. The documentation etc. requirements are much less stringent than for proper packages.}
\usage{
# Usual: mlibrary( task=)
mlibrary( \dots, character.only=FALSE, task, pos=lib.pos(), execute.First=TRUE)
}
\arguments{
\item{ task}{an unquoted character string naming a task.}
\item{ character.only}{if TRUE, \code{task} will be interpreted as a normal quoted character string.}
\item{ pos}{a position on the search path; no reason not to use the default}
\item{ execute.First}{if FALSE, don't execute any \code{.First.lib} code. ?Is this working?}
\item{ \dots}{other arguments as for \code{library}}
}
\value{As for \code{library}.}
\details{
\code{mlibrary( task=mytask)} loads task \code{mytask} as a library. It sets \code{lib.loc} based on the disk location of \code{mytask} before calling \code{library}. If no objects are found in the loaded package after the \code{library} call (i.e. if there is no code in the file "R/mytask"), then \code{mlibrary} will load the .Rdata file and execute its \code{.First.lib} if any (but see below). This binary-loading feature is extremely convenient if you are developing personal proto-libraries and want to avoid the formality of \R source files, Rd documentation files, and perpetual RCMD INSTALL; it's how I maintain \code{mvbutils}, for example. Of course, for CRAN distribution you must do the job properly; \code{\link{formalize.package}} may help.

To use task \code{XXX} as a proto-package loaded via \code{mlibrary(task=XXX)}, all you need to add to \code{XXX} is a DESCRIPTION file in the task directory; none of the usual package subdirectories (not even "R" or "man") need be present.

After \code{mlibrary( task=mytask)}, you can \code{cd(mytask)} to bring \code{mytask} into the active workspace (top of the search path); see \code{\link{cd}}. Note that \code{mlibrary} calls \code{.First.lib}, while \code{cd} calls \code{.First.task}, and you probably don't want both in a single task.

\code{execute.First=FALSE} is useful for debugging; if there is a problem in \code{.First.lib}, normal \code{library} will just refuse to load the package.

\code{mlibrary} without a \code{task} argument will duplicate \code{library}. In particular, \code{.execute.First=FALSE} will have no effect.
}
\note{
(1) The "binary load" option (see \code{?INSTALL}) available in more recent versions of \R may make \code{mlibrary} partly obsolete.

(2) \code{mlibrary} has not been tried with namespaced proto-libraries.
}
\examples{
\dontrun{
mlibrary( task=mvbutils)
}
}
\seealso{ \code{\link{cd}}, \code{\link{formalize.package}}}
\author{Mark Bravington}
\keyword{utilities}

\eof
\name{mlocal}
\alias{mlocal}
\title{Macro-like functions}
\description{\code{mlocal} lets you write a function whose statements are executed in its caller's frame, rather than in its own frame.}
\usage{
# Use only as wrapper of function body, like this:
# my.fun <- function(\dots, nlocal=sys.parent()) mlocal( expr)
# \dots should be replaced by the arguments of "my.fun"
# expr should be replaced by the code of "my.fun"
# nlocal should always be included as shown
mlocal( expr) # Don't use it like this!
}
\arguments{\item{ expr}{the function code, normally a braced expression}}
\details{
Sometimes it's useful to write a "child" function that can create and modify variables in its parent directly, without using \code{assign} or \code{<<-} (note that \code{<<-} will only work on variables that exist already). This can make for clearer, more modular programming; for example, tedious initializations of many variables can be hidden inside an \code{initialize()} statement. The definition of an \code{mlocal} function does not have to occur within its caller; the \code{mlocal} function can exist as a completely separate \R object.

\code{mlocal} functions can have arguments just like normal functions. These arguments will temporarily hide any objects of the same name in the \code{nlocal} frame (i.e. the calling frame). When the \code{mlocal} function exits, its arguments will be deleted from the calling frame and the hidden objects (if any) will be restored. Sometimes it's desirable to avoid cluttering the calling frame with variables that only matter to the \code{mlocal} function. A useful convention is to "declare" such temporary variables in your function definition, as defaultless arguments after the \code{nlocal} argument.

The \code{nlocal} argument of an \code{mlocal} function-- which must ALWAYS be included in the definition, with the default specified as \code{sys.parent()}-- can normally be omitted when invoking your \code{mlocal} function. However, you will need to set it explicitly when your function is to be called by another, e.g. \code{lapply}; see the third example. A more daring usage is to call e.g. \code{fun.mlocal(nlocal=another.frame.number)} so that the statements in \code{fun.mlocal} get executed in a completely different frame. A convoluted example can be found in the (internal) function \code{find.debug.HQ} in the \pkg{debug} package, which creates a frame and defines a large number of variables in it, by calling \code{setup.debug.admin(nlocal=new.frame.number)}.

\code{mlocal} functions can be nested, though this gets confusing. By default, all evaluation will happen in the same frame.

Note that (at least at present) all arguments are evaluated as soon as your \code{mlocal} function is invoked, rather than by the usual lazy evaluation mechanism. Missing arguments are still OK, though.

If you call \code{return} in an \code{mlocal} function, you must call \code{\link{local.return}} too.

Frame-dependent functions (sys.parent()) etc. will not do what you expect inside an \code{mlocal} function. In \R 1.8 at least, you need to shift the normal index by 3 to get what you'd expect, so that \code{sys.call(-3)} inside an \code{mlocal} function will return the call to the \code{mlocal} function, and \code{sys.function( sys.parent(3))} will return the \code{mlocal} function definition. You can get the expected results for the \emph{caller} via \code{mvb.sys.parent} with no shift, etc.-- unless the caller is itself an \code{mlocal} function.

\code{on.exit} works as you might expect, i.e. in the \code{mlocal} function only. Calls to \code{on.exit} in the \code{mlocal} function will \emph{not} alter the exit code in the caller.

See R-news 2001 \#3 (1/3) for another closely related approach to "macros".
}
\value{As per your function; also see \code{\link{local.return}}.}
\examples{
# Tidiness and variable creation
init <- function( nlocal=sys.parent()) mlocal( sqr.a <- a*a)
ffout <- function( a) \{ init(); sqr.a \}
ffout( 5) # 25
# Parameters and temporary variables
ffin <- function( n, nlocal=sys.parent(), a, i) mlocal(\{
 # this "n" and "a" will temporarily replace caller's "n" and "a"
 print( n)
 a <- 1
 for( i in 1:n)
 a <- a*x
 a
 \})
x.to.the.n.plus.1 <- function( x, n) \{
 print( ffin( n+1))
 print( n)
 print( ls())
 \}
x.to.the.n.plus.1( 3, 2) # prints as follows:
# [1] 3 (in "ffin")
# [1] 27 (result of "ffin")
# [1] 2 (original n)
# [1] "n" "x" (vars in "x.to.the\dots"-- NB no a or i)
# Use of "nlocal"
ffin <- function( i, nlocal=sys.parent()) mlocal( a <- a+i )
ffout <- function( ivec) \{ a <- 0; sapply( ivec, ffin, nlocal=sys.nframe()) \}
ffout( 1:3) # 1 3 6
}
\seealso{ \code{\link{local.return}}, \code{\link{do.in.envir}}, and R-news 1/3}
\author{Mark Bravington}
\keyword{programming}

\eof
\name{move}
\alias{move}
\title{Organizing R workspaces}
\description{\code{move} shifts one or more objects around the task hierarchy (see \code{\link{cd}}), whether or not the source and destination are currently attached on the search path.}
\synopsis{move( x='.', from='.', to='.', what, overwrite.by.default=FALSE, copy=FALSE)}
\usage{
move( x, from, to)
move( what=, from, to)
move( x, from, to, copy=, overwrite.by.default=)
}
\arguments{
\item{ x}{unquoted name}
\item{ from}{unquoted path specifier}
\item{ to}{unquoted path specifier}
\item{ what}{character vector}
\item{ overwrite.by.default}{logical(1)}
\item{ copy}{logical(1)}
}
\details{
The normal invocation is something like \code{move( myobj, ., 0/another.task)}-- note the lack of quotes around \code{myobj}. To move objects with names that have to be quoted, or to move several objects at the same time, specify the \code{what} argument: e.g. \code{move( what=c( "myobj", "\%myop\%"), ., 0/another.task)}. Note that \code{move} is playing fast and loose with standard argument matching here; it correctly interprets the \code{.} as \code{from}, rather than \code{x}. This well-meaning subversion can lead to unexpected trouble if you deviate from the paradigms in EXAMPLES. If in doubt, you can always name \code{from} and \code{to}.

If \code{move} finds an object with the same name in the destination, you will be asked whether to overwrite it. If you say no, the object will not be moved. If you want to force overwriting of a large number of objects, set \code{overwrite.by.default=TRUE}.

By default, \code{move} will delete the original object after it has safely arrived in its destination. It's normally only necessary (and more helpful) to have just one instance of an object; after all, if it needs to be accessed by several different tasks, you can just \code{move} it to an ancestral task. However, if you really do want a duplicate, you can avoid deletion of the original by setting \code{copy=TRUE}.

You will be prompted for whether to \code{save} the source and destination tasks, if they are attached somewhere, but not in position 1. Normally this is a good idea, but you can always say no, and call \code{save.pos} or \code{Save.pos} later. If the source and/or destination are not attached, they will of course be \code{save}d automatically. The top workspace (i.e. current task) \code{.GlobalEnv} is never saved automatically; you have to call \code{save.image} or \code{Save} yourself.

\code{move} is not meant to be called within other functions.
}
\examples{
\dontrun{
move( myobj, ., 0) # back to the ROOT task
move( what="\%myop\%", 0/first.task, 0/second.task)
# neither source nor destination attached. Funny name requires "what"
move( what=c( "first.obj", "second.obj"), ., ../sibling.task)
# multiple objects require "what"
}
}
\seealso{ \code{\link{cd}}}
\author{Mark Bravington}
\keyword{utilities}

\eof
\name{mvb.sys.parent}
\alias{mvb.sys.parent}
\alias{mvb.sys.nframe}
\alias{mvb.match.call}
\alias{mvb.nargs}
\alias{mvb.sys.call}
\alias{mvb.sys.function}
\alias{mvb.sys.on.exit}
\title{Functions to Access the Function Call Stack}
\description{These functions are "do what I mean, not what I say" equivalents of the corresponding system functions. The system functions can behave strangely when called in strange ways (primarily inside \code{eval} calls). The \code{mvb} equivalents behave in a more predictable fashion.}
\usage{
mvb.sys.parent(n=1)
mvb.sys.nframe()
mvb.match.call(definition = sys.function(mvb.sys.parent()),
 call = sys.call(mvb.sys.parent()), expand.dots = TRUE)
mvb.nargs()
mvb.sys.call(which = 0)
mvb.sys.function(n)
mvb.sys.on.exit()
}
\arguments{
All as per the corresponding system functions, from whole helpfiles the following is taken:
\item{ which}{the frame number if non-negative, the number of generations to go back if negative. (See the Details section.)}
\item{ n}{the number of frame generations to go back.}
\item{ definition}{a function, by default the function from which \code{match.call} is called.}
\item{ call}{an unevaluated call to the function specified by \code{definition}, as generated by \code{call}.}
\item{ expand.dots}{logical. Should arguments matching \code{\dots} in the call be included or left as a \code{\dots} argument?}
}
\value{See the helpfiles for the system functions.}
\details{Sometimes \code{eval} is used to execute statements in another frame. If such statements include calls to the system versions of these routines, the results will probably not be what you want. In technical terms: the same environment will actually appear several times on the call stack (returned by \code{sys.frame()}) but with a different calling history each time. The \code{mvb.} equivalents look through \code{sys.frames()} for the first frame whose environment is identical to the environment they were called from, and base all conclusions on that first frame. To see how in detail, look at the most fundamental function: \code{mvb.sys.parent}.}
\examples{
ff.no.eval <- function() sys.nframe()
ff.no.eval() # 1
ff.system <- function() eval( quote( sys.nframe()), envir=sys.frame( sys.nframe()))
ff.system() # expect 1 as per ff.no.eval, get 3
ff.mvb <- function() eval( quote( mvb.sys.nframe()), envir=sys.frame( sys.nframe()))
ff.mvb() # 1
ff.no.eval <- function(\dots) sys.call()
ff.no.eval( 27, b=4) # ff.no.eval( 27, b=4)
ff.system <- function(\dots) eval( quote( sys.call()), envir=sys.frame( sys.nframe()))
ff.system( 27, b=4) # eval( expr, envir, enclos) !!!
ff.mvb <- function(\dots) eval( quote( mvb.sys.call()), envir=sys.frame( sys.nframe()))
ff.mvb( 27, b=4) # ff.mvb( 27, b=4)
}
\seealso{ \code{\link{sys.parent}}, \code{\link{sys.nframe}}, \code{\link{match.call}}, \code{\link{nargs}}, \code{\link{sys.call}}, \code{\link{sys.function}}, \code{\link{sys.on.exit}}}
\author{Mark Bravington}
\keyword{programming}

\eof
\name{mvbutils-internal}
\alias{mvbutils-internal}
\alias{\%**\%}
\alias{as.docattr}
\alias{assign.to.base}
\alias{called.by}
\alias{cdfind.guts}
\alias{cd.change.all.paths.guts}
\alias{cdtree.guts}
\alias{cd.write.mvb.tasks.guts}
\alias{cd..}
\alias{cd.load}
\alias{char.unlist}
\alias{close.selfdeleting.file}
\alias{create.bkind.if.needed}
\alias{deal.with.backups}
\alias{discard.mouldering.backups}
\alias{dos.or.windows}
\alias{exists.mvb}
\alias{expand.match}
\alias{find.path}
\alias{find.prefix}
\alias{find.web}
\alias{get.bkfile}
\alias{get.cd.from.menu}
\alias{get.path.list}
\alias{group}
\alias{hack.help}
\alias{hack.library}
\alias{index}
\alias{install.proged}
\alias{is.nonzero}
\alias{least.mutual.dependency}
\alias{lib.pos}
\alias{load.mvb}
\alias{make.new.cd.task}
\alias{maybe.save.after.move}
\alias{move.backup.file}
\alias{move.fix.list}
\alias{my.all.equal}
\alias{organize.web.display}
\alias{plot.cdtree}
\alias{print.cdtree}
\alias{print.docattr}
\alias{prepare.for.move}
\alias{promote.2.to.1}
\alias{put.in.session}
\alias{read.bkind}
\alias{reattach.placeholder}
\alias{save.pos}
\alias{set.path.attr}
\alias{set.pos.and.path}
\alias{set.test}
\alias{unpaste}
\alias{upper.case}
\alias{what.is.open}
\alias{write.mvb.tasks}
\title{Internal functions for mvbutils}
\description{Internal functions for \code{mvbutils}, not meant to be called directly.}
\usage{
x \%**\% y
as.docattr(x)
assign.to.base( x, what=lapply( named( x),
 function( x, where) get( "replacement." \%&\% x, pos=where),
 where=where), where=-1)
called.by( fname, can.match, where)
cdfind.guts(found, task.dir, task.name, pattern, env)
cd.change.all.paths.guts(found, task.dir, task.name = "??",
 env, old.path, new.path, case)
cdtree.guts(found, task.dir, task.name, env)
cd.write.mvb.tasks.guts(found, task.dir, task.name, env)
cd..(pos, nlocal = sys.parent())
cd.load( taskname, pos, attach.new, nlocal = sys.parent())
char.unlist(x)
close.selfdeleting.file( con, \dots)
create.bkind.if.needed(dir)
deal.with.backups(name, where)
discard.mouldering.backups(nlocal = sys.parent())
dos.or.windows()
exists.mvb(x, pos = -1, envir = pos.to.env(pos), frame, mode = "any",
 inherits = FALSE)
expand.match(short, long, any.case = FALSE)
find.path(rel.path, char.rel.path, return.all = FALSE)
find.prefix(j, nodes, parents)
find.web(nlocal = sys.parent())
get.bkfile(name, bkdir, create = FALSE)
get.cd.from.menu()
get.path.list()
group(m, \dots)
hack.library()
index( lvector)
install.proged()
is.nonzero( x)
least.mutual.dependency(funmat, funs, level)
lib.pos()
load.mvb(filename, name, pos, attach.new, \dots)
make.new.cd.task(task.name, nlocal = sys.parent(), answer, dir.name)
maybe.save.after.move(to.from)
move.backup.file(name, old.dir, new.dir, copy = FALSE)
move.fix.list(nlocal = sys.parent())
my.all.equal(x, y)
organize.web.display(resequence = TRUE, merge01 = FALSE,
 plotmath = FALSE, nlocal = sys.parent())
prepare.for.move(path)
plot.cdtree( x, \dots)
print.cdtree( x, \dots)
print.docattr( x, \dots)
promote.2.to.1()
put.in.session(\dots)
read.bkind(dir)
reattach.placeholder(sn, nlocal = sys.parent())
save.pos( pos, path, ascii=FALSE)
set.path.attr(env, the.path, task.name = character(0))
set.pos.and.path( nlocal=sys.parent())
set.test(a, b)
unpaste(string, sep)
upper.case( s)
what.is.open()
write.mvb.tasks(tasks = get("tasks", env = env),
 env = .GlobalEnv, dir = attr(env, "path"))
}
\note{
The following may be obsolete: \code{expand.match}, \code{char.unlist}, \code{\%**\%}, \code{what.is.open}

or duplicative

\itemize{
\item \code{index} (nearly synonymous with \code{which})
\item \code{my.all.equal} (\code{identical}? \code{all.equal}?)
\item \code{unpaste} (for compatibility with S+)
\item \code{upper.case} (\code{casefold})
\item \code{save.pos} (use \code{Save.pos} instead for more safety)
}

The \code{print} and \code{plot} methods do the obvious thing; this seems to be the least intrusive place to "document" them.

\code{hack.library} and \code{hack.help} produce modified versions of the appropriate system functions, hopefully in a version-independent fashion. See \code{\link{README.mvbutils}}.
}
\author{Mark Bravington}
\keyword{internal}

\eof
\name{mvbutils-operators}
\alias{mvbutils-operators}
\alias{\%&\%}
\alias{\%!in\%}
\alias{\%is.a\%}
\alias{\%is.not.a\%}
\alias{\%is.an\%}
\alias{\%is.not.an\%}
\alias{\%except\%}
\alias{\%matching\%}
\alias{\%without.name\%}
\alias{\%in.range\%}
\alias{\%upto\%}
\alias{\%downto\%}
\alias{\%where\%}
\title{Utility operators}
\description{Succinct or convenience operators}
\usage{
a \%&\% b
a \%!in\% b
x \%is.not.a\% what
x \%is.a\% what
x \%is.not.an\% what
x \%is.an\% what
vector \%except\% condition
x \%matching\% patt
x \%without.name\% what
a \%in.range\% b
from \%upto\% to
from \%downto\% to
x \%where\% cond
}
\arguments{\item{ a, b, vector, condition, x, what, patt, from, to, cond}{see "Arguments By Function" below.}}
\section{Arguments by function }{
\item{ \%&\%}{a, b:character vectors to be \code{paste}d with no separator}
\item{ \%!in\%}{a, b:vectors (character, numeric, complex, or logical).}
\item{ \%except\%}{vector, condition:character or numeric vectors}
\item{ \%in.range\%}{a, b:numeric vectors.}
\item{ \%is.a\%, etc.}{x:object whose class is to be checked}
\item{ \%is.a\%, etc.}{what:class name}
\item{ \%matching\%}{x:character vector}
\item{ \%matching\%}{patt:character vector of regexps}
\item{ \%upto\%, \%downto\%}{from, to:numeric(1)}
\item{ \%where\%}{x:data.frame}
\item{ \%where\%}{cond:unquoted expression to be \code{eval}ed in context of \code{x}, then in the calling frame of \code{\%where\%} (or .GlobalEnv). Wrap \code{cond} in parentheses to avoid trouble with operator precedence.}
\item{ \%without.name\%}{x:object with \code{names} attribute}
\item{ \%without.name\%}{what:character vector of names to drop}
}
\value{
\item{ \%&\%}{string concatenation via \code{paste( a, b, sep="")}}
\item{ \%!in\%}{logical negation of \code{\%in\%}}
\item{ \%is.a\%}{(and \code{\%is.not.a\%}, \code{\%is.an\%}, \code{\%is.not.an\%}) result of \code{inherits} to test class membership}
\item{ \%except\%}{\code{vector} except those elements that match something in \code{condition}}
\item{ \%matching\%}{those elements in \code{x} which are regexp-matched with any of the \code{patt}s}
\item{ \%without.name\%}{\code{x} except those elements whose names match \code{what}}
\item{ \%in.range\%}{those elements of \code{a} that are >=min(b) and <=max(b)}
\item{ \%upto\%}{like \code{:} except that if \code{to<from}, numeric(0) is returned (useful for coding for-loops)}
\item{ \%downto\%}{converse of \code{\%upto\%}}
\item{ \%where\%}{those rows of the data.frame \code{x} where \code{cond} is satisfied (see DETAILS)}
}
\examples{
 "a" \%&\% "b" # "ab"
 1:5 \%!in\% 3:4 # c( TRUE, TRUE, FALSE, FALSE, TRUE)
 trf <- try( 1+"nonsense")
 if( trf \%is.not.a\% "try-error") cat( "OK\\n") else cat( "not OK\\n")
 1:5 \%except\% c(2,4,6) # c(1,3,5)
 c( alpha=1, beta=2) \%without.name\% "alpha" # c( beta=2)
 1:5 \%in.range\% c( 2, 4) # c(F,T,T,T,F)
 c( "cat", "hat", "dog", "brick") \%matching\% c( "at", "ic") # cat hat brick
 1 \%upto\% 2 # 1:2
 1 \%upto\% 0 # numeric( 0); using \%upto\% rather than : in for-loops can simplify coding
 1 \%downto\% 0 # 1:0
 1 \%downto\% 2 # numeric( 0)
 ff <- function( which.row) \{
 x <- data.frame( a=1:3, b=4:6)
 x \%where\% (a==which.row)
 \}
 ff( 2) # data.frame( a=2, b=5)
}
\author{Mark Bravington}
\keyword{programming}
\keyword{utilities}
\keyword{misc}

\eof
\name{mvbutils-utils}
\alias{mvbutils-utils}
\alias{clip}
\alias{cq}
\alias{deparse.names.parsably}
\alias{empty.data.frame}
\alias{expanded.call}
\alias{find.funs}
\alias{is.dir}
\alias{legal.filename}
\alias{masked}
\alias{masking}
\alias{mkdir}
\alias{named}
\alias{option.or.default}
\alias{pos}
\alias{print.cat}
\alias{print.nullprint}
\alias{returnList}
\alias{safe.rbind}
\alias{to.regexpr}
\alias{yes.no}
\title{Miscellaneous utilities}
\description{Miscellaneous utilities.}
\usage{
clip( x, n=1)
cq( \dots)
deparse.names.parsably( x)
empty.data.frame( \dots)
expanded.call( nlocal=sys.parent())
find.funs(pos=1, \dots)
is.dir( dir)
legal.filename( name)
masked( pos)
masking( pos=1)
mkdir( dirlist)
named( x)
option.or.default( opt.name, default)
pos( substrs, mainstrs, any.case = FALSE, names.for.output)
print.cat( x, \dots)
print.nullprint( x, \dots)
returnList( \dots)
safe.rbind( df1, df2)
to.regexpr( x)
yes.no( prompt, default)
}
\arguments{
\item{ x, n, \dots, nlocal, dir, name, pos, dirlist, opt.name, default, substrs,}{}
\item{ mainstrs, any.case, names.for.output, df1, df2, prompt}{see "Arguments by function"}
}
\section{Arguments by function }{
\item{ clip}{x:a vector or list}
\item{ clip}{n:integer saying how many elements to clip from the end of \code{x}}
\item{ cq}{\dots:quoted or unquoted character strings, to be \code{substitute}d and then concatenated}
\item{ deparse.names.parsably}{x:any object for \code{deparse}-- \code{name} objects treated specially}
\item{ empty.data.frame}{\dots:named length-1 vectors of appropriate mode, e.g. "first.col=''"}
\item{ expanded.call}{nlocal:frame to retrieve arguments from. Normally, use the default; see \code{\link{mlocal}}.}
\item{ find.funs}{\dots:extra arguments for \code{objects}. Usually just "pattern" for regexp searches.}
\item{ is.dir}{dir:character vector of files to check existence and directoriness of.}
\item{ legal.filename}{name:character string to be modified}
\item{ find.funs}{pos:list of environments, or vector of char or numeric positions in search path.}
\item{ masking, masked}{pos:position in search path}
\item{ mkdir}{dirlist:character vector of directories to create}
\item{ named}{x:character vector which will become its own \code{names} attribute}
\item{ option.or.default}{opt.name:character(1)}
\item{ option.or.default}{default:value to be returned if there is no \code{option} called \code{"opt.name"}}
\item{ pos}{substrs:character vector of patterns (literal not regexpr)}
\item{ pos}{mainstrs:character vector to search for \code{substrs} in.}
\item{ pos}{any.case:logical-- ignore case?}
\item{ pos}{names.for.output:character vector to label rows of output matrix; optional}
\item{ print.cat, print.nullprint}{x:thing to print}
\item{ print.cat, print.nullprint}{\dots:args for \code{print} (ignored)}
\item{ returnList}{\dots:named or un-named arguments, just as for \code{return} before \R 1.8.}
\item{ safe.rbind}{df1, df2:\code{data.frame} or \code{list}}
\item{ to.regexpr}{x:character vector}
\item{ yes.no}{prompt:string to put before asking for input}
\item{ yes.no}{default:value to return if user just presses <ENTER>}
}
\details{
\code{clip} removes the last \code{n} elements of \code{x}.

\code{cq} is handy for typing \code{cq( alpha, beta, gamma)} instead of \code{cq( "alpha", "beta", "gamma")}. Certain strings DO still require quotes around them, e.g. \code{cq( "NULL", "1-2")}).

\code{deparse.names.parsably} is like \code{deparse} except that \code{name} objects get wrapped in a call to \code{as.name}, so that they won't be evaluated accidentally.

\code{empty.data.frame} creates a template data frame with 0 rows but with all columns of the appropriate type.

\code{find.funs} finds "function" objects in one or more environments, optionally matching a pattern.

\code{expanded.call} returns the full argument list available to its caller, including defaults where arguments were not set explicitly. The arguments may not be those originally passed, if they were modified before the invocation of \code{expanded.call}. Default arguments which depend on calculations after the invocation of \code{expanded.call} will lead to an error.

\code{is.dir} tests for directoriness.

\code{legal.filename} coerces its character argument into a similar-looking string that is a legal filename on any (?) system

\code{masked} checks which objects in \code{search()[pos]} are masked by identically-named objects higher in the search path. \code{masking} checks objects mask identically-named objects lower in the search path. Namespaces may make the results irrelevant.

\code{mkdir} makes directories; unlike \code{dir.create}, it can do several levels at once.

\code{named(x)} is just \code{names(x) <- as.character( x); x}; useful for \code{lapply} etc.

\code{option.or.default} returns the named option value if it exists, otherwise the supplied default.

\code{pos} will either search for several literal patterns in a single target, or vice versa-- not both. It returns a matrix showing the positions of the matching substrings, with as many columns as the maximum number of matches. 0 signifies "no match"; there is always at least one column even if there are no matches at all. \code{pos} is very slow and should probably be rewritten.

\code{print}: if \code{class(x)=="cat"}, the character vector \code{x} will be \code{print}ed by \code{cat(x,sep="\\n")}. If \code{class(x)=="nullprint"}, then \code{print(x)} will not print anything.

\code{returnList} returns a list corresponding to old-style (pre-R 1.8) \code{return} syntax. Briefly: a single argument is returned as itself. Multiple arguments are returned in a list. The names of that list are the argument names if provided; or, for any unnamed argument that is just a symbolic name, that symbolic name; or no name at all, for other unnamed arguments. You can duplicate pre-1.8 behaviour of \code{return(\dots)} via \code{return(returnList(\dots))}.

\code{safe.rbind} mimics \code{rbind}, but works round an \R bug (I reckon) where a column appears to be a numeric in one \code{data.frame} but a factor in the other.

\code{to.regexpr} converts literal strings to their equivalent regexprs, e.g. by doubling backslashes.

\code{yes.no} \code{cat}s the \code{prompt} argument and waits for user input. if the user input \code{pmatch}es "yes" or "YES", then \code{yes.no} returns \code{TRUE}; if the input \code{pmatch}es \code{no} or \code{NO} then \code{yes.no} returns \code{FALSE}; if the input is '' and \code{default} is set, then \code{yes.no} returns \code{default}; otherwise it repeats the question. You probably want to put a space at the end of \code{prompt}.
}
\value{
\item{ clip}{vector of the same mode as \code{x}.}
\item{ cq}{character vector.}
\item{ empty.data.frame}{\code{data.frame}}
\item{ expanded.call}{a \code{call} object}
\item{ find.funs}{a character vector of function names}
\item{ is.dir}{logical vector}
\item{ is.nonzero}{TRUE or FALSE}
\item{ legal.filename}{character( 1)}
\item{ masked}{character vector.}
\item{ masking}{character vector.}
\item{ mkdir}{logical vector of success/failure}
\item{ named}{vector of the same mode as \code{x}}
\item{ option.or.default}{option value}
\item{ pos}{numeric matrix, one column per match found plus one ; at least one column guaranteed}
\item{ returnList}{list or single object}
\item{ safe.rbind}{\code{data.frame}}
\item{ to.regexpr}{character}
\item{ yes.no}{TRUE or FALSE}
}
\examples{
clip( 1:5, 2) # 1:3
cq( alpha, beta) # c( "alpha", "beta")
empty.data.frame( a=1, b="yes")
# data.frame with 0 rows of columns "a" (numeric) and
# "b" (a factor with levels ""yes"")
f <- function( a=9, b) expanded.call(); f( 3, 4) # list( a=3, b=4)
find.funs( "package:base", patt="an") # "transform" etc.
is.dir( getwd()) # TRUE
legal.filename( "a:b\\\\c/d&f") # "a.b.c.d&f"
sapply( named( cq( alpha, beta)), nchar) # c( alpha=5, beta=4)
option.or.default( "my.option", 5) # probably 5
pos( cq( quick, lazy), "the quick brown fox jumped over the lazy dog")
# matrix( c( 5, 37), nrow=2)
pos( "quick", c( "first quick", "second quick quick", "third"))
# matrix( c( 7,8,0, 0,14,0), nrow=3)
pos( "quick", "slow") # matrix( 0)
f <- function() \{ a <- 9; return( returnList( a, a*a, a2=a+a)) \}
f() # list( a=9, 81, a2=18)
levels( rbind( data.frame( x=1), data.frame( x="cat"))$x)
# NULL, because "x" acquires mode "character"; a bug, I think
levels( safe.rbind( data.frame( x=1), data.frame( x="cat"))$x)
# c( "1", "cat")
to.regexpr( "a[[") # "a\\\\[\\\\["
\dontrun{
mkdir( "subdirectory.of.getwd")
yes.no( "OK (Y/N)? ")
masking( 1)
masked( 5)
}
}
\author{Mark Bravington}
\keyword{utilities}
\keyword{misc}

\eof
\name{my.index}
\alias{my.index}
\alias{my.index.assign}
\alias{my.index.exists}
\title{Arbitrary-level retrieval from and modification of recursive objects}
\description{\code{my.index} and \code{my.index.assign} are designed to replace \code{[[} and \code{[[<-} \emph{within} a function, to allow arbitrary-depth access into any recursive object. In order to avoid conflicts with system usage and/or slowdowns, it may be wise to do this only inside a function definition where they are needed. \code{my.index.exists} tests whether the indexed element actually exists.}
\usage{
# Use them like this, inside a function definition:
# assign( "[[", my.index); var[[i]]
# assign( "[[<-", my.index.assign); var[[i]] <- value
my.index( var, \dots) # not normally called by name
my.index.assign( var, \dots, value) # not normally called by name
my.index.exists( i, var)
}
\arguments{
\item{ var}{a recursive object of any mode (not just \code{list}, but e.g. \code{call} too)}
\item{ value}{anything}
\item{ \dots}{one or more numeric index vectors, to be concatenated}
\item{ i}{numeric index vector}
}
\details{
Although \R allows arbitrary-level access to lists, this does not (yet) extend to \code{call} objects or certain other language objects-- hence these functions. They are written entirely in \R, and are probably very slow as a result. It is probably \emph{unwise} to replace system \code{[[} and \code{[[<-} with these replacements at a global level, i.e. outside the body of a function-- these replacements do not dispatch based on object class, for example.

Note that \code{my.index} and \code{my.index.assign} distort strict \R syntax, by concatenating their \code{\dots} arguments before lookup. Strictly speaking, \R says that \code{x[[2,1]]} should extract one element from a matrix list; however, this doesn't really seem useful because the same result can always be achieved by \code{x[2,1][[1]]}. With \code{my.index}, \code{x[[2,1]]} is the same as \code{x[[c(2,1)]]}. The convenience of automatic concatentation seems slightly preferable.

\code{my.index.exists} checks whether \code{var} is "deep enough" for \code{var[[i]]} to work. Unlike the others, it does not automatically concatenate indices.

At present, there is no facility to use a mixture of character and numeric indexes, which you can in S+ via "list subscripting of lists".
}
\examples{
assign( "[[", my.index)
assign( "[[<-", my.index.assign)
ff <- function() \{ a <- b + c \}
body( ff)[[2,3,2]] # as.name( "b")
my.index.exists( c(2,3,2), body( ff)) # TRUE
my.index.exists( c(2,3,2,1), body( ff)) # FALSE
body( ff)[[2,3,2]] <- quote( ifelse( a>1,2,3))
ff # function () \{ a <- ifelse(a > 1, 2, 3) + c \}
my.index.exists( c(2,3,2,1), body( ff)) # now TRUE
remove( list=c( "[[", "[[<-"))
}
\author{Mark Bravington}
\keyword{programming}
\keyword{utilities}

\eof
\name{readLines.mvb}
\alias{readLines.mvb}
\title{Read text lines from a connection}
\description{Reads text lines from a connection (just like \code{readLines}), but optionally only until a specfied string is found.}
\usage{ readLines.mvb( con=stdin(), n=-1, ok=TRUE, EOF=as.character( NA))}
\arguments{
\item{ con}{A connection object or a character string.}
\item{ n}{integer. The (maximal) number of lines to read. Negative values indicate that one should read up to the end of the connection.}
\item{ ok}{logical. Is it OK to reach the end of the connection before `n > 0' lines are read? If not, an error will be generated.}
\item{ EOF}{character. If the current line matches the EOF, it's treated as an end-of-file, and the read stops. The connection is left OPEN so that subsequent reads work.}
}
\details{Apart from stopping if the EOF line is encountered, behaviour should be as for \code{readLines}.}
\value{A character vector of length the number of lines read.}
\examples{
tt <- tempfile()
cat( letters[ 1:6], sep="\\n", file=tt)
the.data <- readLines.mvb( tt, EOF="d")
unlink( tt)
the.data # [1] "a" "b" "c"
}
\seealso{ \code{\link{source.mvb}}, \code{\link{current.source}}, \code{\link{flatdoc}}}
\keyword{IO}

\eof
\name{source.mvb}
\alias{source.mvb}
\alias{from.here}
\alias{current.source}
\title{Read R code and data from a file or connection}
\description{\code{source.mvb} works like \code{source(local=TRUE)}, except you can intersperse free-format data into your code. \code{current.source} returns the connection that's currently being read by \code{source.mvb}, so you can redirect input accordingly. To do this conveniently inside \code{read.table}, you can use \code{from.here} to read the next lines as data rather than \R code.}
\usage{
 source.mvb( con, envir=parent.frame(), max.n.expr=Inf, echo, prompt.echo)
 current.source()
 from.here( EOF=as.character(NA)) # Don't use it like this!
 # Use "from.here" only inside "read.table", like so: read.table( file=from.here( EOF=), \dots)
}
\arguments{
\item{ con}{a filename or connection}
\item{ envir}{an environment to evaluate the code in; by default, the environment of the caller of \code{source}}
\item{ max.n.expr}{finish after evaluating \code{max.n.expr} complete expressions, unless file ends first.}
\item{ echo}{logical; defaults to \code{option.or.default( "verbose", FALSE)}}
\item{ prompt.echo}{what to show before the first line of each echoed command.}
\item{ EOF}{line which terminates data block; lines afterwards will again be treated as \R statements.}
\item{ \dots}{other args to \code{read.table}}
}
\value{
\code{source.mvb} returns the value of the last expression executed, but is mainly called for its side-effects of evaluating the code.
\code{from.here} returns a connection, of class \code{c( "selfdeleting.file", "file", "connection")}; see DETAILS.
\code{current.source} returns a connection.
}
\details{
Calls to \code{source.mvb} can be nested, because the function maintains a stack of connections currently being read by \code{source.mvb}. The stack is stored in the list \code{source.list} in the \code{mvb.session.info} environment, on the search path. \code{current.source} returns the last (most recent) entry of \code{source.list}.

The sequence of operations differs from vanilla \code{source}, which parses the entire file and then executes each expression in turn; that's why it can't cope with interspersed data. Instead, \code{source.mvb} parses one statement, then executes it, then parses the next, then executes that, etc. Thus, if you include in your file a call to e.g.

 \code{text.line <- readLines( con=current.source(), n=1)}

then the next line in the file will be read in to \code{text.line}, and execution will continue at the following line. \code{\link{readLines.mvb}} can be used to read text whose length is not known in advance, until a terminating string is encountered; lines after the terminator, if any, will again be evaluated as \R expressions by \code{source.mvb}.

After \code{max.n.expr} statements (i.e. syntactically complete \R expressions) have been executed, \code{source.mvb} will return.

If the connection was open when \code{source.mvb} is called, it is left open; otherwise, it is closed.

If you want to use \code{read.table} or \code{scan} etc. inside a \code{source.mvb} file, to read either a known number of lines or the rest of the file as data, you can use e.g. \code{read.table( current.source(), \dots)}.

If you want to \code{read.table} to read an \emph{unknown} number of lines until a terminator, you could explicitly use \code{\link{readLines.mvb}}, as shown in the demo "source.mvb.demo.R". However, the process is cumbersome because you have to explicitly open and close a \code{textConnection}. Instead, you can just use \code{read.table( from.here( EOF=\dots), \dots)} with a non-default \code{EOF}, as in USAGE and the same demo (but see NOTE). \code{from.here} \emph{shouldn't} be used inside \code{scan}, however, because a temporary file will be left over.

\code{current.source()} can also be used inside a source file, to work out the source file's name. Of course, this will only work if the file is being handled by \code{source.mvb} rather than \code{source}.

If you type \code{source.list} at the \R command prompt, you should always see an empty list, because all \code{source.mvb} calls should have finished. However, the source list can occasionally become corrupt, i.e. containing invalid connections (I have only had this happen when debugging \code{source.mvb} and quitting before the exit code can clean up). If so, you'll get an error message on typing \code{source.list} (?an \R bug?). Normally this won't matter at all. If it bothers you, try \code{source.list <<- list()}.
}
\note{
\code{from.here} creates a temporary file, which should be automatically deleted when \code{read.table} finishes (with or without an error). Technically, the connection returned by \code{from.here} is of class \code{selfdeleting.file} inheriting from \code{file}; this class has a specific \code{close} method, which unlinks the \code{description} field of the connection. This trick works inside \code{read.table}, which calls \code{close} explicitly, but not in \code{scan} or \code{closeAllConnections}, which ignore the \code{selfdeleting.file} class.

\code{from.here()} without an explicit terminator is equivalent to \code{readLines( current.source())}, and the latter avoids temporary files.
}
\section{Limitations}{Because \code{source.mvb} relies on \code{\link{pushBack}}, \code{con=stdin()} won't work.}
\examples{
# You wouldn"t normally do it like this:
tt <- tempfile()
cat( "data <- scan( current.source(), what=list( x=0, y=0))",
 "27 3",
 "35 5",
 file=tt, sep="\\n")
source.mvb( tt)
unlink( tt)
data # list( x=c( 27, 35), y=c(3, 5))
# "current.source", useful for hacking:
tt <- tempfile()
cat( "cat( \\"This code is being read from file\\",",
 "summary( current.source())$description)", file=tt)
source.mvb( tt)
cat( "\\nTo prove the point:\\n")
cat( scan( tt, what="", sep="\\n"), sep="\\n")
unlink( tt)
}
\section{To do}{Add at least the \code{local=FALSE} argument of \code{source}.}
\seealso{ \code{\link{source}}, \code{\link{readLines.mvb}}, \code{\link{flatdoc}}, the demo in "source.mvb.demo.R"}
\keyword{IO}

\eof
\name{strip.missing}
\alias{strip.missing}
\title{Exclude "missing" objects}
\description{To be called inside a function, with a character vector of object names in that function's frame. \code{strip.missing} will return all names except those corresponding to formal arguments which were not set in the original call and which lack defaults. The output can safely be passed to \code{get}.}
\usage{strip.missing( obs)}
\arguments{\item{ obs}{character vector of object names, often from \code{ls(all=TRUE)}}}
\details{Formal arguments that were not passed explicitly, but which \emph{do} have defaults, will \emph{not} be treated as missing; instead, they will be set equal to their evaluated defaults. This could cause problems if the defaults aren't meant to be evaluated.}
\examples{
funco <- function( first, second, third) \{
 a <- 9
 return( do.call("returnList", lapply( strip.missing( ls()), as.name)))
\}
funco( 1) # list( a=9, first=1)
funco( second=2) # list( a=9, second=2)
funco( ,,3) # list( a=9, third=3)
funco2 <- function( first=999) \{
 a <- 9
 return( do.call("returnList", lapply( strip.missing( ls()), as.name)))
\}
funco() # list( a=9, first=999) even tho' "first" was not set
}
\seealso{ \code{\link{returnList}}}
\author{Mark Bravington}
\keyword{programming}

\eof
\name{task.home}
\alias{task.home}
\title{Organizing R workspaces}
\description{Returns file path to current task, or to a file in that task.}
\usage{
task.home()
task.home(fname)
}
\arguments{\item{ fname}{file name, a character(1)}}
\details{
Without any arguments, \code{task.home} returns the path of the current task. With a filename argument, the filename is interpreted as relative to the current task, and its full (non-relative) path is returned.

\code{task.home} is almost obsolete in \R, since the working directory tracks the current task. It is more important in the S+ version of \code{mvbutils}.
}
\examples{
\dontrun{
task.home( "myfile.c") # probably the same as file.path( getwd(), "myfile.c")
task.home() # probably the same as getwd()
}
}
\seealso{ \code{\link{cd}}, \code{\link{getwd}}, \code{\link{file.path}}}
\author{Mark Bravington}
\keyword{utilities}

\eof
\name{write.sourceable.function}
\alias{write.sourceable.function}
\title{Sourceable code for functions with flat-format documentation}
\description{Works like "write" for functions without flat documentation (i.e. without a "doc" attribute). If a "doc" attribute exists, the file is written in a form allowing it to be edited and then read back in with "source.mvb"; the "doc" attribute is given as free-form text following the function definition.}
\usage{write.sourceable.function( x, con, append=FALSE, print.name=FALSE)}
\arguments{
\item{ x}{function object (or the name of a function) to be output}
\item{ con}{a connection or filename}
\item{ append}{if "con" is not already open, should it be appended to rather than overwritten?}
\item{ print.name}{should output start with \code{"NAME" <-} (where NAME is deduced from \code{x})?}
}
\details{
If \code{x} is unquoted and \code{print.name=TRUE}, the name is obtained from \code{deparse( substitute( x))}. If \code{x} is a character string, the name is \code{x} itself and the function printed is \code{get(x)}.

The real criterion for an attribute to be output in \code{flatdoc}-style, is not whether the attribute is called \code{doc}, but rather whether it is a character-mode object of class \code{docattr}. You can use this to force \code{flatdoc}-style output of several \code{doc}-like attributes.

The default EOF line for an attribute is <<end of doc>>, but this will be adjusted if it appears in the attribute itself.
}
\examples{
\dontrun{
write.sourceable.function( write.sourceable.function, "wsf.r")
# To dump all functions and their documentation in a workspace into a single sourceable file:
cat( "", file="allfuns.r")
sapply( find.funs(), write.sourceable.function, file="allfuns.r", append=TRUE, print.name=TRUE)
}
}
\seealso{ \code{\link{source.mvb}}, \code{\link{readLines.mvb}}, \code{\link{flatdoc}}, the file "demo/original.dochelp.rrr", the demo in "flatdoc.demo.r"}
\keyword{programming}
\keyword{documentation}

\eof
