### Name: foodweb
### Title: Shows which functions call what
### Aliases: foodweb plot.foodweb callers.of callees.of
### Keywords: utilities

### ** Examples

foodweb( ) # functions in .GlobalEnv
foodweb( where="package:mvbutils", cex=0.4, charlim=60) # yikes!
foodweb( c( find.funs("package:mvbutils"), "paste"))
# functions in .GlobalEnv, and "paste"
foodweb( find.funs("package:mvbutils"), prune="paste")
# only those parts of the tree connected to "paste";
# NB that funs <- unique( c( funs, prune)) inside "foodweb"
foodweb( where='package:mvbutils', rprune="aste")
# doesn't include "paste" as it's not in "mvbutils", and rprune doesn't augment funs
foodweb( where='package:mvbutils', rprune="name") # does work
fw <- foodweb( where="package:mvbutils")
fw$funmat # a big matrix
callers.of( "mlocal", fw)
callees.of( find.funs() %matching% "name", fw)



