### Name: mvbutils-operators
### Title: Utility operators
### Aliases: mvbutils-operators \%&\% \%!in\% \%is.a\% \%is.not.a\%
###   \%is.an\% \%is.not.an\% \%except\% \%matching\% \%without.name\%
###   \%in.range\% \%upto\% \%downto\% \%where\%
### Keywords: programming utilities misc

### ** Examples

 "a" %&% "b" # "ab"
 1:5 %!in% 3:4 # c( TRUE, TRUE, FALSE, FALSE, TRUE)
 trf <- try( 1+"nonsense")
 if( trf %is.not.a% "try-error") cat( "OK\n") else cat( "not OK\n")
 1:5 %except% c(2,4,6) # c(1,3,5)
 c( alpha=1, beta=2) %without.name% "alpha" # c( beta=2)
 1:5 %in.range% c( 2, 4) # c(F,T,T,T,F)
 c( "cat", "hat", "dog", "brick") %matching% c( "at", "ic") # cat hat brick
 1 %upto% 2 # 1:2
 1 %upto% 0 # numeric( 0); using %upto% rather than : in for-loops can simplify coding
 1 %downto% 0 # 1:0
 1 %downto% 2 # numeric( 0)
 ff <- function( which.row) {
 x <- data.frame( a=1:3, b=4:6)
 x %where% (a==which.row)
 }
 ff( 2) # data.frame( a=2, b=5)



