### Name: mvbutils-utils
### Title: Miscellaneous utilities
### Aliases: mvbutils-utils clip cq deparse.names.parsably empty.data.frame
###   expanded.call find.funs is.dir legal.filename masked masking mkdir
###   named option.or.default pos print.cat print.nullprint returnList
###   safe.rbind to.regexpr yes.no
### Keywords: utilities misc

### ** Examples

clip( 1:5, 2) # 1:3
cq( alpha, beta) # c( "alpha", "beta")
empty.data.frame( a=1, b="yes")
# data.frame with 0 rows of columns "a" (numeric) and
# "b" (a factor with levels ""yes"")
f <- function( a=9, b) expanded.call(); f( 3, 4) # list( a=3, b=4)
find.funs( "package:base", patt="an") # "transform" etc.
is.dir( getwd()) # TRUE
legal.filename( "a:b\\c/d&f") # "a.b.c.d&f"
sapply( named( cq( alpha, beta)), nchar) # c( alpha=5, beta=4)
option.or.default( "my.option", 5) # probably 5
pos( cq( quick, lazy), "the quick brown fox jumped over the lazy dog")
# matrix( c( 5, 37), nrow=2)
pos( "quick", c( "first quick", "second quick quick", "third"))
# matrix( c( 7,8,0, 0,14,0), nrow=3)
pos( "quick", "slow") # matrix( 0)
f <- function() { a <- 9; return( returnList( a, a*a, a2=a+a)) }
f() # list( a=9, 81, a2=18)
levels( rbind( data.frame( x=1), data.frame( x="cat"))$x)
# NULL, because "x" acquires mode "character"; a bug, I think
levels( safe.rbind( data.frame( x=1), data.frame( x="cat"))$x)
# c( "1", "cat")
to.regexpr( "a[[") # "a\\[\\["
## Not run: 
##D mkdir( "subdirectory.of.getwd")
##D yes.no( "OK (Y/N)? ")
##D masking( 1)
##D masked( 5)
## End(Not run)



