### Name: MarronWand
### Title: Marron-Wand Densities as `norMix' Objects
### Aliases: MarronWand MW.nm1 MW.nm2 MW.nm3 MW.nm4 MW.nm5 MW.nm6 MW.nm7
###   MW.nm8 MW.nm9 MW.nm10 MW.nm11 MW.nm12 MW.nm13 MW.nm14 MW.nm15 MW.nm16
### Keywords: datasets distribution

### ** Examples

MW.nm10
plot(MW.nm14)

## These are defined as norMix() calls in  ../R/zMarrWand-dens.R
require("nor1mix")
ppos <- which("package:nor1mix" == search())
nms <- ls(pat="^MW.nm", pos = ppos)
nms <- nms[order(as.numeric(substring(nms,6)))]
for(n in nms) {
   cat("\n",n,":\n"); print(get(n, pos = ppos))
}

## Plot all of them:
op <- par(mfrow=c(4,4), mgp = c(1.2, 0.5, 0), tcl = -0.2,
          mar = .1 + c(2,2,2,1), oma = c(0,0,3,0))
for(n in nms) { plot(get(n, pos = ppos))}
mtext("The Marron-Wand Densities", outer = TRUE,
      font = 2, cex = 1.6)
par(op)



