\name{MarronWand}
\alias{MarronWand}% to use as "link"
%% Note: These are ``datasets'' , but cannot be handled as strictly
%%       as such since they  *require* the normix package.
\alias{MW.nm1}
\alias{MW.nm2}
\alias{MW.nm3}
\alias{MW.nm4}
\alias{MW.nm5}
\alias{MW.nm6}
\alias{MW.nm7}
\alias{MW.nm8}
\alias{MW.nm9}
\alias{MW.nm10}
\alias{MW.nm11}
\alias{MW.nm12}
\alias{MW.nm13}
\alias{MW.nm14}
\alias{MW.nm15}
\alias{MW.nm16}
\non_function{}
\title{Marron-Wand Densities as `norMix' Objects}
\description{
  The fifteen density examples used in Marron and Wand (1992)'s
  simulation study have been used in quite a few subsequent studies,
  can all be written as normal mixtures and are provided here for
  convenience and didactical examples of normal mixtures.
  Number 16 has been added by Jansen et al.
}
\usage{
 MW.nm1	 # Gaussian
 MW.nm2	 # Skewed
 MW.nm3	 # Str Skew
 MW.nm4	 # Kurtotic
 MW.nm5	 # Outlier
 MW.nm6	 # Biomdal
 MW.nm7	 # Separated (bimodal)
 MW.nm8	 # Aymmettric Bimodal
 MW.nm9	 # Trimodal
 MW.nm10 # Claw
 MW.nm11 # Double Claw
 MW.nm12 # Asymmetric Claw
 MW.nm13 # Asymm. Double Claw
 MW.nm14 # Smooth   Comb
 MW.nm15 # Discrete Comb
 MW.nm16 # Distant Bimodal
}
\source{
  The first part % 1..15 ??
  are translated from Steve Marron's Matlab code at
  \url{http://www.stat.unc.edu/postscript/papers/marron/parameters/nmpar.m}
}
\author{Martin Maechler}
\references{
  Marron, S. and Wand, M. (1992)
  Exact Mean Integrated Squared Error;
  \emph{Annals of Statistcs} \bold{20}, 712--736.

  For number 16,\cr% in the book Wand & Marron(1995) has
  Janssen, Marron, Verb..., Sarle (1995) .... %% FIXME
}
\examples{
MW.nm10
plot(MW.nm14)

## These are defined as norMix() calls in  ../R/zMarrWand-dens.R
require("nor1mix")
ppos <- which("package:nor1mix" == search())
nms <- ls(pat="^MW.nm", pos = ppos)
nms <- nms[order(as.numeric(substring(nms,6)))]
for(n in nms) {
   cat("\n",n,":\n"); print(get(n, pos = ppos))
}

## Plot all of them:
op <- par(mfrow=c(4,4), mgp = c(1.2, 0.5, 0), tcl = -0.2,
          mar = .1 + c(2,2,2,1), oma = c(0,0,3,0))
for(n in nms) { plot(get(n, pos = ppos))}
mtext("The Marron-Wand Densities", outer = TRUE,
      font = 2, cex = 1.6)
par(op)
}
\keyword{datasets}
\keyword{distribution}

\eof
\name{dnorMix}
\alias{dnorMix}
\title{Normal Mixture Density}
\description{
  Evaluate the density function of the normal mixture specified as
  \code{\link{norMix}} object.
}
\usage{
dnorMix(obj, x = NULL, xlim = NULL, n = 511)
}
\arguments{
  \item{obj}{an object of class \code{norMix}.}
  \item{x}{numeric vector with abscissa values where to evaluate the
    density. Default is constructed from \code{n} (and \code{xlim} if
    specified).}
  \item{xlim}{range of abscissa values, used if \code{x == NULL}.  By default,
    xlim taken as mean plus/minus 3 standard deviations of the normal mixture.}
  \item{n}{number of abscissa values to generate if \code{x} is not specified.}
}
\value{
  A list with components
  \item{x}{the abscissa values.}
  \item{y}{the density \eqn{f(x)} at \code{x}.}
}
\seealso{\code{\link{rnorMix}} for random number generation, and
  \code{\link{norMix}} for the construction and further methods,
  particularly \code{\link{plot.norMix}} which makes use \code{dnorMix}.
}
\examples{
 ff <- dnorMix(MW.nm7)
 str(ff)
 plot(ff, type = "h") # rather use plot(ff, ...)
}
\keyword{distribution}

\eof
\name{norMix}
\alias{norMix}
\alias{is.norMix}
\alias{m.norMix}
\alias{mean.norMix}
\alias{var.norMix}
\alias{print.norMix}
\title{Mixtures of Univariate Normal Distributions}
\description{
  Objects of class \code{norMix} represent finite mixtures of
  (univariate) normal (aka Gaussian) distributions.  Methods for
  construction, printing, plotting, and basic computations are provided.
}
\usage{
norMix(mu, sig2 = rep(1,m), w = NULL, name = NULL, long.name = FALSE)

is.norMix(obj)
m.norMix(obj)
mean.norMix(x, \dots)
var.norMix(x, \dots)
\method{print}{norMix}(x, \dots)
}
\arguments{
  \item{mu}{numeric vector of length \eqn{K}, say, specifying the means
    \eqn{\mu} of the \eqn{K} normal components.}
  \item{sig2}{numeric vector of length \eqn{K}, specifying the variances
    \eqn{\sigma^2} of the \eqn{K} normal components.}
  \item{w}{numeric vector of length \eqn{K}, specifying the mixture proportions
    \eqn{\pi_j}{p[j]} of the normal components, \eqn{j = 1,\dots,K}.
    Defaults to equal proportions}
  \item{name}{optional name tag of the result (used for printing).}
  \item{long.name}{ ~~Describe \code{long.name} here~~ }

  \item{obj,x }{an object of class \code{norMix}.}
  \item{\dots}{further arguments passed to methods.}
}
\details{
  The (one dimensional) normal mixtures, \R objects of class
  \code{"norMix"}, are constructed by \code{norMix} and tested for by
  \code{is.norMix}.  \code{m.norMix()} returns the number of mixture
  components,
  ....
 %% FIXME
  For further methods see below. %% seealso
}
\value{
  \code{norMix} returns objects of class \code{"norMix"} which are
  currently implemented as 3-column matrix with column names \code{mu},
  \code{sig2}, and \code{w}, and further attributes.
  The user should rarely need to access the underlying structure
  directly.
}
\author{Martin Maechler}
\seealso{\code{\link{dnorMix}} for the density, \code{\link{rnorMix}}
  for random numbers and \code{\link{print.norMix}}, the plot method.

  \code{\link{MarronWand}} has the Marron-Wand densities as normal mixtures.
}
\examples{
ex <- norMix(mu = c(1,2,5))# s^2 = 1, equal proportions
ex
plot(ex)# looks like a mixture of only 2

plot(ex, log = "y")# maybe "revealing"
}
\keyword{distribution}

\eof
\name{plot.norMix}
\alias{plot.norMix}
\alias{lines.norMix}
\title{Plotting Methods for `norMix' Objects}
\description{
  The \code{plot} and \code{lines} methods for \code{\link{norMix}}
  objects draw the normal mixture density, optionally additonally with a
  fitted normal density.
}
\usage{
\method{plot}{norMix}(x, type = "l", n = 511, xout = NULL, xlim = NULL,
      xlab = "x", ylab = "f(x)", main = attr(x, "name"), lwd = 1.4,
      p.norm = TRUE, p.h0 = TRUE,
      parNorm = list(col = 2, lty = 2, lwd = 0.4),
      parH0 = list(col = 3, lty = 3, lwd = 0.4), \dots)

\method{lines}{norMix}(x, type = "l", n = 511, xout = NULL,
      lwd = 1.4, p.norm = FALSE, parNorm = list(col = 2, lty = 2, lwd = 0.4),
      \dots)
}
\arguments{
  \item{x}{object of class \code{norMix}.}
  \item{type}{character denoting type of plot, see, e.g. \code{\link{lines}}.}
  \item{n}{number of points to generate if \code{xout} is unspecified.}
  \item{xout}{numeric or \code{NULL} giving the abscissae at which to
    draw the density.}
  \item{xlim}{range of x values to use; particularly important if
    \code{xout} is not specified where \code{xlim} is passed to
    \code{\link{dnorMix}} and gets a smart default if unspecified.}
  \item{xlab,ylab}{labels for the x and y axis with defaults.}
  \item{main}{main title of plot, defaulting to the \code{\link{norMix}}
    name.}
  \item{lwd}{line width for plotting with a non-standard default.}
  \item{p.norm}{logical indicating if the normal density with the same
    mean and variance should be drawn as well.}
  \item{p.h0}{logical indicating if the line \eqn{y = 0} should be drawn.}
  \item{parNorm}{graphical parameters for drawing the normal density if
    \code{p.norm} is true.}
  \item{parH0}{graphical parameters for drawing the line \eqn{y = 0} if
    \code{p.h0} is true.}
  \item{\dots}{further arguments passed to and from methods.}
}
\author{Martin Maechler}
\seealso{\code{\link{norMix}} for the construction and further methods,
  particularly \code{\link{dnorMix}} which is used here.
}
\examples{
plot(norMix(m=c(0,3),s=c(4,1)))
## Further examples in  ?norMix and  ?rnorMix
}
\keyword{distribution}
\keyword{hplot}

\eof
\name{pnorMix}
\alias{pnorMix}
\alias{qnorMix}
\title{Normal Mixture Cumulative Distribution and Quantiles}
\description{
  Compute cumulative probabilities or quantiles (the inverse) for a
  normal mixture specified as \code{\link{norMix}} object.
}
\usage{
pnorMix(obj, q)
qnorMix(obj, p)
}
\arguments{
  \item{obj}{an object of class \code{norMix}.}
  \item{p}{numeric vector of probabilities.}
  \item{q}{numeric vector of quantiles}.
}
\details{
  Whereas the distribution function \code{pnorMix} is the trivial sum of
  weighted normal probabilities (\code{\link{pnorm}}), its inverse is
  currently computed numerically using \code{\link{uniroot}} to find
  \code{q} such that \code{pnorMix(obj, q) == p}.
}
\value{
  a numeric vector of the same length as \code{p} or \code{q}, respectively.
}
\author{First version by Erik Jrgensen
  \email{Erik.Jorgensen@agrsci.dk}.}
\seealso{\code{\link{dnorMix}} for the density function.}
\examples{
MW.nm3 # the "strange skew" one
plot(MW.nm3)
## now the cumlative :
x <- seq(-4,4, length=1001)
plot(x, pnorMix(MW.nm3, x), type="l", col=2)
## and some of its inverse :
pp <- seq(.1, .9, by=.1)
plot(qnorMix(MW.nm3, pp), pp)

## The "true" median of a normal mixture:
median.norMix <- function(x) qnorMix(x, 1/2)
median.norMix(MW.nm3) ## -2.32
}
\keyword{distribution}

\eof
\name{r.norMix}
\alias{r.norMix}
\title{Ratio of Normal Mixture to Corresponding Normal}
\description{
  Compute \eqn{r(x) = f(x)/ f0(x)} where \eqn{f()} is a normal mixture
  density and \eqn{f0} the normal density with the same mean and
  variance as \eqn{f}.
}
\usage{
r.norMix(obj, x = NULL, xlim = NULL, n = 511, xy.return = TRUE)
}
\arguments{
  \item{obj}{an object of class \code{norMix}.}
  \item{x}{numeric vector with abscissa values where to evaluate the
    density. Default is constructed from \code{n} (and \code{xlim} if
    specified).}
  \item{xlim}{range of abscissa values, used if \code{x == NULL}.  By default,
    xlim taken as mean plus/minus 3 standard deviations of the normal mixture.}
  \item{n}{number of abscissa values to generate if \code{x} is not specified.}
  \item{xy.return}{logical indicating if the result should be a list or
    just a numeric vector, see below.}
}
\value{
  It depends on \code{xy.return}.  If it's false,  a numeric vector of
  the same length as \code{x}, if true (as per default), a list that can
  be plotted, with components
  \item{x}{abscissa values corresponding to argument \code{x}.}
  \item{y}{corresponding values \eqn{r(x)}.}
  \item{f0}{values of the moment matching normal density \eqn{f0(x)}.}
}
\note{The ratio function is used in certain semi-parametric density
  estimation methods (and theory).
}
\examples{
  d3 <- norMix(m = 5*(0:2), w = c(0.6, 0.3, 0.1))
  plot(d3)
  rd3 <- r.norMix(d3)
  str(rd3)
  stopifnot(rd3 $ y  == r.norMix(d3, xy.ret = FALSE))
  par(new = TRUE)
  plot(rd3, type = "l", col = 3, axes = FALSE, xlab = "", ylab="")
  axis(4, col.axis=3)
}
\keyword{distribution}

\eof
\name{rnorMix}
\alias{rnorMix}
\title{Generate ``Normal Mixture'' Distributed Random Numbers}
\description{
  Generate \code{n} random numbers, distributed according to a normal
  mixture.
}
\usage{
rnorMix(n, obj)
}
\arguments{
  \item{n}{the number of random numbers desired.}
  \item{obj}{an object of class \code{norMix}.}
}
\details{
  For a mixture of \eqn{m}, i.e., \code{m.norMix(obj)}, components,
  generate the number in each component as multinomial, and then use
  \code{\link{rnorm}} for each.
}
\value{
  numeric vector of length \code{n}.
}
\seealso{\code{\link{dnorMix}} for the density, and \code{\link{norMix}}
  for the construction and further methods.
}
\examples{
x <- rnorMix(5000, MW.nm10)
hist(x)# you don't see the claw
plot(density(x), ylim = c(0,0.6),
     main = "Estim. and true 'MW.nm10' density")
lines(MW.nm10, col = "orange")
}
\keyword{distribution}

\eof
