\name{.code.to.na}
\alias{.code.to.na}
\title{
Changes missing value code to NA
}
\description{
Changes missing value code to NA. It's called from
\emph{'prelim.norm'}.
}
\usage{
.code.to.na(x, mvcode)
}
\arguments{
\item{x}{data object.
}
\item{mvcode}{internal input of 'prelim.norm'.
}
}}
\value{
Initial data object with missing values code changed to NA.
}
\seealso{
\code{\link{prelim.norm}}
}
\keyword{
NA
}
\eof
\name{da.norm}
\alias{da.norm}
\title{
Data augmentation for incomplete multivariate normal data
}
\description{
Data augmentation under a normal-inverted Wishart prior. If no prior
is specified by the user, the usual "noninformative" prior for the
multivariate normal distribution is used. This function simulates one
or more iterations of a single Markov chain. Each iteration consists
of a random imputation of the missing data given the observed data and
the current parameter value (I-step), followed by a draw from the
posterior distribution of the parameter given the observed data and
the imputed data (P-step).
}
\usage{
da.norm(s, start, prior, steps=1, showits=FALSE, return.ymis=FALSE)
}
\arguments{
\item{s}{
summary list of an incomplete normal data matrix produced by the
function \code{prelim.norm}.
}
\item{start}{
starting value of the parameter.  This is a parameter vector in packed
storage, such as one created by the function \code{makeparam.norm}. One
obvious choice for a starting value is an ML estimate or posterior
mode produced by \code{em.norm.}
}
\item{prior}{
optional prior distribution. This is a list containing the
hyperparameters of a normal-inverted Wishart distribution. In order,
the elements of the list are: tau (a scalar), m (a scalar), mu0 (a
vector of length \code{ncol(x)}, where \code{x} is the original matrix of
incomplete data), and lambdainv (a matrix of dimension
\code{c(ncol(x),ncol(x))}). The elements of mu0 and lambdainv apply to the
data after transformation, i.e. after the columns have been centered
and scaled to have mean zero and variance one. If no prior is
supplied, the default is the usual noninformative prior for a
multivariate normal model: tau=0, m=-1, mu0=arbitrary, and lambdainv =
matrix of zeros.
}
\item{steps}{
number of data augmentation iterations to be simulated.
}
\item{showits}{
if \code{TRUE}, reports the iterations so the user can monitor the progress
of the algorithm.
}
\item{return.ymis}{
if \code{TRUE}, returns the output of the last I-step (imputed values of
missing data) in addition to the output of the last P-step. These
imputed values are useful for forming Rao-Blackwellized estimates of
posterior summaries.
}}
\value{
if \code{return.ymis=FALSE}, returns a parameter vector, the result of the last
P-step. If the value of \code{steps} was large enough to guarantee
approximate stationarity, then this parameter can be regarded as a
proper draw from the observed-data posterior, independent of \code{start}.
If \code{return.ymis=TRUE}, then this function returns a list of the following
two components:

\item{parameter}{
a parameter vector, the result of the last P-step
}
\item{ymis}{
a vector of missing values, the result of the last I-step.  The length
of this vector is \code{sum(is.na(x))}, where x is the original data
matrix. The storage order is the same as that of \code{x[is.na(x)]}.
}}
\section{WARNING}{
Before this function may be used, the random number generator seed
must be initialized with \code{rngseed} at least once in the current S
session.
}
\references{
See Chapter 5 of Schafer (1996).
}
\seealso{
\code{\link{rngseed}}, \code{\link{em.norm}}, \code{\link{prelim.norm}}, and \code{\link{getparam.norm}}.
}
\examples{
data(mdata)
s  <-  prelim.norm(mdata)
thetahat <- em.norm(s)   #find the MLE for a starting value
rngseed(1234567)   #set random number generator seed
theta <- da.norm(s,thetahat,steps=20,showits=TRUE)  # take 20 steps
getparam.norm(s,theta) # look at result
}
\keyword{distribution}
% Converted by Sd2Rd version 0.3-3.
\eof
\name{em.norm}
\alias{em.norm}
\title{
EM algorithm for incomplete normal data
}
\description{
Performs maximum-likelihood estimation on the matrix of incomplete
data using the EM algorithm. Can also be used to find a posterior mode
under a normal-inverted Wishart prior supplied by the user.
}
\usage{
em.norm(s, start, showits=TRUE, maxits=1000, criterion=0.0001, prior)
}
\arguments{
\item{s}{
summary list of an incomplete normal data matrix produced by the
function \code{prelim.norm}.
}
\item{start}{
optional starting value of the parameter. This is a parameter vector
in packed storage, such as one created by the function
\code{makeparam.norm}. If no starting value is supplied, \code{em.norm} chooses
its own starting value.
}
\item{showits}{
if \code{TRUE}, reports the iterations of EM so the user can monitor the
progress of the algorithm.
}
\item{maxits}{
maximum number of iterations performed. The algorithm will stop if the
parameter still has not converged after this many iterations.
}
\item{criterion}{
convergence criterion. The algorithm stops when
the maximum relative difference in all of the estimated means,
variances, or covariances from one iteration to the next
is less than or equal to this value.
}
\item{prior}{
optional prior distribution. This is a list containing the
hyperparameters of a normal-inverted Wishart distribution. In order,
the elements of the list are: tau (a scalar), m (a scalar), mu0 (a
vector of length ncol(x)), and lambdainv (a matrix of dimension
c(ncol(x),ncol(x))). The elements of mu0 ans lambdainv apply to 
the data after transformation, i.e. after the columns have been
centered and scaled to have mean zero and variance one. If no prior is
supplied, the default is a uniform prior, which results in 
maximum-likelihood estimation.
}}
\value{
a vector representing the maximum-likelihood estimates of the normal
parameters. This vector contains means, variances, and covariances on
the transformed scale in packed storage.  The parameter can be
transformed back to the original scale and put into a more
understandable format by the function \code{getparam.norm}.
}
\details{
The default starting value takes all means on the transformed scale to
be equal to zero, and covariance matrix on the transformed scale equal
to the identity. All important computations are carried out in double
precision, using the sweep operator.
}
\references{
See Section 5.3 of Schafer (1994).
}
\seealso{
\code{\link{prelim.norm}}, \code{\link{getparam.norm}}, and \code{\link{makeparam.norm}}.
}
\examples{
data(mdata)
s <- prelim.norm(mdata)   #do preliminary manipulations
thetahat <- em.norm(s)   #compute mle
getparam.norm(s,thetahat,corr=TRUE)$r #look at estimated correlations
}
\keyword{regression}
% Converted by Sd2Rd version 0.3-3.
\eof
\name{getparam.norm}
\alias{getparam.norm}
\title{
Extract normal parameters from packed storage
}
\description{
Takes a parameter vector, such as one produced by em.norm or da.norm,
and returns a list of parameters on the original scale.
}
\usage{
getparam.norm(s, theta, corr=FALSE)
}
\arguments{
\item{s}{
summary list of an incomplete normal data matrix created by the
function \code{prelim.norm}.
}
\item{theta}{
vector of normal parameters expressed on transformed scale in packed
storage, such as one produced by the function \code{em.norm}.
}
\item{corr}{
if \code{TRUE}, computes means, standard deviations, and a correlation
matrix. If \code{FALSE}, computes means and a covariance matrix.
}}
\value{
if \code{corr=FALSE}, a list containing the components \code{mu} and \code{sigma}; if
\code{corr=TRUE}, a list containing the components \code{mu}, \code{sdv}, and \code{r}.  The
components are:

\item{mu}{
vector of means. Elements are in the same order and on the same scale
as the columns of the original data matrix, and with names
corresponding to the column names of the original data matrix.
}
\item{sigma}{
matrix of variances and covariances.
}
\item{sdv}{
vector of standard deviations.
}
\item{r}{
matrix of correlations.
}}
\seealso{
\code{\link{prelim.norm}} and \code{\link{makeparam.norm}}.
}
\examples{
data(mdata)
s <- prelim.norm(mdata)   #do preliminary manipulations
thetahat <- em.norm(s)   #compute MLE
getparam.norm(s,thetahat,corr=TRUE)$r #look at estimated correlations
}
\keyword{regression}
% Converted by Sd2Rd version 0.3-3.
\eof
\name{imp.norm}
\alias{imp.norm}
\title{
Impute missing multivariate normal data
}
\description{
Draws missing elements of a data matrix under the multivariate normal
model and a user-supplied parameter
}
\usage{
imp.norm(s, theta, x)
}
\arguments{
\item{s}{
summary list of an incomplete normal data matrix \code{x} created by the
function \code{prelim.norm}.
}
\item{theta}{
value of the normal parameter under which the missing data are to be
randomly imputed. This is a parameter vector in packed storage, such
as one created by \code{em.norm} or \code{da.norm}.
}
\item{x}{
the original data matrix used to create the summary list \code{s}. If this
argument is not supplied, then the data matrix returned by this
function may disagree slightly with the observed values in \code{x} due to
rounding errors.
}}
\value{
a matrix of the same form as \code{x}, but with all missing values filled in
with simulated values drawn from their predictive distribution given
the observed data and the specified parameter.
}
\details{
This function simply performs one I-step of data augmentation.
}
\section{WARNING}{
Before this function may be used, the random number generator seed
must be initialized with \code{rngseed} at least once in the current S
session.
}
\references{
See Section 5.4.1 of Schafer (1996).
}
\seealso{
\code{\link{prelim.norm}}, \code{\link{makeparam.norm}}, and \code{\link{rngseed}}.
}
\examples{
data(mdata)
s <- prelim.norm(mdata)   #do preliminary manipulations
thetahat <- em.norm(s)   #find the mle
rngseed(1234567)   #set random number generator seed
ximp <- imp.norm(s,thetahat,mdata)  #impute missing data under the MLE
}
\keyword{regression}
% Converted by Sd2Rd version 0.3-3.
\eof
\name{loglik.norm}
\alias{loglik.norm}
\title{
Observed-data loglikelihood for normal data
}
\description{
Evaluates the observed-data loglikelihood function at a user-supplied
value of the parameter. This function is useful for monitoring the
progress of EM and data augmentation.
}
\usage{
loglik.norm(s, theta)
}
\arguments{
\item{s}{
summary list of an incomplete normal data matrix created by the
function \code{prelim.norm}.
}
\item{theta}{
vector of normal parameters expressed on transformed scale in packed
storage, such as one produced by the function \code{em.norm}.
}}
\value{
value of the observed-data loglikelihood 
}
\references{
See Section 5.3.5 of Schafer (1996)
}
\seealso{
\code{\link{prelim.norm}} and \code{\link{logpost.norm}}
}
\examples{
data(mdata)
s <- prelim.norm(mdata)   #do preliminary manipulations
thetahat <- em.norm(s)   #compute MLE
loglik.norm(s,thetahat)  #loglikelihood at the MLE
}
\keyword{multivariate}
% Converted by Sd2Rd version 0.3-3.
\eof
\name{logpost.norm}
\alias{logpost.norm}
\title{
Observed-data log-posterior for normal data
}
\description{
Evaluates the log of the observed-data posterior density at a
user-supplied value of the parameter. Assumes a normal-inverted
Wishart prior. This function is useful for monitoring the progress of
EM and data augmentation.
}
\usage{
logpost.norm(s, theta, prior)
}
\arguments{
\item{s}{
summary list of an incomplete normal data matrix created by the
function \code{prelim.norm}.
}
\item{theta}{
vector of normal parameters expressed on transformed scale in packed
storage, such as one produced by the function \code{em.norm}.
}
\item{prior}{
optional prior distribution. This is a list containing the
hyperparameters of a normal-inverted Wishart distribution. In order,
the elements of the list are: tau (a scalar), m (a scalar), mu0 (a
vector of length \code{ncol(x)}, where \code{x} is the original matrix of
incomplete data), and lambdainv (a matrix of dimension
\code{c(ncol(x),ncol(x))}). The elements of mu0 and lambdainv apply to the
data after transformation, i.e. after the columns have been centered
and scaled to have mean zero and variance one. If no prior is
supplied, the default is the usual noninformative prior for a
multivariate normal model: tau=0, m=-1, mu0=arbitrary, and lambdainv =
matrix of zeros.
}}
\value{
value of the observed-data log-posterior density
}
\references{
See Section 5.3.5 of Schafer (1996)
}
\seealso{
\code{\link{prelim.norm}} and \code{\link{loglik.norm}}
}
\examples{
data(mdata)
s <- prelim.norm(mdata)   #do preliminary manipulations
prior <- list(0,.5,rep(0,ncol(mdata)),
   .5*diag(rep(1,ncol(mdata)))) #ridge prior with .5 df
thetahat <- em.norm(s,prior=prior)   #compute posterior mode
logpost.norm(s,thetahat,prior)  #log-posterior at mode
}
\keyword{multivariate}
% Converted by Sd2Rd version 0.3-3.
\eof
\name{makeparam.norm}
\alias{makeparam.norm}
\title{
Convert normal parameters to packed storage
}
\description{
Does the opposite of \code{getparam.norm}.
Converts a list of user-specified parameters to a parameter vector
suitable for input to functions such as \code{da.norm} and \code{em.norm}.
}
\usage{
makeparam.norm(s, thetalist)
}
\arguments{
\item{s}{
summary list of an incomplete normal data matrix created
by the function \code{prelim.norm}.
}
\item{thetalist}{
list of normal parameters of the same form as one produced by
\code{getparam.norm}. If the list has two components, the first must be the
vector of means and the second must be the covariance matrix,
where means and covariances are expressed on the scale of the original
data. If the list has three components, the first must be the vector
of means, the second must be the vector of standard deviations, and
the third must be the correlation matrix.
}}
\value{
normal parameter in packed storage, suitable for use as a starting
value for \code{em.norm}, \code{mda.norm}, or \code{mdamet.norm}.
}
\seealso{
\code{\link{prelim.norm}} and \code{\link{getparam.norm}}.
}
\examples{
data(mdata)
s <- prelim.norm(mdata)   #do preliminary manipulations
thetahat <- em.norm(s)   #compute mle
thetahat <- getparam.norm(s,thetahat,corr=TRUE)   #extract parameters
thetahat$r   #look at mle correlations
thetahat$r[1,2] <- .5   #tweak a parameter
thetahat <- makeparam.norm(s,thetahat)   #convert to packed storage
thetahat <- em.norm(s,thetahat) #run EM again from new starting value
}
\keyword{regression}
% Converted by Sd2Rd version 0.3-3.
\eof
\name{mda.norm}
\alias{mda.norm}
\title{
Monotone data augmentation for incomplete multivariate normal data
}
\description{
Monotone data augmentation under the usual noninformative prior, as
described in Chapter 6 of Schafer (1996).  This function simulates one
or more iterations of a single Markov chain. One iteration consists of
a random imputation of the missing data given the observed data and
the current parameter value (I-step), followed by a draw from the
posterior distribution of the parameter given the observed data and
the imputed data (P-step). The I-step imputes only enough data to
complete a monotone pattern, which typically makes this algorithm
converge more quickly than \code{da.norm}, particularly when the observed
data are nearly monotone. The order of the variables in the original
data matrix determines the monotone pattern to be completed. For fast
convergence, it helps to order the variables according to their rates
of missingness, with the most observed (least missing) variable on the
left and the least observed variable on the right.
}
\usage{
mda.norm(s, theta, steps=1, showits=FALSE)
}
\arguments{
\item{s}{
summary list of an incomplete normal data matrix produced by the
function \code{prelim.norm}.
}
\item{theta}{
starting value of the parameter.  This is a parameter vector in packed
storage, such as one created by the function \code{makeparam.norm}. One
obvious choice for a starting value is an ML estimate or posterior
mode produced by \code{em.norm.}
}
\item{steps}{
number of monotone data augmentation iterations to be simulated.
}
\item{showits}{
if \code{TRUE}, reports the iterations so the user can monitor the progress
of the algorithm.
}}
\value{
Returns a parameter vector, the result of the last P-step. If the
value of \code{steps} was large enough to guarantee approximate
stationarity, then this parameter can be regarded as a proper draw
from the observed-data posterior, independent of \code{start}.
}
\section{WARNING}{
Before this function may be used, the random number generator seed
must be initialized with \code{rngseed} at least once in the current S
session.
}
\references{
Chapter 6 of Schafer (1996).
}
\seealso{
\code{\link{rngseed}}, \code{\link{em.norm}}, \code{\link{prelim.norm}}, and \code{\link{getparam.norm}}.
}
\examples{
data(mdata)
s <- prelim.norm(mdata)
thetahat <- em.norm(s)   #find the MLE for a starting value
rngseed(1234567)   #set random number generator seed
theta <- mda.norm(s,thetahat,steps=20,showits=TRUE)  # take 20 steps
getparam.norm(s,theta) # look at result
}
\keyword{multivariate}
% Converted by Sd2Rd version 0.3-3.
\eof
\name{mdata}
\alias{mdata}
\title{
Dataset with missing values to illustrate use of package norm
}
\description{
Household survey with missing values. See Schafer~(1997).
}
\references{
Schafer, J.L.(1997) \emph{Analysis of Incomplete Multivariate Data},
Chapman & Hall, London. ISBN: 0412040611
}
\keyword{
datasets
}
\eof
\name{mi.inference}
\alias{mi.inference}
\title{
Multiple imputation inference
}
\description{
Combines estimates and standard errors from m complete-data analyses
performed on m imputed datasets to produce a single inference.  Uses
the technique described by Rubin (1987) for multiple
imputation inference for a scalar estimand.
}
\usage{
mi.inference(est, std.err, confidence=0.95)
}
\arguments{
\item{est}{
a list of $m$ (at least 2) vectors representing estimates (e.g.,
vectors of estimated regression coefficients) from complete-data
analyses performed on $m$ imputed datasets.
}
\item{std.err}{
a list of $m$ vectors containing standard errors from the
complete-data analyses corresponding to the estimates in \code{est}.
}
\item{confidence}{
desired coverage of interval estimates.
}}
\value{
a list with the following components, each of which is a vector of the
same length as the components of \code{est} and \code{std.err}:

\item{est}{
the average of the complete-data estimates.
}
\item{std.err}{
standard errors incorporating both the between and the
within-imputation uncertainty (the square root of the "total
variance").
}
\item{df}{
degrees of freedom associated with the t reference distribution used
for interval estimates.
}
\item{signif}{
P-values for the two-tailed hypothesis tests that the estimated
quantities are equal to zero.
}
\item{lower}{
lower limits of the (100*confidence)\% interval estimates.
}
\item{upper}{
upper limits of the (100*confidence)\% interval estimates.
}
\item{r}{
estimated relative increases in variance due to nonresponse.
}
\item{fminf}{
estimated fractions of missing information.
}}
\section{METHOD}{
Uses the method described on pp. 76-77 of Rubin (1987) for combining
the complete-data estimates from $m$ imputed datasets
for a scalar estimand. Significance levels and interval estimates are
approximately valid for each one-dimensional estimand, not for all of
them jointly.
}
\references{
See Rubin (1987) or Schafer (1996), Chapter 4.
}
\keyword{
htest
}
% Converted by Sd2Rd version 0.3-3.
\eof
\name{.na.to.snglcode}
\alias{.na.to.snglcode}
\title{
Changes NA's to single precision missing value code
}
\description{
Changes NA's to single precision missing value code
It's called internally by other functions in the package, e.g., 
\emph{'prelim.norm'}.
}
\usage{
.code.to.na(x, mvcode)
}
\arguments{
\item{x}{data object.
}
\item{mvcode}{internal input of 'prelim.norm'.
}
}}
\value{
Initial data object with missing values code precision changed to
sinlge.
}
\seealso{
\code{\link{prelim.norm}}
}
\keyword{
NA
}
\eof
\name{ninvwish}
\alias{ninvwish}
\title{
Random normal-inverted Wishart variate
}
\description{
Simulates a value from a normal-inverted Wishart distribution. This
function may be useful for obtaining starting values of the
parameters of a  multivariate normal distribution for multiple
chains of data augmentation.
}
\usage{
ninvwish(s, params)
}
\arguments{
\item{s}{
summary list of an incomplete normal data matrix produced by the
function \code{prelim.norm}.
}
\item{params}{
list of parameters of a normal-inverted Wishart distribution. In
order, the elements of the list are: tau (a scalar), m (a scalar), mu0
(a vector of length ncol(x)), and lambdainv (a matrix of dimension
c(ncol(x),ncol(x))). When using this function to create starting
values for data augmentation, mu0 and lambdainv should be chosen in
relation to the data matrix after the columns have been centered and
scaled to have mean zero and variance one.
}}
\value{
a vector in packed storage representing the simulated normal-inverted
Wishart variate. This vector has the same form as parameter vectors
produced by functions such as \code{em.norm} and \code{da.norm}, and may be
used directly as a starting value for these functions. This vector can
also be put into a more understandable format by \code{getparam.norm}.
}
\section{WARNING}{
Before this function may be used, the random number generator seed
must be initialized with \code{rngseed} at least once in the current S
session.
}
\references{
See Section 5.4.2 of Schafer (1996).
}
\seealso{
\code{\link{rngseed}}, \code{\link{getparam.norm}}, \code{\link{em.norm}} and \code{\link{da.norm}}.
}
\examples{
data(mdata)
s <- prelim.norm(mdata)   #do preliminary manipulations
params <- list(1,.5,rep(0,ncol(mdata)), .5*diag(rep(1,ncol(mdata)))) # gives widely dispersed values
rngseed(1234567)
start <- ninvwish(s,params)  # draw a variate
thetahat <- em.norm(s,start=start) # run EM from this starting value
}
\keyword{multivariate}
% Converted by Sd2Rd version 0.3-3.
\eof
\name{prelim.norm}
\alias{prelim.norm}
\title{
Preliminary manipulations for a matrix of incomplete 
continuous data.
}
\description{
Sorts rows of x by missingness patterns, and centers/scales
columns of x. Calculates various bookkeeping quantities needed
for input to other functions, such as \code{em.norm} and \code{da.norm}.
}
\usage{
prelim.norm(x)
}
\arguments{
\item{x}{
data matrix containing missing values. The rows of x 
correspond to observational units, and the columns to variables. 
Missing values are denoted by \code{NA}.
}}
\value{
a list of thirteen components that summarize various features of x
after the data have been centered, scaled, and sorted by missingness
patterns. Components that might be of interest to the user include:

\item{nmis}{
a vector of length ncol(x) containing the number of missing
values for each variable in x. This vector has names that correspond
to the column names of x, if any.
}
\item{r}{
matrix of response indicators showing the missing data patterns 
in x.  Dimension is (S,p) where S is the number of distinct 
missingness patterns in the rows of x, and p is the number of 
columns in x. Observed values are indicated by 1 and missing 
values by 0. The row names give the number of observations in
each pattern, and the column names correspond to the column names of
x.
}}
\references{
See Section 5.3.1 of Schafer (1996).
}
\examples{
data(mdata)
s <- prelim.norm(mdata)  #do preliminary manipulations 
s$nmis[s$co] #look at nmis 
s$r #look at missing data patterns
}
\keyword{multivariate}
% Converted by Sd2Rd version 0.3-3.
\eof
\name{rngseed}
\alias{rngseed}
\title{
Initialize random number generator seed
}
\description{
Initializes the seed value for the internal random-number generator
used in missing-data programs
}
\usage{
rngseed(seed)
}
\arguments{
\item{seed}{
a positive number > = 1, preferably a large integer.
}}
\value{
\code{NULL}.
}
\section{NOTE}{
The random number generator seed must be set at least once
by this function before the simulation or imputation functions
in this package (\code{da.norm}, etc.) can be used.
}
\keyword{
distribution
}
% Converted by Sd2Rd version 0.3-3.
\eof
