\name{ad.test}
\alias{ad.test}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Anderson-Darling test for normality}
\description{
  Performs the Anderson-Darling test for  the composite hypothesis of normality, 
  see e.g. Thode (2002, Sec. 5.1.4).
}
  
\usage{
ad.test(x)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{a numeric vector of data values, the number of 
  which must be greater than 7. Missing values are allowed.}
}
\details{The Anderson-Darling test is an EDF omnibus test for the composite hypothesis of normality. 
The test statistic is 
\deqn{
A = -n -\frac{1}{n} \sum_{i=1}^{n} [2i-1] 
[\ln(p_{(i)}) + \ln(1 - p_{(n-i+1)})],
}
where \eqn{p_{(i)} = \Phi([x_{(i)} - \overline{x}]/s)}. Here, 
\eqn{\Phi} is the cumulative distribution function 
of the standard normal distribution, and \eqn{\overline{x}} and \eqn{s} 
are mean and standard deviation of the data values. 
The p-value is computed from the modified statistic 
\eqn{Z=A (1.0 + 0.75/n +2.25/n^{2})}\ according to Table 4.9 in 
Stephens (1986). 

}
\value{
  A list with class "htest" containing the following components: 
  \item{statistic}{the value of the Anderson-Darling statistic.}
  \item{p.value }{the p-value for the test.}
  \item{method}{the character string "Anderson-Darling normality test".}
  \item{data.name}{a character string giving the name(s) of the data.} 
}
\references{Stephens, M.A. (1986): Tests based on EDF statistics. In:
D'Agostino, R.B. and Stephens, M.A., eds.: Goodness-of-Fit Techniques.
Marcel Dekker, New York.

Thode Jr., H.C. (2002): Testing for  Normality. Marcel Dekker, New York.
}
\author{Juergen Gross}

\note{The Anderson-Darling test is the recommended EDF test by Stephens (1986). Compared to the 
Cramer-von Mises test (as second choice) it gives more weight to the tails of the distribution.}


\seealso{\code{\link[ctest]{shapiro.test}} for performing the Shapiro-Wilk test for normality. 
\code{\link{cvm.test}}, \code{\link{lillie.test}}, 
\code{\link{pearson.test}}, \code{\link{sf.test}} for performing further tests for normality.
\code{\link{qqnorm}} for producing a normal quantile-quantile plot.}

\examples{
ad.test(rnorm(100, mean = 5, sd = 3))
ad.test(runif(100, min = 2, max = 4))

}
\keyword{htest}

\eof
\name{cvm.test}
\alias{cvm.test}
\title{Cramer-von Mises test for normality}
\description{
  Performs the Cramer-von Mises test for the composite hypothesis of normality, 
  see e.g. Thode (2002, Sec. 5.1.3).
}

\usage{
cvm.test(x)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{a numeric vector of data values, the number of 
  which must be greater than 7. Missing values are allowed.}
}
\details{The Cramer-von Mises test is an EDF omnibus test for the composite hypothesis of normality. 
The test statistic is 
\deqn{
W = \frac{1}{12 n} + \sum_{i=1}^{n} (p_{(i)} - \frac{2i-1}{2n}),
}
where \eqn{p_{(i)} = \Phi([x_{(i)} - \overline{x}]/s)}. Here, 
\eqn{\Phi} is the cumulative distribution function 
of the standard normal distribution, and \eqn{\overline{x}} and \eqn{s} 
are mean and standard deviation of the data values. 
The p-value is computed from the modified statistic 
\eqn{Z=W (1.0 + 0.5/n)} according to Table 4.9 in 
Stephens (1986). 
}
\value{
  A list with class "htest" containing the following components: 
  \item{statistic}{the value of the Cramer-von Mises statistic.}
  \item{p.value }{the p-value for the test.}
  \item{method}{the character string "Cramer-von Mises normality test".}
  \item{data.name}{a character string giving the name(s) of the data.} 
}
\references{Stephens, M.A. (1986): Tests based on EDF statistics. In:
D'Agostino, R.B. and Stephens, M.A., eds.: Goodness-of-Fit Techniques.
Marcel Dekker, New York.

Thode Jr., H.C. (2002): Testing for  Normality. Marcel Dekker, New York.
}
\author{Juergen Gross}


\seealso{\code{\link[ctest]{shapiro.test}} for performing the Shapiro-Wilk test for normality. 
\code{\link{ad.test}}, \code{\link{lillie.test}}, 
\code{\link{pearson.test}}, \code{\link{sf.test}} for performing further tests for normality.
\code{\link{qqnorm}} for producing a normal quantile-quantile plot.}

\examples{
cvm.test(rnorm(100, mean = 5, sd = 3))
cvm.test(runif(100, min = 2, max = 4))

}
\keyword{htest}

\eof
\name{lillie.test}
\alias{lillie.test}
\title{Lilliefors (Kolmogorov-Smirnov) test for  normality}
\description{
  Performs the Lilliefors (Kolmogorov-Smirnov) test for the composite hypothesis of normality,
  see e.g. Thode (2002, Sec. 5.1.1).
}
\usage{
lillie.test(x)
}

\arguments{
  \item{x}{a numeric vector of data values, the number of
  which must be greater than 4. Missing values are allowed.}
}
\details{The Lilliefors (Kolmogorov-Smirnov) test is an EDF omnibus test for the composite
hypothesis of normality. The test statistic is the maximal absolute difference
between empirical and
hypothetical cumulative distribution function. It may be computed as
\eqn{D=\max\{D^{+}, D^{-}\}} with
\deqn{
D^{+} = \max_{i=1,\ldots, n}\{i/n - p_{(i)}\},
D^{-} = \max_{i=1,\ldots, n}\{p_{(i)} - (i-1)/n\},
}
where \eqn{p_{(i)} = \Phi([x_{(i)} - \overline{x}]/s)}. Here,
\eqn{\Phi} is the cumulative distribution function
of the standard normal distribution, and \eqn{\overline{x}} and \eqn{s}
are mean and standard deviation of the data values.
The p-value is computed from the Dallal-Wilkinson (1986) formula, which is claimed to
be only reliable when the p-value is smaller than 0.1. If the Dallal-Wilkinson
p-value turns out to be greater than 0.1, then the p-value is computed from the distribution of
the modified statistic \eqn{Z=D (\sqrt{n}-0.01+0.85/\sqrt{n})}, see Stephens (1974),
the actual p-value formula being obtained by a simulation and approximation process.}

\value{
  A list with class "htest" containing the following components:
  \item{statistic}{the value of the Lilliefors (Kolomogorv-Smirnov) statistic.}
  \item{p.value }{the p-value for the test.}
  \item{method}{the character string "Lilliefors (Kolmogorov-Smirnov) normality test".}
  \item{data.name}{a character string giving the name(s) of the data.}
}
\references{
Dallal, G.E. and Wilkinson, L. (1986):
An analytic approximation to the distribution of Lilliefors' test for normality.
The American Statistician, 40, 294--296.


Stephens, M.A. (1974): EDF statistics for goodness of fit and some comparisons.
Journal of the American Statistical Association, 69, 730--737.

Thode Jr., H.C. (2002): Testing for  Normality. Marcel Dekker, New York.
}
\author{Juergen Gross}

\note{The Lilliefors (Kolomorov-Smirnov) test is the most famous EDF omnibus test for normality.
Compared to the Anderson-Darling test and the Cramer-von Mises test it is known to perform worse.
Although the test statistic obtained from \code{lillie.test(x)} is the same as that obtained from
\code{ks.test(x, "pnorm", mean(x), sd(x))}, it is not correct to use the p-value from the latter
for the composite hypothesis of normality (mean and variance unknown),
since the distribution of the test statistic is different when the parameters are estimated.

The function call \code{lillie.test(x)} essentially produces
the same result as the S-PLUS function call \code{ks.gof(x)}
with the distinction that the p-value is not set to 0.5 when
the Dallal-Wilkinson approximation yields a p-value greater than 0.1. (Actually,
the alternative p-value approximation is provided for the complete range of test statistic values,
but is only used when the Dallal-Wilkinson approximation fails.)}

\seealso{\code{\link[ctest]{shapiro.test}} for performing the Shapiro-Wilk test for normality.
\code{\link{ad.test}}, \code{\link{cvm.test}},
\code{\link{pearson.test}}, \code{\link{sf.test}} for performing further tests for normality.
\code{\link{qqnorm}} for producing a normal quantile-quantile plot.}

\examples{
lillie.test(rnorm(100, mean = 5, sd = 3))
lillie.test(runif(100, min = 2, max = 4))

}
\keyword{htest}

\eof
\name{pearson.test}
\alias{pearson.test}
\title{Pearson chi-square test for  normality}
\description{
  Performs the Pearson chi-square test for the composite hypothesis of normality,
  see e.g. Thode (2002, Sec. 5.2).
}
\usage{
pearson.test(x, n.classes = ceiling(2 * (n^(2/5))), adjust = TRUE)
}
\arguments{
  \item{x}{a numeric vector of data values. Missing values are allowed.}
  \item{n.classes}{The number of classes. The default is due to Moore (1986).}
  \item{adjust}{logical; if \code{TRUE} (default), the p-value is computed from
  a chi-square distribution with \code{n.classes}-3 degrees of freedom, otherwise
  from a chi-square distribution with \code{n.classes}-1 degrees of freedom.}
}
\details{
The Pearson test statistic is \eqn{P=\sum (C_{i} - E_{i})^{2}/E_{i}},
where \eqn{C_{i}} is the number of counted and \eqn{E_{i}} is the number of expected observations
(under the hypothesis) in class \eqn{i}. The classes are build is such a way that they are equiprobable under the hypothesis
of normality. The p-value is computed from a chi-square distribution with \code{n.classes}-3 degrees of freedom
if \code{adjust} is \code{TRUE} and from a chi-square distribution with \code{n.classes}-1
degrees of freedom otherwise. In both cases this is not (!) the correct p-value,
lying somewhere between the two, see also Moore (1986).
}

\value{
  A list with class "htest" containing the following components:
  \item{statistic}{the value of the Pearson chi-square statistic.}
  \item{p.value }{the p-value for the test.}
  \item{method}{the character string "Pearson chi-square normality test".}
  \item{data.name}{a character string giving the name(s) of the data.}
  \item{n.classes}{the number of classes used for the test.}
  \item{df}{the degress of freedom of the chi-square distribution used to compute the p-value.}
}
\references{Moore, D.S. (1986): Tests of the chi-squared type. In:
D'Agostino, R.B. and Stephens, M.A., eds.: Goodness-of-Fit Techniques.
Marcel Dekker, New York.

Thode Jr., H.C. (2002): Testing for  Normality. Marcel Dekker, New York.
}
\author{Juergen Gross}

\note{The Pearson chi-square test is usually not recommended for testing the composite hypothesis of normality
due to its inferior power properties compared to other tests. It is common practice to compute the p-value
from the chi-square distribution with \code{n.classes} - 3 degrees of freedom, in order to adjust for the
additional estimation of two parameters. (For the simple hypothesis of normality (mean and variance known)
the test statistic is asymptotically chi-square distributed with
\code{n.classes} - 1 degrees of freedom.)
This is, however, not correct as long as the parameters are estimated by \code{mean(x)} and \code{var(x)}
(or \code{sd(x)}), as it is usually done, see Moore (1986) for details.
Since the true p-value is somewhere between the two, it is suggested to run \code{pearson.test} twice, with
\code{adjust = TRUE} (default) and with \code{adjust = FALSE}.
It is also suggested to slightly change the default number of classes, in order
to see the effect on the p-value. Eventually, it is suggested not to rely upon the result of the test.

The function call \code{pearson.test(x)} essentially produces
the same result as the S-PLUS function call \code{chisq.gof((x-mean(x))/sqrt(var(x)), n.param.est=2)}.
}


\seealso{\code{\link[ctest]{shapiro.test}} for performing the Shapiro-Wilk test for normality.
\code{\link{ad.test}}, \code{\link{cvm.test}},
\code{\link{lillie.test}}, \code{\link{sf.test}} for performing further tests for normality.
\code{\link{qqnorm}} for producing a normal quantile-quantile plot.}

\examples{
pearson.test(rnorm(100, mean = 5, sd = 3))
pearson.test(runif(100, min = 2, max = 4))

}
\keyword{htest}

\eof
\name{sf.test}
\alias{sf.test}
\title{Shapiro-Francia test for  normality}
\description{
  Performs the Shapiro-Francia  test for the composite hypothesis of normality, 
  see e.g. Thode (2002, Sec. 2.3.2).
}
\usage{
sf.test(x)
}

\arguments{
  \item{x}{a numeric vector of data values, the number of 
  which must be between 5 and 5000. Missing values are allowed.}
}
\details{The test statistic of the Shapiro-Francia test is simply the 
squared correlation between the ordered sample values and the (approximated) 
expected ordered quantiles from the standard normal
distribution. The p-value is computed from the formula given by Royston (1993).
}
\value{
  A list with class "htest" containing the following components: 
  \item{statistic}{the value of the Shapiro-Francia  statistic.}
  \item{p.value }{the p-value for the test.}
  \item{method}{the character string "Shapiro-Francia normality test".}
  \item{data.name}{a character string giving the name(s) of the data.} 
}
\references{Royston, P. (1993): A pocket-calculator algorithm for the
Shapiro-Francia test for non-normality: an application to medicine.
Statistics in Medicine, 12, 181--184.

Thode Jr., H.C. (2002): Testing for  Normality. Marcel Dekker, New York.}
 
\author{Juergen Gross}

\note{The Shapiro-Francia test is known to perform well, 
see also the comments by Royston (1993). The expected ordered quantiles 
from the standard normal distribution are approximated by 
\code{qnorm(ppoints(x, a = 3/8))}, being slightly different from the approximation
\code{qnorm(ppoints(x, a = 1/2))} used for the normal quantile-quantile plot by 
\code{\link{qqnorm}} for sample sizes greater than 10.}

\seealso{\code{\link[ctest]{shapiro.test}} for performing the Shapiro-Wilk test for normality. 
\code{\link{ad.test}}, \code{\link{cvm.test}}, 
\code{\link{lillie.test}}, \code{\link{pearson.test}} for performing further tests for normality.
\code{\link{qqnorm}} for producing a normal quantile-quantile plot.}

\examples{
sf.test(rnorm(100, mean = 5, sd = 3))
sf.test(runif(100, min = 2, max = 4))

}
\keyword{htest}

\eof
