### Name: noverlap.for
### Title: Minimal number of overlap based on an affine hyperplane in
###   binary regression (complete or quasicomplete separation)
### Aliases: noverlap.for noverlap
### Keywords: regression robust

### ** Examples

data(Z2)
noverlap.for(Z2)
noverlap.for(Z2,NDIR=100000)
# x11()
postscript(file="tmp1.ps")
par(mfrow=c(2,1))
noverlap.for(Z2,NDIR=10000,PLOT=TRUE)
tmp <- noverlap.for(Z2)
tmp$NOVERLAP
tmp$COEFFICIENTS
tmp$NSIN
tmp$DETAILS
Z3 <- as.data.frame(Z2)
names(Z3) <- c("x1","x2","y")
plot(x2 ~ x1, data=Z3,pch=as.character(y),main="Scatterplot")
abline(c(0,1.5),col="blue")
points(Z3[2,1],Z3[2,2],pch=as.character(Z3[2,3]),col="red")
dev.off()

# NO OVERLAP: maximum likelihood estimates do NOT exist
data(Z1)
Z1
# X11()
postscript(file="tmp2.ps")
noverlap.for(Z1)
tmp <- noverlap.for(Z1)
tmp$NOVERLAP
tmp$COEFFICIENTS
tmp$NSIN
tmp$DETAILS
Z3 <- as.data.frame(Z1)
names(Z3) <- c("x1","y")
plot(y ~ x1, data=Z3,pch=as.character(y),main="Scatterplot")
summary(glm(y ~ x1, data=Z3, family=binomial(link=logit), trace=TRUE, maxit=30))
dev.off()

# NO OVERLAP: maximum likelihood estimates in the logistic regression model
# do NOT exist for the banknotes data set
data(Banknotes)
Banknotes
# X11()
postscript(file="tmp3.ps")
tmp <- noverlap.for(Banknotes,PLOT=TRUE)
dev.off()
tmp$NOVERLAP
tmp$COEFFICIENTS
Z3 <- as.data.frame(Banknotes)
names(Z3) <- c("x1","x2", "x3", "x4", "x5", "x6","y")
summary(glm(y ~ x1+x2+x3+x4+x5+x6, data=Z3, family=binomial(link=logit), trace=TRUE, maxit=30))



