### Name: mvr
### Title: Multivariate Regression
### Aliases: mvr pcr pls
### Keywords: regression

### ** Examples

data(NIR)
attach(NIR)
NIR.pcr <- mvr(Xtrain, Ytrain, 1:6, validation="CV")
NIR.simpls <- mvr(Xtrain, Ytrain, 1:6, validation="CV", method="SIMPLS")
NIR.kernelpls <- mvr(Xtrain, Ytrain, 1:6, validation="CV", method="kernelPLS")

data(sensory)
Pn <- scale(sensory$Panel)
Ql <- scale(sensory$Quality)
sens.pcr <- mvr(Ql, Pn, 1:5)
sens.simpls <- mvr(Ql, Pn, 1:5, method="SIMPLS")
sens.kernelpls <- mvr(Ql, Pn, 1:5, method="kernelPLS")



