### Name: plot.mvr
### Title: Plot a MVR object
### Aliases: plot.mvr
### Keywords: regression

### ** Examples

data(NIR)
attach(NIR)
nir.pcr <- pcr(Xtrain,Ytrain,1:9, validat="CV")
## Not run: plot(nir.pcr)
plot(nir.pcr, "coefficients", nlv=3:6, type="l")
## Not run: plot(nir.pcr, "prediction", nlv=3:6)
plot(nir.pcr, "prediction", nlv=3:6, which=2)

data(sensory)
Pn <- scale(sensory$Panel)
Ql <- scale(sensory$Quality)
sens.simpls <- mvr(Ql, Pn, 1:5, method="SIMPLS")
plot(sens.simpls, "loadings")
plot(sens.simpls, "scores")



