\name{calif}
\alias{calif}
\title{California places}
\description{See user's guide}
\arguments{
}
\note{See the user's guide, pps.pdf, for more information.}
\examples{
}
\keyword{survey}


\eof
\name{califcty}
\alias{califcty}
\title{California counties}
\description{See user's guide}
\arguments{
}
\note{See the user's guide, pps.pdf, for more information.}
\examples{
}
\keyword{survey}


\eof
\name{permuteinstrata}
\alias{permuteinstrata}
\title{Randomize units within strata}
\description{Randomize the order of units within each stratum}
\usage{permuteinstrata(stratsizes)}
\arguments{
	\item{stratsizes}{A vector containing the size of each stratum}
}
\value{Returns the vector of permuted indices. In the example below, 
the returned vector has 29 elements.}
\note{See the user's guide, pps.pdf, for more information.}
\examples{
stratsizes <- c(9,10,10)  # strata have 9, 10 and 10 units, respectively
permuteinstrata(stratsizes)
}
\keyword{survey}

\eof
\name{pps1}
\alias{pps1}
\title{Select one unit with PPS}
\description{Use PPS systematic sampling to select a single unit out of N}
\usage{pps1(sizes)}
\arguments{
	\item{sizes}{A vector of the sizes of the units in the population}
}
\value{Returns the index of the unit that was selected}
\note{See the user's guide, pps.pdf, for more information.}
\examples{
sizes <- c(9,2,5,17,4,21,15,7,4,11,23,23,14)
sampleindex <- pps1(sizes)
}
\keyword{survey}


\eof
\name{ppss}
\alias{ppss}
\title{PPS systematic sampling}
\description{Use PPS systematic sampling to select a sample of n units out of N}
\usage{ppss(sizes,n)}
\arguments{
	\item{sizes}{A vector of the sizes of the units in the population}
	\item{n}{The sample size}
}
\value{Returns the indices of the units that were selected in the sample}
\note{See the user's guide, pps.pdf, for more information.}
\examples{
sizes <- c(9,2,5,17,4,21,15,7,4,11,23,23,14)
sampleindices <- ppss(sizes,4)
}
\keyword{survey}


\eof
\name{ppssstrat}
\alias{ppssstrat}
\title{Stratified PPS systematic sampling}
\description{In each stratum, select a sample using pps systematic sampling}
\usage{ppssstrat(sizes,stratum,n)}
\arguments{
	\item{sizes}{A vector of the sizes of the units in the population,
	sorted by stratum}
	\item{stratum}{A vector of stratum codes, in the same order}
	\item{n}{A vector containing the sample size in each stratum}
}
\value{Returns the indices of the units that were selected in the sample}
\note{\code{ppssstrat} calls \code{ppss} once per stratum.
See the user's guide, pps.pdf, for more information.}
\examples{
sizes <- c(1:5,10:6)*10
strat <- c(1,1,1,2,2,3,3,3,3,3)
n <- c(2,1,3)
ppssstrat(sizes,strat,n)
}
\keyword{survey}


\eof
\name{ppswr}
\alias{ppswr}
\title{PPS sampling with replacement}
\description{Use PPS sampling to select a sample of n units out of N with replacement}
\usage{ppswr(sizes,n)}
\arguments{
	\item{sizes}{A vector of the sizes of the units in the population}
	\item{n}{The sample size}
}
\value{Returns the indices of the units that were selected in the sample}
\note{See the user's guide, pps.pdf, for more information.}
\examples{
sizes <- c(9,2,5,17,4,21,15,7,4,11,23,23,14)
sampleindices <- ppswr(sizes,4)
}
\keyword{survey}


\eof
\name{sampford}
\alias{sampford}
\title{Sampford's PPS sampling method}
\description{Use Sampford's method to select a PPS sample of units}
\usage{sampford(size,n)}
\arguments{
	\item{size}{A vector of the sizes of the units in the population}
	\item{n}{The sample size}
}
\value{Returns the indices of the units that were selected in the sample}
\note{The function \code{sampfordpi} can be used to compute joint inclusion
probabilities for this method.
See the user's guide, pps.pdf, for more information.}
\examples{
size <- c(9,2,5,17,4,21,15,7,4,11,23,23,14)
sampleindices <- sampford(size,4)
}
\keyword{survey}


\eof
\name{sampfordpi}
\alias{sampfordpi}
\title{Joint inclusion probabilities for Sampford's PPS sampling method}
\description{Compute joint inclusion probabilities for Sampford's method of PPS sampling}
\usage{sampfordpi(sizes,n)}
\arguments{
	\item{sizes}{A vector of the sizes of the units in the population}
	\item{n}{The sample size}
}
\value{Returns 
a matrix with the inclusion probability pi(i) for
for each unit i in the population and with the joint
inclusion probability pi(i,j) of units i and j in
position (i,j) in the matrix, where i and j are not equal.
Note that the size of the matrix is NxN, where N is the population size.}
\note{The function \code{sampford} can be used to select a sample
using Sampford's method.
See the user's guide, pps.pdf, for more information.}
\examples{
sizes <- c(9,2,5,17,4,21,15,7,4,11,23,23,14)
piij <- sampfordpi(sizes,4)
weights <- 1/diag(piij)  # the weights one would use for estimation
}
\keyword{survey}


\eof
\name{sizesok}
\alias{sizesok}
\title{Check that unit sizes are not too big}
\description{See user's guide}
\usage{sizesok(size,n)}
\arguments{
	\item{size}{A vector of the sizes of the units in the population}
	\item{n}{The sample size}
}
\value{Returns the number of "bad" units}
\note{See the user's guide, pps.pdf, for more information.}
\examples{
}
\keyword{survey}


\eof
\name{stratsrs}
\alias{stratsrs}
\title{Stratified simple random sampling}
\description{In each stratum, select a simple random sample}
\usage{stratsrs(stratum,nh)}
\arguments{
	\item{stratum}{A vector of stratum codes, sorted by stratum}
	\item{nh}{A vector containing the sample size in each stratum}
}
\value{Returns the indices of the units that were selected in the sample}
\note{See the user's guide, pps.pdf, for more information.}
\examples{
strat <- c(1,1,1,1,1,2,2,2,3,3,3,3,3,3,3)  # stratum 1 has 5 units, etc. 
nh <- c(2,1,3)  # select 2 units from stratum 1, 1 from stratum 2 and 3 from 3
stratsrs(strat,nh)
}
\keyword{survey}


\eof
\name{stratumsizes}
\alias{stratumsizes}
\title{Compute size of each stratum}
\description{Given a vector of sorted stratum indicators, returns the number of units in each stratum}
\usage{stratumsizes(stratum)}
\arguments{
	\item{stratum}{A vector of sorted stratum indicators}
}
\value{Returns the number of units in each stratum}
\note{See the user's guide, pps.pdf, for more information.}
\examples{
}
\keyword{survey}


\eof
