cluspop.nb             package:prabclus             R Documentation

_S_i_m_u_l_a_t_i_o_n _o_f _p_r_e_s_e_n_c_e-_a_b_s_e_n_c_e _m_a_t_r_i_c_e_s (_c_l_u_s_t_e_r_e_d)

_D_e_s_c_r_i_p_t_i_o_n:

     Generates a simulated matrix where the rows are interpreted as
     regions and the columns as species, 1 means that a species is
     present in the region and 0 means that the species is absent.
     Species are generated in order to produce 2 clusters of species
     with similar ranges. Spatial autocorrelation of a species'
     presences is governed by the parameter 'p.nb' and a list of
     neighbors for each region.

_U_s_a_g_e:

     cluspop.nb(neighbors, p.nb = 0.5, n.species, clus.specs, reg.group,
     grouppf = 10, n.regions = length(neighbors),
     vector.species = rep(1, n.species), pdf.regions = rep(1/n.regions,
     n.regions), count = TRUE, pdfnb = FALSE)

_A_r_g_u_m_e_n_t_s:

neighbors: A list with a component for every region. The components are
          vectors of integers indicating neighboring regions. A region
          without neighbors (e.g., an island) should be assigned a list
          'numeric(0)'.

    p.nb: numerical between 0 and 1. The probability that a new region
          is drawn from the non-neighborhood of the previous regions
          belonging to a species under generation. Note that for a
          given presence-absence matrix, this parameter can be
          estimated by 'autoconst' (called 'pd' there).

n.species: integer. Number of species.

clus.specs: integer not larger than 'n.species'. Number of species
          restricted to one of the two groups of regions defined by
          'reg.group' (called "clustered species" because this leads to
          more similar species ranges).

reg.group: vector of pairwise distinct integers not larger than 'n.
          regions'. Defines a group of regions to which a part of the
          'clus.specs' clustered species is restricted (more or less,
          see 'grouppf'). The other clustered species are restricted to
          the complementary regions.

 grouppf: numerical. The probability of the region of a clustered
          species to belong to the corresponding group of regions is
          up-weighted by factor 'grouppf' compared to the generation of
          "non-clustered" species.

n.regions: integer. Number of regions.

vector.species: vector of integers. The sizes (i.e., numbers of
          regions) of the species are generated randomly from the
          empirical distribution of 'vector.species'.

pdf.regions: numerical vector of length 'n.species'. The entries must
          sum up to 1 and give probabilities for the regions to be
          drawn during the generation of a species. These probabilities
          are used conditional on the new region being a neighbor or a
          non-neighbor of the previous regions of the species, see
          'p.nb', modified by 'grouppf' for the clustered species.

   count: logical. If 'TRUE', the number of the currently generated
          species is printed.

   pdfnb: logical. If 'TRUE', the probabilities of the regions are
          modified according to the number of neighboring regions by
          dividing them relative to the others by min(1,number of
          neighbors).

_D_e_t_a_i_l_s:

     The non-clustered species are generated as explained on the help
     page for 'randpop.nb'. The general principle for the clustered
     species is the same, but with modified probabilities for the
     regions. For each clustered species, one of the two groups of
     regions is drawn, distributed according to the sum of its regions'
     probability given by 'pdf.regions'. The first region of such a
     species is only drawn from the regions of this group.

_V_a_l_u_e:

     A 0-1-matrix, rows are regions, columns are species.

_A_u_t_h_o_r(_s):

     Christian Hennig hennig@math.uni-hamburg.de <URL:
     http://www.math.uni-hamburg.de/home/hennig/>

_R_e_f_e_r_e_n_c_e_s:

     Hennig, C. and Hausdorf, B. (2002) Distance-based parametric
     bootstrap tests for clustering of species ranges, submitted, <URL:
     http://stat.ethz.ch/Research-Reports/110.html>.

_S_e_e _A_l_s_o:

     'randpop.nb',

     'autoconst' estimates 'p.nb' from matrices of class 'prab'. These
     are generated by 'prabinit'.

_E_x_a_m_p_l_e_s:

     data(nb)
     # Note: If you do not use the installed package, replace this by
     # nb <- list()
     # for (i in 1:34)
     #   nb <- c(nb,list(scan(file="(path/)nb.dat",
     #                   skip=i-1,nlines=1)))
     set.seed(888)
     cluspop.nb(nb, p.nb=0.1, n.species=10, clus.specs=9, reg.group=1:17,
     vector.species=c(10))

