randpop.nb             package:prabclus             R Documentation

_S_i_m_u_l_a_t_i_o_n _o_f _p_r_e_s_e_n_c_e-_a_b_s_e_n_c_e _m_a_t_r_i_c_e_s (_n_o_n-_c_l_u_s_t_e_r_e_d)

_D_e_s_c_r_i_p_t_i_o_n:

     Generates a simulated matrix where the rows are interpreted as
     regions and the columns as species, 1 means that a species is
     present in the region and 0 means that the species is absent.
     Species are generated i.i.d.. Spatial autocorrelation of a
     species' presences is governed by the parameter 'p.nb' and a list
     of neighbors for each region.

_U_s_a_g_e:

     randpop.nb(neighbors, p.nb = 0.5, n.species, n.regions =
     length(neighbors), vector.species = rep(1, n.species),
     species.fixed = FALSE, pdf.regions = rep(1/n.regions, n.regions),
     count = TRUE, pdfnb = FALSE)

_A_r_g_u_m_e_n_t_s:

neighbors: A list with a component for every region. The components are
          vectors of integers indicating neighboring regions. A region
          without neighbors (e.g., an island) should be assigned a list
          'numeric(0)'.

    p.nb: numerical between 0 and 1. The probability that a new region
          is drawn from the non-neighborhood of the previous regions
          belonging to a species under generation. Note that for a
          given presence-absence matrix, this parameter can be
          estimated by 'autoconst' (called 'pd' there).

n.species: integer. Number of species.

n.regions: integer. Number of regions.

vector.species: vector of integers. If 'species.fixed=TRUE',
          'vector.species' must have length 'n.species' and gives the
          sizes (i.e., numbers of regions) of the species to generate.
          Else, the sizes are generated randomly from the empirical
          distribution of 'vector.species'.

species.fixed: logical. See 'vector.species'.

pdf.regions: numerical vector of length 'n.species'. The entries must
          sum up to 1 and give probabilities for the regions to be
          drawn during the generation of a species. These probabilities
          are used conditional on the new region being a neighbor or a
          non-neighbor of the previous regions of the species, see
          'p.nb'.

   count: logical. If 'TRUE', the number of the currently generated
          species is printed.

   pdfnb: logical. If 'TRUE', the probabilities of the regions are
          modified according to the number of neighboring regions by
          dividing them relative to the others by min(1,number of
          neighbors).

_D_e_t_a_i_l_s:

     The principle is that a single species with given size is
     generated one-by-one region. The first region is drawn according
     to 'pdf.regions'. For all following regions, a neighbor or
     non-neighbor of the previous configuration is added (if possible),
     as explained in 'pdf.regions', 'p.nb'.

_V_a_l_u_e:

     A 0-1-matrix, rows are regions, columns are species.

_A_u_t_h_o_r(_s):

     Christian Hennig hennig@math.uni-hamburg.de <URL:
     http://www.math.uni-hamburg.de/home/hennig/>

_R_e_f_e_r_e_n_c_e_s:

     Hennig, C. and Hausdorf, B. (2002) Distance-based parametric
     bootstrap tests for clustering of species ranges, submitted, <URL:
     http://stat.ethz.ch/Research-Reports/110.html>.

     Hausdorf, B. and Hennig, C. (2003)  Biotic Element Analysis in
     Biogeography. To appear in  _Systematic Biology_.

     Hausdorf, B. and Hennig, C. (2003) Nestedness of nerth-west
     European land snail ranges as a consequence of differential
     immigration from Pleistocene glacial refuges. _Oecologia_ 135,
     102-109.

_S_e_e _A_l_s_o:

     'autoconst' estimates 'p.nb' from matrices of class 'prab'. These
     are generated by 'prabinit'.

     'prabtest' uses 'randpop.nb' as a null model for tests of
     clustering. An alternative model is given by 'cluspop.nb'.

_E_x_a_m_p_l_e_s:

     data(nb)
     # Note: If you do not use the installed package, replace this by
     # nb <- list()
     # for (i in 1:34)
     #   nb <- c(nb,list(scan(file="(path/)nb.dat",
     #                   skip=i-1,nlines=1)))
     set.seed(2346)
     randpop.nb(nb, p.nb=0.1, n.species=5, vector.species=c(1,10,20,30,34))

