### Name: bristleX
### Title: Data on bristle number in Drosophila
### Aliases: bristleX
### Keywords: datasets

### ** Examples

data(bristleX)
# Summaries
summary(bristleX)
plot(bristleX)

# genome scan for each of the average phenotypes
bristleX <- calc.genoprob(bristleX, step=2)
out <- vector("list", 4)
for(i in 1:4) out[[i]] <- scanone(bristleX, pheno.col=2*i-1)

# Plot the results
    # maximum LOD score among four phenotypes    
ym <- max(sapply(out, function(a) max(a[,3])))
plot(out[[1]], ylim=c(0,ym))
for(i in 2:4) plot(out[[i]], add=TRUE, col=c("blue","red","green")[i-1])



