### Name: effectplot
### Title: Plot phenotype means against genotypes at one or two markers.
### Aliases: effectplot
### Keywords: hplot

### ** Examples

data(fake.f2)

# plot of genotype-specific phenotype means for 1 marker
mname <- find.marker(fake.f2, 1, 37) # marker D1M437
effectplot(fake.f2, pheno.col=1, mname1=mname)

# Plot of sex-specific phenotype means
sex <- fake.f2$pheno[,2]
effectplot(fake.f2, mname1="Sex", mark1=sex, geno1=c("F","M"))

# plot of genotype-specific phenotype means for 2 markers
mname1 <- find.marker(fake.f2, 1, 37) # marker D1M437
mname2 <- find.marker(fake.f2, 13, 24) # marker D13M254
effectplot(fake.f2, mname1=mname1, mname2=mname2)

# Plot of sex- and genotype-specific phenotype means 
mname <- find.marker(fake.f2, 13, 24) # marker D13M254
effectplot(fake.f2, mname1=mname, mname2="Sex",
           mark2=fake.f2$pheno$sex, geno2=c("F","M"))

# Same as above, switch role of sex and the marker
effectplot(fake.f2, mname1="Sex", mark1=fake.f2$pheno$sex,
           geno1=c("F","M"), mname2=mname)

# X chromosome marker
mname <- find.marker(fake.f2, "X", 14) # marker DXM66
effectplot(fake.f2, mname1=mname)

# Two markers, including one on the X
mname1 <- find.marker(fake.f2, 13, 24) # marker D13M254
mname2 <- find.marker(fake.f2, "X", 14) # marker DXM66
effectplot(fake.f2, mname1=mname1, mname2=mname2)



