### Name: listeria
### Title: Data on Listeria monocytogenes susceptibility
### Aliases: listeria
### Keywords: datasets

### ** Examples

data(listeria)
# Summaries
summary(listeria)
plot(listeria)

# Take log of phenotype
listeria$pheno[,2] <- log2(listeria$pheno[,1])
names(listeria$pheno)[2] <- "logSurv"
plot(listeria)

# Genome scan with a two-part model, using log survival
listeria <- calc.genoprob(listeria, step=2)
out <- scanone(listeria, model="2part", method="em",
               upper=TRUE, pheno.col=2)

# Summary of the results
summary(out, 4)

# Plot LOD curves for interesting chromosomes
#     (The two-part model gives three LOD scores)
plot(out, out, out, chr=c(1,5,6,13,15), lodcolumn=3:5,
     lty=1, col=c("black","red","blue"))



