### Name: qvcalc
### Title: Quasi Variances for Model Coefficients
### Aliases: qvcalc summary.qv plot.qv
### Keywords: models regression

### ** Examples

##  Overdispersed Poisson loglinear model for ship damage data
##  from McCullagh and Nelder (1989), Sec 6.3.2 
library(MASS)
data(ships)
ships$year <- as.factor(ships$year)
ships$period <- as.factor(ships$period)
shipmodel <- glm(formula = incidents ~ type + year + period,
    family = quasipoisson, 
    data = ships, subset = (service > 0), offset = log(service))
shiptype.qvs <- qvcalc(shipmodel, "type")
summary(shiptype.qvs, digits=4)
plot(shiptype.qvs)
## Not run: 
##D ##  Example of a negative quasi variance
##D ##  Requires the "car" package
##D library(car)
##D data(Prestige)
##D attach(Prestige)
##D mymodel <- lm(prestige ~ type + education)
##D library(qvcalc)
##D type.qvs <- qvcalc(mymodel, "type")
##D ##  Warning message: 
##D ##  NaNs produced in: sqrt(qv) 
##D summary(type.qvs)
##D ##  Model call:  lm(formula = prestige ~ type + education) 
##D ##  Factor name:  type 
##D ##          estimate       SE  quasiSE  quasiVar
##D ##    bc    0.000000 0.000000 2.874361  8.261952
##D ##    prof  6.142444 4.258961 3.142737  9.876793
##D ##    wc   -5.458495 2.690667      NaN -1.022262
##D ##  Worst relative errors in SEs of simple contrasts (%):  0 0 
##D ##  Worst relative errors over *all* contrasts (%):  0 0
##D plot(type.qvs)
##D ##  Error in plot.qv(type.qvs) :  No comparison intervals available,
##D ##  since one of the quasi variances is negative.  See ?qvcalc for more.
## End(Not run) 



