### Name: regress
### Title: Fit a Gaussian Linear Model in which the Covariance Structure is
###   a Linear Combination of Known Matrices by Maximising the Residual Log
###   Likelihood
### Aliases: regress
### Keywords: regression models multivariate

### ** Examples

  ## Example of Random Effects model from Venables and Ripley, page 205
  library("nlme")
  library("regress")
  data(Oats)
  names(Oats) <- c("B","V","N","Y")
  
  ## Using regress
  oats.reg <- regress(Y~N+V,~B+I(B:V),identity=TRUE,print.level=1,data=Oats)
  summary(oats.reg)

  ## Using lme
  oats.lme <- lme(Y~N+V,random=~1|B/V,data=Oats,method="REML")
  summary(oats.lme)



