meta.DSL                package:rmeta                R Documentation

_R_a_n_d_o_m _e_f_f_e_c_t_s (_D_e_r_S_i_m_o_n_i_a_n-_L_a_i_r_d) _m_e_t_a-_a_n_a_l_y_s_i_s

_D_e_s_c_r_i_p_t_i_o_n:

     Computes the individual odds ratios or relative risks, the
     summary, the random effects variance, and Woolf's test for
     heterogeneity. The 'print' method gives the summary and test for
     heterogeneity; the 'summary' method also gives all the individual
     odds ratios and confidence intervals. Studies with zero or
     infinite odds ratio are omitted, as their variance cannot be
     calculated sensibly.

     The 'plot' method draws a standard meta-analysis plot. The
     confidence interval for each study is given by a horizontal line,
     and the point estimate is given by a square whose height is
     inversely proportional to the standard error of the estimate.  The
     summary odds ratio, if requested, is drawn as a diamond with
     horizontal limits at the confidence limits and width inversely
     proportional to its standard error.

_U_s_a_g_e:

     meta.DSL(ntrt, nctrl, ptrt, pctrl, conf.level=0.95,
              names=NULL, data=NULL, subset=NULL, na.action=na.fail,statistic="OR")
     ## S3 method for class 'meta.DSL':
     summary(object, conf.level=NULL, ...)
     ## S3 method for class 'meta.DSL':
     plot(x, summary=TRUE, summlabel="Summary",
                  conf.level=NULL, colors=meta.colors(), xlab=NULL,...)

_A_r_g_u_m_e_n_t_s:

    ntrt: Number of subjects in treated/exposed group

   nctrl: Number of subjects in control group 

    ptrt: Number of events in treated/exposed group

   pctrl: Number of events in control group

conf.level: Coverage for confidence intervals

   names: names or labels for studies

    data: data frame to interpret variables

  subset: subset of studies to include

na.action: a function which indicates what should happen when the data
          contain 'NA's.  Defaults to 'na.fail'.

statistic: "OR" for odds ratio, "RR" for relative risk

x,object: a 'meta.DSL' object

 summary: Plot the summary odds ratio?

summlabel: Label for the summary odds ratio

  colors: see 'meta.colors'

    xlab: x-axis label, default is based on 'statistic'

     ...: further arguments to be passed from or to methods.

_V_a_l_u_e:

     An object of class 'meta.DSL' with 'print', 'plot', 'funnelplot'
     and 'summary' methods.

_A_u_t_h_o_r(_s):

     Thomas Lumley

_S_e_e _A_l_s_o:

     'plot','par','meta.MH','funnelplot'

_E_x_a_m_p_l_e_s:

     data(catheter)
     b <- meta.DSL(n.trt, n.ctrl, col.trt, col.ctrl, data=catheter,
                   names=Name, subset=c(13,6,5,3,7,12,4,11,1,8,10,2))
     b
     summary(b)
     plot(b)
     e <- meta.DSL(n.trt, n.ctrl, inf.trt, inf.ctrl, data=catheter,
                   names=Name, subset=c(13,6,3,12,4,11,1,14,8,10,2))
     e
     summary(e)
     ##tasteless
     plot(e, colors=meta.colors(summary="green",lines="purple",box="orange"))

